/*
 * Copyright (c) 2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef PAS_PAGE_CONFIG_SIZE_CATEGORY_H
#define PAS_PAGE_CONFIG_SIZE_CATEGORY_H

#include "pas_utils.h"

PAS_BEGIN_EXTERN_C;

enum pas_page_config_size_category {
    pas_page_config_size_category_small,
    pas_page_config_size_category_medium,
    pas_page_config_size_category_marge,
    pas_page_config_size_category_large,
};

typedef enum pas_page_config_size_category pas_page_config_size_category;

static inline const char* pas_page_config_size_category_get_string(pas_page_config_size_category page_config_size_category)
{
    switch (page_config_size_category) {
    case pas_page_config_size_category_small:
        return "small";
    case pas_page_config_size_category_medium:
        return "medium";
    case pas_page_config_size_category_marge:
        return "marge";
    case pas_page_config_size_category_large:
        return "large";
    }
    PAS_ASSERT(!"Should not be reached");
    return NULL;
}

PAS_END_EXTERN_C;

#endif /* PAS_PAGE_CONFIG_SIZE_CATEGORY_H */

