//
// Copyright 2023 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

// context_private_call_gl.cpp:
//   Helpers that set/get state that is entirely locally accessed by the context.

#include "libANGLE/context_private_call_gl_autogen.h"
#include "libANGLE/context_private_call_gles_autogen.h"

#include "common/debug.h"

namespace gl
{
void ContextPrivateVertexAttrib1d(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLdouble x)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib1dv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib1s(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLshort x)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib1sv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib2d(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLdouble x,
                                  GLdouble y)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib2dv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib2s(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLshort x,
                                  GLshort y)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib2sv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib3d(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLdouble x,
                                  GLdouble y,
                                  GLdouble z)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib3dv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib3s(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLshort x,
                                  GLshort y,
                                  GLshort z)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib3sv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nbv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLbyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Niv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nsv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nub(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLubyte x,
                                    GLubyte y,
                                    GLubyte z,
                                    GLubyte w)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nubv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLubyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nuiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLuint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4Nusv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLushort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4bv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLbyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4d(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLdouble x,
                                  GLdouble y,
                                  GLdouble z,
                                  GLdouble w)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4dv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4iv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4s(PrivateState *privateState,
                                  PrivateStateCache *privateStateCache,
                                  GLuint index,
                                  GLshort x,
                                  GLshort y,
                                  GLshort z,
                                  GLshort w)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4sv(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4ubv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLubyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4uiv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLuint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttrib4usv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLushort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI1i(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLint x)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI1iv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI1ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLuint x)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI1uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLuint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI2i(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLint x,
                                   GLint y)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI2iv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI2ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI2uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLuint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI3i(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLint x,
                                   GLint y,
                                   GLint z)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI3iv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI3ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y,
                                    GLuint z)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI3uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLuint *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI4bv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLbyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI4sv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLshort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI4ubv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLubyte *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribI4usv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     const GLushort *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP1ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP1uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP2ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP2uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP3ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP3uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP4ui(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribP4uiv(PrivateState *privateState,
                                     PrivateStateCache *privateStateCache,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL1d(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLdouble x)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL1dv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL2d(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL2dv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL3d(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y,
                                   GLdouble z)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL3dv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLdouble *v)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL4d(PrivateState *privateState,
                                   PrivateStateCache *privateStateCache,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y,
                                   GLdouble z,
                                   GLdouble w)
{
    UNIMPLEMENTED();
}

void ContextPrivateVertexAttribL4dv(PrivateState *privateState,
                                    PrivateStateCache *privateStateCache,
                                    GLuint index,
                                    const GLdouble *v)
{
    UNIMPLEMENTED();
}
}  // namespace gl
