#!/bin/bash
# configurações diversas do tint2

function _get_configs() {
	LARGURA_ATUAL=$(egrep "^panel_size =" ~/.config/tint2/tint2rc | cut -d'=' -f2 | cut -d'%' -f1)
	ALTURA_ATUAL=$(egrep "^panel_size =" ~/.config/tint2/tint2rc | cut -d'=' -f2 | cut -d'%' -f2)
	TAMANHO_BORDA=$(egrep "^border_width =" ~/.config/tint2/tint2rc | cut -d'=' -f2)
	AUTO_ESCONDER=$(egrep "^autohide =" ~/.config/tint2/tint2rc | cut -d'=' -f2)
	ALTURA_ESCONDER=$(egrep "^autohide_height =" ~/.config/tint2/tint2rc | cut -d'=' -f2)
	[ $AUTO_ESCONDER -eq 0 ] && AUTO_ESCONDER='FALSE' || AUTO_ESCONDER='TRUE'
}

_get_configs

while CONFIGS=$(yad --form --title='Configure Tint2' --width=400 \
	--field='Toolbar width':NUM $LARGURA_ATUAL!30..100 --field='Toolbar height':NUM $ALTURA_ATUAL!20..100 \
	--field='Toolbar border':NUM $TAMANHO_BORDA!0..10 --field='Auto-hide':CHK "$AUTO_ESCONDER" \
	--field='Height when auto-hidding':NUM $ALTURA_ESCONDER!0..10 --button='X':1 --button='OK':0)
do
	NOVA_LARGURA=$(echo $CONFIGS | cut -d'|' -f1 | cut -d'.' -f1)
	NOVA_ALTURA=$(echo $CONFIGS | cut -d'|' -f2 | cut -d'.' -f1)
	NOVA_TAMANHO_BORDA=$(echo $CONFIGS | cut -d'|' -f3 | cut -d'.' -f1)
	NOVO_AUTO_ESCONDER=$(echo $CONFIGS | cut -d'|' -f4)
	NOVA_ALTURA_ESCONDER=$(echo $CONFIGS | cut -d'|' -f5 | cut -d'.' -f1)
	[ $NOVO_AUTO_ESCONDER == 'FALSE' ] && NOVO_AUTO_ESCONDER=0 || NOVO_AUTO_ESCONDER=1
	[ $AUTO_ESCONDER == 'FALSE' ] && AUTO_ESCONDER=0 || AUTO_ESCONDER=1
	sed -i "/^panel_size =/s/$LARGURA_ATUAL%/ $NOVA_LARGURA%/g" ~/.config/tint2/tint2rc
	sed -i "/^panel_size =/s/$ALTURA_ATUAL/ $NOVA_ALTURA/g" ~/.config/tint2/tint2rc
	sed -i "/^border_width =/s/$TAMANHO_BORDA/ $NOVA_TAMANHO_BORDA/g" ~/.config/tint2/tint2rc
	sed -i "/^autohide =/s/$AUTO_ESCONDER/ $NOVO_AUTO_ESCONDER/g" ~/.config/tint2/tint2rc
	sed -i "/^autohide_height =/s/$ALTURA_ESCONDER/ $NOVA_ALTURA_ESCONDER/g" ~/.config/tint2/tint2rc
	# reiniciar o tint2
	killall -9 tint2
	tint2 &
	_get_configs
done
