// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_1_autogen.cpp:
//   Defines the Desktop GL 1.x entry points.

#include "libGL/entry_points_gl_1_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/gl_enum_utils.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL1_autogen.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {

// GL 1.0
void GL_APIENTRY GL_Accum(GLenum op, GLfloat value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAccum, "context = %d, op = %s, value = %f", CID(context),
          GLenumToString(GLenumGroup::AccumOp, op), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateAccum(context, angle::EntryPoint::GLAccum, op, value));
        if (isCallValid)
        {
            context->accum(op, value);
        }
        ANGLE_CAPTURE_GL(Accum, isCallValid, context, op, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_AlphaFunc(GLenum func, GLfloat ref)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAlphaFunc, "context = %d, func = %s, ref = %f", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked                              = PackParam<AlphaTestFunc>(func);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateAlphaFunc(context, angle::EntryPoint::GLAlphaFunc, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFunc(funcPacked, ref);
        }
        ANGLE_CAPTURE_GL(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Begin(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBegin, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBegin(context, angle::EntryPoint::GLBegin, mode));
        if (isCallValid)
        {
            context->begin(mode);
        }
        ANGLE_CAPTURE_GL(Begin, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Bitmap(GLsizei width,
                           GLsizei height,
                           GLfloat xorig,
                           GLfloat yorig,
                           GLfloat xmove,
                           GLfloat ymove,
                           const GLubyte *bitmap)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBitmap,
          "context = %d, width = %d, height = %d, xorig = %f, yorig = %f, xmove = %f, ymove = %f, "
          "bitmap = 0x%016" PRIxPTR "",
          CID(context), width, height, xorig, yorig, xmove, ymove, (uintptr_t)bitmap);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBitmap(context, angle::EntryPoint::GLBitmap, width, height,
                                                                                xorig, yorig, xmove, ymove, bitmap));
        if (isCallValid)
        {
            context->bitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
        }
        ANGLE_CAPTURE_GL(Bitmap, isCallValid, context, width, height, xorig, yorig, xmove, ymove,
                         bitmap);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendFunc(GLenum sfactor, GLenum dfactor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFunc, "context = %d, sfactor = %s, dfactor = %s", CID(context),
          GLenumToString(GLenumGroup::BlendingFactor, sfactor),
          GLenumToString(GLenumGroup::BlendingFactor, dfactor));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFunc(context, angle::EntryPoint::GLBlendFunc, sfactor, dfactor));
        if (isCallValid)
        {
            context->blendFunc(sfactor, dfactor);
        }
        ANGLE_CAPTURE_GL(BlendFunc, isCallValid, context, sfactor, dfactor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CallList(GLuint list)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCallList, "context = %d, list = %u", CID(context), list);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCallList(context, angle::EntryPoint::GLCallList, list));
        if (isCallValid)
        {
            context->callList(list);
        }
        ANGLE_CAPTURE_GL(CallList, isCallValid, context, list);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CallLists(GLsizei n, GLenum type, const void *lists)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCallLists, "context = %d, n = %d, type = %s, lists = 0x%016" PRIxPTR "",
          CID(context), n, GLenumToString(GLenumGroup::ListNameType, type), (uintptr_t)lists);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCallLists(context, angle::EntryPoint::GLCallLists, n, type, lists));
        if (isCallValid)
        {
            context->callLists(n, type, lists);
        }
        ANGLE_CAPTURE_GL(CallLists, isCallValid, context, n, type, lists);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Clear(GLbitfield mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClear, "context = %d, mask = %s", CID(context),
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str());

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClear(context, angle::EntryPoint::GLClear, mask));
        if (isCallValid)
        {
            context->clear(mask);
        }
        ANGLE_CAPTURE_GL(Clear, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearAccum, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearAccum(context, angle::EntryPoint::GLClearAccum, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearAccum(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(ClearAccum, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearColor, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearColor(context, angle::EntryPoint::GLClearColor, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(ClearColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearDepth(GLdouble depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearDepth, "context = %d, depth = %f", CID(context), depth);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearDepth(context, angle::EntryPoint::GLClearDepth, depth));
        if (isCallValid)
        {
            context->clearDepth(depth);
        }
        ANGLE_CAPTURE_GL(ClearDepth, isCallValid, context, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearIndex(GLfloat c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearIndex, "context = %d, c = %f", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearIndex(context, angle::EntryPoint::GLClearIndex, c));
        if (isCallValid)
        {
            context->clearIndex(c);
        }
        ANGLE_CAPTURE_GL(ClearIndex, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearStencil(GLint s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearStencil, "context = %d, s = %d", CID(context), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearStencil(context, angle::EntryPoint::GLClearStencil, s));
        if (isCallValid)
        {
            context->clearStencil(s);
        }
        ANGLE_CAPTURE_GL(ClearStencil, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClipPlane(GLenum plane, const GLdouble *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipPlane, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClipPlane(context, angle::EntryPoint::GLClipPlane, plane, equation));
        if (isCallValid)
        {
            context->clipPlane(plane, equation);
        }
        ANGLE_CAPTURE_GL(ClipPlane, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3b(GLbyte red, GLbyte green, GLbyte blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3b, "context = %d, red = %d, green = %d, blue = %d", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3b(context, angle::EntryPoint::GLColor3b, red, green, blue));
        if (isCallValid)
        {
            context->color3b(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3b, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3bv(const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3bv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3bv(context, angle::EntryPoint::GLColor3bv, v));
        if (isCallValid)
        {
            context->color3bv(v);
        }
        ANGLE_CAPTURE_GL(Color3bv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3d(GLdouble red, GLdouble green, GLdouble blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3d, "context = %d, red = %f, green = %f, blue = %f", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3d(context, angle::EntryPoint::GLColor3d, red, green, blue));
        if (isCallValid)
        {
            context->color3d(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3d, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3dv(context, angle::EntryPoint::GLColor3dv, v));
        if (isCallValid)
        {
            context->color3dv(v);
        }
        ANGLE_CAPTURE_GL(Color3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3f(GLfloat red, GLfloat green, GLfloat blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3f, "context = %d, red = %f, green = %f, blue = %f", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3f(context, angle::EntryPoint::GLColor3f, red, green, blue));
        if (isCallValid)
        {
            context->color3f(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3f, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3fv(context, angle::EntryPoint::GLColor3fv, v));
        if (isCallValid)
        {
            context->color3fv(v);
        }
        ANGLE_CAPTURE_GL(Color3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3i(GLint red, GLint green, GLint blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3i, "context = %d, red = %d, green = %d, blue = %d", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3i(context, angle::EntryPoint::GLColor3i, red, green, blue));
        if (isCallValid)
        {
            context->color3i(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3i, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3iv(context, angle::EntryPoint::GLColor3iv, v));
        if (isCallValid)
        {
            context->color3iv(v);
        }
        ANGLE_CAPTURE_GL(Color3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3s(GLshort red, GLshort green, GLshort blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3s, "context = %d, red = %d, green = %d, blue = %d", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3s(context, angle::EntryPoint::GLColor3s, red, green, blue));
        if (isCallValid)
        {
            context->color3s(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3s, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3sv(context, angle::EntryPoint::GLColor3sv, v));
        if (isCallValid)
        {
            context->color3sv(v);
        }
        ANGLE_CAPTURE_GL(Color3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3ub, "context = %d, red = %d, green = %d, blue = %d", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3ub(context, angle::EntryPoint::GLColor3ub, red, green, blue));
        if (isCallValid)
        {
            context->color3ub(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3ub, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3ubv(const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3ubv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3ubv(context, angle::EntryPoint::GLColor3ubv, v));
        if (isCallValid)
        {
            context->color3ubv(v);
        }
        ANGLE_CAPTURE_GL(Color3ubv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3ui(GLuint red, GLuint green, GLuint blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3ui, "context = %d, red = %u, green = %u, blue = %u", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3ui(context, angle::EntryPoint::GLColor3ui, red, green, blue));
        if (isCallValid)
        {
            context->color3ui(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3ui, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3uiv(const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3uiv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3uiv(context, angle::EntryPoint::GLColor3uiv, v));
        if (isCallValid)
        {
            context->color3uiv(v);
        }
        ANGLE_CAPTURE_GL(Color3uiv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3us(GLushort red, GLushort green, GLushort blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3us, "context = %d, red = %u, green = %u, blue = %u", CID(context), red,
          green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor3us(context, angle::EntryPoint::GLColor3us, red, green, blue));
        if (isCallValid)
        {
            context->color3us(red, green, blue);
        }
        ANGLE_CAPTURE_GL(Color3us, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color3usv(const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor3usv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor3usv(context, angle::EntryPoint::GLColor3usv, v));
        if (isCallValid)
        {
            context->color3usv(v);
        }
        ANGLE_CAPTURE_GL(Color3usv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4b, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4b(context, angle::EntryPoint::GLColor4b, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4b(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4b, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4bv(const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4bv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4bv(context, angle::EntryPoint::GLColor4bv, v));
        if (isCallValid)
        {
            context->color4bv(v);
        }
        ANGLE_CAPTURE_GL(Color4bv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4d, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4d(context, angle::EntryPoint::GLColor4d, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4d(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4d, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4dv(context, angle::EntryPoint::GLColor4dv, v));
        if (isCallValid)
        {
            context->color4dv(v);
        }
        ANGLE_CAPTURE_GL(Color4dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4f, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4f(context, angle::EntryPoint::GLColor4f, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4f(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4f, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4fv(context, angle::EntryPoint::GLColor4fv, v));
        if (isCallValid)
        {
            context->color4fv(v);
        }
        ANGLE_CAPTURE_GL(Color4fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4i(GLint red, GLint green, GLint blue, GLint alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4i, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4i(context, angle::EntryPoint::GLColor4i, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4i(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4i, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4iv(context, angle::EntryPoint::GLColor4iv, v));
        if (isCallValid)
        {
            context->color4iv(v);
        }
        ANGLE_CAPTURE_GL(Color4iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4s(GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4s, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4s(context, angle::EntryPoint::GLColor4s, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4s(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4s, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4sv(context, angle::EntryPoint::GLColor4sv, v));
        if (isCallValid)
        {
            context->color4sv(v);
        }
        ANGLE_CAPTURE_GL(Color4sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4ub, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4ub(context, angle::EntryPoint::GLColor4ub, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4ub(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4ubv(const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4ubv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4ubv(context, angle::EntryPoint::GLColor4ubv, v));
        if (isCallValid)
        {
            context->color4ubv(v);
        }
        ANGLE_CAPTURE_GL(Color4ubv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4ui, "context = %d, red = %u, green = %u, blue = %u, alpha = %u",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4ui(context, angle::EntryPoint::GLColor4ui, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4ui(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4ui, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4uiv(const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4uiv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4uiv(context, angle::EntryPoint::GLColor4uiv, v));
        if (isCallValid)
        {
            context->color4uiv(v);
        }
        ANGLE_CAPTURE_GL(Color4uiv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4us, "context = %d, red = %u, green = %u, blue = %u, alpha = %u",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4us(context, angle::EntryPoint::GLColor4us, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4us(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4us, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Color4usv(const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4usv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColor4usv(context, angle::EntryPoint::GLColor4usv, v));
        if (isCallValid)
        {
            context->color4usv(v);
        }
        ANGLE_CAPTURE_GL(Color4usv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMask, "context = %d, red = %s, green = %s, blue = %s, alpha = %s",
          CID(context), GLbooleanToString(red), GLbooleanToString(green), GLbooleanToString(blue),
          GLbooleanToString(alpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColorMask(context, angle::EntryPoint::GLColorMask, red, green, blue, alpha));
        if (isCallValid)
        {
            context->colorMask(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(ColorMask, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ColorMaterial(GLenum face, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMaterial, "context = %d, face = %s, mode = %s", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::ColorMaterialParameter, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColorMaterial(context, angle::EntryPoint::GLColorMaterial, face, mode));
        if (isCallValid)
        {
            context->colorMaterial(face, mode);
        }
        ANGLE_CAPTURE_GL(ColorMaterial, isCallValid, context, face, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyPixels, "context = %d, x = %d, y = %d, width = %d, height = %d, type = %s",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelCopyType, type));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyPixels(context, angle::EntryPoint::GLCopyPixels, x, y,
                                                                                    width, height, type));
        if (isCallValid)
        {
            context->copyPixels(x, y, width, height, type);
        }
        ANGLE_CAPTURE_GL(CopyPixels, isCallValid, context, x, y, width, height, type);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CullFace(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCullFace, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::CullFaceMode, mode));

    if (context)
    {
        CullFaceMode modePacked                               = PackParam<CullFaceMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCullFace(context, angle::EntryPoint::GLCullFace, modePacked));
        if (isCallValid)
        {
            context->cullFace(modePacked);
        }
        ANGLE_CAPTURE_GL(CullFace, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteLists(GLuint list, GLsizei range)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteLists, "context = %d, list = %u, range = %d", CID(context), list, range);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDeleteLists(context, angle::EntryPoint::GLDeleteLists, list, range));
        if (isCallValid)
        {
            context->deleteLists(list, range);
        }
        ANGLE_CAPTURE_GL(DeleteLists, isCallValid, context, list, range);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DepthFunc(GLenum func)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthFunc, "context = %d, func = %s", CID(context),
          GLenumToString(GLenumGroup::DepthFunction, func));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDepthFunc(context, angle::EntryPoint::GLDepthFunc, func));
        if (isCallValid)
        {
            context->depthFunc(func);
        }
        ANGLE_CAPTURE_GL(DepthFunc, isCallValid, context, func);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DepthMask(GLboolean flag)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthMask, "context = %d, flag = %s", CID(context), GLbooleanToString(flag));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDepthMask(context, angle::EntryPoint::GLDepthMask, flag));
        if (isCallValid)
        {
            context->depthMask(flag);
        }
        ANGLE_CAPTURE_GL(DepthMask, isCallValid, context, flag);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DepthRange(GLdouble n, GLdouble f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthRange, "context = %d, n = %f, f = %f", CID(context), n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDepthRange(context, angle::EntryPoint::GLDepthRange, n, f));
        if (isCallValid)
        {
            context->depthRange(n, f);
        }
        ANGLE_CAPTURE_GL(DepthRange, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Disable(GLenum cap)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisable, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDisable(context, angle::EntryPoint::GLDisable, cap));
        if (isCallValid)
        {
            context->disable(cap);
        }
        ANGLE_CAPTURE_GL(Disable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawBuffer(GLenum buf)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawBuffer, "context = %d, buf = %s", CID(context),
          GLenumToString(GLenumGroup::DrawBufferMode, buf));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawBuffer(context, angle::EntryPoint::GLDrawBuffer, buf));
        if (isCallValid)
        {
            context->drawBuffer(buf);
        }
        ANGLE_CAPTURE_GL(DrawBuffer, isCallValid, context, buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_DrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawPixels,
          "context = %d, width = %d, height = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR
          "",
          CID(context), width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawPixels(context, angle::EntryPoint::GLDrawPixels, width,
                                                                                    height, format, type, pixels));
        if (isCallValid)
        {
            context->drawPixels(width, height, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(DrawPixels, isCallValid, context, width, height, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EdgeFlag(GLboolean flag)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEdgeFlag, "context = %d, flag = %s", CID(context), GLbooleanToString(flag));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEdgeFlag(context, angle::EntryPoint::GLEdgeFlag, flag));
        if (isCallValid)
        {
            context->edgeFlag(flag);
        }
        ANGLE_CAPTURE_GL(EdgeFlag, isCallValid, context, flag);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EdgeFlagv(const GLboolean *flag)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEdgeFlagv, "context = %d, flag = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)flag);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEdgeFlagv(context, angle::EntryPoint::GLEdgeFlagv, flag));
        if (isCallValid)
        {
            context->edgeFlagv(flag);
        }
        ANGLE_CAPTURE_GL(EdgeFlagv, isCallValid, context, flag);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Enable(GLenum cap)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnable, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEnable(context, angle::EntryPoint::GLEnable, cap));
        if (isCallValid)
        {
            context->enable(cap);
        }
        ANGLE_CAPTURE_GL(Enable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_End()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnd, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnd(context, angle::EntryPoint::GLEnd));
        if (isCallValid)
        {
            context->end();
        }
        ANGLE_CAPTURE_GL(End, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EndList()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndList, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndList(context, angle::EntryPoint::GLEndList));
        if (isCallValid)
        {
            context->endList();
        }
        ANGLE_CAPTURE_GL(EndList, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord1d(GLdouble u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord1d, "context = %d, u = %f", CID(context), u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord1d(context, angle::EntryPoint::GLEvalCoord1d, u));
        if (isCallValid)
        {
            context->evalCoord1d(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord1d, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord1dv(const GLdouble *u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord1dv, "context = %d, u = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord1dv(context, angle::EntryPoint::GLEvalCoord1dv, u));
        if (isCallValid)
        {
            context->evalCoord1dv(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord1dv, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord1f(GLfloat u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord1f, "context = %d, u = %f", CID(context), u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord1f(context, angle::EntryPoint::GLEvalCoord1f, u));
        if (isCallValid)
        {
            context->evalCoord1f(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord1f, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord1fv(const GLfloat *u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord1fv, "context = %d, u = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord1fv(context, angle::EntryPoint::GLEvalCoord1fv, u));
        if (isCallValid)
        {
            context->evalCoord1fv(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord1fv, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord2d(GLdouble u, GLdouble v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord2d, "context = %d, u = %f, v = %f", CID(context), u, v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord2d(context, angle::EntryPoint::GLEvalCoord2d, u, v));
        if (isCallValid)
        {
            context->evalCoord2d(u, v);
        }
        ANGLE_CAPTURE_GL(EvalCoord2d, isCallValid, context, u, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord2dv(const GLdouble *u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord2dv, "context = %d, u = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord2dv(context, angle::EntryPoint::GLEvalCoord2dv, u));
        if (isCallValid)
        {
            context->evalCoord2dv(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord2dv, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord2f(GLfloat u, GLfloat v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord2f, "context = %d, u = %f, v = %f", CID(context), u, v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord2f(context, angle::EntryPoint::GLEvalCoord2f, u, v));
        if (isCallValid)
        {
            context->evalCoord2f(u, v);
        }
        ANGLE_CAPTURE_GL(EvalCoord2f, isCallValid, context, u, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalCoord2fv(const GLfloat *u)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalCoord2fv, "context = %d, u = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)u);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalCoord2fv(context, angle::EntryPoint::GLEvalCoord2fv, u));
        if (isCallValid)
        {
            context->evalCoord2fv(u);
        }
        ANGLE_CAPTURE_GL(EvalCoord2fv, isCallValid, context, u);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalMesh1(GLenum mode, GLint i1, GLint i2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalMesh1, "context = %d, mode = %s, i1 = %d, i2 = %d", CID(context),
          GLenumToString(GLenumGroup::MeshMode1, mode), i1, i2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateEvalMesh1(context, angle::EntryPoint::GLEvalMesh1, mode, i1, i2));
        if (isCallValid)
        {
            context->evalMesh1(mode, i1, i2);
        }
        ANGLE_CAPTURE_GL(EvalMesh1, isCallValid, context, mode, i1, i2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalMesh2, "context = %d, mode = %s, i1 = %d, i2 = %d, j1 = %d, j2 = %d",
          CID(context), GLenumToString(GLenumGroup::MeshMode2, mode), i1, i2, j1, j2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateEvalMesh2(context, angle::EntryPoint::GLEvalMesh2, mode, i1, i2, j1, j2));
        if (isCallValid)
        {
            context->evalMesh2(mode, i1, i2, j1, j2);
        }
        ANGLE_CAPTURE_GL(EvalMesh2, isCallValid, context, mode, i1, i2, j1, j2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalPoint1(GLint i)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalPoint1, "context = %d, i = %d", CID(context), i);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalPoint1(context, angle::EntryPoint::GLEvalPoint1, i));
        if (isCallValid)
        {
            context->evalPoint1(i);
        }
        ANGLE_CAPTURE_GL(EvalPoint1, isCallValid, context, i);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EvalPoint2(GLint i, GLint j)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEvalPoint2, "context = %d, i = %d, j = %d", CID(context), i, j);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEvalPoint2(context, angle::EntryPoint::GLEvalPoint2, i, j));
        if (isCallValid)
        {
            context->evalPoint2(i, j);
        }
        ANGLE_CAPTURE_GL(EvalPoint2, isCallValid, context, i, j);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFeedbackBuffer,
          "context = %d, size = %d, type = %s, buffer = 0x%016" PRIxPTR "", CID(context), size,
          GLenumToString(GLenumGroup::FeedbackType, type), (uintptr_t)buffer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFeedbackBuffer(context, angle::EntryPoint::GLFeedbackBuffer,
                                                                                        size, type, buffer));
        if (isCallValid)
        {
            context->feedbackBuffer(size, type, buffer);
        }
        ANGLE_CAPTURE_GL(FeedbackBuffer, isCallValid, context, size, type, buffer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Finish()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFinish, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFinish(context, angle::EntryPoint::GLFinish));
        if (isCallValid)
        {
            context->finish();
        }
        ANGLE_CAPTURE_GL(Finish, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Flush()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFlush, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFlush(context, angle::EntryPoint::GLFlush));
        if (isCallValid)
        {
            context->flush();
        }
        ANGLE_CAPTURE_GL(Flush, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Fogf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogf(context, angle::EntryPoint::GLFogf, pname, param));
        if (isCallValid)
        {
            context->fogf(pname, param);
        }
        ANGLE_CAPTURE_GL(Fogf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Fogfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogfv(context, angle::EntryPoint::GLFogfv, pname, params));
        if (isCallValid)
        {
            context->fogfv(pname, params);
        }
        ANGLE_CAPTURE_GL(Fogfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Fogi(GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogi, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogi(context, angle::EntryPoint::GLFogi, pname, param));
        if (isCallValid)
        {
            context->fogi(pname, param);
        }
        ANGLE_CAPTURE_GL(Fogi, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Fogiv(GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogiv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogiv(context, angle::EntryPoint::GLFogiv, pname, params));
        if (isCallValid)
        {
            context->fogiv(pname, params);
        }
        ANGLE_CAPTURE_GL(Fogiv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FrontFace(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrontFace, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::FrontFaceDirection, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFrontFace(context, angle::EntryPoint::GLFrontFace, mode));
        if (isCallValid)
        {
            context->frontFace(mode);
        }
        ANGLE_CAPTURE_GL(FrontFace, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Frustum(GLdouble left,
                            GLdouble right,
                            GLdouble bottom,
                            GLdouble top,
                            GLdouble zNear,
                            GLdouble zFar)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrustum,
          "context = %d, left = %f, right = %f, bottom = %f, top = %f, zNear = %f, zFar = %f",
          CID(context), left, right, bottom, top, zNear, zFar);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustum(context, angle::EntryPoint::GLFrustum,
                                                          left, right, bottom, top, zNear, zFar));
        if (isCallValid)
        {
            context->frustum(left, right, bottom, top, zNear, zFar);
        }
        ANGLE_CAPTURE_GL(Frustum, isCallValid, context, left, right, bottom, top, zNear, zFar);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GL_GenLists(GLsizei range)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenLists, "context = %d, range = %d", CID(context), range);

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenLists(context, angle::EntryPoint::GLGenLists, range));
        if (isCallValid)
        {
            returnValue = context->genLists(range);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGenLists, GLuint>();
        }
        ANGLE_CAPTURE_GL(GenLists, isCallValid, context, range, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGenLists, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetBooleanv(GLenum pname, GLboolean *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBooleanv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBooleanv(context, angle::EntryPoint::GLGetBooleanv, pname, data));
        if (isCallValid)
        {
            context->getBooleanv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetBooleanv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetClipPlane(GLenum plane, GLdouble *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetClipPlane, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetClipPlane(context, angle::EntryPoint::GLGetClipPlane, plane, equation));
        if (isCallValid)
        {
            context->getClipPlane(plane, equation);
        }
        ANGLE_CAPTURE_GL(GetClipPlane, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetDoublev(GLenum pname, GLdouble *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetDoublev, "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetDoublev(context, angle::EntryPoint::GLGetDoublev, pname, data));
        if (isCallValid)
        {
            context->getDoublev(pname, data);
        }
        ANGLE_CAPTURE_GL(GetDoublev, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLenum GL_APIENTRY GL_GetError()
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetError, "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetError(context, angle::EntryPoint::GLGetError));
        if (isCallValid)
        {
            returnValue = context->getError();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
        }
        ANGLE_CAPTURE_GL(GetError, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetFloatv(GLenum pname, GLfloat *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFloatv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetFloatv(context, angle::EntryPoint::GLGetFloatv, pname, data));
        if (isCallValid)
        {
            context->getFloatv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetFloatv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetIntegerv(GLenum pname, GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetIntegerv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetIntegerv(context, angle::EntryPoint::GLGetIntegerv, pname, data));
        if (isCallValid)
        {
            context->getIntegerv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetIntegerv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetLightfv(context, angle::EntryPoint::GLGetLightfv, light,
                                                                                    pnamePacked, params));
        if (isCallValid)
        {
            context->getLightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetLightiv(GLenum light, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightiv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetLightiv(context, angle::EntryPoint::GLGetLightiv, light, pname, params));
        if (isCallValid)
        {
            context->getLightiv(light, pname, params);
        }
        ANGLE_CAPTURE_GL(GetLightiv, isCallValid, context, light, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMapdv(GLenum target, GLenum query, GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMapdv, "context = %d, target = %s, query = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::GetMapQuery, query), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMapdv(context, angle::EntryPoint::GLGetMapdv, target, query, v));
        if (isCallValid)
        {
            context->getMapdv(target, query, v);
        }
        ANGLE_CAPTURE_GL(GetMapdv, isCallValid, context, target, query, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMapfv(GLenum target, GLenum query, GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMapfv, "context = %d, target = %s, query = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::GetMapQuery, query), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMapfv(context, angle::EntryPoint::GLGetMapfv, target, query, v));
        if (isCallValid)
        {
            context->getMapfv(target, query, v);
        }
        ANGLE_CAPTURE_GL(GetMapfv, isCallValid, context, target, query, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMapiv(GLenum target, GLenum query, GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMapiv, "context = %d, target = %s, query = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::GetMapQuery, query), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMapiv(context, angle::EntryPoint::GLGetMapiv, target, query, v));
        if (isCallValid)
        {
            context->getMapiv(target, query, v);
        }
        ANGLE_CAPTURE_GL(GetMapiv, isCallValid, context, target, query, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialfv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialfv(context, angle::EntryPoint::GLGetMaterialfv, face,
                                                                                       pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialiv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialiv(context, angle::EntryPoint::GLGetMaterialiv, face,
                                                                                       pname, params));
        if (isCallValid)
        {
            context->getMaterialiv(face, pname, params);
        }
        ANGLE_CAPTURE_GL(GetMaterialiv, isCallValid, context, face, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPixelMapfv(GLenum map, GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPixelMapfv, "context = %d, map = %s, values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPixelMapfv(context, angle::EntryPoint::GLGetPixelMapfv, map, values));
        if (isCallValid)
        {
            context->getPixelMapfv(map, values);
        }
        ANGLE_CAPTURE_GL(GetPixelMapfv, isCallValid, context, map, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPixelMapuiv(GLenum map, GLuint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPixelMapuiv, "context = %d, map = %s, values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPixelMapuiv(context, angle::EntryPoint::GLGetPixelMapuiv, map, values));
        if (isCallValid)
        {
            context->getPixelMapuiv(map, values);
        }
        ANGLE_CAPTURE_GL(GetPixelMapuiv, isCallValid, context, map, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPixelMapusv(GLenum map, GLushort *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPixelMapusv, "context = %d, map = %s, values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPixelMapusv(context, angle::EntryPoint::GLGetPixelMapusv, map, values));
        if (isCallValid)
        {
            context->getPixelMapusv(map, values);
        }
        ANGLE_CAPTURE_GL(GetPixelMapusv, isCallValid, context, map, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPolygonStipple(GLubyte *mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPolygonStipple, "context = %d, mask = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPolygonStipple(context, angle::EntryPoint::GLGetPolygonStipple, mask));
        if (isCallValid)
        {
            context->getPolygonStipple(mask);
        }
        ANGLE_CAPTURE_GL(GetPolygonStipple, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

const GLubyte *GL_APIENTRY GL_GetString(GLenum name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetString, "context = %d, name = %s", CID(context),
          GLenumToString(GLenumGroup::StringName, name));

    const GLubyte *returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetString(context, angle::EntryPoint::GLGetString, name));
        if (isCallValid)
        {
            returnValue = context->getString(name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
        }
        ANGLE_CAPTURE_GL(GetString, isCallValid, context, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnvfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnvfv(context, angle::EntryPoint::GLGetTexEnvfv,
                                                                                     targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnviv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnviv(context, angle::EntryPoint::GLGetTexEnviv,
                                                                                     targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGendv,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexGendv(context, angle::EntryPoint::GLGetTexGendv, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGendv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGendv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenfv,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexGenfv(context, angle::EntryPoint::GLGetTexGenfv, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGenfv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGeniv,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexGeniv(context, angle::EntryPoint::GLGetTexGeniv, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGeniv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_GetTexImage(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexImage,
          "context = %d, target = %s, level = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexImage(context, angle::EntryPoint::GLGetTexImage,
                                                                                     targetPacked, level, format, type, pixels));
        if (isCallValid)
        {
            context->getTexImage(targetPacked, level, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(GetTexImage, isCallValid, context, targetPacked, level, format, type,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexLevelParameterfv(GLenum target,
                                           GLint level,
                                           GLenum pname,
                                           GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterfv,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterfv(context, angle::EntryPoint::GLGetTexLevelParameterfv,
                                            targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterfv, isCallValid, context, targetPacked, level, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameteriv,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameteriv(context, angle::EntryPoint::GLGetTexLevelParameteriv,
                                            targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameteriv, isCallValid, context, targetPacked, level, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexParameterfv(context, angle::EntryPoint::GLGetTexParameterfv,
                                       targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexParameteriv(context, angle::EntryPoint::GLGetTexParameteriv,
                                       targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Hint(GLenum target, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLHint, "context = %d, target = %s, mode = %s", CID(context),
          GLenumToString(GLenumGroup::HintTarget, target),
          GLenumToString(GLenumGroup::HintMode, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateHint(context, angle::EntryPoint::GLHint, target, mode));
        if (isCallValid)
        {
            context->hint(target, mode);
        }
        ANGLE_CAPTURE_GL(Hint, isCallValid, context, target, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_IndexMask(GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexMask, "context = %d, mask = %u", CID(context), mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexMask(context, angle::EntryPoint::GLIndexMask, mask));
        if (isCallValid)
        {
            context->indexMask(mask);
        }
        ANGLE_CAPTURE_GL(IndexMask, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexd(GLdouble c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexd, "context = %d, c = %f", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIndexd(context, angle::EntryPoint::GLIndexd, c));
        if (isCallValid)
        {
            context->indexd(c);
        }
        ANGLE_CAPTURE_GL(Indexd, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexdv(const GLdouble *c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexdv, "context = %d, c = 0x%016" PRIxPTR "", CID(context), (uintptr_t)c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexdv(context, angle::EntryPoint::GLIndexdv, c));
        if (isCallValid)
        {
            context->indexdv(c);
        }
        ANGLE_CAPTURE_GL(Indexdv, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexf(GLfloat c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexf, "context = %d, c = %f", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIndexf(context, angle::EntryPoint::GLIndexf, c));
        if (isCallValid)
        {
            context->indexf(c);
        }
        ANGLE_CAPTURE_GL(Indexf, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexfv(const GLfloat *c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexfv, "context = %d, c = 0x%016" PRIxPTR "", CID(context), (uintptr_t)c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexfv(context, angle::EntryPoint::GLIndexfv, c));
        if (isCallValid)
        {
            context->indexfv(c);
        }
        ANGLE_CAPTURE_GL(Indexfv, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexi(GLint c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexi, "context = %d, c = %d", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIndexi(context, angle::EntryPoint::GLIndexi, c));
        if (isCallValid)
        {
            context->indexi(c);
        }
        ANGLE_CAPTURE_GL(Indexi, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexiv(const GLint *c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexiv, "context = %d, c = 0x%016" PRIxPTR "", CID(context), (uintptr_t)c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexiv(context, angle::EntryPoint::GLIndexiv, c));
        if (isCallValid)
        {
            context->indexiv(c);
        }
        ANGLE_CAPTURE_GL(Indexiv, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexs(GLshort c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexs, "context = %d, c = %d", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIndexs(context, angle::EntryPoint::GLIndexs, c));
        if (isCallValid)
        {
            context->indexs(c);
        }
        ANGLE_CAPTURE_GL(Indexs, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexsv(const GLshort *c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexsv, "context = %d, c = 0x%016" PRIxPTR "", CID(context), (uintptr_t)c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexsv(context, angle::EntryPoint::GLIndexsv, c));
        if (isCallValid)
        {
            context->indexsv(c);
        }
        ANGLE_CAPTURE_GL(Indexsv, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InitNames()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInitNames, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateInitNames(context, angle::EntryPoint::GLInitNames));
        if (isCallValid)
        {
            context->initNames();
        }
        ANGLE_CAPTURE_GL(InitNames, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsEnabled(GLenum cap)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsEnabled, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIsEnabled(context, angle::EntryPoint::GLIsEnabled, cap));
        if (isCallValid)
        {
            returnValue = context->isEnabled(cap);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsEnabled, isCallValid, context, cap, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsList(GLuint list)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsList, "context = %d, list = %u", CID(context), list);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIsList(context, angle::EntryPoint::GLIsList, list));
        if (isCallValid)
        {
            returnValue = context->isList(list);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsList, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsList, isCallValid, context, list, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsList, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_LightModelf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightModelf(context, angle::EntryPoint::GLLightModelf, pname, param));
        if (isCallValid)
        {
            context->lightModelf(pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LightModelfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightModelfv(context, angle::EntryPoint::GLLightModelfv, pname, params));
        if (isCallValid)
        {
            context->lightModelfv(pname, params);
        }
        ANGLE_CAPTURE_GL(LightModelfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LightModeli(GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModeli, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightModeli(context, angle::EntryPoint::GLLightModeli, pname, param));
        if (isCallValid)
        {
            context->lightModeli(pname, param);
        }
        ANGLE_CAPTURE_GL(LightModeli, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LightModeliv(GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModeliv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightModeliv(context, angle::EntryPoint::GLLightModeliv, pname, params));
        if (isCallValid)
        {
            context->lightModeliv(pname, params);
        }
        ANGLE_CAPTURE_GL(LightModeliv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Lightf(GLenum light, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightf, "context = %d, light = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightf(context, angle::EntryPoint::GLLightf, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightf(light, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Lightf, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightfv(context, angle::EntryPoint::GLLightfv, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Lighti(GLenum light, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLighti, "context = %d, light = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLighti(context, angle::EntryPoint::GLLighti, light, pname, param));
        if (isCallValid)
        {
            context->lighti(light, pname, param);
        }
        ANGLE_CAPTURE_GL(Lighti, isCallValid, context, light, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Lightiv(GLenum light, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightiv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightiv(context, angle::EntryPoint::GLLightiv, light, pname, params));
        if (isCallValid)
        {
            context->lightiv(light, pname, params);
        }
        ANGLE_CAPTURE_GL(Lightiv, isCallValid, context, light, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LineStipple(GLint factor, GLushort pattern)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLineStipple, "context = %d, factor = %d, pattern = %u", CID(context), factor,
          pattern);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLineStipple(context, angle::EntryPoint::GLLineStipple, factor, pattern));
        if (isCallValid)
        {
            context->lineStipple(factor, pattern);
        }
        ANGLE_CAPTURE_GL(LineStipple, isCallValid, context, factor, pattern);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LineWidth(GLfloat width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLineWidth, "context = %d, width = %f", CID(context), width);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLineWidth(context, angle::EntryPoint::GLLineWidth, width));
        if (isCallValid)
        {
            context->lineWidth(width);
        }
        ANGLE_CAPTURE_GL(LineWidth, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ListBase(GLuint base)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLListBase, "context = %d, base = %u", CID(context), base);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateListBase(context, angle::EntryPoint::GLListBase, base));
        if (isCallValid)
        {
            context->listBase(base);
        }
        ANGLE_CAPTURE_GL(ListBase, isCallValid, context, base);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadIdentity()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadIdentity, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLoadIdentity(context, angle::EntryPoint::GLLoadIdentity));
        if (isCallValid)
        {
            context->loadIdentity();
        }
        ANGLE_CAPTURE_GL(LoadIdentity, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadMatrixd(const GLdouble *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixd, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLoadMatrixd(context, angle::EntryPoint::GLLoadMatrixd, m));
        if (isCallValid)
        {
            context->loadMatrixd(m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixd, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLoadMatrixf(context, angle::EntryPoint::GLLoadMatrixf, m));
        if (isCallValid)
        {
            context->loadMatrixf(m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadName(GLuint name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadName, "context = %d, name = %u", CID(context), name);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLoadName(context, angle::EntryPoint::GLLoadName, name));
        if (isCallValid)
        {
            context->loadName(name);
        }
        ANGLE_CAPTURE_GL(LoadName, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LogicOp(GLenum opcode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLogicOp, "context = %d, opcode = %s", CID(context),
          GLenumToString(GLenumGroup::LogicOp, opcode));

    if (context)
    {
        LogicalOperation opcodePacked                         = PackParam<LogicalOperation>(opcode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLogicOp(context, angle::EntryPoint::GLLogicOp, opcodePacked));
        if (isCallValid)
        {
            context->logicOp(opcodePacked);
        }
        ANGLE_CAPTURE_GL(LogicOp, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_Map1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMap1d,
          "context = %d, target = %s, u1 = %f, u2 = %f, stride = %d, order = %d, points = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target), u1, u2, stride, order,
          (uintptr_t)points);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMap1d(context, angle::EntryPoint::GLMap1d, target,
                                                        u1, u2, stride, order, points));
        if (isCallValid)
        {
            context->map1d(target, u1, u2, stride, order, points);
        }
        ANGLE_CAPTURE_GL(Map1d, isCallValid, context, target, u1, u2, stride, order, points);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_Map1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMap1f,
          "context = %d, target = %s, u1 = %f, u2 = %f, stride = %d, order = %d, points = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target), u1, u2, stride, order,
          (uintptr_t)points);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMap1f(context, angle::EntryPoint::GLMap1f, target,
                                                        u1, u2, stride, order, points));
        if (isCallValid)
        {
            context->map1f(target, u1, u2, stride, order, points);
        }
        ANGLE_CAPTURE_GL(Map1f, isCallValid, context, target, u1, u2, stride, order, points);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Map2d(GLenum target,
                          GLdouble u1,
                          GLdouble u2,
                          GLint ustride,
                          GLint uorder,
                          GLdouble v1,
                          GLdouble v2,
                          GLint vstride,
                          GLint vorder,
                          const GLdouble *points)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMap2d,
          "context = %d, target = %s, u1 = %f, u2 = %f, ustride = %d, uorder = %d, v1 = %f, v2 = "
          "%f, vstride = %d, vorder = %d, points = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target), u1, u2, ustride, uorder, v1,
          v2, vstride, vorder, (uintptr_t)points);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMap2d(context, angle::EntryPoint::GLMap2d, target, u1, u2,
                                                                               ustride, uorder, v1, v2, vstride, vorder, points));
        if (isCallValid)
        {
            context->map2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
        }
        ANGLE_CAPTURE_GL(Map2d, isCallValid, context, target, u1, u2, ustride, uorder, v1, v2,
                         vstride, vorder, points);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Map2f(GLenum target,
                          GLfloat u1,
                          GLfloat u2,
                          GLint ustride,
                          GLint uorder,
                          GLfloat v1,
                          GLfloat v2,
                          GLint vstride,
                          GLint vorder,
                          const GLfloat *points)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMap2f,
          "context = %d, target = %s, u1 = %f, u2 = %f, ustride = %d, uorder = %d, v1 = %f, v2 = "
          "%f, vstride = %d, vorder = %d, points = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target), u1, u2, ustride, uorder, v1,
          v2, vstride, vorder, (uintptr_t)points);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMap2f(context, angle::EntryPoint::GLMap2f, target, u1, u2,
                                                                               ustride, uorder, v1, v2, vstride, vorder, points));
        if (isCallValid)
        {
            context->map2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
        }
        ANGLE_CAPTURE_GL(Map2f, isCallValid, context, target, u1, u2, ustride, uorder, v1, v2,
                         vstride, vorder, points);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapGrid1d, "context = %d, un = %d, u1 = %f, u2 = %f", CID(context), un, u1,
          u2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMapGrid1d(context, angle::EntryPoint::GLMapGrid1d, un, u1, u2));
        if (isCallValid)
        {
            context->mapGrid1d(un, u1, u2);
        }
        ANGLE_CAPTURE_GL(MapGrid1d, isCallValid, context, un, u1, u2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapGrid1f, "context = %d, un = %d, u1 = %f, u2 = %f", CID(context), un, u1,
          u2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMapGrid1f(context, angle::EntryPoint::GLMapGrid1f, un, u1, u2));
        if (isCallValid)
        {
            context->mapGrid1f(un, u1, u2);
        }
        ANGLE_CAPTURE_GL(MapGrid1f, isCallValid, context, un, u1, u2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_MapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapGrid2d,
          "context = %d, un = %d, u1 = %f, u2 = %f, vn = %d, v1 = %f, v2 = %f", CID(context), un,
          u1, u2, vn, v1, v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapGrid2d(context, angle::EntryPoint::GLMapGrid2d, un, u1, u2, vn, v1, v2));
        if (isCallValid)
        {
            context->mapGrid2d(un, u1, u2, vn, v1, v2);
        }
        ANGLE_CAPTURE_GL(MapGrid2d, isCallValid, context, un, u1, u2, vn, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapGrid2f,
          "context = %d, un = %d, u1 = %f, u2 = %f, vn = %d, v1 = %f, v2 = %f", CID(context), un,
          u1, u2, vn, v1, v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapGrid2f(context, angle::EntryPoint::GLMapGrid2f, un, u1, u2, vn, v1, v2));
        if (isCallValid)
        {
            context->mapGrid2f(un, u1, u2, vn, v1, v2);
        }
        ANGLE_CAPTURE_GL(MapGrid2f, isCallValid, context, un, u1, u2, vn, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Materialf(GLenum face, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialf, "context = %d, face = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialf(context, angle::EntryPoint::GLMaterialf, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialf(face, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Materialf, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialfv, "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMaterialfv(context, angle::EntryPoint::GLMaterialfv, face,
                                                                                    pnamePacked, params));
        if (isCallValid)
        {
            context->materialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Materiali(GLenum face, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMateriali, "context = %d, face = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMateriali(context, angle::EntryPoint::GLMateriali, face, pname, param));
        if (isCallValid)
        {
            context->materiali(face, pname, param);
        }
        ANGLE_CAPTURE_GL(Materiali, isCallValid, context, face, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Materialiv(GLenum face, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialiv, "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialiv(context, angle::EntryPoint::GLMaterialiv, face, pname, params));
        if (isCallValid)
        {
            context->materialiv(face, pname, params);
        }
        ANGLE_CAPTURE_GL(Materialiv, isCallValid, context, face, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MatrixMode(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMatrixMode, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::MatrixMode, mode));

    if (context)
    {
        MatrixType modePacked                                 = PackParam<MatrixType>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMatrixMode(context, angle::EntryPoint::GLMatrixMode, modePacked));
        if (isCallValid)
        {
            context->matrixMode(modePacked);
        }
        ANGLE_CAPTURE_GL(MatrixMode, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultMatrixd(const GLdouble *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixd, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultMatrixd(context, angle::EntryPoint::GLMultMatrixd, m));
        if (isCallValid)
        {
            context->multMatrixd(m);
        }
        ANGLE_CAPTURE_GL(MultMatrixd, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultMatrixf(context, angle::EntryPoint::GLMultMatrixf, m));
        if (isCallValid)
        {
            context->multMatrixf(m);
        }
        ANGLE_CAPTURE_GL(MultMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NewList(GLuint list, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNewList, "context = %d, list = %u, mode = %s", CID(context), list,
          GLenumToString(GLenumGroup::ListMode, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNewList(context, angle::EntryPoint::GLNewList, list, mode));
        if (isCallValid)
        {
            context->newList(list, mode);
        }
        ANGLE_CAPTURE_GL(NewList, isCallValid, context, list, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3b, "context = %d, nx = %d, ny = %d, nz = %d", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3b(context, angle::EntryPoint::GLNormal3b, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3b(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3b, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3bv(const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3bv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3bv(context, angle::EntryPoint::GLNormal3bv, v));
        if (isCallValid)
        {
            context->normal3bv(v);
        }
        ANGLE_CAPTURE_GL(Normal3bv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3d, "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3d(context, angle::EntryPoint::GLNormal3d, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3d(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3d, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3dv(context, angle::EntryPoint::GLNormal3dv, v));
        if (isCallValid)
        {
            context->normal3dv(v);
        }
        ANGLE_CAPTURE_GL(Normal3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3f, "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3f(context, angle::EntryPoint::GLNormal3f, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3f(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3f, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3fv(context, angle::EntryPoint::GLNormal3fv, v));
        if (isCallValid)
        {
            context->normal3fv(v);
        }
        ANGLE_CAPTURE_GL(Normal3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3i(GLint nx, GLint ny, GLint nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3i, "context = %d, nx = %d, ny = %d, nz = %d", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3i(context, angle::EntryPoint::GLNormal3i, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3i(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3i, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3iv(context, angle::EntryPoint::GLNormal3iv, v));
        if (isCallValid)
        {
            context->normal3iv(v);
        }
        ANGLE_CAPTURE_GL(Normal3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3s(GLshort nx, GLshort ny, GLshort nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3s, "context = %d, nx = %d, ny = %d, nz = %d", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3s(context, angle::EntryPoint::GLNormal3s, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3s(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3s, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Normal3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormal3sv(context, angle::EntryPoint::GLNormal3sv, v));
        if (isCallValid)
        {
            context->normal3sv(v);
        }
        ANGLE_CAPTURE_GL(Normal3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Ortho(GLdouble left,
                          GLdouble right,
                          GLdouble bottom,
                          GLdouble top,
                          GLdouble zNear,
                          GLdouble zFar)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLOrtho,
          "context = %d, left = %f, right = %f, bottom = %f, top = %f, zNear = %f, zFar = %f",
          CID(context), left, right, bottom, top, zNear, zFar);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateOrtho(context, angle::EntryPoint::GLOrtho, left,
                                                        right, bottom, top, zNear, zFar));
        if (isCallValid)
        {
            context->ortho(left, right, bottom, top, zNear, zFar);
        }
        ANGLE_CAPTURE_GL(Ortho, isCallValid, context, left, right, bottom, top, zNear, zFar);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PassThrough(GLfloat token)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPassThrough, "context = %d, token = %f", CID(context), token);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePassThrough(context, angle::EntryPoint::GLPassThrough, token));
        if (isCallValid)
        {
            context->passThrough(token);
        }
        ANGLE_CAPTURE_GL(PassThrough, isCallValid, context, token);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelMapfv, "context = %d, map = %s, mapsize = %d, values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), mapsize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelMapfv(context, angle::EntryPoint::GLPixelMapfv, map, mapsize, values));
        if (isCallValid)
        {
            context->pixelMapfv(map, mapsize, values);
        }
        ANGLE_CAPTURE_GL(PixelMapfv, isCallValid, context, map, mapsize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelMapuiv,
          "context = %d, map = %s, mapsize = %d, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PixelMap, map), mapsize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelMapuiv(context, angle::EntryPoint::GLPixelMapuiv, map, mapsize, values));
        if (isCallValid)
        {
            context->pixelMapuiv(map, mapsize, values);
        }
        ANGLE_CAPTURE_GL(PixelMapuiv, isCallValid, context, map, mapsize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelMapusv,
          "context = %d, map = %s, mapsize = %d, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PixelMap, map), mapsize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelMapusv(context, angle::EntryPoint::GLPixelMapusv, map, mapsize, values));
        if (isCallValid)
        {
            context->pixelMapusv(map, mapsize, values);
        }
        ANGLE_CAPTURE_GL(PixelMapusv, isCallValid, context, map, mapsize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelStoref(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelStoref, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::PixelStoreParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelStoref(context, angle::EntryPoint::GLPixelStoref, pname, param));
        if (isCallValid)
        {
            context->pixelStoref(pname, param);
        }
        ANGLE_CAPTURE_GL(PixelStoref, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelStorei(GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelStorei, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::PixelStoreParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelStorei(context, angle::EntryPoint::GLPixelStorei, pname, param));
        if (isCallValid)
        {
            context->pixelStorei(pname, param);
        }
        ANGLE_CAPTURE_GL(PixelStorei, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelTransferf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelTransferf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::PixelTransferParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelTransferf(context, angle::EntryPoint::GLPixelTransferf, pname, param));
        if (isCallValid)
        {
            context->pixelTransferf(pname, param);
        }
        ANGLE_CAPTURE_GL(PixelTransferf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelTransferi(GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelTransferi, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::PixelTransferParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelTransferi(context, angle::EntryPoint::GLPixelTransferi, pname, param));
        if (isCallValid)
        {
            context->pixelTransferi(pname, param);
        }
        ANGLE_CAPTURE_GL(PixelTransferi, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PixelZoom(GLfloat xfactor, GLfloat yfactor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelZoom, "context = %d, xfactor = %f, yfactor = %f", CID(context), xfactor,
          yfactor);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePixelZoom(context, angle::EntryPoint::GLPixelZoom, xfactor, yfactor));
        if (isCallValid)
        {
            context->pixelZoom(xfactor, yfactor);
        }
        ANGLE_CAPTURE_GL(PixelZoom, isCallValid, context, xfactor, yfactor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PointSize(GLfloat size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSize, "context = %d, size = %f", CID(context), size);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePointSize(context, angle::EntryPoint::GLPointSize, size));
        if (isCallValid)
        {
            context->pointSize(size);
        }
        ANGLE_CAPTURE_GL(PointSize, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PolygonMode(GLenum face, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonMode, "context = %d, face = %s, mode = %s", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::PolygonMode, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePolygonMode(context, angle::EntryPoint::GLPolygonMode, face, mode));
        if (isCallValid)
        {
            context->polygonMode(face, mode);
        }
        ANGLE_CAPTURE_GL(PolygonMode, isCallValid, context, face, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PolygonStipple(const GLubyte *mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonStipple, "context = %d, mask = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePolygonStipple(context, angle::EntryPoint::GLPolygonStipple, mask));
        if (isCallValid)
        {
            context->polygonStipple(mask);
        }
        ANGLE_CAPTURE_GL(PolygonStipple, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopAttrib()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopAttrib, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePopAttrib(context, angle::EntryPoint::GLPopAttrib));
        if (isCallValid)
        {
            context->popAttrib();
        }
        ANGLE_CAPTURE_GL(PopAttrib, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopMatrix, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePopMatrix(context, angle::EntryPoint::GLPopMatrix));
        if (isCallValid)
        {
            context->popMatrix();
        }
        ANGLE_CAPTURE_GL(PopMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopName()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopName, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePopName(context, angle::EntryPoint::GLPopName));
        if (isCallValid)
        {
            context->popName();
        }
        ANGLE_CAPTURE_GL(PopName, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushAttrib(GLbitfield mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushAttrib, "context = %d, mask = %s", CID(context),
          GLbitfieldToString(GLenumGroup::AttribMask, mask).c_str());

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePushAttrib(context, angle::EntryPoint::GLPushAttrib, mask));
        if (isCallValid)
        {
            context->pushAttrib(mask);
        }
        ANGLE_CAPTURE_GL(PushAttrib, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushMatrix, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePushMatrix(context, angle::EntryPoint::GLPushMatrix));
        if (isCallValid)
        {
            context->pushMatrix();
        }
        ANGLE_CAPTURE_GL(PushMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushName(GLuint name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushName, "context = %d, name = %u", CID(context), name);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePushName(context, angle::EntryPoint::GLPushName, name));
        if (isCallValid)
        {
            context->pushName(name);
        }
        ANGLE_CAPTURE_GL(PushName, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2d(GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2d, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2d(context, angle::EntryPoint::GLRasterPos2d, x, y));
        if (isCallValid)
        {
            context->rasterPos2d(x, y);
        }
        ANGLE_CAPTURE_GL(RasterPos2d, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2dv(context, angle::EntryPoint::GLRasterPos2dv, v));
        if (isCallValid)
        {
            context->rasterPos2dv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos2dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2f(GLfloat x, GLfloat y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2f, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2f(context, angle::EntryPoint::GLRasterPos2f, x, y));
        if (isCallValid)
        {
            context->rasterPos2f(x, y);
        }
        ANGLE_CAPTURE_GL(RasterPos2f, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2fv(context, angle::EntryPoint::GLRasterPos2fv, v));
        if (isCallValid)
        {
            context->rasterPos2fv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos2fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2i(GLint x, GLint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2i, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2i(context, angle::EntryPoint::GLRasterPos2i, x, y));
        if (isCallValid)
        {
            context->rasterPos2i(x, y);
        }
        ANGLE_CAPTURE_GL(RasterPos2i, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2iv(context, angle::EntryPoint::GLRasterPos2iv, v));
        if (isCallValid)
        {
            context->rasterPos2iv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos2iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2s(GLshort x, GLshort y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2s, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2s(context, angle::EntryPoint::GLRasterPos2s, x, y));
        if (isCallValid)
        {
            context->rasterPos2s(x, y);
        }
        ANGLE_CAPTURE_GL(RasterPos2s, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos2sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos2sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos2sv(context, angle::EntryPoint::GLRasterPos2sv, v));
        if (isCallValid)
        {
            context->rasterPos2sv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos2sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3d, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos3d(context, angle::EntryPoint::GLRasterPos3d, x, y, z));
        if (isCallValid)
        {
            context->rasterPos3d(x, y, z);
        }
        ANGLE_CAPTURE_GL(RasterPos3d, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos3dv(context, angle::EntryPoint::GLRasterPos3dv, v));
        if (isCallValid)
        {
            context->rasterPos3dv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3f, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos3f(context, angle::EntryPoint::GLRasterPos3f, x, y, z));
        if (isCallValid)
        {
            context->rasterPos3f(x, y, z);
        }
        ANGLE_CAPTURE_GL(RasterPos3f, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos3fv(context, angle::EntryPoint::GLRasterPos3fv, v));
        if (isCallValid)
        {
            context->rasterPos3fv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3i(GLint x, GLint y, GLint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3i, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos3i(context, angle::EntryPoint::GLRasterPos3i, x, y, z));
        if (isCallValid)
        {
            context->rasterPos3i(x, y, z);
        }
        ANGLE_CAPTURE_GL(RasterPos3i, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos3iv(context, angle::EntryPoint::GLRasterPos3iv, v));
        if (isCallValid)
        {
            context->rasterPos3iv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3s(GLshort x, GLshort y, GLshort z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3s, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos3s(context, angle::EntryPoint::GLRasterPos3s, x, y, z));
        if (isCallValid)
        {
            context->rasterPos3s(x, y, z);
        }
        ANGLE_CAPTURE_GL(RasterPos3s, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos3sv(context, angle::EntryPoint::GLRasterPos3sv, v));
        if (isCallValid)
        {
            context->rasterPos3sv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4d, "context = %d, x = %f, y = %f, z = %f, w = %f", CID(context), x,
          y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos4d(context, angle::EntryPoint::GLRasterPos4d, x, y, z, w));
        if (isCallValid)
        {
            context->rasterPos4d(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(RasterPos4d, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos4dv(context, angle::EntryPoint::GLRasterPos4dv, v));
        if (isCallValid)
        {
            context->rasterPos4dv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos4dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4f, "context = %d, x = %f, y = %f, z = %f, w = %f", CID(context), x,
          y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos4f(context, angle::EntryPoint::GLRasterPos4f, x, y, z, w));
        if (isCallValid)
        {
            context->rasterPos4f(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(RasterPos4f, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos4fv(context, angle::EntryPoint::GLRasterPos4fv, v));
        if (isCallValid)
        {
            context->rasterPos4fv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos4fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4i, "context = %d, x = %d, y = %d, z = %d, w = %d", CID(context), x,
          y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos4i(context, angle::EntryPoint::GLRasterPos4i, x, y, z, w));
        if (isCallValid)
        {
            context->rasterPos4i(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(RasterPos4i, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos4iv(context, angle::EntryPoint::GLRasterPos4iv, v));
        if (isCallValid)
        {
            context->rasterPos4iv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos4iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4s, "context = %d, x = %d, y = %d, z = %d, w = %d", CID(context), x,
          y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRasterPos4s(context, angle::EntryPoint::GLRasterPos4s, x, y, z, w));
        if (isCallValid)
        {
            context->rasterPos4s(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(RasterPos4s, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RasterPos4sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRasterPos4sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRasterPos4sv(context, angle::EntryPoint::GLRasterPos4sv, v));
        if (isCallValid)
        {
            context->rasterPos4sv(v);
        }
        ANGLE_CAPTURE_GL(RasterPos4sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ReadBuffer(GLenum src)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadBuffer, "context = %d, src = %s", CID(context),
          GLenumToString(GLenumGroup::ReadBufferMode, src));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateReadBuffer(context, angle::EntryPoint::GLReadBuffer, src));
        if (isCallValid)
        {
            context->readBuffer(src);
        }
        ANGLE_CAPTURE_GL(ReadBuffer, isCallValid, context, src);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ReadPixels(GLint x,
                               GLint y,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadPixels,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, pixels = "
          "0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateReadPixels(context, angle::EntryPoint::GLReadPixels, x, y,
                                                                                    width, height, format, type, pixels));
        if (isCallValid)
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(ReadPixels, isCallValid, context, x, y, width, height, format, type,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectd, "context = %d, x1 = %f, y1 = %f, x2 = %f, y2 = %f", CID(context), x1,
          y1, x2, y2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectd(context, angle::EntryPoint::GLRectd, x1, y1, x2, y2));
        if (isCallValid)
        {
            context->rectd(x1, y1, x2, y2);
        }
        ANGLE_CAPTURE_GL(Rectd, isCallValid, context, x1, y1, x2, y2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectdv(const GLdouble *v1, const GLdouble *v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectdv, "context = %d, v1 = 0x%016" PRIxPTR ", v2 = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)v1, (uintptr_t)v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectdv(context, angle::EntryPoint::GLRectdv, v1, v2));
        if (isCallValid)
        {
            context->rectdv(v1, v2);
        }
        ANGLE_CAPTURE_GL(Rectdv, isCallValid, context, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectf, "context = %d, x1 = %f, y1 = %f, x2 = %f, y2 = %f", CID(context), x1,
          y1, x2, y2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectf(context, angle::EntryPoint::GLRectf, x1, y1, x2, y2));
        if (isCallValid)
        {
            context->rectf(x1, y1, x2, y2);
        }
        ANGLE_CAPTURE_GL(Rectf, isCallValid, context, x1, y1, x2, y2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectfv(const GLfloat *v1, const GLfloat *v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectfv, "context = %d, v1 = 0x%016" PRIxPTR ", v2 = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)v1, (uintptr_t)v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectfv(context, angle::EntryPoint::GLRectfv, v1, v2));
        if (isCallValid)
        {
            context->rectfv(v1, v2);
        }
        ANGLE_CAPTURE_GL(Rectfv, isCallValid, context, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Recti(GLint x1, GLint y1, GLint x2, GLint y2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRecti, "context = %d, x1 = %d, y1 = %d, x2 = %d, y2 = %d", CID(context), x1,
          y1, x2, y2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRecti(context, angle::EntryPoint::GLRecti, x1, y1, x2, y2));
        if (isCallValid)
        {
            context->recti(x1, y1, x2, y2);
        }
        ANGLE_CAPTURE_GL(Recti, isCallValid, context, x1, y1, x2, y2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectiv(const GLint *v1, const GLint *v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectiv, "context = %d, v1 = 0x%016" PRIxPTR ", v2 = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)v1, (uintptr_t)v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectiv(context, angle::EntryPoint::GLRectiv, v1, v2));
        if (isCallValid)
        {
            context->rectiv(v1, v2);
        }
        ANGLE_CAPTURE_GL(Rectiv, isCallValid, context, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rects(GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRects, "context = %d, x1 = %d, y1 = %d, x2 = %d, y2 = %d", CID(context), x1,
          y1, x2, y2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRects(context, angle::EntryPoint::GLRects, x1, y1, x2, y2));
        if (isCallValid)
        {
            context->rects(x1, y1, x2, y2);
        }
        ANGLE_CAPTURE_GL(Rects, isCallValid, context, x1, y1, x2, y2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rectsv(const GLshort *v1, const GLshort *v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRectsv, "context = %d, v1 = 0x%016" PRIxPTR ", v2 = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)v1, (uintptr_t)v2);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRectsv(context, angle::EntryPoint::GLRectsv, v1, v2));
        if (isCallValid)
        {
            context->rectsv(v1, v2);
        }
        ANGLE_CAPTURE_GL(Rectsv, isCallValid, context, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GL_RenderMode(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderMode, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::RenderingMode, mode));

    GLint returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRenderMode(context, angle::EntryPoint::GLRenderMode, mode));
        if (isCallValid)
        {
            returnValue = context->renderMode(mode);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLRenderMode, GLint>();
        }
        ANGLE_CAPTURE_GL(RenderMode, isCallValid, context, mode, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLRenderMode, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_Rotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotated, "context = %d, angle = %f, x = %f, y = %f, z = %f", CID(context),
          angle, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRotated(context, angle::EntryPoint::GLRotated, angle, x, y, z));
        if (isCallValid)
        {
            context->rotated(angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotated, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotatef, "context = %d, angle = %f, x = %f, y = %f, z = %f", CID(context),
          angle, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRotatef(context, angle::EntryPoint::GLRotatef, angle, x, y, z));
        if (isCallValid)
        {
            context->rotatef(angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotatef, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Scaled(GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScaled, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateScaled(context, angle::EntryPoint::GLScaled, x, y, z));
        if (isCallValid)
        {
            context->scaled(x, y, z);
        }
        ANGLE_CAPTURE_GL(Scaled, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScalef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateScalef(context, angle::EntryPoint::GLScalef, x, y, z));
        if (isCallValid)
        {
            context->scalef(x, y, z);
        }
        ANGLE_CAPTURE_GL(Scalef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScissor, "context = %d, x = %d, y = %d, width = %d, height = %d", CID(context),
          x, y, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateScissor(context, angle::EntryPoint::GLScissor, x, y, width, height));
        if (isCallValid)
        {
            context->scissor(x, y, width, height);
        }
        ANGLE_CAPTURE_GL(Scissor, isCallValid, context, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SelectBuffer(GLsizei size, GLuint *buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSelectBuffer, "context = %d, size = %d, buffer = 0x%016" PRIxPTR "",
          CID(context), size, (uintptr_t)buffer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSelectBuffer(context, angle::EntryPoint::GLSelectBuffer, size, buffer));
        if (isCallValid)
        {
            context->selectBuffer(size, buffer);
        }
        ANGLE_CAPTURE_GL(SelectBuffer, isCallValid, context, size, buffer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ShadeModel(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadeModel, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::ShadingModel, mode));

    if (context)
    {
        ShadingModel modePacked                               = PackParam<ShadingModel>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateShadeModel(context, angle::EntryPoint::GLShadeModel, modePacked));
        if (isCallValid)
        {
            context->shadeModel(modePacked);
        }
        ANGLE_CAPTURE_GL(ShadeModel, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilFunc, "context = %d, func = %s, ref = %d, mask = %u", CID(context),
          GLenumToString(GLenumGroup::StencilFunction, func), ref, mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateStencilFunc(context, angle::EntryPoint::GLStencilFunc, func, ref, mask));
        if (isCallValid)
        {
            context->stencilFunc(func, ref, mask);
        }
        ANGLE_CAPTURE_GL(StencilFunc, isCallValid, context, func, ref, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilMask(GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilMask, "context = %d, mask = %u", CID(context), mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateStencilMask(context, angle::EntryPoint::GLStencilMask, mask));
        if (isCallValid)
        {
            context->stencilMask(mask);
        }
        ANGLE_CAPTURE_GL(StencilMask, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilOp, "context = %d, fail = %s, zfail = %s, zpass = %s", CID(context),
          GLenumToString(GLenumGroup::StencilOp, fail),
          GLenumToString(GLenumGroup::StencilOp, zfail),
          GLenumToString(GLenumGroup::StencilOp, zpass));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateStencilOp(context, angle::EntryPoint::GLStencilOp, fail, zfail, zpass));
        if (isCallValid)
        {
            context->stencilOp(fail, zfail, zpass);
        }
        ANGLE_CAPTURE_GL(StencilOp, isCallValid, context, fail, zfail, zpass);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1d(GLdouble s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1d, "context = %d, s = %f", CID(context), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1d(context, angle::EntryPoint::GLTexCoord1d, s));
        if (isCallValid)
        {
            context->texCoord1d(s);
        }
        ANGLE_CAPTURE_GL(TexCoord1d, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1dv(context, angle::EntryPoint::GLTexCoord1dv, v));
        if (isCallValid)
        {
            context->texCoord1dv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord1dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1f(GLfloat s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1f, "context = %d, s = %f", CID(context), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1f(context, angle::EntryPoint::GLTexCoord1f, s));
        if (isCallValid)
        {
            context->texCoord1f(s);
        }
        ANGLE_CAPTURE_GL(TexCoord1f, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1fv(context, angle::EntryPoint::GLTexCoord1fv, v));
        if (isCallValid)
        {
            context->texCoord1fv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord1fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1i(GLint s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1i, "context = %d, s = %d", CID(context), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1i(context, angle::EntryPoint::GLTexCoord1i, s));
        if (isCallValid)
        {
            context->texCoord1i(s);
        }
        ANGLE_CAPTURE_GL(TexCoord1i, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1iv(context, angle::EntryPoint::GLTexCoord1iv, v));
        if (isCallValid)
        {
            context->texCoord1iv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord1iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1s(GLshort s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1s, "context = %d, s = %d", CID(context), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1s(context, angle::EntryPoint::GLTexCoord1s, s));
        if (isCallValid)
        {
            context->texCoord1s(s);
        }
        ANGLE_CAPTURE_GL(TexCoord1s, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord1sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord1sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord1sv(context, angle::EntryPoint::GLTexCoord1sv, v));
        if (isCallValid)
        {
            context->texCoord1sv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord1sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2d(GLdouble s, GLdouble t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2d, "context = %d, s = %f, t = %f", CID(context), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2d(context, angle::EntryPoint::GLTexCoord2d, s, t));
        if (isCallValid)
        {
            context->texCoord2d(s, t);
        }
        ANGLE_CAPTURE_GL(TexCoord2d, isCallValid, context, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2dv(context, angle::EntryPoint::GLTexCoord2dv, v));
        if (isCallValid)
        {
            context->texCoord2dv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord2dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2f(GLfloat s, GLfloat t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2f, "context = %d, s = %f, t = %f", CID(context), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2f(context, angle::EntryPoint::GLTexCoord2f, s, t));
        if (isCallValid)
        {
            context->texCoord2f(s, t);
        }
        ANGLE_CAPTURE_GL(TexCoord2f, isCallValid, context, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2fv(context, angle::EntryPoint::GLTexCoord2fv, v));
        if (isCallValid)
        {
            context->texCoord2fv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord2fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2i(GLint s, GLint t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2i, "context = %d, s = %d, t = %d", CID(context), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2i(context, angle::EntryPoint::GLTexCoord2i, s, t));
        if (isCallValid)
        {
            context->texCoord2i(s, t);
        }
        ANGLE_CAPTURE_GL(TexCoord2i, isCallValid, context, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2iv(context, angle::EntryPoint::GLTexCoord2iv, v));
        if (isCallValid)
        {
            context->texCoord2iv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord2iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2s(GLshort s, GLshort t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2s, "context = %d, s = %d, t = %d", CID(context), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2s(context, angle::EntryPoint::GLTexCoord2s, s, t));
        if (isCallValid)
        {
            context->texCoord2s(s, t);
        }
        ANGLE_CAPTURE_GL(TexCoord2s, isCallValid, context, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord2sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord2sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord2sv(context, angle::EntryPoint::GLTexCoord2sv, v));
        if (isCallValid)
        {
            context->texCoord2sv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord2sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3d, "context = %d, s = %f, t = %f, r = %f", CID(context), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3d(context, angle::EntryPoint::GLTexCoord3d, s, t, r));
        if (isCallValid)
        {
            context->texCoord3d(s, t, r);
        }
        ANGLE_CAPTURE_GL(TexCoord3d, isCallValid, context, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3dv(context, angle::EntryPoint::GLTexCoord3dv, v));
        if (isCallValid)
        {
            context->texCoord3dv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3f, "context = %d, s = %f, t = %f, r = %f", CID(context), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3f(context, angle::EntryPoint::GLTexCoord3f, s, t, r));
        if (isCallValid)
        {
            context->texCoord3f(s, t, r);
        }
        ANGLE_CAPTURE_GL(TexCoord3f, isCallValid, context, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3fv(context, angle::EntryPoint::GLTexCoord3fv, v));
        if (isCallValid)
        {
            context->texCoord3fv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3i(GLint s, GLint t, GLint r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3i, "context = %d, s = %d, t = %d, r = %d", CID(context), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3i(context, angle::EntryPoint::GLTexCoord3i, s, t, r));
        if (isCallValid)
        {
            context->texCoord3i(s, t, r);
        }
        ANGLE_CAPTURE_GL(TexCoord3i, isCallValid, context, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3iv(context, angle::EntryPoint::GLTexCoord3iv, v));
        if (isCallValid)
        {
            context->texCoord3iv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3s(GLshort s, GLshort t, GLshort r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3s, "context = %d, s = %d, t = %d, r = %d", CID(context), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3s(context, angle::EntryPoint::GLTexCoord3s, s, t, r));
        if (isCallValid)
        {
            context->texCoord3s(s, t, r);
        }
        ANGLE_CAPTURE_GL(TexCoord3s, isCallValid, context, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord3sv(context, angle::EntryPoint::GLTexCoord3sv, v));
        if (isCallValid)
        {
            context->texCoord3sv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4d, "context = %d, s = %f, t = %f, r = %f, q = %f", CID(context), s, t,
          r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexCoord4d(context, angle::EntryPoint::GLTexCoord4d, s, t, r, q));
        if (isCallValid)
        {
            context->texCoord4d(s, t, r, q);
        }
        ANGLE_CAPTURE_GL(TexCoord4d, isCallValid, context, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord4dv(context, angle::EntryPoint::GLTexCoord4dv, v));
        if (isCallValid)
        {
            context->texCoord4dv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord4dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4f, "context = %d, s = %f, t = %f, r = %f, q = %f", CID(context), s, t,
          r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexCoord4f(context, angle::EntryPoint::GLTexCoord4f, s, t, r, q));
        if (isCallValid)
        {
            context->texCoord4f(s, t, r, q);
        }
        ANGLE_CAPTURE_GL(TexCoord4f, isCallValid, context, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord4fv(context, angle::EntryPoint::GLTexCoord4fv, v));
        if (isCallValid)
        {
            context->texCoord4fv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord4fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4i, "context = %d, s = %d, t = %d, r = %d, q = %d", CID(context), s, t,
          r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexCoord4i(context, angle::EntryPoint::GLTexCoord4i, s, t, r, q));
        if (isCallValid)
        {
            context->texCoord4i(s, t, r, q);
        }
        ANGLE_CAPTURE_GL(TexCoord4i, isCallValid, context, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord4iv(context, angle::EntryPoint::GLTexCoord4iv, v));
        if (isCallValid)
        {
            context->texCoord4iv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord4iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4s, "context = %d, s = %d, t = %d, r = %d, q = %d", CID(context), s, t,
          r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexCoord4s(context, angle::EntryPoint::GLTexCoord4s, s, t, r, q));
        if (isCallValid)
        {
            context->texCoord4s(s, t, r, q);
        }
        ANGLE_CAPTURE_GL(TexCoord4s, isCallValid, context, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoord4sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoord4sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoord4sv(context, angle::EntryPoint::GLTexCoord4sv, v));
        if (isCallValid)
        {
            context->texCoord4sv(v);
        }
        ANGLE_CAPTURE_GL(TexCoord4sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvf, "context = %d, target = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexEnvf(context, angle::EntryPoint::GLTexEnvf,
                                                          targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(TexEnvf, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvfv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexEnvfv(context, angle::EntryPoint::GLTexEnvfv,
                                                           targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexEnvi(GLenum target, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvi, "context = %d, target = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexEnvi(context, angle::EntryPoint::GLTexEnvi,
                                                          targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(TexEnvi, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnviv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexEnviv(context, angle::EntryPoint::GLTexEnviv,
                                                           targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGend(GLenum coord, GLenum pname, GLdouble param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGend, "context = %d, coord = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGend(context, angle::EntryPoint::GLTexGend, coord, pname, param));
        if (isCallValid)
        {
            context->texGend(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGend, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGendv, "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGendv(context, angle::EntryPoint::GLTexGendv, coord, pname, params));
        if (isCallValid)
        {
            context->texGendv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGendv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenf(GLenum coord, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenf, "context = %d, coord = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGenf(context, angle::EntryPoint::GLTexGenf, coord, pname, param));
        if (isCallValid)
        {
            context->texGenf(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGenf, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenfv, "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGenfv(context, angle::EntryPoint::GLTexGenfv, coord, pname, params));
        if (isCallValid)
        {
            context->texGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGenfv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGeni(GLenum coord, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGeni, "context = %d, coord = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGeni(context, angle::EntryPoint::GLTexGeni, coord, pname, param));
        if (isCallValid)
        {
            context->texGeni(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGeni, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGeniv, "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexGeniv(context, angle::EntryPoint::GLTexGeniv, coord, pname, params));
        if (isCallValid)
        {
            context->texGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGeniv, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage1D(GLenum target,
                               GLint level,
                               GLint internalformat,
                               GLsizei width,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage1D,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, border = %d, "
          "format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage1D(context, angle::EntryPoint::GLTexImage1D, target, level,
                                internalformat, width, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage1D(target, level, internalformat, width, border, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage1D, isCallValid, context, target, level, internalformat, width,
                         border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage2D(GLenum target,
                               GLint level,
                               GLint internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2D,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "border = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, height, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage2D(context, angle::EntryPoint::GLTexImage2D, targetPacked, level,
                                internalformat, width, height, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage2D, isCallValid, context, targetPacked, level, internalformat,
                         width, height, border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterf, "context = %d, target = %s, pname = %s, param = %f",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterf(context, angle::EntryPoint::GLTexParameterf,
                                                                                       targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterf(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameterf, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterfv(context, angle::EntryPoint::GLTexParameterfv,
                                                                                        targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameteri(GLenum target, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameteri, "context = %d, target = %s, pname = %s, param = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameteri(context, angle::EntryPoint::GLTexParameteri,
                                                                                       targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameteri(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameteri, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameteriv(context, angle::EntryPoint::GLTexParameteriv,
                                                                                        targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Translated(GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslated, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTranslated(context, angle::EntryPoint::GLTranslated, x, y, z));
        if (isCallValid)
        {
            context->translated(x, y, z);
        }
        ANGLE_CAPTURE_GL(Translated, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslatef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTranslatef(context, angle::EntryPoint::GLTranslatef, x, y, z));
        if (isCallValid)
        {
            context->translatef(x, y, z);
        }
        ANGLE_CAPTURE_GL(Translatef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2d(GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2d, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2d(context, angle::EntryPoint::GLVertex2d, x, y));
        if (isCallValid)
        {
            context->vertex2d(x, y);
        }
        ANGLE_CAPTURE_GL(Vertex2d, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2dv(context, angle::EntryPoint::GLVertex2dv, v));
        if (isCallValid)
        {
            context->vertex2dv(v);
        }
        ANGLE_CAPTURE_GL(Vertex2dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2f(GLfloat x, GLfloat y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2f, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2f(context, angle::EntryPoint::GLVertex2f, x, y));
        if (isCallValid)
        {
            context->vertex2f(x, y);
        }
        ANGLE_CAPTURE_GL(Vertex2f, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2fv(context, angle::EntryPoint::GLVertex2fv, v));
        if (isCallValid)
        {
            context->vertex2fv(v);
        }
        ANGLE_CAPTURE_GL(Vertex2fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2i(GLint x, GLint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2i, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2i(context, angle::EntryPoint::GLVertex2i, x, y));
        if (isCallValid)
        {
            context->vertex2i(x, y);
        }
        ANGLE_CAPTURE_GL(Vertex2i, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2iv(context, angle::EntryPoint::GLVertex2iv, v));
        if (isCallValid)
        {
            context->vertex2iv(v);
        }
        ANGLE_CAPTURE_GL(Vertex2iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2s(GLshort x, GLshort y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2s, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2s(context, angle::EntryPoint::GLVertex2s, x, y));
        if (isCallValid)
        {
            context->vertex2s(x, y);
        }
        ANGLE_CAPTURE_GL(Vertex2s, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex2sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex2sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex2sv(context, angle::EntryPoint::GLVertex2sv, v));
        if (isCallValid)
        {
            context->vertex2sv(v);
        }
        ANGLE_CAPTURE_GL(Vertex2sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3d(GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3d, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3d(context, angle::EntryPoint::GLVertex3d, x, y, z));
        if (isCallValid)
        {
            context->vertex3d(x, y, z);
        }
        ANGLE_CAPTURE_GL(Vertex3d, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3dv(context, angle::EntryPoint::GLVertex3dv, v));
        if (isCallValid)
        {
            context->vertex3dv(v);
        }
        ANGLE_CAPTURE_GL(Vertex3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3f(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3f, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3f(context, angle::EntryPoint::GLVertex3f, x, y, z));
        if (isCallValid)
        {
            context->vertex3f(x, y, z);
        }
        ANGLE_CAPTURE_GL(Vertex3f, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3fv(context, angle::EntryPoint::GLVertex3fv, v));
        if (isCallValid)
        {
            context->vertex3fv(v);
        }
        ANGLE_CAPTURE_GL(Vertex3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3i(GLint x, GLint y, GLint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3i, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3i(context, angle::EntryPoint::GLVertex3i, x, y, z));
        if (isCallValid)
        {
            context->vertex3i(x, y, z);
        }
        ANGLE_CAPTURE_GL(Vertex3i, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3iv(context, angle::EntryPoint::GLVertex3iv, v));
        if (isCallValid)
        {
            context->vertex3iv(v);
        }
        ANGLE_CAPTURE_GL(Vertex3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3s(GLshort x, GLshort y, GLshort z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3s, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3s(context, angle::EntryPoint::GLVertex3s, x, y, z));
        if (isCallValid)
        {
            context->vertex3s(x, y, z);
        }
        ANGLE_CAPTURE_GL(Vertex3s, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex3sv(context, angle::EntryPoint::GLVertex3sv, v));
        if (isCallValid)
        {
            context->vertex3sv(v);
        }
        ANGLE_CAPTURE_GL(Vertex3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4d, "context = %d, x = %f, y = %f, z = %f, w = %f", CID(context), x, y,
          z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4d(context, angle::EntryPoint::GLVertex4d, x, y, z, w));
        if (isCallValid)
        {
            context->vertex4d(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(Vertex4d, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4dv(context, angle::EntryPoint::GLVertex4dv, v));
        if (isCallValid)
        {
            context->vertex4dv(v);
        }
        ANGLE_CAPTURE_GL(Vertex4dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4f, "context = %d, x = %f, y = %f, z = %f, w = %f", CID(context), x, y,
          z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4f(context, angle::EntryPoint::GLVertex4f, x, y, z, w));
        if (isCallValid)
        {
            context->vertex4f(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(Vertex4f, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4fv(context, angle::EntryPoint::GLVertex4fv, v));
        if (isCallValid)
        {
            context->vertex4fv(v);
        }
        ANGLE_CAPTURE_GL(Vertex4fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4i(GLint x, GLint y, GLint z, GLint w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4i, "context = %d, x = %d, y = %d, z = %d, w = %d", CID(context), x, y,
          z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4i(context, angle::EntryPoint::GLVertex4i, x, y, z, w));
        if (isCallValid)
        {
            context->vertex4i(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(Vertex4i, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4iv(context, angle::EntryPoint::GLVertex4iv, v));
        if (isCallValid)
        {
            context->vertex4iv(v);
        }
        ANGLE_CAPTURE_GL(Vertex4iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4s, "context = %d, x = %d, y = %d, z = %d, w = %d", CID(context), x, y,
          z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4s(context, angle::EntryPoint::GLVertex4s, x, y, z, w));
        if (isCallValid)
        {
            context->vertex4s(x, y, z, w);
        }
        ANGLE_CAPTURE_GL(Vertex4s, isCallValid, context, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Vertex4sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertex4sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertex4sv(context, angle::EntryPoint::GLVertex4sv, v));
        if (isCallValid)
        {
            context->vertex4sv(v);
        }
        ANGLE_CAPTURE_GL(Vertex4sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLViewport, "context = %d, x = %d, y = %d, width = %d, height = %d",
          CID(context), x, y, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateViewport(context, angle::EntryPoint::GLViewport, x, y, width, height));
        if (isCallValid)
        {
            context->viewport(x, y, width, height);
        }
        ANGLE_CAPTURE_GL(Viewport, isCallValid, context, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 1.1
GLboolean GL_APIENTRY GL_AreTexturesResident(GLsizei n,
                                             const GLuint *textures,
                                             GLboolean *residences)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAreTexturesResident,
          "context = %d, n = %d, textures = 0x%016" PRIxPTR ", residences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures, (uintptr_t)residences);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateAreTexturesResident(context, angle::EntryPoint::GLAreTexturesResident, n,
                                         textures, residences));
        if (isCallValid)
        {
            returnValue = context->areTexturesResident(n, textures, residences);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLAreTexturesResident, GLboolean>();
        }
        ANGLE_CAPTURE_GL(AreTexturesResident, isCallValid, context, n, textures, residences,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLAreTexturesResident, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_ArrayElement(GLint i)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLArrayElement, "context = %d, i = %d", CID(context), i);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateArrayElement(context, angle::EntryPoint::GLArrayElement, i));
        if (isCallValid)
        {
            context->arrayElement(i);
        }
        ANGLE_CAPTURE_GL(ArrayElement, isCallValid, context, i);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindTexture(GLenum target, GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindTexture, "context = %d, target = %s, texture = %u", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target), texture);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindTexture(context, angle::EntryPoint::GLBindTexture,
                                                                                     targetPacked, texturePacked));
        if (isCallValid)
        {
            context->bindTexture(targetPacked, texturePacked);
        }
        ANGLE_CAPTURE_GL(BindTexture, isCallValid, context, targetPacked, texturePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColorPointer(context, angle::EntryPoint::GLColorPointer, size,
                                                                                      typePacked, stride, pointer));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTexImage1D(GLenum target,
                                   GLint level,
                                   GLenum internalformat,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLint border)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexImage1D,
          "context = %d, target = %s, level = %d, internalformat = %s, x = %d, y = %d, width = %d, "
          "border = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), x, y, width, border);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyTexImage1D(context, angle::EntryPoint::GLCopyTexImage1D, target, level,
                                    internalformat, x, y, width, border));
        if (isCallValid)
        {
            context->copyTexImage1D(target, level, internalformat, x, y, width, border);
        }
        ANGLE_CAPTURE_GL(CopyTexImage1D, isCallValid, context, target, level, internalformat, x, y,
                         width, border);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTexImage2D(GLenum target,
                                   GLint level,
                                   GLenum internalformat,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLint border)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexImage2D,
          "context = %d, target = %s, level = %d, internalformat = %s, x = %d, y = %d, width = %d, "
          "height = %d, border = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), x, y, width, height, border);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyTexImage2D(context, angle::EntryPoint::GLCopyTexImage2D, targetPacked,
                                    level, internalformat, x, y, width, height, border));
        if (isCallValid)
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
        ANGLE_CAPTURE_GL(CopyTexImage2D, isCallValid, context, targetPacked, level, internalformat,
                         x, y, width, height, border);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_CopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexSubImage1D,
          "context = %d, target = %s, level = %d, xoffset = %d, x = %d, y = %d, width = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, x, y,
          width);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyTexSubImage1D(context, angle::EntryPoint::GLCopyTexSubImage1D, target,
                                       level, xoffset, x, y, width));
        if (isCallValid)
        {
            context->copyTexSubImage1D(target, level, xoffset, x, y, width);
        }
        ANGLE_CAPTURE_GL(CopyTexSubImage1D, isCallValid, context, target, level, xoffset, x, y,
                         width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTexSubImage2D(GLenum target,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint x,
                                      GLint y,
                                      GLsizei width,
                                      GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexSubImage2D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, x = %d, y = %d, "
          "width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          x, y, width, height);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyTexSubImage2D(context, angle::EntryPoint::GLCopyTexSubImage2D,
                                       targetPacked, level, xoffset, yoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
        ANGLE_CAPTURE_GL(CopyTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                         yoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteTextures(GLsizei n, const GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteTextures, "context = %d, n = %d, textures = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures);

    if (context)
    {
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteTextures(context, angle::EntryPoint::GLDeleteTextures, n,
                                                                                        texturesPacked));
        if (isCallValid)
        {
            context->deleteTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE_GL(DeleteTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDisableClientState(
                                                                     context, angle::EntryPoint::GLDisableClientState, arrayPacked));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(DisableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArrays, "context = %d, mode = %s, first = %d, count = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), first, count);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawArrays(context, angle::EntryPoint::GLDrawArrays, modePacked,
                                                                                    first, count));
        if (isCallValid)
        {
            context->drawArrays(modePacked, first, count);
        }
        ANGLE_CAPTURE_GL(DrawArrays, isCallValid, context, modePacked, first, count);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElements,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElements(context, angle::EntryPoint::GLDrawElements,
                                                                                      modePacked, count, typePacked, indices));
        if (isCallValid)
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
        ANGLE_CAPTURE_GL(DrawElements, isCallValid, context, modePacked, count, typePacked,
                         indices);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EdgeFlagPointer(GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEdgeFlagPointer, "context = %d, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), stride, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEdgeFlagPointer(context, angle::EntryPoint::GLEdgeFlagPointer,
                                                                                         stride, pointer));
        if (isCallValid)
        {
            context->edgeFlagPointer(stride, pointer);
        }
        ANGLE_CAPTURE_GL(EdgeFlagPointer, isCallValid, context, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EnableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEnableClientState(
                                                                     context, angle::EntryPoint::GLEnableClientState, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(EnableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenTextures(GLsizei n, GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenTextures, "context = %d, n = %d, textures = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures);

    if (context)
    {
        TextureID *texturesPacked                             = PackParam<TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGenTextures(context, angle::EntryPoint::GLGenTextures, n, texturesPacked));
        if (isCallValid)
        {
            context->genTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE_GL(GenTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPointerv(GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointerv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPointervPName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPointerv(context, angle::EntryPoint::GLGetPointerv, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetPointerv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_IndexPointer(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::IndexPointerType, type), stride, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexPointer(context, angle::EntryPoint::GLIndexPointer, type,
                                                                                      stride, pointer));
        if (isCallValid)
        {
            context->indexPointer(type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(IndexPointer, isCallValid, context, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexub(GLubyte c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexub, "context = %d, c = %d", CID(context), c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexub(context, angle::EntryPoint::GLIndexub, c));
        if (isCallValid)
        {
            context->indexub(c);
        }
        ANGLE_CAPTURE_GL(Indexub, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Indexubv(const GLubyte *c)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIndexubv, "context = %d, c = 0x%016" PRIxPTR "", CID(context), (uintptr_t)c);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIndexubv(context, angle::EntryPoint::GLIndexubv, c));
        if (isCallValid)
        {
            context->indexubv(c);
        }
        ANGLE_CAPTURE_GL(Indexubv, isCallValid, context, c);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InterleavedArrays(GLenum format, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInterleavedArrays,
          "context = %d, format = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::InterleavedArrayFormat, format), stride, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateInterleavedArrays(context, angle::EntryPoint::GLInterleavedArrays, format,
                                       stride, pointer));
        if (isCallValid)
        {
            context->interleavedArrays(format, stride, pointer);
        }
        ANGLE_CAPTURE_GL(InterleavedArrays, isCallValid, context, format, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsTexture(GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsTexture, "context = %d, texture = %u", CID(context), texture);

    GLboolean returnValue;
    if (context)
    {
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateIsTexture(context, angle::EntryPoint::GLIsTexture, texturePacked));
        if (isCallValid)
        {
            returnValue = context->isTexture(texturePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsTexture, isCallValid, context, texturePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormalPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormalPointer(context, angle::EntryPoint::GLNormalPointer,
                                                                                       typePacked, stride, pointer));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PolygonOffset(GLfloat factor, GLfloat units)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonOffset, "context = %d, factor = %f, units = %f", CID(context), factor,
          units);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePolygonOffset(context, angle::EntryPoint::GLPolygonOffset, factor, units));
        if (isCallValid)
        {
            context->polygonOffset(factor, units);
        }
        ANGLE_CAPTURE_GL(PolygonOffset, isCallValid, context, factor, units);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopClientAttrib()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopClientAttrib, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePopClientAttrib(context, angle::EntryPoint::GLPopClientAttrib));
        if (isCallValid)
        {
            context->popClientAttrib();
        }
        ANGLE_CAPTURE_GL(PopClientAttrib, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PrioritizeTextures(GLsizei n, const GLuint *textures, const GLfloat *priorities)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPrioritizeTextures,
          "context = %d, n = %d, textures = 0x%016" PRIxPTR ", priorities = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures, (uintptr_t)priorities);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePrioritizeTextures(context, angle::EntryPoint::GLPrioritizeTextures, n,
                                        textures, priorities));
        if (isCallValid)
        {
            context->prioritizeTextures(n, textures, priorities);
        }
        ANGLE_CAPTURE_GL(PrioritizeTextures, isCallValid, context, n, textures, priorities);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushClientAttrib(GLbitfield mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushClientAttrib, "context = %d, mask = %s", CID(context),
          GLbitfieldToString(GLenumGroup::ClientAttribMask, mask).c_str());

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePushClientAttrib(context, angle::EntryPoint::GLPushClientAttrib, mask));
        if (isCallValid)
        {
            context->pushClientAttrib(mask);
        }
        ANGLE_CAPTURE_GL(PushClientAttrib, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::TexCoordPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoordPointer(context, angle::EntryPoint::GLTexCoordPointer,
                                                                                         size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(TexCoordPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage1D(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLsizei width,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage1D,
          "context = %d, target = %s, level = %d, xoffset = %d, width = %d, format = %s, type = "
          "%s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, width,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage1D(context, angle::EntryPoint::GLTexSubImage1D, target, level,
                                   xoffset, width, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage1D(target, level, xoffset, width, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage1D, isCallValid, context, target, level, xoffset, width, format,
                         type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage2D(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage2D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage2D(context, angle::EntryPoint::GLTexSubImage2D, targetPacked, level,
                                   xoffset, yoffset, width, height, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage2D(targetPacked, level, xoffset, yoffset, width, height, format,
                                   type, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage2D, isCallValid, context, targetPacked, level, xoffset, yoffset,
                         width, height, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::VertexPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexPointer(context, angle::EntryPoint::GLVertexPointer, size,
                                                                                       typePacked, stride, pointer));
        if (isCallValid)
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(VertexPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 1.2
void GL_APIENTRY GL_CopyTexSubImage3D(GLenum target,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLint x,
                                      GLint y,
                                      GLsizei width,
                                      GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexSubImage3D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexSubImage3D(
                                                                     context, angle::EntryPoint::GLCopyTexSubImage3D, targetPacked,
                                                                     level, xoffset, yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE_GL(CopyTexSubImage3D, isCallValid, context, targetPacked, level, xoffset,
                         yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawRangeElements(GLenum mode,
                                      GLuint start,
                                      GLuint end,
                                      GLsizei count,
                                      GLenum type,
                                      const void *indices)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawRangeElements,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawRangeElements(context, angle::EntryPoint::GLDrawRangeElements, modePacked,
                                       start, end, count, typePacked, indices));
        if (isCallValid)
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
        ANGLE_CAPTURE_GL(DrawRangeElements, isCallValid, context, modePacked, start, end, count,
                         typePacked, indices);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage3D(GLenum target,
                               GLint level,
                               GLint internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLsizei depth,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3D,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "depth = %d, border = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, height, depth, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexImage3D(context, angle::EntryPoint::GLTexImage3D,
                                                                                    targetPacked, level, internalformat, width, height,
                                                                                    depth, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage3D, isCallValid, context, targetPacked, level, internalformat,
                         width, height, depth, border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage3D(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLint zoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage3D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexSubImage3D(context, angle::EntryPoint::GLTexSubImage3D,
                                                                                       targetPacked, level, xoffset, yoffset, zoffset,
                                                                                       width, height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage3D, isCallValid, context, targetPacked, level, xoffset, yoffset,
                         zoffset, width, height, depth, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 1.3
void GL_APIENTRY GL_ActiveTexture(GLenum texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateActiveTexture(context, angle::EntryPoint::GLActiveTexture, texture));
        if (isCallValid)
        {
            context->activeTexture(texture);
        }
        ANGLE_CAPTURE_GL(ActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClientActiveTexture(GLenum texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClientActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClientActiveTexture(
                                                                     context, angle::EntryPoint::GLClientActiveTexture, texture));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE_GL(ClientActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexImage1D(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage1D,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, border = %d, "
          "imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, border, imageSize,
          (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexImage1D(
                                                                     context, angle::EntryPoint::GLCompressedTexImage1D, target, level,
                                                                     internalformat, width, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage1D(target, level, internalformat, width, border, imageSize,
                                          data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage1D, isCallValid, context, target, level, internalformat,
                         width, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexImage2D(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage2D,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexImage2D(
                                                                     context, angle::EntryPoint::GLCompressedTexImage2D, targetPacked,
                                                                     level, internalformat, width, height, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage2D, isCallValid, context, targetPacked, level,
                         internalformat, width, height, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexImage3D(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage3D,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3D(context, angle::EntryPoint::GLCompressedTexImage3D,
                                          targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage3D, isCallValid, context, targetPacked, level,
                         internalformat, width, height, depth, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage1D(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLsizei width,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage1D,
          "context = %d, target = %s, level = %d, xoffset = %d, width = %d, format = %s, imageSize "
          "= %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, width,
          GLenumToString(GLenumGroup::PixelFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage1D(
                                                                     context, angle::EntryPoint::GLCompressedTexSubImage1D, target,
                                                                     level, xoffset, width, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage1D(target, level, xoffset, width, format, imageSize,
                                             data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage1D, isCallValid, context, target, level, xoffset,
                         width, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage2D(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage2D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::PixelFormat, format), imageSize,
          (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage2D(
                                                                     context, angle::EntryPoint::GLCompressedTexSubImage2D, targetPacked,
                                                                     level, xoffset, yoffset, width, height, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage2D, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, width, height, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage3D(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage3D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexSubImage3D(context, angle::EntryPoint::GLCompressedTexSubImage3D,
                                             targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage3D, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetCompressedTexImage(GLenum target, GLint level, void *img)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetCompressedTexImage,
          "context = %d, target = %s, level = %d, img = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target), level, (uintptr_t)img);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetCompressedTexImage(context, angle::EntryPoint::GLGetCompressedTexImage,
                                           targetPacked, level, img));
        if (isCallValid)
        {
            context->getCompressedTexImage(targetPacked, level, img);
        }
        ANGLE_CAPTURE_GL(GetCompressedTexImage, isCallValid, context, targetPacked, level, img);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadTransposeMatrixd(const GLdouble *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadTransposeMatrixd, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLoadTransposeMatrixd(context, angle::EntryPoint::GLLoadTransposeMatrixd, m));
        if (isCallValid)
        {
            context->loadTransposeMatrixd(m);
        }
        ANGLE_CAPTURE_GL(LoadTransposeMatrixd, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadTransposeMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadTransposeMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLoadTransposeMatrixf(context, angle::EntryPoint::GLLoadTransposeMatrixf, m));
        if (isCallValid)
        {
            context->loadTransposeMatrixf(m);
        }
        ANGLE_CAPTURE_GL(LoadTransposeMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultTransposeMatrixd(const GLdouble *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultTransposeMatrixd, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultTransposeMatrixd(context, angle::EntryPoint::GLMultTransposeMatrixd, m));
        if (isCallValid)
        {
            context->multTransposeMatrixd(m);
        }
        ANGLE_CAPTURE_GL(MultTransposeMatrixd, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultTransposeMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultTransposeMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultTransposeMatrixf(context, angle::EntryPoint::GLMultTransposeMatrixf, m));
        if (isCallValid)
        {
            context->multTransposeMatrixf(m);
        }
        ANGLE_CAPTURE_GL(MultTransposeMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1d(GLenum target, GLdouble s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1d, "context = %d, target = %s, s = %f", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1d(context, angle::EntryPoint::GLMultiTexCoord1d, target, s));
        if (isCallValid)
        {
            context->multiTexCoord1d(target, s);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1d, isCallValid, context, target, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1dv(GLenum target, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1dv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1dv(context, angle::EntryPoint::GLMultiTexCoord1dv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord1dv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1dv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1f(GLenum target, GLfloat s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1f, "context = %d, target = %s, s = %f", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1f(context, angle::EntryPoint::GLMultiTexCoord1f, target, s));
        if (isCallValid)
        {
            context->multiTexCoord1f(target, s);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1f, isCallValid, context, target, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1fv(GLenum target, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1fv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1fv(context, angle::EntryPoint::GLMultiTexCoord1fv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord1fv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1fv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1i(GLenum target, GLint s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1i, "context = %d, target = %s, s = %d", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1i(context, angle::EntryPoint::GLMultiTexCoord1i, target, s));
        if (isCallValid)
        {
            context->multiTexCoord1i(target, s);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1i, isCallValid, context, target, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1iv(GLenum target, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1iv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1iv(context, angle::EntryPoint::GLMultiTexCoord1iv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord1iv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1iv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1s(GLenum target, GLshort s)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1s, "context = %d, target = %s, s = %d", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1s(context, angle::EntryPoint::GLMultiTexCoord1s, target, s));
        if (isCallValid)
        {
            context->multiTexCoord1s(target, s);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1s, isCallValid, context, target, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord1sv(GLenum target, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord1sv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord1sv(context, angle::EntryPoint::GLMultiTexCoord1sv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord1sv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord1sv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2d, "context = %d, target = %s, s = %f, t = %f", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2d(context, angle::EntryPoint::GLMultiTexCoord2d, target, s, t));
        if (isCallValid)
        {
            context->multiTexCoord2d(target, s, t);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2d, isCallValid, context, target, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2dv(GLenum target, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2dv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2dv(context, angle::EntryPoint::GLMultiTexCoord2dv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord2dv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2dv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2f(GLenum target, GLfloat s, GLfloat t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2f, "context = %d, target = %s, s = %f, t = %f", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2f(context, angle::EntryPoint::GLMultiTexCoord2f, target, s, t));
        if (isCallValid)
        {
            context->multiTexCoord2f(target, s, t);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2f, isCallValid, context, target, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2fv(GLenum target, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2fv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2fv(context, angle::EntryPoint::GLMultiTexCoord2fv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord2fv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2fv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2i(GLenum target, GLint s, GLint t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2i, "context = %d, target = %s, s = %d, t = %d", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2i(context, angle::EntryPoint::GLMultiTexCoord2i, target, s, t));
        if (isCallValid)
        {
            context->multiTexCoord2i(target, s, t);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2i, isCallValid, context, target, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2iv(GLenum target, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2iv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2iv(context, angle::EntryPoint::GLMultiTexCoord2iv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord2iv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2iv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2s(GLenum target, GLshort s, GLshort t)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2s, "context = %d, target = %s, s = %d, t = %d", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s, t);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2s(context, angle::EntryPoint::GLMultiTexCoord2s, target, s, t));
        if (isCallValid)
        {
            context->multiTexCoord2s(target, s, t);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2s, isCallValid, context, target, s, t);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord2sv(GLenum target, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord2sv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord2sv(context, angle::EntryPoint::GLMultiTexCoord2sv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord2sv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord2sv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3d, "context = %d, target = %s, s = %f, t = %f, r = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord3d(context, angle::EntryPoint::GLMultiTexCoord3d,
                                                                                         target, s, t, r));
        if (isCallValid)
        {
            context->multiTexCoord3d(target, s, t, r);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3d, isCallValid, context, target, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3dv(GLenum target, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3dv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord3dv(context, angle::EntryPoint::GLMultiTexCoord3dv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord3dv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3dv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3f, "context = %d, target = %s, s = %f, t = %f, r = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord3f(context, angle::EntryPoint::GLMultiTexCoord3f,
                                                                                         target, s, t, r));
        if (isCallValid)
        {
            context->multiTexCoord3f(target, s, t, r);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3f, isCallValid, context, target, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3fv(GLenum target, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3fv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord3fv(context, angle::EntryPoint::GLMultiTexCoord3fv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord3fv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3fv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3i, "context = %d, target = %s, s = %d, t = %d, r = %d",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord3i(context, angle::EntryPoint::GLMultiTexCoord3i,
                                                                                         target, s, t, r));
        if (isCallValid)
        {
            context->multiTexCoord3i(target, s, t, r);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3i, isCallValid, context, target, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3iv(GLenum target, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3iv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord3iv(context, angle::EntryPoint::GLMultiTexCoord3iv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord3iv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3iv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3s, "context = %d, target = %s, s = %d, t = %d, r = %d",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord3s(context, angle::EntryPoint::GLMultiTexCoord3s,
                                                                                         target, s, t, r));
        if (isCallValid)
        {
            context->multiTexCoord3s(target, s, t, r);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3s, isCallValid, context, target, s, t, r);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord3sv(GLenum target, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord3sv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord3sv(context, angle::EntryPoint::GLMultiTexCoord3sv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord3sv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord3sv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4d, "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord4d(context, angle::EntryPoint::GLMultiTexCoord4d,
                                                                                         target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4d(target, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4d, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4dv(GLenum target, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4dv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4dv(context, angle::EntryPoint::GLMultiTexCoord4dv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord4dv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4dv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4f, "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord4f(context, angle::EntryPoint::GLMultiTexCoord4f,
                                                                                         target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4fv(GLenum target, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4fv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4fv(context, angle::EntryPoint::GLMultiTexCoord4fv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord4fv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4fv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4i, "context = %d, target = %s, s = %d, t = %d, r = %d, q = %d",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord4i(context, angle::EntryPoint::GLMultiTexCoord4i,
                                                                                         target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4i(target, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4i, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4iv(GLenum target, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4iv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4iv(context, angle::EntryPoint::GLMultiTexCoord4iv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord4iv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4iv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4s, "context = %d, target = %s, s = %d, t = %d, r = %d, q = %d",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoord4s(context, angle::EntryPoint::GLMultiTexCoord4s,
                                                                                         target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4s(target, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4s, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiTexCoord4sv(GLenum target, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4sv, "context = %d, target = %s, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4sv(context, angle::EntryPoint::GLMultiTexCoord4sv, target, v));
        if (isCallValid)
        {
            context->multiTexCoord4sv(target, v);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4sv, isCallValid, context, target, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SampleCoverage(GLfloat value, GLboolean invert)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSampleCoverage, "context = %d, value = %f, invert = %s", CID(context), value,
          GLbooleanToString(invert));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSampleCoverage(context, angle::EntryPoint::GLSampleCoverage, value, invert));
        if (isCallValid)
        {
            context->sampleCoverage(value, invert);
        }
        ANGLE_CAPTURE_GL(SampleCoverage, isCallValid, context, value, invert);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 1.4
void GL_APIENTRY GL_BlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendColor, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendColor(context, angle::EntryPoint::GLBlendColor, red, green, blue, alpha));
        if (isCallValid)
        {
            context->blendColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(BlendColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendEquation(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquation, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendEquation(context, angle::EntryPoint::GLBlendEquation, mode));
        if (isCallValid)
        {
            context->blendEquation(mode);
        }
        ANGLE_CAPTURE_GL(BlendEquation, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendFuncSeparate(GLenum sfactorRGB,
                                      GLenum dfactorRGB,
                                      GLenum sfactorAlpha,
                                      GLenum dfactorAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFuncSeparate,
          "context = %d, sfactorRGB = %s, dfactorRGB = %s, sfactorAlpha = %s, dfactorAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendingFactor, sfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, sfactorAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparate(context, angle::EntryPoint::GLBlendFuncSeparate, sfactorRGB,
                                       dfactorRGB, sfactorAlpha, dfactorAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
        ANGLE_CAPTURE_GL(BlendFuncSeparate, isCallValid, context, sfactorRGB, dfactorRGB,
                         sfactorAlpha, dfactorAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FogCoordPointer(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogCoordPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogPointerTypeEXT, type), stride, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogCoordPointer(context, angle::EntryPoint::GLFogCoordPointer,
                                                                                         type, stride, pointer));
        if (isCallValid)
        {
            context->fogCoordPointer(type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(FogCoordPointer, isCallValid, context, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FogCoordd(GLdouble coord)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogCoordd, "context = %d, coord = %f", CID(context), coord);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogCoordd(context, angle::EntryPoint::GLFogCoordd, coord));
        if (isCallValid)
        {
            context->fogCoordd(coord);
        }
        ANGLE_CAPTURE_GL(FogCoordd, isCallValid, context, coord);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FogCoorddv(const GLdouble *coord)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogCoorddv, "context = %d, coord = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coord);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogCoorddv(context, angle::EntryPoint::GLFogCoorddv, coord));
        if (isCallValid)
        {
            context->fogCoorddv(coord);
        }
        ANGLE_CAPTURE_GL(FogCoorddv, isCallValid, context, coord);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FogCoordf(GLfloat coord)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogCoordf, "context = %d, coord = %f", CID(context), coord);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogCoordf(context, angle::EntryPoint::GLFogCoordf, coord));
        if (isCallValid)
        {
            context->fogCoordf(coord);
        }
        ANGLE_CAPTURE_GL(FogCoordf, isCallValid, context, coord);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FogCoordfv(const GLfloat *coord)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogCoordfv, "context = %d, coord = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coord);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFogCoordfv(context, angle::EntryPoint::GLFogCoordfv, coord));
        if (isCallValid)
        {
            context->fogCoordfv(coord);
        }
        ANGLE_CAPTURE_GL(FogCoordfv, isCallValid, context, coord);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawArrays(GLenum mode,
                                    const GLint *first,
                                    const GLsizei *count,
                                    GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArrays,
          "context = %d, mode = %s, first = 0x%016" PRIxPTR ", count = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)first,
          (uintptr_t)count, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiDrawArrays(context, angle::EntryPoint::GLMultiDrawArrays,
                                                                                         modePacked, first, count, drawcount));
        if (isCallValid)
        {
            context->multiDrawArrays(modePacked, first, count, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawArrays, isCallValid, context, modePacked, first, count,
                         drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElements(GLenum mode,
                                      const GLsizei *count,
                                      GLenum type,
                                      const void *const *indices,
                                      GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElements,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawElements(context, angle::EntryPoint::GLMultiDrawElements, modePacked,
                                       count, typePacked, indices, drawcount));
        if (isCallValid)
        {
            context->multiDrawElements(modePacked, count, typePacked, indices, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawElements, isCallValid, context, modePacked, count, typePacked,
                         indices, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PointParameterf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePointParameterf(context, angle::EntryPoint::GLPointParameterf,
                                                                                         pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterf(pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(PointParameterf, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PointParameterfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePointParameterfv(context, angle::EntryPoint::GLPointParameterfv,
                                                                                          pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterfv(pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PointParameteri(GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameteri, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePointParameteri(context, angle::EntryPoint::GLPointParameteri, pname, param));
        if (isCallValid)
        {
            context->pointParameteri(pname, param);
        }
        ANGLE_CAPTURE_GL(PointParameteri, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PointParameteriv(GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameteriv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePointParameteriv(context, angle::EntryPoint::GLPointParameteriv,
                                                                                          pname, params));
        if (isCallValid)
        {
            context->pointParameteriv(pname, params);
        }
        ANGLE_CAPTURE_GL(PointParameteriv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3b, "context = %d, red = %d, green = %d, blue = %d",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3b(context, angle::EntryPoint::GLSecondaryColor3b,
                                                                                          red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3b(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3b, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3bv(const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3bv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3bv(context, angle::EntryPoint::GLSecondaryColor3bv, v));
        if (isCallValid)
        {
            context->secondaryColor3bv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3bv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3d, "context = %d, red = %f, green = %f, blue = %f",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3d(context, angle::EntryPoint::GLSecondaryColor3d,
                                                                                          red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3d(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3d, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3dv(context, angle::EntryPoint::GLSecondaryColor3dv, v));
        if (isCallValid)
        {
            context->secondaryColor3dv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3f, "context = %d, red = %f, green = %f, blue = %f",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3f(context, angle::EntryPoint::GLSecondaryColor3f,
                                                                                          red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3f(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3f, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3fv(context, angle::EntryPoint::GLSecondaryColor3fv, v));
        if (isCallValid)
        {
            context->secondaryColor3fv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3i(GLint red, GLint green, GLint blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3i, "context = %d, red = %d, green = %d, blue = %d",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3i(context, angle::EntryPoint::GLSecondaryColor3i,
                                                                                          red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3i(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3i, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3iv(context, angle::EntryPoint::GLSecondaryColor3iv, v));
        if (isCallValid)
        {
            context->secondaryColor3iv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3s(GLshort red, GLshort green, GLshort blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3s, "context = %d, red = %d, green = %d, blue = %d",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3s(context, angle::EntryPoint::GLSecondaryColor3s,
                                                                                          red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3s(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3s, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3sv(context, angle::EntryPoint::GLSecondaryColor3sv, v));
        if (isCallValid)
        {
            context->secondaryColor3sv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3ub, "context = %d, red = %d, green = %d, blue = %d",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3ub(
                                                                     context, angle::EntryPoint::GLSecondaryColor3ub, red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3ub(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3ub, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3ubv(const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3ubv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3ubv(context, angle::EntryPoint::GLSecondaryColor3ubv, v));
        if (isCallValid)
        {
            context->secondaryColor3ubv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3ubv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3ui(GLuint red, GLuint green, GLuint blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3ui, "context = %d, red = %u, green = %u, blue = %u",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3ui(
                                                                     context, angle::EntryPoint::GLSecondaryColor3ui, red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3ui(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3ui, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3uiv(const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3uiv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3uiv(context, angle::EntryPoint::GLSecondaryColor3uiv, v));
        if (isCallValid)
        {
            context->secondaryColor3uiv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3uiv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3us(GLushort red, GLushort green, GLushort blue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3us, "context = %d, red = %u, green = %u, blue = %u",
          CID(context), red, green, blue);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSecondaryColor3us(
                                                                     context, angle::EntryPoint::GLSecondaryColor3us, red, green, blue));
        if (isCallValid)
        {
            context->secondaryColor3us(red, green, blue);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3us, isCallValid, context, red, green, blue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColor3usv(const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColor3usv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColor3usv(context, angle::EntryPoint::GLSecondaryColor3usv, v));
        if (isCallValid)
        {
            context->secondaryColor3usv(v);
        }
        ANGLE_CAPTURE_GL(SecondaryColor3usv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SecondaryColorPointer(GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColorPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSecondaryColorPointer(context, angle::EntryPoint::GLSecondaryColorPointer,
                                           size, type, stride, pointer));
        if (isCallValid)
        {
            context->secondaryColorPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(SecondaryColorPointer, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2d(GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2d, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2d(context, angle::EntryPoint::GLWindowPos2d, x, y));
        if (isCallValid)
        {
            context->windowPos2d(x, y);
        }
        ANGLE_CAPTURE_GL(WindowPos2d, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2dv(context, angle::EntryPoint::GLWindowPos2dv, v));
        if (isCallValid)
        {
            context->windowPos2dv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos2dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2f(GLfloat x, GLfloat y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2f, "context = %d, x = %f, y = %f", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2f(context, angle::EntryPoint::GLWindowPos2f, x, y));
        if (isCallValid)
        {
            context->windowPos2f(x, y);
        }
        ANGLE_CAPTURE_GL(WindowPos2f, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2fv(context, angle::EntryPoint::GLWindowPos2fv, v));
        if (isCallValid)
        {
            context->windowPos2fv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos2fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2i(GLint x, GLint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2i, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2i(context, angle::EntryPoint::GLWindowPos2i, x, y));
        if (isCallValid)
        {
            context->windowPos2i(x, y);
        }
        ANGLE_CAPTURE_GL(WindowPos2i, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2iv(context, angle::EntryPoint::GLWindowPos2iv, v));
        if (isCallValid)
        {
            context->windowPos2iv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos2iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2s(GLshort x, GLshort y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2s, "context = %d, x = %d, y = %d", CID(context), x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2s(context, angle::EntryPoint::GLWindowPos2s, x, y));
        if (isCallValid)
        {
            context->windowPos2s(x, y);
        }
        ANGLE_CAPTURE_GL(WindowPos2s, isCallValid, context, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos2sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos2sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos2sv(context, angle::EntryPoint::GLWindowPos2sv, v));
        if (isCallValid)
        {
            context->windowPos2sv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos2sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3d, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWindowPos3d(context, angle::EntryPoint::GLWindowPos3d, x, y, z));
        if (isCallValid)
        {
            context->windowPos3d(x, y, z);
        }
        ANGLE_CAPTURE_GL(WindowPos3d, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3dv(const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3dv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos3dv(context, angle::EntryPoint::GLWindowPos3dv, v));
        if (isCallValid)
        {
            context->windowPos3dv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos3dv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3f, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWindowPos3f(context, angle::EntryPoint::GLWindowPos3f, x, y, z));
        if (isCallValid)
        {
            context->windowPos3f(x, y, z);
        }
        ANGLE_CAPTURE_GL(WindowPos3f, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3fv(const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3fv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos3fv(context, angle::EntryPoint::GLWindowPos3fv, v));
        if (isCallValid)
        {
            context->windowPos3fv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos3fv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3i(GLint x, GLint y, GLint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3i, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWindowPos3i(context, angle::EntryPoint::GLWindowPos3i, x, y, z));
        if (isCallValid)
        {
            context->windowPos3i(x, y, z);
        }
        ANGLE_CAPTURE_GL(WindowPos3i, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3iv(const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3iv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos3iv(context, angle::EntryPoint::GLWindowPos3iv, v));
        if (isCallValid)
        {
            context->windowPos3iv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos3iv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3s(GLshort x, GLshort y, GLshort z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3s, "context = %d, x = %d, y = %d, z = %d", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWindowPos3s(context, angle::EntryPoint::GLWindowPos3s, x, y, z));
        if (isCallValid)
        {
            context->windowPos3s(x, y, z);
        }
        ANGLE_CAPTURE_GL(WindowPos3s, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WindowPos3sv(const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWindowPos3sv, "context = %d, v = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWindowPos3sv(context, angle::EntryPoint::GLWindowPos3sv, v));
        if (isCallValid)
        {
            context->windowPos3sv(v);
        }
        ANGLE_CAPTURE_GL(WindowPos3sv, isCallValid, context, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 1.5
void GL_APIENTRY GL_BeginQuery(GLenum target, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginQuery, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBeginQuery(context, angle::EntryPoint::GLBeginQuery, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE_GL(BeginQuery, isCallValid, context, targetPacked, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindBuffer(GLenum target, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindBuffer, "context = %d, target = %s, buffer = %u", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), buffer);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindBuffer(context, angle::EntryPoint::GLBindBuffer,
                                                                                    targetPacked, bufferPacked));
        if (isCallValid)
        {
            context->bindBuffer(targetPacked, bufferPacked);
        }
        ANGLE_CAPTURE_GL(BindBuffer, isCallValid, context, targetPacked, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferData,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", usage = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLenumToString(GLenumGroup::BufferUsageARB, usage));

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferUsage usagePacked                               = PackParam<BufferUsage>(usage);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferData(context, angle::EntryPoint::GLBufferData,
                                                                                    targetPacked, size, data, usagePacked));
        if (isCallValid)
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
        ANGLE_CAPTURE_GL(BufferData, isCallValid, context, targetPacked, size, data, usagePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferSubData,
          "context = %d, target = %s, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)data);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferSubData(context, angle::EntryPoint::GLBufferSubData,
                                                                                       targetPacked, offset, size, data));
        if (isCallValid)
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
        ANGLE_CAPTURE_GL(BufferSubData, isCallValid, context, targetPacked, offset, size, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteBuffers(GLsizei n, const GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteBuffers, "context = %d, n = %d, buffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)buffers);

    if (context)
    {
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDeleteBuffers(context, angle::EntryPoint::GLDeleteBuffers, n, buffersPacked));
        if (isCallValid)
        {
            context->deleteBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteQueries(GLsizei n, const GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteQueries, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)ids);

    if (context)
    {
        const QueryID *idsPacked                              = PackParam<const QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDeleteQueries(context, angle::EntryPoint::GLDeleteQueries, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE_GL(DeleteQueries, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EndQuery(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndQuery, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEndQuery(context, angle::EntryPoint::GLEndQuery, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE_GL(EndQuery, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenBuffers(GLsizei n, GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenBuffers, "context = %d, n = %d, buffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)buffers);

    if (context)
    {
        BufferID *buffersPacked                               = PackParam<BufferID *>(buffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGenBuffers(context, angle::EntryPoint::GLGenBuffers, n, buffersPacked));
        if (isCallValid)
        {
            context->genBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE_GL(GenBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenQueries(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenQueries, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        QueryID *idsPacked                                    = PackParam<QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGenQueries(context, angle::EntryPoint::GLGenQueries, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE_GL(GenQueries, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBufferParameteriv(context, angle::EntryPoint::GLGetBufferParameteriv,
                                          targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetBufferParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferPointerv(GLenum target, GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferPointerv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBufferPointerv(context, angle::EntryPoint::GLGetBufferPointerv,
                                       targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetBufferPointerv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferSubData,
          "context = %d, target = %s, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferSubData(context, angle::EntryPoint::GLGetBufferSubData,
                                                                                          target, offset, size, data));
        if (isCallValid)
        {
            context->getBufferSubData(target, offset, size, data);
        }
        ANGLE_CAPTURE_GL(GetBufferSubData, isCallValid, context, target, offset, size, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectiv,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectiv(context, angle::EntryPoint::GLGetQueryObjectiv,
                                                                                          idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectiv, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectuiv,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryObjectuiv(context, angle::EntryPoint::GLGetQueryObjectuiv, idPacked,
                                       pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectuiv, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryiv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryiv(context, angle::EntryPoint::GLGetQueryiv,
                                                                                    targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsBuffer(GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsBuffer, "context = %d, buffer = %u", CID(context), buffer);

    GLboolean returnValue;
    if (context)
    {
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIsBuffer(context, angle::EntryPoint::GLIsBuffer, bufferPacked));
        if (isCallValid)
        {
            returnValue = context->isBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsQuery(GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsQuery, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateIsQuery(context, angle::EntryPoint::GLIsQuery, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQuery, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsQuery, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQuery, GLboolean>();
    }
    return returnValue;
}

void *GL_APIENTRY GL_MapBuffer(GLenum target, GLenum access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapBuffer, "context = %d, target = %s, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapBuffer(context, angle::EntryPoint::GLMapBuffer, targetPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBuffer, void *>();
        }
        ANGLE_CAPTURE_GL(MapBuffer, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBuffer, void *>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_UnmapBuffer(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUnmapBuffer, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target));

    GLboolean returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUnmapBuffer(context, angle::EntryPoint::GLUnmapBuffer, targetPacked));
        if (isCallValid)
        {
            returnValue = context->unmapBuffer(targetPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(UnmapBuffer, isCallValid, context, targetPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBuffer, GLboolean>();
    }
    return returnValue;
}

}  // extern "C"
