#!/bin/bash
#Simple Calendar for antiX - dependencies: Yad. By PPC, GPL license, 15/01/2021. Please keep this line about Creator and license

TEXTDOMAINDIR=/usr/share/locale
TEXTDOMAIN=yad-agenda

#Allow only one instance of the script running
scriptname="$0"
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then
     echo antiX-Calendar is already running...
     wmctrl -R "antiX-calendar"
     exit
    fi 
done

set -x
echo $scriptname > /tmp/antix-calendar-script-name
export calendar_file="$HOME/yad-calendar.txt"
export window_icon=/usr/share/icons/papirus-antix/24x24/apps/calendar.png
export script_name=$BASH_SOURCE

##Clean up calendar file (NOTE: because @ is a special character, in order for the sed comand to percieve it as an ordinary character, it has to be preceded by \, like so: "\@"):
#Remove all empty lines
sed -i '/^$/d' $calendar_file
#Remove all empty lines
sed -i '/^$/d' $calendar_file
#Remove lines with only date and nothing more (orphan lines)- it removes all lines with less than 10 characters
sed -i -r '/^.{,10}$/d' $calendar_file
#Replace "@ " with "@"
sed -i -e 's/\@ /\@/g'  $calendar_file
#Replace "@@" with a simple "@"
sed -i -e 's/\@\@/\@/g'  $calendar_file
#Replace "@ @" with "@"
sed -i -e 's/\@ \@/\@/g'  $calendar_file
#Remove any "@" left at the end of any line
sed 's/\@$//' $calendar_file
#Remove any "@ " left at the end of any line
sed 's/\@ $//' $calendar_file
#Remove any "?", replace with .
#sed -i -e 's/\?/\./g'  $calendar_file
#Remove any "...", replace with .
#sed -i -e 's/\.../\./g'  $calendar_file

touch /tmp/new-calendar-event
echo "" > /tmp/new-calendar-event
inicio=""

Check_time (){
#Validate time format
time=$inicio
number_of_digits_in_time=$(echo -n "time" | wc -c)
time_check="good"
#Only procede if there's a initial time entered- to allow adding directly "all day events"
#check is "time" value exists, store result in "time_inputed"
[[ ! -z "$inicio" ]] && time_inputed=1 ||  time_inputed=0
if [ $time_inputed -eq 1 ];then
echo "USer entered start time, it's not an all day event, check if time is valid"
hour=$(echo $time |cut -d':' -f1)
number_of_digits_in_hour=$(echo -n "$hour" | wc -c)
##echo $number_of_digits_in_hour
if [ "$number_of_digits_in_hour" -lt 2 ] ; then
hour=$(echo 0$hour)
fi
if [ "$hour" -lt 24 ] ; then
 echo "Valid time pattern"
 #hour is ok, checking minutes
 minute=$(echo $time |cut -d':' -f2)
 number_of_digits_in_minute=$(echo -n "$minute" | wc -c)
## echo $number_of_digits_in_minute
 if [ "$number_of_digits_in_minute" -lt 2 ] ; then
   hour=$(echo 0$minute)
 fi
 if [ "$minute" -lt 60 ] ; then
	echo "Valid time pattern"
	else
##	 echo "InValid time pattern"
export	time_check="bad"
 fi
 else
##	echo "InValid time pattern"
export	time_check="bad"
fi
fi
}

Adicionar_evento_complexo(){
#bash ~/add_complex_event.sh
# Empty day, add an event
wmctrl -c "antiX-calendar"
day=$(cat /tmp/chosen_calendar_day)
touch /tmp/new-calendar-event
eventoORIGINAL=$(cat /tmp/new-calendar-event)

entrada=$(yad --window-icon=$window_icon --title="$day" --center --width=400 --form --field=$"Event" --field=$"Start" --field=$"End (optional)" "$eventoORIGINAL" "$inicio" "$fim")
inicio=$(echo $entrada |cut -d'|' -f2)
evento=$(echo $entrada |cut -d'|' -f1)
fim=$(echo $entrada |cut -d'|' -f3)

echo $evento > /tmp/new-calendar-event
##### Time validation
if date -d "$inicio" >/dev/null # enventually remove redirection...
then
status="Valid time pattern"
else
status="InValid time pattern"
yad --center --window-icon=$window_icon --title="antiX Calendar" --text=" Incorrect time entered \n Enter a time between 00:00 and 23:59 " --button="X":1 --button="OK":2
		foo=$?
		if [[ $foo -eq 1 ]]; then
			exit
		fi
		if [[ $foo -eq 2 ]]; then
			 Adicionar_evento_complexo  #############fix this!!!!!!!!!!!!!!!!!!1
		fi          
 fi

if date -d "$fim" >/dev/null # enventually remove redirection...
then
status="Valid time pattern"
else
status="InValid time pattern"
yad --center --window-icon=$window_icon --title="antiX Calendar" --text=" Incorrect time entered \n Enter a time between 00:00 and 23:59 " --button="X":1 --button="OK":2
		foo=$?
		if [[ $foo -eq 1 ]]; then
			exit
		fi
		if [[ $foo -eq 2 ]]; then
			 Adicionar_evento_complexo  #############fix this!!!!!!!!!!!!!!!!!!1
		fi          
 fi

[[ ! -z "$inicio" ]] && inicio=$(echo \@$inicio)
[[ ! -z "$fim" ]] && inicio=$(echo $inicio-$fim)
echo $day $inicio $evento >> $HOME/yad-calendar.txt
### restart main calendar window
wmctrl -c "antiX-calendar"
exec $BASH_SOURCE  ### to restart main calendar window
}

Adicionar_evento(){
# Empty day, add an event
touch /tmp/new-calendar-event
existing_event=$(cat /tmp/new-calendar-event)
event=$(yad --center --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png" --width=350 --hight=250 --title="$day" --button=" ...":2 --button=$"OK":0 --form --separator="" --item-separator="" --field="" "$existing_event")
button=$?

if [[ $button == "0" ]]; then
echo $day $event >> $calendar_file
echo "" > /tmp/new-calendar-event
fi

if [[ $button == "2" ]]; then
echo $event > /tmp/new-calendar-event
Adicionar_evento_complexo
fi
$BASH_SOURCE &  ### to restart main calendar window
exit
}

Editar_evento(){
#bash ~/edit_event.sh

# Day with existing event(s)
#Create array of the day's event(s)
day=$(cat /tmp/chosen_calendar_day)
entrada=$(grep -h $day $calendar_file)
reminder_time=$(echo $entrada|cut -d' ' -f2)
reminder_date=$(echo $entrada|cut -d' ' -f1)
line=($(grep -n $day $calendar_file | head -n 1 | cut -d: -f1))
eventos_existentes=$(grep $day $calendar_file |cut -d' ' -f1 --complement)
#Count existing timed events (indicated by "@", so, count "@" signs
x=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
#The number of events for the day is $x
let "x=x+2"
numero_de_eventos_no_dia=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
#clean temporary file
echo "" > /tmp/listar_eventos_do_dia
##loop to check for each timed event, add each event to a different line of the temp file
i=1
until [ $i -ge $x ]
do
grep $day $calendar_file |cut -d@ -f$i >> /tmp/listar_eventos_do_dia
  ((i=i+1))
done
#remove empty lines
sed -i '/^$/d' /tmp/listar_eventos_do_dia
selection=""
#list that day's event(s) in a yad window:
evento_a_editar=$(yad --window-icon=$window_icon --title="$day"  --button="+":2 --width=800 --height=550 --center --separator=" " --list  --column=$"Double click an event to edit or cancel it, double click date to add an all day event"  < /tmp/listar_eventos_do_dia)
selection=$?
export $selection

#START GUI to add (timed) event:
if [[ $selection -eq 2 ]]; then
#process result of user entry:
date=$day
input=$(yad --window-icon=$window_icon --title="$day" --center --form --field=$"Event" --field=$"Start" --field=$"End (optional)")
export start=$(echo $input |cut -d'|' -f2)
event=$(echo $input |cut -d'|' -f1)
export end=$(echo $input |cut -d'|' -f3)

##### Time validation
if date -d "$start" >/dev/null # you can enventually remove redirection...
then
status="Valid time pattern"
else
status="InValid time pattern"
yad --center --window-icon=$window_icon --title="antiX Calendar" --text=" Incorrect time entered \n Enter a time between 00:00 and 23:59 " --button="X":1 --button="OK":2
		foo=$?
		if [[ $foo -eq 1 ]]; then
			exit
		fi
		if [[ $foo -eq 2 ]]; then
			 Editar_evento
		fi          
 fi

edited_day=$(echo $current_day @$start $event)
#Generate list of current day's events (withouy all day events), in file /tmp/listar_eventos_do_dia
eventos_existentes=$(grep ^$day $calendar_file |cut -d' ' -f1 --complement)
x=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
##echo O Numero de Eventos no dia em causa é $x
let "x=x+2"
#Count envents (each @ sign)
numero_de_eventos_no_dia=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
echo "" > /tmp/listar_eventos_do_dia
i=2
#loop to add events to temporary file
until [ $i -ge $x ]
do
grep $day $calendar_file |cut -d@ -f$i >> /tmp/listar_eventos_do_dia
  ((i=i+1))
done
#Remove empty lines
sed -i '/^$/d' /tmp/listar_eventos_do_dia

#add new entry to the end of the file
input=$edited_day   ##############################simulate user input
echo $input >> /tmp/listar_eventos_do_dia

####Put events in correct order
date_and_all_day_events=$(egrep "^$day " $calendar_file |cut -d'@' -f1)
sort /tmp/listar_eventos_do_dia > /tmp/temp0.txt
tac /tmp/temp0.txt > /tmp/temp1.txt
echo $date_and_all_day_events >> /tmp/temp1.txt
tac /tmp/temp1.txt > /tmp/listar_eventos_do_dia_editados
sed -i '/^$/d' /tmp/listar_eventos_do_dia_editados
# New event's list, starting with date (and eventual all day's events) followed by timed events, in /tmp/listar_eventos_do_dia_editados

###Create line from /tmp/listar_eventos_do_dia_editados
#Start by adding " @" at the begining of each line
sed -i -e 's/^/ @/' /tmp/listar_eventos_do_dia_editados
#Remove " @" from first line (date and eventual all day events)- it's the 2 first characters, so, repeat sed command 
sed -i '1s/^.//' /tmp/listar_eventos_do_dia_editados
sed -i '1s/^.//' /tmp/listar_eventos_do_dia_editados
#Generate line from temporary file
export linha_nova=$(tr -d '\n' < /tmp/listar_eventos_do_dia_editados)

###Save changes in correct day
export day
export ENTRADA_ATUAL=$(egrep "^$day " $calendar_file)
while read -r line; do
linha_nova=$(tr -d '\n' < /tmp/listar_eventos_do_dia_editados)
printf "%s\n" "${line/"${ENTRADA_ATUAL}"/"${linha_nova}"}"
done < $calendar_file > ~/file.new
#Replace "@@" with a simple "@"
sed -i -e 's/\@\@/\@/g'  ~/file.new
cp ~/file.new $calendar_file
###restart main calendar window
wmctrl -c "antiX-calendar"
exec $BASH_SOURCE   ### to restart main calendar window
fi
##END of GUI to add (timed) event

### Process click in event from list:
entrada=$(grep -h $day $calendar_file)
if [ -z "${evento_a_editar}" ]; then
#No event selected for edition, exit
exec $BASH_SOURCE  ### to restart main calendar window
    exit
fi

input=$evento_a_editar
echo $input > /tmp/tempor1
evento_a_editar=$(cat /tmp/tempor1 |cut -d'|' -f1)
input2=$(yad --window-icon=$window_icon --center --width=350 --hight=250 --title="$day" --form --field="" "$evento_a_editar")

 selection2=$?
case ${selection2} in
   1) status="You pressed Cancel" && exit ;;
   #0) echo "You pressed OK";;
   252) status="You pressed ESCAPE key or closed the window,exiting without saving anything" && exit ;;
esac

echo $input2 > /tmp/tempor2
alteracao=$(cat /tmp/tempor2 |cut -d'|' -f1)
export result=$(echo $entrada | awk -v srch="$evento_a_editar" -v repl="$alteracao" '{ sub(srch,repl,$0); print $0 }')

###Save changes in correct day
export day
export ENTRADA_ATUAL=$(egrep "^$day " $calendar_file)
while read -r line; do
linha_nova=$(tr -d '\n' < /tmp/listar_eventos_do_dia_editados)
printf "%s\n" "${line/"${ENTRADA_ATUAL}"/"${result}"}"
done < $calendar_file > ~/file.new
egrep "^$day " ~/file.new 
cp ~/file.new  $calendar_file
#Replace "@ " with "@"
sed -i -e 's/\@ /\@/g'  $calendar_file
#Replace "@@" with a simple "@"
sed -i -e 's/\@\@/\@/g'  $calendar_file
#Replace "@ @" with "@"
sed -i -e 's/\@ \@/\@/g'  $calendar_file  ###############################be carefull with sed
#Replace "@ " with "@"
sed -i -e 's/\@ /\@/g'  $calendar_file  ###############################be carefull with sed
#Remove any "@" left at the end of any line
sed 's/\@$//' $calendar_file              ###############################be carefull with sed
#Remove any "@ " left at the end of any line
sed 's/\@ $//' $calendar_file              ###############################be carefull with sed
egrep "^$day "  $calendar_file 

#####Ugly way to to reorder day's entries:
#Generate list of current day's events (withouy all day events), in file /tmp/listar_eventos_do_dia
eventos_existentes=$(grep ^$day $calendar_file |cut -d' ' -f1 --complement)
echo $eventos_existentes
x=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
echo O Numero de Eventos no dia em causa é $x
let "x=x+2"
#Count envents (each @ sign)
numero_de_eventos_no_dia=$(tr -dc '@' <<<"$eventos_existentes" | awk '{ print length; }')
echo "" > /tmp/listar_eventos_do_dia
i=2
#loop to add events to temporary file
until [ $i -ge $x ]
do
grep $day $calendar_file |cut -d@ -f$i >> /tmp/listar_eventos_do_dia
  ((i=i+1))
done
#Remove empty lines
sed -i '/^$/d' /tmp/listar_eventos_do_dia

####Put events in correct order
date_and_all_day_events=$(egrep "^$day " $calendar_file |cut -d'@' -f1)
sort /tmp/listar_eventos_do_dia > /tmp/temp0.txt
tac /tmp/temp0.txt > /tmp/temp1.txt
echo $date_and_all_day_events >> /tmp/temp1.txt
tac /tmp/temp1.txt > /tmp/listar_eventos_do_dia_editados
sed -i '/^$/d' /tmp/listar_eventos_do_dia_editados

###Create line from /tmp/listar_eventos_do_dia_editados
#Start by adding " @" at the begining of each line
sed -i -e 's/^/ @/' /tmp/listar_eventos_do_dia_editados
#Remove " @" from first line (date and eventual all day events)- it's the 2 first characters, so, repeat sed command 
sed -i '1s/^.//' /tmp/listar_eventos_do_dia_editados
sed -i '1s/^.//' /tmp/listar_eventos_do_dia_editados
#Generate line from temporary file
export linha_nova=$(tr -d '\n' < /tmp/listar_eventos_do_dia_editados)
echo "Current day's entry will be:"
echo $linha_nova

###Save changes in correct day
export day
export ENTRADA_ATUAL=$(egrep "^$day " $calendar_file)
while read -r line; do
linha_nova=$(tr -d '\n' < /tmp/listar_eventos_do_dia_editados)
printf "%s\n" "${line/"${ENTRADA_ATUAL}"/"${linha_nova}"}"
done < $calendar_file > ~/file.new
#Replace "@@" with a simple "@"
sed -i -e 's/\@\@/\@/g'  ~/file.new
cp ~/file.new $calendar_file
### restart main calendar window
wmctrl -c "antiX-calendar"
exec $BASH_SOURCE  ### to restart main calendar window

}

search_event(){
 ###future entry to search for events:
  event_to_search=$( yad --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png" --title="antiX Calendar" --center --width=250 --entry --entry-label="" --button=" !/usr/share/icons/papirus-antix/22x22/actions/search.png")
  rm /tmp/agenda_search_results.txt
 #Display results, only if something was searched
 if [ -z ${event_to_search} ]; then exit; else grep -i $event_to_search $HOME/yad-calendar.txt > /tmp/agenda_search_results-desorganized.txt
   grep -i $event_to_search $HOME/yad-calendar.txt > /tmp/agenda_search_results-desorganized.txt
   sort -n -t"/" -k3 -k2 -k1 /tmp/agenda_search_results-desorganized.txt > /tmp/agenda_search_results.txt
   yad --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png" --title="antiX Calendar" --no-buttons  --width=550 --height=550 --center --separator=" " --list  --column=""  < /tmp/agenda_search_results.txt
    $BASH_SOURCE &  ### to restart main calendar window
    exit 1
 fi    
}

alarm-toogler(){
####Togle Calendar alarms
BASECMD="salarm3.sh"
check=$(pgrep $BASECMD)

#check variable not empty means that Alarms are on, are with pid $check, turning them off
if [ -n "$check" ]; then
yad --timeout=2 --on-top --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png"  --title="antiX Calendar" --picture --filename=/usr/local/lib/ft10/icons/alarms_off-small.png --geometry=300x180-50-50 --inc=256 --no-buttons --timeout-indicator=bottom
pkill salarm3 
 #...and make sure that the Simple Calandar Alarms script is not on the startup file anymore:
 sed -i '/slarm3.sh/d' ~/.desktop-session/startup

##Alarms should now be off, restarting Calendar
pkill yad
pkill yad-calendar-ft
script_to_restart=$(cat /tmp/antix-calendar-script-name)
$script_to_restart &  ### to restart main calendar window
exit 1
fi

##Turning Calendar Alarms on
salarm3.sh &
check=$(pgrep $BASECMD)
##Alarms should now be on, restarting Calendar
pkill yad
script_to_restart=$(cat /tmp/antix-calendar-script-name)
$script_to_restart &  ### to restart main calendar window
exit
}

choose_icon(){
	#Choose correct icon to indicate status- if alarms are on or off:
	BASECMD="salarm3.sh"
	var=$(pgrep "$BASECMD")
	if [ -n "$var" ]; then
	        #Alarms are "on" icon
			#cp /usr/share/icons/papirus-antix/symbolic/status/alarm-symbolic.png ~/.config/tint2/cal-icon.png
			cp /usr/local/lib/ft10/icons/alarms_on-tiny.png		~/.config/tint2/cal-icon.png
			
		else
		    #Alarms are "off" icon
			#cp /usr/share/icons/papirus-antix/symbolic/status/airplane-mode-symbolic.png ~/.config/tint2/cal-icon.png
			cp /usr/local/lib/ft10/icons/alarms_off-tiny.png		~/.config/tint2/cal-icon.png
	fi		

}

#import functions and make sure that the default config file exists
export -f Adicionar_evento Editar_evento search_event alarm-toogler choose_icon
touch ~/yad-calendar.txt && [ -s ~/yad-calendar.txt ] || echo "28/06/2020 This is how yad-calendar entries work! Add ONLY ONE line per day, starting with the date. If nothing shows up in the calendar, try another date format like dd-mm-yyyy" > $HOME/yad-calendar.txt

 choose_icon
#Main part of the script:
#New section: on the top of the month view, display todays event's if any;
today=$(date +%x)
todays_events=$(grep $today $HOME/yad-calendar.txt|sed 's/@/\n/g')
icon="$HOME/.config/tint2/cal-icon.png"
day=$(yad --borders=10 --image-on-top --image=$icon --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png"  --calendar --undecorated --geometry=280x90-40-50 --title="antiX-calendar" --text="$todays_events" --details=$HOME/yad-calendar.txt  --button="!/usr/local/lib/ft10/icons/emblem-system-symbolic.png":"bash -c 'alarm-toogler'" --button="!/usr/share/icons/papirus-antix/24x24/actions/search.png":"bash -c search_event" --button="!/usr/share/icons/papirus-antix/48x48/actions/stock_xfburn-blank-cdrw.png":1)
#Draw main window
echo $day > /tmp/chosen_calendar_day

if [[ $foo -eq 1 ]]; then
    exit 1
  fi
#If no date selected, just exit
[ -z "$day" ] && exit

#If a date was selected, see if has an event and run the corresponding function
if grep -q $day $HOME/yad-calendar.txt; then
   Editar_evento
   else
   Adicionar_evento
fi
