#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Segments.Integrators._RichardsonFixedStep import _RichardsonFixedStep

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054969.9906387
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:49 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/Segments/Integrators/RichardsonFixedStep.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class RichardsonFixedStep(_RichardsonFixedStep):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(RichardsonFixedStep, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: segment $segmentNumber ($stepper.name fixed-step, fixed-order integrator with Richardson Extrapolation) at line 26, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''segment ''')
        _v = VFFSL(SL,"segmentNumber",True) # '$segmentNumber' on line 26, col 27
        if _v is not None: write(_filter(_v, rawExpr='$segmentNumber')) # from line 26, col 27.
        write(''' (''')
        _v = VFFSL(SL,"stepper.name",True) # '$stepper.name' on line 26, col 43
        if _v is not None: write(_filter(_v, rawExpr='$stepper.name')) # from line 26, col 43.
        write(''' fixed-step, fixed-order integrator with Richardson Extrapolation)''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def localInitialise(self, **KWS):



        ## CHEETAH: generated from @def localInitialise at line 34, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(RichardsonFixedStep, self).localInitialise()
        if _v is not None: write(_filter(_v))
        # 
        write('''
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 39, col 3
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 40, col 1
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 40, col 1.
            write('''* _T0_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 40, col 21
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 40, col 21.
            write('''[''')
            _v = VFFSL(SL,"extrapolations",True) # '$extrapolations' on line 40, col 34
            if _v is not None: write(_filter(_v, rawExpr='$extrapolations')) # from line 40, col 34.
            write('''];
''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 41, col 1
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 41, col 1.
            write('''* _T1_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 41, col 21
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 41, col 21.
            write('''[''')
            _v = VFFSL(SL,"extrapolations",True) # '$extrapolations' on line 41, col 34
            if _v is not None: write(_filter(_v, rawExpr='$extrapolations')) # from line 41, col 34.
            write('''];

''')
            for i in range(0, VFFSL(SL,"extrapolations",True)): # generated from line 43, col 3
                write('''_T0_''')
                _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 44, col 5
                if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 44, col 5.
                write('''[''')
                _v = VFFSL(SL,"i",True) # '$i' on line 44, col 18
                if _v is not None: write(_filter(_v, rawExpr='$i')) # from line 44, col 18.
                write('''] = _rerow_T0_''')
                _v = VFFSL(SL,"i",True) # '${i}' on line 44, col 34
                if _v is not None: write(_filter(_v, rawExpr='${i}')) # from line 44, col 34.
                write('''_''')
                _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 44, col 39
                if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 44, col 39.
                write(''';
_T1_''')
                _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 45, col 5
                if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 45, col 5.
                write('''[''')
                _v = VFFSL(SL,"i",True) # '$i' on line 45, col 18
                if _v is not None: write(_filter(_v, rawExpr='$i')) # from line 45, col 18.
                write('''] = _rerow_T1_''')
                _v = VFFSL(SL,"i",True) # '${i}' on line 45, col 34
                if _v is not None: write(_filter(_v, rawExpr='${i}')) # from line 45, col 34.
                write('''_''')
                _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 45, col 39
                if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 45, col 39.
                write(''';
''')
            write('''
''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 48, col 1
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 48, col 1.
            write('''** _Tprev_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 48, col 25
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 48, col 25.
            write(''' = _T0_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 48, col 44
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 48, col 44.
            write(''';
''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 49, col 1
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 49, col 1.
            write('''** _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 49, col 25
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 49, col 25.
            write(''' = _T1_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 49, col 44
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 49, col 44.
            write(''';
''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 50, col 1
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 50, col 1.
            write('''* _result_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 50, col 25
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 50, col 25.
            write(''';

''')
        write('''
''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_re_reset') # "${copyVectors($integrationVectors, '_re_reset')}" on line 54, col 1
        if _v is not None: write(_filter(_v, rawExpr="${copyVectors($integrationVectors, '_re_reset')}")) # from line 54, col 1.
        write('''
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def functionPrototypes(self, **KWS):



        ## CHEETAH: generated from @def functionPrototypes at line 61, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(RichardsonFixedStep, self).functionPrototypes()
        if _v is not None: write(_filter(_v))
        # 
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 65, col 3
            write('''void _segment''')
            _v = VFFSL(SL,"segmentNumber",True) # '${segmentNumber}' on line 66, col 14
            if _v is not None: write(_filter(_v, rawExpr='${segmentNumber}')) # from line 66, col 14.
            write('''_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 66, col 31
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 66, col 31.
            write('''_reset(''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 66, col 50
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 66, col 50.
            write('''* _reset_to);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def segmentFunctionBody(self, function, **KWS):



        ## CHEETAH: generated from @def segmentFunctionBody($function) @* Overrides segmentFunctionBody of FixedStep *@ at line 71, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = VFFSL(SL,"createStepVariable",True) # '${createStepVariable}' on line 73, col 1
        if _v is not None: write(_filter(_v, rawExpr='${createStepVariable}')) # from line 73, col 1.
        # 
        featureOrderingOuter = ['Stochastic']
        _v = VFFSL(SL,"insertCodeForFeatures",False)('integrateFixedStepBegin', featureOrderingOuter) # "${insertCodeForFeatures('integrateFixedStepBegin', featureOrderingOuter)}" on line 76, col 1
        if _v is not None: write(_filter(_v, rawExpr="${insertCodeForFeatures('integrateFixedStepBegin', featureOrderingOuter)}")) # from line 76, col 1.
        write('''
''')
        _v = VFFSL(SL,"allocate",True) # '${allocate}' on line 78, col 1
        if _v is not None: write(_filter(_v, rawExpr='${allocate}')) # from line 78, col 1.
        _v = VFFSL(SL,"initialise",True) # '${initialise}' on line 79, col 1
        if _v is not None: write(_filter(_v, rawExpr='${initialise}')) # from line 79, col 1.
        _v = VFFSL(SL,"localInitialise",True) # '${localInitialise}' on line 80, col 1
        if _v is not None: write(_filter(_v, rawExpr='${localInitialise}')) # from line 80, col 1.
        write('''
for (long _istep = 0; _istep < ''')
        _v = VFFSL(SL,"stepCount",True) # '${stepCount}' on line 82, col 32
        if _v is not None: write(_filter(_v, rawExpr='${stepCount}')) # from line 82, col 32.
        write('''; _istep++) {
''')
        #  Insert code for features
        featureOrderingInner = ['Output', 'ErrorCheck', 'Stochastic']
        # 
        dict = {'extraIndent': 0}
        write('''  ''')
        _v = VFFSL(SL,"insertCodeForFeatures",False)('integrateFixedStepInnerLoopBegin', featureOrderingInner, dict) # "${insertCodeForFeatures('integrateFixedStepInnerLoopBegin', featureOrderingInner, dict), autoIndent=True}" on line 87, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${insertCodeForFeatures('integrateFixedStepInnerLoopBegin', featureOrderingInner, dict), autoIndent=True}")) # from line 87, col 3.
        extraIndent = VFFSL(SL,"dict.extraIndent",True)
        write('''  
  ''')
        _v = VFFSL(SL,"preSingleStep",True) # '${preSingleStep, autoIndent=True, extraIndent=extraIndent}' on line 90, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, extraIndent=extraIndent, rawExpr='${preSingleStep, autoIndent=True, extraIndent=extraIndent}')) # from line 90, col 3.
        write('''  ''')
        _v = VFFSL(SL,"richardsonExtrapolate",False)(function) # '${richardsonExtrapolate(function), autoIndent=True, extraIndent=extraIndent}' on line 91, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, extraIndent=extraIndent, rawExpr='${richardsonExtrapolate(function), autoIndent=True, extraIndent=extraIndent}')) # from line 91, col 3.
        write('''  ''')
        _v = VFFSL(SL,"postSingleStep",True) # '${postSingleStep, autoIndent=True, extraIndent=extraIndent}' on line 92, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, extraIndent=extraIndent, rawExpr='${postSingleStep, autoIndent=True, extraIndent=extraIndent}')) # from line 92, col 3.
        write('''  
''')
        if VFFSL(SL,"cross",True): # generated from line 94, col 3
            #  If we are cross-integrating, then we now need to copy our result back
            #  into the original arrays for the integration vectors
            write('''  ''')
            _v = VFFSL(SL,"copyResultIntoIntegrationArrays",True) # '${copyResultIntoIntegrationArrays, autoIndent=True, extraIndent=extraIndent}' on line 97, col 3
            if _v is not None: write(_filter(_v, autoIndent=True, extraIndent=extraIndent, rawExpr='${copyResultIntoIntegrationArrays, autoIndent=True, extraIndent=extraIndent}')) # from line 97, col 3.
            write('''  
''')
        # 
        write('''  ''')
        _v = VFFSL(SL,"insertCodeForFeaturesInReverseOrder",False)('integrateFixedStepInnerLoopEnd', featureOrderingInner, dict) # "${insertCodeForFeaturesInReverseOrder('integrateFixedStepInnerLoopEnd', featureOrderingInner, dict), autoIndent=True}" on line 101, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${insertCodeForFeaturesInReverseOrder('integrateFixedStepInnerLoopEnd', featureOrderingInner, dict), autoIndent=True}")) # from line 101, col 3.
        write('''}

''')
        _v = VFFSL(SL,"localFinalise",True) # '${localFinalise}' on line 104, col 1
        if _v is not None: write(_filter(_v, rawExpr='${localFinalise}')) # from line 104, col 1.
        _v = VFFSL(SL,"finalise",True) # '${finalise}' on line 105, col 1
        if _v is not None: write(_filter(_v, rawExpr='${finalise}')) # from line 105, col 1.
        _v = VFFSL(SL,"free",True) # '${free}' on line 106, col 1
        if _v is not None: write(_filter(_v, rawExpr='${free}')) # from line 106, col 1.
        write('''
''')
        _v = VFFSL(SL,"insertCodeForFeaturesInReverseOrder",False)('integrateFixedStepEnd', featureOrderingOuter) # "${insertCodeForFeaturesInReverseOrder('integrateFixedStepEnd', featureOrderingOuter)}" on line 108, col 1
        if _v is not None: write(_filter(_v, rawExpr="${insertCodeForFeaturesInReverseOrder('integrateFixedStepEnd', featureOrderingOuter)}")) # from line 108, col 1.
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def richardsonExtrapolate(self, function, **KWS):



        ## CHEETAH: generated from @def richardsonExtrapolate($function) at line 112, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''long _k = 0;
long _max_integration_steps = 0;

long _istep_temp = _istep;
real _step_temp = _step;
real _''')
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 119, col 7
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 119, col 7.
        write('''_temp = ''')
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 119, col 38
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 119, col 38.
        write(''';

for (_k = 0; _k < ''')
        _v = VFFSL(SL,"extrapolations",True) # '$extrapolations' on line 121, col 19
        if _v is not None: write(_filter(_v, rawExpr='$extrapolations')) # from line 121, col 19.
        write('''; _k++)
{
  // Swap active rows
  {
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 125, col 3
            write('''    ''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 126, col 5
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 126, col 5.
            write('''** _temp_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 126, col 28
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 126, col 28.
            write(''' = _Tprev_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 126, col 50
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 126, col 50.
            write(''';
    _Tprev_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 127, col 12
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 127, col 12.
            write(''' = _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 127, col 34
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 127, col 34.
            write(''';
    _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 128, col 12
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 128, col 12.
            write(''' = _temp_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 128, col 33
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 128, col 33.
            write(''';
''')
        write('''  }
  
  long _nk = 2 * (_k + 1);
  _max_integration_steps = _nk;
  
  _step = _step_temp / _nk;
  
  ''')
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 137, col 3
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 137, col 3.
        write(''' = _''')
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 137, col 30
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 137, col 30.
        write('''_temp;
  
  for (_istep = 0; _istep < _nk; _istep++) {
    ''')
        _v = VFN(VFFSL(SL,"stepper",True),"singleIntegrationStep",False)(function) # '${stepper.singleIntegrationStep(function), autoIndent=True}' on line 140, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${stepper.singleIntegrationStep(function), autoIndent=True}')) # from line 140, col 5.
        write('''  }
  _istep = _istep_temp;
  _step = _step_temp;
  
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 145, col 3
            write('''  _result_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 146, col 11
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 146, col 11.
            write(''' = _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 146, col 33
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 146, col 33.
            write('''[0];
''')
        write('''  
  ''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_result', '_active') # "${copyVectors($integrationVectors, '_result', '_active'), autoIndent=True}" on line 149, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${copyVectors($integrationVectors, '_result', '_active'), autoIndent=True}")) # from line 149, col 3.
        write('''  
  for (long _j = 0; _j < _k; _j++)
  {
    real _nksubj = 2 * (_k - _j);
    real _denominator = pow(((real)_nk) / _nksubj, 2) - 1.0;
    
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 156, col 5
            write('''    ''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 157, col 5
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 157, col 5.
            write('''* const _TcurrJPlusOne_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 157, col 42
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 157, col 42.
            write(''' = _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 157, col 64
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 157, col 64.
            write('''[_j+1];
    ''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 158, col 5
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 158, col 5.
            write('''* const _TcurrJ_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 158, col 35
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 158, col 35.
            write(''' = _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 158, col 57
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 158, col 57.
            write('''[_j];
    ''')
            _v = VFFSL(SL,"vector.type",True) # '${vector.type}' on line 159, col 5
            if _v is not None: write(_filter(_v, rawExpr='${vector.type}')) # from line 159, col 5.
            write('''* const _TprevJ_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 159, col 35
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 159, col 35.
            write(''' = _Tprev_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 159, col 57
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 159, col 57.
            write('''[_j];
''')
        write('''    
    ''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""_TcurrJPlusOne_${vector.id}[$index] = _TcurrJ_${vector.id}[$index] + (_TcurrJ_${vector.id}[$index] - _TprevJ_${vector.id}[$index]) / _denominator;
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""_TcurrJPlusOne_${vector.id}[$index] = _TcurrJ_${vector.id}[$index] + (_TcurrJ_${vector.id}[$index] - _TprevJ_${vector.id}[$index]) / _denominator;\n""", basis = $homeBasis), autoIndent=True}')) # from line 162, col 5.
        write('''  }
  
  // Reset
  ''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_active', '_re_reset') # "${copyVectors($integrationVectors, '_active', '_re_reset'), autoIndent=True}" on line 168, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${copyVectors($integrationVectors, '_active', '_re_reset'), autoIndent=True}")) # from line 168, col 3.
        write('''}

''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 171, col 3
            write('''_result_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 172, col 9
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 172, col 9.
            write(''' = _Tcurr_''')
            _v = VFFSL(SL,"vector.id",True) # '${vector.id}' on line 172, col 31
            if _v is not None: write(_filter(_v, rawExpr='${vector.id}')) # from line 172, col 31.
            write('''[_k-1];
''')
        write('''
''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_active', '_result') # "${copyVectors($integrationVectors, '_active', '_result')}" on line 175, col 1
        if _v is not None: write(_filter(_v, rawExpr="${copyVectors($integrationVectors, '_active', '_result')}")) # from line 175, col 1.
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_re_reset', '_active') # "${copyVectors($integrationVectors, '_re_reset', '_active')}" on line 176, col 1
        if _v is not None: write(_filter(_v, rawExpr="${copyVectors($integrationVectors, '_re_reset', '_active')}")) # from line 176, col 1.
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 177, col 1
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 177, col 1.
        write(''' = _''')
        _v = VFFSL(SL,"propagationDimension",True) # '${propagationDimension}' on line 177, col 28
        if _v is not None: write(_filter(_v, rawExpr='${propagationDimension}')) # from line 177, col 28.
        write('''_temp + _step;

''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # RichardsonFixedStep.tmpl
        # 
        # Created by Sean Wild on 2013-10-10.
        # 
        # Copyright (c) 2007-2013, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''



                                      

''')
        # 
        #   Function prototypes
        write('''

''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    extrapolations = 4

    supportsConstantIPOperators = False

    maxIntegrationStepsVar = '_max_integration_steps'

    _mainCheetahMethod_for_RichardsonFixedStep = 'writeBody'

## END CLASS DEFINITION

if not hasattr(RichardsonFixedStep, '_initCheetahAttributes'):
    templateAPIClass = getattr(RichardsonFixedStep,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(RichardsonFixedStep)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=RichardsonFixedStep()).run()


