/* -*-mode:java; c-basic-offset:2; -*- */
/* WeirdX - Guess.
 *
 * Copyright (C) 2000-2004 JCraft, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.weirdx;
import java.io.*;
import java.awt.event.KeyEvent;
import java.net.*;

final class Keymap_jp106 extends Keymap{
  // There are 4 KeySyms per KeyCode; KeyCodes range from 8 to 134.
  private int[] _map={
    0x0,	0x0,	0x0,	0x0,	 // 8 
    0xff1b,	0x0,	0x0,	0x0,	 // 9 Escape, 
    0x0031,	0x0021,	0x04c7,	0x00a1,	 // 10 1, exclam, kana_NU, exclamdown, 
    0x0032,	0x0022,	0x04cc,	0x0ac3,	 // 11 2, quotedbl, kana_FU, oneeighth, 
    0x0033,	0x0023,	0x04b1,	0x04a7,	 // 12 3, numbersign, kana_A, kana_a, 
    0x0034,	0x0024,	0x04b3,	0x04a9,	 // 13 4, dollar, kana_U, kana_u, 
    0x0035,	0x0025,	0x04b4,	0x04aa,	 // 14 5, percent, kana_E, kana_e, 
    0x0036,	0x0026,	0x04b5,	0x04ab,	 // 15 6, ampersand, kana_O, kana_o, 
    0x0037,	0x0027,	0x04d4,	0x04ac,	 // 16 7, apostrophe, kana_YA, kana_ya, 
    0x0038,	0x0028,	0x04d5,	0x04ad,	 // 17 8, parenleft, kana_YU, kana_yu, 
    0x0039,	0x0029,	0x04d6,	0x04ae,	 // 18 9, parenright, kana_YO, kana_yo, 
    0x0030,	0x007e,	0x04dc,	0x04a6,	 // 19 0, asciitilde, kana_WA, kana_WO, 
    0x002d,	0x003d,	0x04ce,	0x00bf,	 // 20 minus, equal, kana_HO, questiondown, 
    0x005e,	0x007e,	0x04cd,	0xfe5c,	 // 21 asciicircum, asciitilde, kana_HE, dead_ogonek, 
    0xff08,	0x0,	0x0,	0x0,	 // 22 BackSpace, 
    0xff09,	0xfe20,	0x0,	0x0,	 // 23 Tab, ISO_Left_Tab, 
    0x0071,	0x0051,	0x04c0,	0x07d9,	 // 24 q, Q, kana_TA, Greek_OMEGA, 
    0x0077,	0x0057,	0x04c3,	0x01a3,	 // 25 w, W, kana_TE, Lstroke, 
    0x0065,	0x0045,	0x04b2,	0x04a8,	 // 26 e, E, kana_I, kana_i, 
    0x0072,	0x0052,	0x04bd,	0x00ae,	 // 27 r, R, kana_SU, registered, 
    0x0074,	0x0054,	0x04b6,	0x03ac,	 // 28 t, T, kana_KA, Tslash, 
    0x0079,	0x0059,	0x04dd,	0x00a5,	 // 29 y, Y, kana_N, yen, 
    0x0075,	0x0055,	0x04c5,	0x08fc,	 // 30 u, U, kana_NA, uparrow, 
    0x0069,	0x0049,	0x04c6,	0x02b9,	 // 31 i, I, kana_NI, idotless, 
    0x006f,	0x004f,	0x04d7,	0x00d8,	 // 32 o, O, kana_RA, Ooblique, 
    0x0070,	0x0050,	0x04be,	0x00de,	 // 33 p, P, kana_SE, THORN, 
    0x0040,	0x0060,	0x04de,	0xfe58,	 // 34 at, grave, voicedsound, dead_abovering, 
    0x005b,	0x007b,	0x04df,	0x04a2,	 // 35 bracketleft, braceleft, semivoicedsound, kana_openingbracket, 
    0xff0d,	0x0,	0x0,	0x0,	 // 36 Return, 
    0xffe3,	0x0,	0x0,	0x0,	 // 37 Control_L, 
    0x0061,	0x0041,	0x04c1,	0x00c6,	 // 38 a, A, kana_CHI, AE, 
    0x0073,	0x0053,	0x04c4,	0x00a7,	 // 39 s, S, kana_TO, section, 
    0x0064,	0x0044,	0x04bc,	0x00d0,	 // 40 d, D, kana_SHI, ETH, 
    0x0066,	0x0046,	0x04ca,	0x00aa,	 // 41 f, F, kana_HA, ordfeminine, 
    0x0067,	0x0047,	0x04b7,	0x03bd,	 // 42 g, G, kana_KI, ENG, 
    0x0068,	0x0048,	0x04b8,	0x02a1,	 // 43 h, H, kana_KU, Hstroke, 
    0x006a,	0x004a,	0x04cf,	0x0,	 // 44 j, J, kana_MA, 
    0x006b,	0x004b,	0x04c9,	0x0026,	 // 45 k, K, kana_NO, ampersand, 
    0x006c,	0x004c,	0x04d8,	0x01a3,	 // 46 l, L, kana_RI, Lstroke, 
    0x003b,	0x002b,	0x04da,	0xfe59,	 // 47 semicolon, plus, kana_RE, dead_doubleacute, 
    0x003a,	0x002a,	0x04b9,	0xfe5a,	 // 48 colon, asterisk, kana_KE, dead_caron, 
    0xff28,	0xff28,	0x0,	0x0,	 // 49 Zenkaku, Zenkaku, 
    0xffe1,	0x0,	0x0,	0x0,	 // 50 Shift_L, 
    0x005d,	0x007d,	0x04d1,	0x04a3,	 // 51 bracketright, braceright, kana_MU, kana_closingbracket, 
    0x007a,	0x005a,	0x04c2,	0x04af,	 // 52 z, Z, kana_TSU, kana_tsu, 
    0x0078,	0x0058,	0x04bb,	0x003e,	 // 53 x, X, kana_SA, greater, 
    0x0063,	0x0043,	0x04bf,	0x00a9,	 // 54 c, C, kana_SO, copyright, 
    0x0076,	0x0056,	0x04cb,	0x0060,	 // 55 v, V, kana_HI, grave, 
    0x0062,	0x0042,	0x04ba,	0x0027,	 // 56 b, B, kana_KO, apostrophe, 
    0x006e,	0x004e,	0x04d0,	0x0,	 // 57 n, N, kana_MI, 
    0x006d,	0x004d,	0x04d3,	0x00ba,	 // 58 m, M, kana_MO, masculine, 
    0x002c,	0x003c,	0x04c8,	0x04a4,	 // 59 comma, less, kana_NE, kana_comma, 
    0x002e,	0x003e,	0x04d9,	0x04a1,	 // 60 period, greater, kana_RU, kana_fullstop, 
    0x002f,	0x003f,	0x04d2,	0x04a5,	 // 61 slash, question, kana_ME, kana_conjunctive, 
    0xffe2,	0x0,	0x0,	0x0,	 // 62 Shift_R, 
    0xffaa,	0x0,	0x0,	0x0,	 // 63 KP_Multiply, 
    0xffe9,	0xffe7,	0x0,	0x0,	 // 64 Alt_L, Meta_L, 
    0x0020,	0x0,	0x0,	0x0,	 // 65 space, 
    0xffff,	0xffe5,	0x0,	0x0,	 // 66 VoidSymbol, Caps_Lock, 
    0xffbe,	0x0,	0x0,	0x0,	 // 67 F1, 
    0xffbf,	0x0,	0x0,	0x0,	 // 68 F2, 
    0xffc0,	0x0,	0x0,	0x0,	 // 69 F3, 
    0xffc1,	0x0,	0x0,	0x0,	 // 70 F4, 
    0xffc2,	0x0,	0x0,	0x0,	 // 71 F5, 
    0xffc3,	0x0,	0x0,	0x0,	 // 72 F6, 
    0xffc4,	0x0,	0x0,	0x0,	 // 73 F7, 
    0xffc5,	0x0,	0x0,	0x0,	 // 74 F8, 
    0xffc6,	0x0,	0x0,	0x0,	 // 75 F9, 
    0xffc7,	0x0,	0x0,	0x0,	 // 76 F10, 
    0xff7e,	0x0,	0x0,	0x0,	 // 77 Mode_switch, 
    0xff14,	0x0,	0x0,	0x0,	 // 78 Scroll_Lock, 
    0xffb7,	0xffb7,	0x0,	0x0,	 // 79 KP_7, KP_7, 
    0xffb8,	0xffb8,	0x0,	0x0,	 // 80 KP_8, KP_8, 
    0xffb9,	0xffb9,	0x0,	0x0,	 // 81 KP_9, KP_9, 
    0xffad,	0x0,	0x0,	0x0,	 // 82 KP_Subtract, 
    0xffb4,	0xffb4,	0x0,	0x0,	 // 83 KP_4, KP_4, 
    0xffb5,	0xffb5,	0x0,	0x0,	 // 84 KP_5, KP_5, 
    0xffb6,	0xffb6,	0x0,	0x0,	 // 85 KP_6, KP_6, 
    0xffab,	0x0,	0x0,	0x0,	 // 86 KP_Add, 
    0xffb1,	0xffb1,	0x0,	0x0,	 // 87 KP_1, KP_1, 
    0xffb2,	0xffb2,	0x0,	0x0,	 // 88 KP_2, KP_2, 
    0xffb3,	0xffb3,	0x0,	0x0,	 // 89 KP_3, KP_3, 
    0xffb0,	0xffb0,	0x0,	0x0,	 // 90 KP_0, KP_0, 
    0xffae,	0xffae,	0x0,	0x0,	 // 91 KP_Decimal, KP_Decimal, 
    0x0,	0x0,	0x0,	0x0,	 // 92 
    0x0,	0x0,	0x0,	0x0,	 // 93 
    0x0,	0x0,	0x0,	0x0,	 // 94 
    0xffc8,	0x0,	0x0,	0x0,	 // 95 F11, 
    0xffc9,	0x0,	0x0,	0x0,	 // 96 F12, 
    0xff50,	0x0,	0x0,	0x0,	 // 97 Home, 
    0xff52,	0x0,	0x0,	0x0,	 // 98 Up, 
    0xff55,	0x0,	0x0,	0x0,	 // 99 Prior, 
    0xff51,	0x0,	0x0,	0x0,	 // 100 Left, 
    0x0,	0x0,	0x0,	0x0,	 // 101 
    0xff53,	0x0,	0x0,	0x0,	 // 102 Right, 
    0xff57,	0x0,	0x0,	0x0,	 // 103 End, 
    0xff54,	0x0,	0x0,	0x0,	 // 104 Down, 
    0xff56,	0x0,	0x0,	0x0,	 // 105 Next, 
    0xff63,	0x0,	0x0,	0x0,	 // 106 Insert, 
    0xffff,	0x0,	0x0,	0x0,	 // 107 Delete, 
    0xff8d,	0x0,	0x0,	0x0,	 // 108 KP_Enter, 
    0xffe4,	0x0,	0x0,	0x0,	 // 109 Control_R, 
    0xff13,	0xff6b,	0x0,	0x0,	 // 110 Pause, Break, 
    0x0,	0x0,	0x0,	0x0,	 // 111 
    0xffaf,	0x0,	0x0,	0x0,	 // 112 KP_Divide, 
    0xff2a,	0x0,	0x0,	0x0,	 // 113 Zenkaku_Hankaku, 
    0x0,	0x0,	0x0,	0x0,	 // 114 
    0x0,	0x0,	0x0,	0x0,	 // 115 
    0x0,	0x0,	0x0,	0x0,	 // 116 
    0x0,	0x0,	0x0,	0x0,	 // 117 
    0x0,	0x0,	0x0,	0x0,	 // 118 
    0x0,	0x0,	0x0,	0x0,	 // 119 
    0xff25,	0xff26,	0x0,	0x0,	 // 120 Hiragana, Katakana, 
    0x0,	0x0,	0x0,	0x0,	 // 121 
    0x0,	0x0,	0x0,	0x0,	 // 122 
    0x005c,	0x005f,	0x04db,	0x0,	 // 123 backslash, underscore, kana_RO, 
    0x0,	0x0,	0x0,	0x0,	 // 124 
    0x0,	0x0,	0x0,	0x0,	 // 125 
    0x0,	0x0,	0x0,	0x0,	 // 126 
    0x0,	0x0,	0x0,	0x0,	 // 127 
    0x0,	0x0,	0x0,	0x0,	 // 128 
    0xff23,	0x0,	0x0,	0x0,	 // 129 Henkan_Mode, 
    0x0,	0x0,	0x0,	0x0,	 // 130 
    0xff22,	0x0,	0x0,	0x0,	 // 131 Muhenkan, 
    0x0,	0x0,	0x0,	0x0,	 // 132 
    0x005c,	0x007c,	0x04b0,	0x0,	 // 133 backslash, bar, prolongedsound, 
    0x0,	0x0,	0x0,	0x0	 // 134 
    /*
    0x0, 0x0,  0x0,  0x0, 
    0xff1b, 0x0,  0x0,  0x0, 
    0x31, 0x21,  0x4c7,  0xa1, 
    0x32, 0x22,  0x4cc,  0xac3, 
    0x33, 0x23,  0x4b1,  0x4a7, 
    0x34, 0x24,  0x4b3,  0x4a9, 
    0x35, 0x25,  0x4b4,  0x4aa, 
    0x36, 0x26,  0x4b5,  0x4ab, 
    0x37, 0x27,  0x4d4,  0x4ac, 
    0x38, 0x28,  0x4d5,  0x4ad, 
    0x39, 0x29,  0x4d6,  0x4ae, 
    0x30, 0x7e,  0x4dc,  0x4a6, 
    0x2d, 0x3d,  0x4ce,  0xbf, 
    0x5e, 0x7e,  0x4cd,  0xfe5c, 
    0xff08, 0x0,  0x0,  0x0, 
    0xff09, 0xfe20,  0x0,  0x0, 
    0x71, 0x51,  0x4c0,  0x7d9, 
    0x77, 0x57,  0x4c3,  0x1a3, 
    0x65, 0x45,  0x4b2,  0x4a8, 
    0x72, 0x52,  0x4bd,  0xae, 
    0x74, 0x54,  0x4b6,  0x3ac, 
    0x79, 0x59,  0x4dd,  0xa5, 
    0x75, 0x55,  0x4c5,  0x8fc, 
    0x69, 0x49,  0x4c6,  0x2b9, 
    0x6f, 0x4f,  0x4d7,  0xd8, 
    0x70, 0x50,  0x4be,  0xde, 
    0x40, 0x60,  0x4de,  0xfe58, 
    0x5b, 0x7b,  0x4df,  0x4a2, 
    0xff0d, 0x0,  0x0,  0x0, 
    0xffe3, 0x0,  0x0,  0x0, 
    0x61, 0x41,  0x4c1,  0xc6, 
    0x73, 0x53,  0x4c4,  0xa7, 
    0x64, 0x44,  0x4bc,  0xd0, 
    0x66, 0x46,  0x4ca,  0xaa, 
    0x67, 0x47,  0x4b7,  0x3bd, 
    0x68, 0x48,  0x4b8,  0x2a1, 
    0x6a, 0x4a,  0x4cf,  0x0, 
    0x6b, 0x4b,  0x4c9,  0x26, 
    0x6c, 0x4c,  0x4d8,  0x1a3, 
    0x3b, 0x2b,  0x4da,  0xfe59, 
    0x3a, 0x2a,  0x4b9,  0xfe5a, 
    0xff28, 0xff28,  0x0,  0x0, 
    0xffe1, 0x0,  0x0,  0x0, 
    0x5d, 0x7d,  0x4d1,  0x4a3, 
    0x7a, 0x5a,  0x4c2,  0x4af, 
    0x78, 0x58,  0x4bb,  0x3e, 
    0x63, 0x43,  0x4bf,  0xa9, 
    0x76, 0x56,  0x4cb,  0x60, 
    0x62, 0x42,  0x4ba,  0x27, 
    0x6e, 0x4e,  0x4d0,  0x0, 
    0x6d, 0x4d,  0x4d3,  0xba, 
    0x2c, 0x3c,  0x4c8,  0x4a4, 
    0x2e, 0x3e,  0x4d9,  0x4a1, 
    0x2f, 0x3f,  0x4d2,  0x4a5, 
    0xffe2, 0x0,  0x0,  0x0, 
    0xffaa, 0x0,  0x0,  0x0, 
    0xffe9, 0xffe7,  0x0,  0x0, 
    0x20, 0x0,  0x0,  0x0, 
    0xffffff, 0xffe5,  0x0,  0x0, 
    0xffbe, 0x0,  0x0,  0x0, 
    0xffbf, 0x0,  0x0,  0x0, 
    0xffc0, 0x0,  0x0,  0x0, 
    0xffc1, 0x0,  0x0,  0x0, 
    0xffc2, 0x0,  0x0,  0x0, 
    0xffc3, 0x0,  0x0,  0x0, 
    0xffc4, 0x0,  0x0,  0x0, 
    0xffc5, 0x0,  0x0,  0x0, 
    0xffc6, 0x0,  0x0,  0x0, 
    0xffc7, 0x0,  0x0,  0x0, 
    0xff7e, 0x0,  0x0,  0x0, 
    0xff14, 0x0,  0x0,  0x0, 
    0xffb7, 0xffb7,  0x0,  0x0, 
    0xffb8, 0xffb8,  0x0,  0x0, 
    0xffb9, 0xffb9,  0x0,  0x0, 
    0xffad, 0x0,  0x0,  0x0, 
    0xffb4, 0xffb4,  0x0,  0x0, 
    0xffb5, 0xffb5,  0x0,  0x0, 
    0xffb6, 0xffb6,  0x0,  0x0, 
    0xffab, 0x0,  0x0,  0x0, 
    0xffb1, 0xffb1,  0x0,  0x0, 
    0xffb2, 0xffb2,  0x0,  0x0, 
    0xffb3, 0xffb3,  0x0,  0x0, 
    0xffb0, 0xffb0,  0x0,  0x0, 
    0xffae, 0xffae,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xffc8, 0x0,  0x0,  0x0, 
    0xffc9, 0x0,  0x0,  0x0, 
    0xff50, 0x0,  0x0,  0x0, 
    0xff52, 0x0,  0x0,  0x0, 
    0xff55, 0x0,  0x0,  0x0, 
    0xff51, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xff53, 0x0,  0x0,  0x0, 
    0xff57, 0x0,  0x0,  0x0, 
    0xff54, 0x0,  0x0,  0x0, 
    0xff56, 0x0,  0x0,  0x0, 
    0xff63, 0x0,  0x0,  0x0, 
    0xffff, 0x0,  0x0,  0x0, 
    0xff8d, 0x0,  0x0,  0x0, 
    0xffe4, 0x0,  0x0,  0x0, 
    0xff13, 0xff6b,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xffaf, 0x0,  0x0,  0x0, 
    0xff2a, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xff25, 0xff26,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x5c, 0x5f,  0x4db,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xff23, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0xff22, 0x0,  0x0,  0x0, 
    0x0, 0x0,  0x0,  0x0, 
    0x5c, 0x7c,  0x4b0,  0x0, 
    0x0, 0x0,  0x0,  0x0
    */
  };

  Keymap_jp106(){
    start=8;
    width=4;
    count=127;
    map=_map;
  }

  final public int getCode(KeyEvent e){
    //if(e.isShiftDown()) state|=1;
    //if(e.isControlDown()) state|=4;
    //if(e.isAltDown()) state|=8;
    int key=e.getKeyCode();
    if(key!=0){
      switch(key){
      case KeyEvent.VK_A:
      case KeyEvent.VK_B:
      case KeyEvent.VK_C:
      case KeyEvent.VK_D:
      case KeyEvent.VK_E:
      case KeyEvent.VK_F:
      case KeyEvent.VK_G:
      case KeyEvent.VK_H:
      case KeyEvent.VK_I:
      case KeyEvent.VK_J:
      case KeyEvent.VK_K:
      case KeyEvent.VK_L:
      case KeyEvent.VK_M:
      case KeyEvent.VK_N:
      case KeyEvent.VK_O:
      case KeyEvent.VK_P:
      case KeyEvent.VK_Q:
      case KeyEvent.VK_R:
      case KeyEvent.VK_S:
      case KeyEvent.VK_T:
      case KeyEvent.VK_U:
      case KeyEvent.VK_V:
      case KeyEvent.VK_W:
      case KeyEvent.VK_X:
      case KeyEvent.VK_Y:
      case KeyEvent.VK_Z:
	key=key+0x20;
	break;
      case KeyEvent.VK_0:
      case KeyEvent.VK_1:
      case KeyEvent.VK_2:
      case KeyEvent.VK_3:
      case KeyEvent.VK_4:
      case KeyEvent.VK_5:
      case KeyEvent.VK_6:
      case KeyEvent.VK_7:
      case KeyEvent.VK_8:
      case KeyEvent.VK_9:
       break;
      case KeyEvent.VK_ENTER:
	key=0xff0d; break;
      case KeyEvent.VK_BACK_SPACE:
	key=0xff08; break;
      case KeyEvent.VK_TAB:
	key=0xff09; break;
//      case KeyEvent.VK_CANCEL:
//	key=0xff69;
//	break;
//      case KeyEvent.VK_CLEAR:
//	key=0xff0b;
//	break;
      case KeyEvent.VK_COMMA:
      case KeyEvent.VK_PERIOD:
      case KeyEvent.VK_SLASH:
      case KeyEvent.VK_OPEN_BRACKET:
      case KeyEvent.VK_CLOSE_BRACKET:
      case KeyEvent.VK_SPACE:
	break;
      case KeyEvent.VK_SEMICOLON:
        if(e.getKeyChar()==':'){ key=0x3a; } else
        if(e.getKeyChar()=='*'){ key=0x2a; }
	break;
      case KeyEvent.VK_EQUALS:
        if(e.getKeyChar()==';'){ key=0x3b; } else
        if(e.getKeyChar()=='+'){ key=0x2b; }
	break;
      case KeyEvent.VK_BACK_SLASH:
        if(e.getKeyChar()=='|') key=0x7c;
	break;
      case KeyEvent.VK_BACK_QUOTE:
	key=0x60; break;
      case KeyEvent.VK_QUOTE:
        if(e.getKeyChar()=='^'){ key=0x5e; }else
        if(e.getKeyChar()=='~'){ key=0x7e; }else
	key=0x27; break;
      case KeyEvent.VK_SHIFT:
	key=0xffe1; break;
      case KeyEvent.VK_CONTROL:
	key=0xffe3; break;
      case KeyEvent.VK_ALT:
	key=0xffe9; break;
      case KeyEvent.VK_PAUSE:
	key=0xff13; break;
      case KeyEvent.VK_CAPS_LOCK:
	key=0xffe5; break;
      case KeyEvent.VK_ESCAPE:
	key=0xff1b; break;
      case KeyEvent.VK_PAGE_UP:
	key=0xff55; break;
      case KeyEvent.VK_PAGE_DOWN:
	key=0xff56; break;
      case KeyEvent.VK_END:
	key=0xff57; break;
      case KeyEvent.VK_HOME:
	key=0xff50; break;
      case KeyEvent.VK_LEFT:
	key=0xff51; break;
      case KeyEvent.VK_UP:
	key=0xff52; break;
      case KeyEvent.VK_RIGHT:
	key=0xff53; break;
      case KeyEvent.VK_DOWN:
	key=0xff54; break;
      case KeyEvent.VK_NUMPAD0:
	key=0xffb0; break;
      case KeyEvent.VK_NUMPAD1:
	key=0xffb1; break;
      case KeyEvent.VK_NUMPAD2:
	key=0xffb2; break;
      case KeyEvent.VK_NUMPAD3:
	key=0xffb3; break;
      case KeyEvent.VK_NUMPAD4:
	key=0xffb4; break;
      case KeyEvent.VK_NUMPAD5:
	key=0xffb5; break;
      case KeyEvent.VK_NUMPAD6:
	key=0xffb6; break;
      case KeyEvent.VK_NUMPAD7:
	key=0xffb7; break;
      case KeyEvent.VK_NUMPAD8:
	key=0xffb8; break;
      case KeyEvent.VK_NUMPAD9:
	key=0xffb9; break;
      case KeyEvent.VK_MULTIPLY:
	key=0xffaa; break;
      case KeyEvent.VK_ADD:
	key=0xffab; break;
      case KeyEvent.VK_SEPARATER:
	key=0xffac; break;
      case KeyEvent.VK_SUBTRACT:
	key=0xffad; break;
      case KeyEvent.VK_DECIMAL:
	key=0xffae; break;
      case KeyEvent.VK_DIVIDE:
	key=0xffaf; break;
      case KeyEvent.VK_F1:
	key=0xffbe; break;
      case KeyEvent.VK_F2:
	key=0xffbf; break;
      case KeyEvent.VK_F3:
	key=0xffc0; break;
      case KeyEvent.VK_F4:
	key=0xffc1; break;
      case KeyEvent.VK_F5:
	key=0xffc2; break;
      case KeyEvent.VK_F6:
	key=0xffc3; break;
      case KeyEvent.VK_F7:
	key=0xffc4; break;
      case KeyEvent.VK_F8:
	key=0xffc5; break;
      case KeyEvent.VK_F9:
	key=0xffc6; break;
      case KeyEvent.VK_F10:
	key=0xffc7; break;
      case KeyEvent.VK_F11:
	key=0xffc8; break;
      case KeyEvent.VK_F12:
	key=0xffc9; break;
      case KeyEvent.VK_DELETE:
	key=0xffff; break;
      case KeyEvent.VK_NUM_LOCK:
	key=0xff7f; break;
      case KeyEvent.VK_SCROLL_LOCK:
	key=0xff14; break;
      case KeyEvent.VK_PRINTSCREEN:
	key=0xff61; break;
      case KeyEvent.VK_INSERT:
	key=0xff63; break;
      case KeyEvent.VK_HELP:
	key=0xff6a; break;
      case KeyEvent.VK_META:
	key=0xffe7; break;
//      case KeyEvent.VK_KP_UP:
//	key=0xff97; break;
//      case KeyEvent.VK_KP_DOWN:
//	key=0xff99; break;
//      case KeyEvent.VK_KP_LEFT:
//	key=0xff96; break;
//      case KeyEvent.VK_KP_RIGHT:
//	key=0xff98; break;

/*    
      // For European keyboards 
      case KeyEvent.VK_DEAD_GRAVE:
      case KeyEvent.VK_DEAD_ACUTE:
      case KeyEvent.VK_DEAD_CIRCUMFLEX:
      case KeyEvent.VK_DEAD_TILDE:
      case KeyEvent.VK_DEAD_MACRON:
      case KeyEvent.VK_DEAD_BREVE:
      case KeyEvent.VK_DEAD_ABOVEDOT:
      case KeyEvent.VK_DEAD_DIAERESIS:
      case KeyEvent.VK_DEAD_ABOVERING:
      case KeyEvent.VK_DEAD_DOUBLEACUTE:
      case KeyEvent.VK_DEAD_CARON:
      case KeyEvent.VK_DEAD_CEDILLA:
      case KeyEvent.VK_DEAD_OGONEK:
      case KeyEvent.VK_DEAD_IOTA:
      case KeyEvent.VK_DEAD_VOICED_SOUND:
      case KeyEvent.VK_DEAD_SEMIVOICED_SOUND:

      case KeyEvent.VK_AMPERSAND:
      case KeyEvent.VK_ASTERISK:
      case KeyEvent.VK_QUOTEDBL:
      case KeyEvent.VK_LESS:

      case KeyEvent.VK_GREATER:
      case KeyEvent.VK_BRACELEFT:
      case KeyEvent.VK_BRACERIGHT:

      // for Asian Keyboards
      case KeyEvent.VK_FINAL:
      case KeyEvent.VK_CONVERT:
      case KeyEvent.VK_NONCONVERT:
      case KeyEvent.VK_ACCEPT:
      case KeyEvent.VK_MODECHANGE:
      case KeyEvent.VK_KANA:
      case KeyEvent.VK_KANJI:

      // for Sun keyboards
      case KeyEvent.VK_CUT:
      case KeyEvent.VK_COPY:
      case KeyEvent.VK_PASTE:
      case KeyEvent.VK_UNDO:
      case KeyEvent.VK_AGAIN:
      case KeyEvent.VK_FIND:
      case KeyEvent.VK_PROPS:
      case KeyEvent.VK_STOP:
*/
      default:
	key=e.getKeyChar();
      }
    }
    else{
      key=e.getKeyChar();
    }

    int s=10;
    if(km!=null){
      int i=0;
      int j=0;
      s=km.start;
      while(i<km.count*km.width){
	if(km.map[i]==key)break;
	i++;
	j++;
	if(j==km.width){
	  j=0;
	  s++;
	}
      }
    }
//System.out.println(e+" key="+key+", s="+s);
    return s;
  }
}
