/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public abstract class PatchGenerator
extends GeometryGenerator {
    protected float[][] controlPointCoordinates;
    protected float[][] controlPointWeights;
    protected int numWidthControlPoints = 0;
    protected int numDepthControlPoints = 0;
    protected float[][] patchCoordinates;
    protected float[][] patchNormals;
    protected float[][] patchTexcoords;
    protected int numPatchValues;
    protected int numNormalValues;
    protected int numTexcoordValues;
    protected boolean patchChanged = true;
    protected boolean normalsChanged = true;
    protected boolean texCoordsChanged = true;
    protected int widthFacetCount;
    protected int depthFacetCount;
    protected boolean useControlPointWeights = false;

    protected PatchGenerator() {
    }

    protected abstract void regeneratePatch();

    public void setFacetCount(int n, int n2) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of width facets is < 3");
        }
        if (n2 < 3) {
            throw new IllegalArgumentException("Number of depth facets is < 3");
        }
        if (this.widthFacetCount != n) {
            this.patchChanged = true;
            this.normalsChanged = true;
            this.texCoordsChanged = true;
        }
        if (this.depthFacetCount != n2) {
            this.patchChanged = true;
            this.normalsChanged = true;
            this.texCoordsChanged = true;
        }
        this.widthFacetCount = n;
        this.depthFacetCount = n2;
    }

    public void enableControlPointWeights(boolean bl) {
        this.useControlPointWeights = bl;
    }

    public boolean hasControlPointWeights() {
        return this.useControlPointWeights;
    }

    public void setPatchWeights(float[][] fArray) {
        int n;
        int n2 = fArray[0].length;
        if (n2 < 3) {
            throw new IllegalArgumentException("Weight size < 3");
        }
        for (n = 1; n < fArray.length; ++n) {
            if (fArray[n].length == n2) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        if (this.controlPointWeights == null || this.controlPointWeights.length < fArray.length) {
            this.controlPointWeights = new float[fArray.length][n2];
        }
        for (n = 0; n < fArray.length; ++n) {
            System.arraycopy(fArray[n], 0, this.controlPointWeights[n], 0, n2);
        }
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchWeights(double[][] dArray) {
        int n;
        int n2 = dArray[0].length;
        if (n2 < 3) {
            throw new IllegalArgumentException("Weight size < 3");
        }
        for (n = 1; n < dArray.length; ++n) {
            if (dArray[n].length == n2) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        if (this.controlPointWeights == null || this.controlPointWeights.length < dArray.length) {
            this.controlPointWeights = new float[dArray.length][n2];
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.controlPointWeights[n][i] = (float)dArray[n][i];
            }
        }
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchWeights(float[] fArray, int n, int n2) {
        if (fArray.length < 3) {
            throw new IllegalArgumentException("Depth weight patch size < 3");
        }
        if (fArray.length < n * n2) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(fArray, n3, this.controlPointWeights[i], 0, n2);
            n3 += n2;
        }
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchWeights(double[] dArray, int n, int n2) {
        if (dArray.length < 3) {
            throw new IllegalArgumentException("Depth weight patch size < 3");
        }
        if (dArray.length < n * n2) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.controlPointWeights[i][j] = (float)dArray[n3++];
            }
        }
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(float[][] fArray) {
        boolean bl;
        int n;
        int n2 = fArray[0].length;
        if (fArray.length < 3 || n2 < 3) {
            throw new IllegalArgumentException("Control point size < 3");
        }
        for (n = 1; n < fArray.length; ++n) {
            if (fArray[n].length == n2) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        int n3 = fArray[0].length / 3;
        boolean bl2 = bl = this.controlPointCoordinates == null || fArray.length != this.numWidthControlPoints || fArray[0].length != this.numDepthControlPoints;
        if (this.controlPointCoordinates == null || fArray.length != this.controlPointCoordinates.length && n2 != this.controlPointCoordinates[0].length) {
            if (this.controlPointCoordinates == null || fArray.length != this.controlPointCoordinates.length) {
                this.controlPointCoordinates = new float[fArray.length][n2];
            } else {
                for (n = 0; n < this.controlPointCoordinates.length; ++n) {
                    this.controlPointCoordinates[n] = new float[n2];
                }
            }
        }
        if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length && n3 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[fArray.length][n3];
            } else {
                for (n = 0; n < this.controlPointWeights.length; ++n) {
                    this.controlPointWeights[n] = new float[n3];
                }
            }
        }
        for (n = 0; n < fArray.length; ++n) {
            System.arraycopy(fArray[n], 0, this.controlPointCoordinates[n], 0, n2);
        }
        if (bl) {
            n = this.controlPointWeights.length;
            while (--n >= 0) {
                int n4 = this.controlPointWeights[0].length;
                while (--n4 >= 0) {
                    this.controlPointWeights[n][n4] = 1.0f;
                }
            }
        }
        this.numWidthControlPoints = fArray.length;
        this.numDepthControlPoints = n2 / 3;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(double[][] dArray) {
        int n;
        boolean bl;
        int n2;
        int n3 = dArray[0].length;
        if (dArray.length < 3 || n3 < 3) {
            throw new IllegalArgumentException("Control point size < 3");
        }
        for (n2 = 1; n2 < dArray.length; ++n2) {
            if (dArray[n2].length == n3) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        int n4 = dArray[0].length / 3;
        boolean bl2 = bl = this.controlPointCoordinates == null || dArray.length != this.numWidthControlPoints || dArray[0].length != this.numDepthControlPoints;
        if (this.controlPointCoordinates == null || dArray.length != this.controlPointCoordinates.length && n3 != this.controlPointCoordinates[0].length) {
            if (this.controlPointCoordinates == null || dArray.length != this.controlPointCoordinates.length) {
                this.controlPointCoordinates = new float[dArray.length][n3];
            } else {
                for (n2 = 0; n2 < this.controlPointCoordinates.length; ++n2) {
                    this.controlPointCoordinates[n2] = new float[n3];
                }
            }
        }
        if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length && n4 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[dArray.length][n4];
            } else {
                for (n2 = 0; n2 < this.controlPointWeights.length; ++n2) {
                    this.controlPointWeights[n2] = new float[n4];
                }
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.controlPointCoordinates[n2][n] = (float)dArray[n2][n];
            }
        }
        if (bl) {
            n2 = this.controlPointWeights.length;
            while (--n2 >= 0) {
                n = this.controlPointWeights[0].length;
                while (--n >= 0) {
                    this.controlPointWeights[n2][n] = 1.0f;
                }
            }
        }
        this.numWidthControlPoints = dArray.length;
        this.numDepthControlPoints = n3 / 3;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(float[][] fArray, float[][] fArray2) {
        int n;
        int n2 = fArray[0].length;
        if (fArray.length < 3 || n2 < 3) {
            throw new IllegalArgumentException("Control point size < 3");
        }
        for (n = 1; n < fArray.length; ++n) {
            if (fArray[n].length == n2) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        int n3 = fArray[0].length / 3;
        if (this.controlPointCoordinates == null || fArray.length != this.controlPointCoordinates.length && n2 != this.controlPointCoordinates[0].length) {
            if (this.controlPointCoordinates == null || fArray.length != this.controlPointCoordinates.length) {
                this.controlPointCoordinates = new float[fArray.length][n2];
            } else {
                for (n = 0; n < this.controlPointCoordinates.length; ++n) {
                    this.controlPointCoordinates[n] = new float[n2];
                }
            }
        }
        if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length && n3 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[fArray.length][n3];
            } else {
                for (n = 0; n < this.controlPointWeights.length; ++n) {
                    this.controlPointWeights[n] = new float[n3];
                }
            }
        }
        for (n = 0; n < fArray.length; ++n) {
            System.arraycopy(fArray[n], 0, this.controlPointCoordinates[n], 0, n2);
        }
        for (n = 0; n < fArray2.length; ++n) {
            System.arraycopy(fArray2[n], 0, this.controlPointWeights[n], 0, n2);
        }
        this.numWidthControlPoints = fArray.length;
        this.numDepthControlPoints = n2 / 3;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3 = dArray[0].length;
        if (dArray.length < 3 || n3 < 3) {
            throw new IllegalArgumentException("Control point size < 3");
        }
        for (n2 = 1; n2 < dArray.length; ++n2) {
            if (dArray[n2].length == n3) continue;
            throw new IllegalArgumentException("Non-equal array lengths");
        }
        int n4 = dArray[0].length / 3;
        if (this.controlPointCoordinates == null || dArray.length != this.controlPointCoordinates.length && n3 != this.controlPointCoordinates[0].length) {
            if (this.controlPointCoordinates == null || dArray.length != this.controlPointCoordinates.length) {
                this.controlPointCoordinates = new float[dArray.length][n3];
            } else {
                for (n2 = 0; n2 < this.controlPointCoordinates.length; ++n2) {
                    this.controlPointCoordinates[n2] = new float[n3];
                }
            }
        }
        if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length && n4 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[dArray.length][n4];
            } else {
                for (n2 = 0; n2 < this.controlPointWeights.length; ++n2) {
                    this.controlPointWeights[n2] = new float[n4];
                }
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.controlPointCoordinates[n2][n] = (float)dArray[n2][n];
            }
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.controlPointWeights[n2][n] = (float)dArray2[n2][n];
            }
        }
        this.numWidthControlPoints = dArray.length;
        this.numDepthControlPoints = n3 / 3;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(float[] fArray, int n, int n2) {
        int n3;
        boolean bl;
        if (fArray.length < 3) {
            throw new IllegalArgumentException("Depth patch size < 3");
        }
        if (fArray.length < n * n2 * 3) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        boolean bl2 = bl = this.controlPointCoordinates == null || n != this.numWidthControlPoints || n2 != this.numDepthControlPoints;
        if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n || this.controlPointCoordinates[0].length < n2 * 3) {
            if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n2) {
                this.controlPointCoordinates = new float[n][n2 * 3];
            } else {
                for (n3 = 0; n3 < this.controlPointCoordinates.length; ++n3) {
                    this.controlPointCoordinates[n3] = new float[n2 * 3];
                }
            }
        }
        if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length && n2 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[fArray.length][n2];
            } else {
                for (n3 = 0; n3 < this.controlPointWeights.length; ++n3) {
                    this.controlPointWeights[n3] = new float[n2];
                }
            }
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            System.arraycopy(fArray, n4, this.controlPointCoordinates[n3], 0, n2 * 3);
            n4 += n2 * 3;
        }
        if (bl) {
            n3 = this.controlPointWeights.length;
            while (--n3 >= 0) {
                int n5 = this.controlPointWeights[0].length;
                while (--n5 >= 0) {
                    this.controlPointWeights[n3][n5] = 1.0f;
                }
            }
        }
        this.numWidthControlPoints = n;
        this.numDepthControlPoints = n2;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        if (dArray.length < 3) {
            throw new IllegalArgumentException("Depth patch size < 3");
        }
        if (dArray.length < n * n2 * 3) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        boolean bl2 = bl = this.controlPointCoordinates == null || n != this.numWidthControlPoints || n2 != this.numDepthControlPoints;
        if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n || this.controlPointCoordinates[0].length < n2 * 3) {
            if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n2) {
                this.controlPointCoordinates = new float[n][n2 * 3];
            } else {
                for (n4 = 0; n4 < this.controlPointCoordinates.length; ++n4) {
                    this.controlPointCoordinates[n4] = new float[n2 * 3];
                }
            }
        }
        if (this.controlPointWeights == null || dArray.length > this.controlPointWeights.length && n2 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[dArray.length][n2];
            } else {
                for (n4 = 0; n4 < this.controlPointWeights.length; ++n4) {
                    this.controlPointWeights[n4] = new float[n2];
                }
            }
        }
        int n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = 0;
            while (n3 < n2 * 3) {
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
            }
        }
        if (bl) {
            n4 = this.controlPointWeights.length;
            while (--n4 >= 0) {
                n3 = this.controlPointWeights[0].length;
                while (--n3 >= 0) {
                    this.controlPointWeights[n4][n3] = 1.0f;
                }
            }
        }
        this.numWidthControlPoints = n;
        this.numDepthControlPoints = n2;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(float[] fArray, int n, int n2, float[] fArray2) {
        int n3;
        if (fArray.length < 3) {
            throw new IllegalArgumentException("Depth patch size < 3");
        }
        if (fArray.length < n * n2 * 3) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n || this.controlPointCoordinates[0].length < n2 * 3) {
            if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n2) {
                this.controlPointCoordinates = new float[n][n2 * 3];
            } else {
                for (n3 = 0; n3 < this.controlPointCoordinates.length; ++n3) {
                    this.controlPointCoordinates[n3] = new float[n2 * 3];
                }
            }
        }
        if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length && n2 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || fArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[fArray.length][n2];
            } else {
                for (n3 = 0; n3 < this.controlPointWeights.length; ++n3) {
                    this.controlPointWeights[n3] = new float[n2];
                }
            }
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            System.arraycopy(fArray, n4, this.controlPointCoordinates[n3], 0, n2 * 3);
            n4 += n2 * 3;
        }
        n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            System.arraycopy(fArray2, n4, this.controlPointWeights[n3], 0, n2);
            n4 += n2;
        }
        this.numWidthControlPoints = n;
        this.numDepthControlPoints = n2;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public void setPatchControlPoints(double[] dArray, int n, int n2, double[] dArray2) {
        int n3;
        int n4;
        if (dArray.length < 3) {
            throw new IllegalArgumentException("Depth patch size < 3");
        }
        if (dArray.length < n * n2 * 3) {
            throw new IllegalArgumentException("Array not big enough ");
        }
        if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n || this.controlPointCoordinates[0].length < n2 * 3) {
            if (this.controlPointCoordinates == null || this.controlPointCoordinates.length < n2) {
                this.controlPointCoordinates = new float[n][n2 * 3];
            } else {
                for (n4 = 0; n4 < this.controlPointCoordinates.length; ++n4) {
                    this.controlPointCoordinates[n4] = new float[n2 * 3];
                }
            }
        }
        if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length && n2 != this.controlPointWeights[0].length) {
            if (this.controlPointWeights == null || dArray.length != this.controlPointWeights.length) {
                this.controlPointWeights = new float[dArray.length][n2];
            } else {
                for (n4 = 0; n4 < this.controlPointWeights.length; ++n4) {
                    this.controlPointWeights[n4] = new float[n2];
                }
            }
        }
        int n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = 0;
            while (n3 < n2 * 3) {
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
                this.controlPointCoordinates[n4][n3++] = (float)dArray[n5++];
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = 0;
            while (n3 < n2) {
                this.controlPointWeights[n4][n3++] = (float)dArray2[n5++];
            }
        }
        this.numWidthControlPoints = n;
        this.numDepthControlPoints = n2;
        this.patchChanged = true;
        this.normalsChanged = true;
        this.texCoordsChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.widthFacetCount * this.depthFacetCount * 6;
                break;
            }
            case 2: {
                n = this.widthFacetCount * this.depthFacetCount * 4;
                break;
            }
            case 3: {
                n = (this.widthFacetCount + 1) * this.depthFacetCount * 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n = (this.widthFacetCount + 1) * (this.depthFacetCount + 1);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateUnindexedTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedQuadTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateUnindexedQuadTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateIndexedTexture3D(geometryData);
        }
        int n = this.widthFacetCount * this.widthFacetCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.widthFacetCount * this.depthFacetCount;
        while (--n4 >= 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + this.widthFacetCount + 1;
            nArray[n2++] = n3 + this.widthFacetCount + 2;
            nArray[n2++] = n3 + 1;
            ++n3;
            if (n4 % this.widthFacetCount != 0) continue;
            ++n3;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateIndexedTexture3D(geometryData);
        }
        int n = this.widthFacetCount * this.widthFacetCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.widthFacetCount * this.depthFacetCount;
        while (--n4 >= 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + this.widthFacetCount + 2;
            nArray[n2++] = n3 + 1;
            nArray[n2++] = n3 + this.widthFacetCount + 1;
            nArray[n2++] = n3 + this.widthFacetCount + 2;
            nArray[n2++] = n3++;
            if (n4 % this.widthFacetCount != 0) continue;
            ++n3;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriStripTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateUnindexedTriTexture3D(geometryData);
        }
        int n = this.widthFacetCount;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = n;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = (this.widthFacetCount + 1) * 2;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateIndexedTexture3D(geometryData);
        }
        int n2 = (this.widthFacetCount + 1) * this.widthFacetCount * 2;
        int n3 = this.widthFacetCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n2];
        } else if (geometryData.indexes.length < n2) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n2);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n3];
        } else if (geometryData.stripCounts.length < n3) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n3);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n2;
        geometryData.numStrips = n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n = (this.widthFacetCount + 1) * this.depthFacetCount;
        while (--n6 >= 0) {
            nArray[n4++] = n5;
            nArray[n4++] = n5 + (this.widthFacetCount + 1);
            ++n5;
        }
        n6 = n3;
        while (--n6 >= 0) {
            nArray2[n6] = (this.widthFacetCount + 1) * 2;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateIndexedTexture3D(geometryData);
        }
        int n = this.widthFacetCount * this.widthFacetCount * 4;
        int n2 = this.widthFacetCount * this.widthFacetCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n2];
        } else if (geometryData.stripCounts.length < n2) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n2);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n;
        geometryData.numStrips = n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthFacetCount * this.depthFacetCount;
        while (--n5 >= 0) {
            nArray[n3++] = n4 + this.widthFacetCount + 1;
            nArray[n3++] = n4 + this.widthFacetCount + 2;
            nArray[n3++] = n4 + 1;
            nArray[n3++] = n4++;
            nArray2[n5] = 4;
            if (n5 % this.widthFacetCount != 0) continue;
            ++n4;
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regeneratePatch();
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchCoordinates[i][n3 + 3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 4];
                fArray[n2++] = this.patchCoordinates[i][n3 + 5];
                fArray[n2++] = this.patchCoordinates[i][n3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 4];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 5];
                fArray[n2++] = this.patchCoordinates[i][n3 + 3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 4];
                fArray[n2++] = this.patchCoordinates[i][n3 + 5];
                n3 += 3;
            }
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regeneratePatch();
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchCoordinates[i][n3 + 3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 4];
                fArray[n2++] = this.patchCoordinates[i][n3 + 5];
                fArray[n2++] = this.patchCoordinates[i][n3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 4];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 5];
                n3 += 3;
            }
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        this.regeneratePatch();
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            n3 = 0;
            for (int j = 0; j < this.widthFacetCount + 1; ++j) {
                fArray[n2++] = this.patchCoordinates[i][n3];
                fArray[n2++] = this.patchCoordinates[i][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i][n3 + 2];
                fArray[n2++] = this.patchCoordinates[i + 1][n3];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 1];
                fArray[n2++] = this.patchCoordinates[i + 1][n3 + 2];
                n3 += 3;
            }
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regeneratePatch();
        int n2 = 0;
        for (int i = 0; i <= this.widthFacetCount; ++i) {
            System.arraycopy(this.patchCoordinates[i], 0, fArray, n2, this.numPatchValues);
            n2 += this.numPatchValues;
        }
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchNormals[i][n3 + 3];
                fArray[n2++] = this.patchNormals[i][n3 + 4];
                fArray[n2++] = this.patchNormals[i][n3 + 5];
                fArray[n2++] = this.patchNormals[i][n3];
                fArray[n2++] = this.patchNormals[i][n3 + 1];
                fArray[n2++] = this.patchNormals[i][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 1];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 1];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 4];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 5];
                fArray[n2++] = this.patchNormals[i][n3 + 3];
                fArray[n2++] = this.patchNormals[i][n3 + 4];
                fArray[n2++] = this.patchNormals[i][n3 + 5];
                n3 += 3;
            }
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchNormals[i][n3 + 3];
                fArray[n2++] = this.patchNormals[i][n3 + 4];
                fArray[n2++] = this.patchNormals[i][n3 + 5];
                fArray[n2++] = this.patchNormals[i][n3];
                fArray[n2++] = this.patchNormals[i][n3 + 1];
                fArray[n2++] = this.patchNormals[i][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 1];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 4];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 5];
                n3 += 3;
            }
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.widthFacetCount * (this.widthFacetCount + 1) * 6;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            n3 = 0;
            for (int j = 0; j < this.widthFacetCount + 1; ++j) {
                fArray[n2++] = this.patchNormals[i][n3];
                fArray[n2++] = this.patchNormals[i][n3 + 1];
                fArray[n2++] = this.patchNormals[i][n3 + 2];
                fArray[n2++] = this.patchNormals[i + 1][n3];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 1];
                fArray[n2++] = this.patchNormals[i + 1][n3 + 2];
                n3 += 3;
            }
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        for (int i = 0; i <= this.widthFacetCount; ++i) {
            System.arraycopy(this.patchNormals[i], 0, fArray, n2, this.numNormalValues);
            n2 += this.numNormalValues;
        }
    }

    private void generateUnindexedTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        float[] fArray = geometryData.textureCoordinates;
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchTexcoords[i][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i][n3 + 3];
                fArray[n2++] = this.patchTexcoords[i][n3];
                fArray[n2++] = this.patchTexcoords[i][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 3];
                fArray[n2++] = this.patchTexcoords[i][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i][n3 + 3];
                n3 += 2;
            }
        }
    }

    private void generateUnindexedQuadTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        float[] fArray = geometryData.textureCoordinates;
        int n2 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.widthFacetCount; ++j) {
                fArray[n2++] = this.patchTexcoords[i][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i][n3 + 3];
                fArray[n2++] = this.patchTexcoords[i][n3];
                fArray[n2++] = this.patchTexcoords[i][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 3];
                n3 += 2;
            }
        }
    }

    private void generateUnindexedTriStripTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.widthFacetCount * (this.widthFacetCount + 1) * 4;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        float[] fArray = geometryData.textureCoordinates;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            n3 = 0;
            for (int j = 0; j < this.widthFacetCount + 1; ++j) {
                fArray[n2++] = this.patchTexcoords[i][n3];
                fArray[n2++] = this.patchTexcoords[i][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 1];
                n3 += 2;
            }
        }
    }

    private void generateIndexedTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("Texcoords", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        float[] fArray = geometryData.textureCoordinates;
        int n2 = 0;
        for (int i = 0; i <= this.widthFacetCount; ++i) {
            System.arraycopy(this.patchTexcoords[i], 0, fArray, n2, this.numTexcoordValues);
            n2 += this.numTexcoordValues;
        }
    }

    private void generateUnindexedTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateUnindexedQuadTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateIndexedTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateUnindexedTriStripTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.widthFacetCount * (this.widthFacetCount + 1) * 6;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        float[] fArray = geometryData.textureCoordinates;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.depthFacetCount; ++i) {
            n3 = 0;
            for (int j = 0; j < this.widthFacetCount + 1; ++j) {
                fArray[n2++] = this.patchTexcoords[i][n3];
                fArray[n2++] = this.patchTexcoords[i][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i][n3 + 2];
                fArray[n2++] = this.patchTexcoords[i + 1][n3];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 1];
                fArray[n2++] = this.patchTexcoords[i + 1][n3 + 2];
                n3 += 3;
            }
        }
    }

    protected void regenerateNormals() {
        int n;
        if (!this.normalsChanged) {
            return;
        }
        this.normalsChanged = false;
        this.numNormalValues = this.numPatchValues;
        if (this.patchNormals == null || this.patchNormals.length <= this.widthFacetCount || this.patchNormals[0].length < this.numNormalValues) {
            this.patchNormals = new float[this.widthFacetCount + 1][this.numNormalValues];
        }
        int n2 = 0;
        Vector3f vector3f = this.createFaceNormal(this.patchCoordinates, 1, 0, 0, 0, 0, 3);
        this.patchNormals[0][n2++] = vector3f.x;
        this.patchNormals[0][n2++] = vector3f.y;
        this.patchNormals[0][n2++] = vector3f.z;
        for (n = 1; n < this.widthFacetCount; ++n) {
            vector3f = this.calcSideAverageNormal(0, n2, 0, n2 + 3, 1, n2, 0, n2 - 3);
            this.patchNormals[0][n2++] = vector3f.x;
            this.patchNormals[0][n2++] = vector3f.y;
            this.patchNormals[0][n2++] = vector3f.z;
        }
        vector3f = this.createFaceNormal(this.patchCoordinates, 0, n2, 1, n2, 1, n2 - 3);
        this.patchNormals[0][n2++] = vector3f.x;
        this.patchNormals[0][n2++] = vector3f.y;
        this.patchNormals[0][n2++] = vector3f.z;
        for (n = 1; n < this.widthFacetCount; ++n) {
            n2 = 0;
            vector3f = this.calcSideAverageNormal(n, n2, n - 1, n2, n, n2 + 3, n + 1, n2);
            this.patchNormals[n][n2++] = vector3f.x;
            this.patchNormals[n][n2++] = vector3f.y;
            this.patchNormals[n][n2++] = vector3f.z;
            for (int i = 1; i < this.widthFacetCount; ++i) {
                vector3f = this.calcQuadAverageNormal(n, n2, n, n2 + 3, n + 1, n2, n, n2 - 3, n - 1, n2);
                this.patchNormals[n][n2++] = vector3f.x;
                this.patchNormals[n][n2++] = vector3f.y;
                this.patchNormals[n][n2++] = vector3f.z;
            }
            vector3f = this.calcSideAverageNormal(n, n2, n + 1, n2, n, n2 - 3, n - 1, n2);
            this.patchNormals[n][n2++] = vector3f.x;
            this.patchNormals[n][n2++] = vector3f.y;
            this.patchNormals[n][n2++] = vector3f.z;
        }
        n2 = 0;
        vector3f = this.createFaceNormal(this.patchCoordinates, this.widthFacetCount, n2, this.widthFacetCount - 1, n2, this.widthFacetCount, n2 + 3);
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.x;
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.y;
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.z;
        for (n = 1; n < this.widthFacetCount; ++n) {
            vector3f = this.calcSideAverageNormal(n, n2, n, n2 - 3, n - 1, n2, n, n2 + 3);
            this.patchNormals[this.widthFacetCount][n2++] = vector3f.x;
            this.patchNormals[this.widthFacetCount][n2++] = vector3f.y;
            this.patchNormals[this.widthFacetCount][n2++] = vector3f.z;
        }
        vector3f = this.createFaceNormal(this.patchCoordinates, this.widthFacetCount, n2, this.widthFacetCount, n2 - 3, this.widthFacetCount - 1, n2);
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.x;
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.y;
        this.patchNormals[this.widthFacetCount][n2++] = vector3f.z;
    }

    private Vector3f calcSideAverageNormal(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Vector3f vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n3, n4, n5, n6);
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n5, n6, n7, n8);
        vector3f.x = (vector3f.x + f) / 2.0f;
        vector3f.y = (vector3f.y + f2) / 2.0f;
        vector3f.z = (vector3f.z + f3) / 2.0f;
        vector3f.normalize();
        return vector3f;
    }

    private Vector3f calcQuadAverageNormal(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Vector3f vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n5, n6, n3, n4);
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n5, n6, n7, n8);
        f += vector3f.x;
        f2 += vector3f.y;
        f3 += vector3f.z;
        vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n7, n8, n9, n10);
        vector3f = this.createFaceNormal(this.patchCoordinates, n, n2, n9, n10, n3, n4);
        vector3f.x = (vector3f.x + (f += vector3f.x)) / 4.0f;
        vector3f.y = (vector3f.y + (f2 += vector3f.y)) / 4.0f;
        vector3f.z = (vector3f.z + (f3 += vector3f.z)) / 4.0f;
        vector3f.normalize();
        return vector3f;
    }

    protected final void regenerateTexcoords() {
        float f;
        int n;
        int n2;
        if (!this.texCoordsChanged) {
            return;
        }
        this.texCoordsChanged = false;
        this.numTexcoordValues = (this.widthFacetCount + 1) * 2;
        if (this.patchTexcoords == null || this.patchTexcoords.length <= this.widthFacetCount || this.patchTexcoords[0].length < this.numTexcoordValues) {
            this.patchTexcoords = new float[this.widthFacetCount + 1][this.numTexcoordValues];
        }
        float f2 = 0.0f;
        float f3 = 1.0f / (float)this.widthFacetCount;
        float f4 = 1.0f / (float)this.widthFacetCount;
        for (n2 = 0; n2 < this.widthFacetCount; ++n2) {
            n = 0;
            f = 0.0f;
            for (int i = 0; i < this.widthFacetCount; ++i) {
                this.patchTexcoords[n2][n++] = f;
                this.patchTexcoords[n2][n++] = f2;
                f += f3;
            }
            this.patchTexcoords[n2][n++] = 1.0f;
            this.patchTexcoords[n2][n++] = f2;
            f2 += f4;
        }
        n = 0;
        f = 0.0f;
        for (n2 = 0; n2 < this.widthFacetCount; ++n2) {
            this.patchTexcoords[this.widthFacetCount][n++] = f;
            this.patchTexcoords[this.widthFacetCount][n++] = 1.0f;
            f += f3;
        }
        this.patchTexcoords[this.widthFacetCount][n++] = 1.0f;
        this.patchTexcoords[this.widthFacetCount][n++] = 1.0f;
    }
}

