/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.IOException;
import java.io.OutputStream;

public class CodeOutputPacker {
    private byte[] bytes = null;
    private OutputStream stream = null;
    private int ctr = 0;
    private int width = 12;
    private int accum = 0;
    private int acc_bits = 0;
    private int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};

    public CodeOutputPacker(byte[] byArray) {
        this.bytes = byArray;
    }

    public CodeOutputPacker(int n) {
        this.bytes = new byte[n];
    }

    public CodeOutputPacker(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public CodeOutputPacker(byte[] byArray, int n) {
        this.bytes = byArray;
        this.width = n;
    }

    public CodeOutputPacker(int n, int n2) {
        this.bytes = new byte[n];
        this.width = n2;
    }

    public CodeOutputPacker(OutputStream outputStream, int n) {
        this.stream = outputStream;
        this.width = n;
    }

    public void flush() throws IOException {
        if (this.acc_bits > 0) {
            if (null != this.bytes) {
                this.bytes[this.ctr] = (byte)(this.accum << this.acc_bits & 0xFF);
            } else if (null != this.stream) {
                this.stream.write((byte)(this.accum << this.acc_bits & 0xFF));
            }
            this.acc_bits = 0;
            ++this.ctr;
        }
    }

    public void putNArray(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.putN(nArray[i]);
        }
    }

    public void reset() {
        this.acc_bits = 0;
        this.ctr = 0;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getCount() {
        return this.ctr;
    }

    public byte[] toByteArray() {
        if (null == this.bytes) {
            return null;
        }
        byte[] byArray = new byte[this.ctr];
        for (int i = 0; i < this.ctr; ++i) {
            byArray[i] = this.bytes[i];
        }
        return byArray;
    }

    public void putN(int n) throws IOException {
        this.accum = this.acc_bits == 0 ? n : this.accum << this.width | (n &= this.masks[this.width]);
        this.acc_bits += this.width;
        while (this.acc_bits >= 8) {
            if (null != this.bytes) {
                this.bytes[this.ctr] = (byte)(this.accum >> this.acc_bits - 8 & 0xFF);
            } else if (null != this.stream) {
                this.stream.write((byte)(this.accum >> this.acc_bits - 8 & 0xFF));
            }
            this.acc_bits -= 8;
            ++this.ctr;
        }
    }
}

