/* -*- c++ -*- */
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#ifndef VDKOBJ_H
#define VDKOBJ_H
#include <gtk/gtk.h>
#include <vdk/vdktypes.h>
#include <vdk/dlist.h>
#include <vdk/vdkutils.h>
#include <vdk/rawobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkstring.h>

#ifdef USE_SIGCPLUSPLUS
#     include <vdk/sigc_addon.h>
#     include <vdk/sigc_events.h>
#     include <vdk/sigc_eventsignals.h>
#endif /* USE_SIGCPLUSPLUS */

class VDKForm;
class VDKTooltip;
class VDKFont;
class VDKObject;
/*!
  partially filled enum for isA() response
*/
enum { object_class, form_class , container_class};

/*
 */
typedef VDKList<VDKObject> ItemList;
typedef VDKListiterator<VDKObject> ItemListIterator;

/*!
  This struct maps an object with a signal,
  used for static tables
 */
struct VDKObjectSignal {
    void* obj;
    int signal;
};

/*!
  This struct maps an object with a signal
  used for dynamics tables
 */
class VDKObjectSignalUnit
{
public:
    void* owner;
    void* obj;
    VDKString signal;
    VDKObjectSignalUnit(void* owner,void *obj, char* signal):
        owner(owner),obj(obj),signal(signal) {}
    ~VDKObjectSignalUnit() {}
};
/*!
  Object connected signal list
 */
typedef VDKList<VDKObjectSignalUnit> SignalUnitList;
typedef VDKListiterator<VDKObjectSignalUnit> SignalUnitListIterator;

/*!
  This struct maps an object with an event
  used for dynamics tables
 */
class VDKObjectEventUnit
{
public:
    void* owner;
    void* obj;
    VDKString signal;
    VDKObjectEventUnit(void* owner,void *obj, char* signal):
        owner(owner),obj(obj),signal(signal) {}
    ~VDKObjectEventUnit() {}
};
/*!
  Object connected event list
 */
typedef VDKList<VDKObjectEventUnit> EventUnitList;
typedef VDKListiterator<VDKObjectEventUnit> EventUnitListIterator;

/*
=============
SIZE PROPERTY
=============
*/
typedef VDKReadWriteValueProp<VDKObject,VDKPoint> SizeOProp;

class SizeObjectProp: public SizeOProp
{
public:
    SizeObjectProp(){}
    SizeObjectProp(char* name, VDKObject* object,
                   void (VDKObject::*write)(VDKPoint) =  NULL,
                   VDKPoint (VDKObject::*read)(void) = NULL) : SizeOProp(name,object,VDKPoint(0,0),write,read) {}
    void operator = (VDKPoint);
    operator VDKPoint();
};

/*
  ===============
  VDKOBJECT CLASS
  ===============
*/
typedef VDKList<VDKRawObject> RawList;
typedef VDKListiterator<VDKRawObject> RawListIterator;

/*! \class VDKObject
  This class is the base class of a wide hierarchy, provides common functionalities to all derived classe
 */
#ifndef USE_SIGCPLUSPLUS
class VDKObject : public VDKNotCopyAble
#else
class VDKObject : public SigC::Object, public VDKNotCopyAble
#endif
{

 public:
  /*
    properties
  */
  /*!
    Setting one of these this properties will set/get object background color. 
    Naming convention follows Gtk+ one.
    Example: form->NormalBackground = VDKRgb(255,0,0);
    (Tip: VDKRgb is a structure defined in vdkutils.h. 
    Remember that some objects are transparent, so if you want to set 
    the background  color, you actually have to set the background 
    color of the parent, VDKLabel is an example.
   */
  VDKReadWriteValueProp<VDKObject,VDKRgb> NormalBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> PrelightBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> InsensitiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> ActiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> SelectedBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> Foreground;
  /*!
    Setting this property will set the object font.

    i.e.: obj->Font = 
    new VDKFont(obj,"X-font-string-chock-full-o-dashes-goes-in-here");
   */
  VDKReadWriteValueProp<VDKObject,VDKFont*> Font;
  /*!
    Setting this property will set/get object minimum size. 
   */
  SizeObjectProp Usize;
  /*!
    Setting this property will set/get object sensitivity. 
   */
  VDKReadWriteValueProp<VDKObject,bool> Enabled;
  /*!
    Setting this property will set/get object cursor type.
   */
  VDKReadWriteValueProp<VDKObject,VDKCursorType> Cursor;
  /*!
    Setting this property will show/hide or get object visibility
  */
  VDKReadWriteValueProp<VDKObject,bool> Visible;
  int Tag;

// GTK_STATE_NORMAL = 0, GTK_STATE_ACTIVE, GTK_STATE_PRELIGHT,
  // GTK_STATE_SELECTED,GTK_STATE_INSENSITIVE
  void SetNormalBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_NORMAL);
  }
  void SetPrelightBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_PRELIGHT);
  }
  void SetInsensitiveBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_INSENSITIVE);
  }
  void SetActiveBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_ACTIVE);
  }
  void SetSelectedBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_SELECTED);
  }
  /*!
    Gets object background color
   */
  VDKRgb
    GetBackground(GtkStateType state = GTK_STATE_NORMAL);
  /*!
    Gets object foreground color
   */
  VDKRgb
    GetForeground(GtkStateType state = GTK_STATE_NORMAL);

private:
  /*
    copy and assignement prohibited
    */
    friend class VDKRawObject;
//     VDKObject(VDKObject& ) {}
//     VDKObject& operator=(VDKObject& ) {
//         return *this;
//     }
    VDKTooltip* tip;
protected:
    ItemList items;
    ItemList garbages;
    RawList  raws;
    SignalUnitList suList;
    EventUnitList euList;
    /*!
      stock connected signal
     */
    VDKObjectSignal s_clicked,s_pressed,s_released,s_enter,s_leave,
        s_list_select,s_list_unselect,s_list_click_column,s_realize,
            s_toggled,s_value_changed,s_child_attached,s_child_detached;
    VDKForm* owner;
    /*!
      underlaying gtk+ widget
    */
    GtkWidget* widget;
    /*!
      underlaying gtk+ widget
      widget and sigwid could be different,
      e.g into composite widget made of a container
      with some inner widget.
      See Widget() and WrappedWidget()
    */      
    GtkWidget* sigwid;
    /*!
      Object parent, where the signal flows if not stopped
    */
    VDKObject* parent;
    /*! \internal
     */
    static int VDKEventPipe(GtkWidget* w, GdkEvent* event, void* obj);
    /*! \internal
     */
    void _setBackground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    /*! \internal
     */
    void _setForeground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    /*! \internal
     */
    void _setFont_(GtkWidget* wid, VDKFont* f);
    /*! \internal
     */
    void ConnectDefaultEvents();
    /*! \internal
     */
    void ConnectDefaultSignals();
    /*! \internal
     */
    void SignalEmit(int signal, int level);
    /*!
      \internal
    */
    virtual void ShowWidget(bool visible);

public:
    /*!
      Constructor, make an object that belongs to <owner> form.
     */
    VDKObject(VDKForm* owner = NULL);
    /*!
      Contructor, makes an object instance from an already gtk+ created object.
     */
    VDKObject(VDKForm* owner, GtkWidget* widget);
    /*!
      Destructor
    */
    virtual ~VDKObject();
    /*!
      Explicitely destroy an object freeing associated memory.
      
      Tip: never use delete operator otherwise garbage collection 
      will fail and program probably will crash. 
     */
    bool Destroy();
    /*!
      returns an enum id (incomplete and not so useful)
    */
    virtual int isA() { return object_class; }
    /*!
      Returns object owner form.
     */
    VDKForm* Owner() {
        return owner;
    }
    /*!
      Returns underlying GTK+ widget.
     */
    virtual GtkWidget* Widget();
    /*!
      Same as WrappedWidget().
     */
    GtkWidget* ConnectingWidget();
    /*!
      Returns underlying wrapped Gtk+ widget, useful in those 
      cases when VDKObject is a composite one.
      Happens in many composite widgets, i.e a container with some
      inner widgets, that underlaying widget isn't which answers to signals.
      In this case the container is the <widget> and one of the 
      inner widgets is the <sigwid>, wich is responsible to answers 
      signal/event.You have to connect with the last one.
      An example is VDKText where Widget() return packing box not text itself. 
      Tip: In doubt use always WrappedWidget() instead of Widget(), 
      is always safer.
     */
    GtkWidget* WrappedWidget();
    /*!
      Sets object font
    */
    virtual void SetFont(VDKFont* f);
    /*!
      Gets object font
    */
    VDKFont* GetFont() 
      {
        return Font;
      }
    /*!
      Set object visibility
      \param visible either true or false
    */
    void SetVisible(bool visible);
    /*!
      Returns object visibility
    */
    bool GetVisible() 
      {
        return GTK_WIDGET_VISIBLE(widget);
      }
    /*!
      Sets object assigned cursor
    */
    void SetCursor(VDKCursorType);
    /*!
      Gets object assigned cursor
    */
    VDKCursorType     GetCursor() 
      {
        return Cursor;
      }
    /*!
      Sets object foreground
      \param   color a VDKRgb object
      \param   state can be one of the gtk+ widget states
     */
    virtual void SetForeground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);

    void SetNormalForeground(VDKRgb color) 
      {
        SetForeground(color);
      }
    /*!
      Sets object background
      \param   color a VDKRgb object
      \param   state can be one of the gtk+ widget states
     */
    virtual void SetBackground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
    /*!
      Sets object minimum size
      \param   w width
      \param   h height
     */
    void SetSize(int w, int h) 
      {
        if(GTK_IS_WIDGET(widget))
	  gtk_widget_set_usize(GTK_WIDGET(widget),w,h);
      }
    /*!
      Sets object minimum size
      \param   s, a VDKPoint object
     */
      
    void SetUsize(VDKPoint s) 
      {
        SetSize(s.X(),s.Y());
      }
    /*
      Sets/unsets object sensitivity
      \param   flag, either true or false
      Tip: with flag=false object does not answer to signal/events
    */
    virtual void Enable(bool flag = true);
    /*
      Returns if the object is enable or not
    */
    bool GetEnabled() 
      {
        return Enabled;
      }
    /*!
      Sets object tip.
     */
    virtual void SetTip(char* );
    /*!
      Add on abiect to the object.
      \param obj the object to be added
      \param justify where the object wil be added, can be:
      - l_justify packed to end (appended)
      - r_justify packed to start (prepended)
      \param expand if true object will expand
      \param fill if true object will fill all available space
      \param padding how many pixels are left around object
    */
    virtual void Add(VDKObject* obj, int justify = l_justify,
                     int expand = TRUE, int fill = TRUE ,
                     int padding = 0);
    /*!
      Return contained objects list
     */
    ItemList& Items() 
      {
        return items;
      }
    /*!
      \internal
    */
    ItemList& Garbages() 
      {
        return garbages;
      }
    /*!
      \internal
    */
    RawList& Raws() 
      {
        return raws;
      }
    /*!
      Draw an object
    */
    void Draw(GdkRectangle* area = NULL);
    /*!
      placeholder for subclasses.
      This method is called whenever an object is added to
      a container.
    */
    virtual void Setup() {}
    /*!
      Emit a signal (static tables)
      \param signal
    */
    void SignalEmit(int signal);
    /*!
      Emit a signal (dynamic tables)
      \param signal
    */
    void SignalEmit(char* sig);
    /*!
      Emit a signal directly to parent (static tables)
      \param signal
    */
    void SignalEmitParent(int signal) {
        SignalEmit(signal,Parent_level);
    }
    /*!
      Emit a signal directly to parent (dynamic tables)
      \param signal
    */
    void SignalEmitParent(char* sig);
    /*!
      Grab the focus to itself
     */
    void GrabFocus();
    /*!
      \internal
    */    
    void AddItem(VDKObject* item);
    /*!
      \internal
    */
    void RemoveItem(VDKObject* item);
    /*!
      \internal
    */
    void RemoveItems();
  /*
==================== signal/event management  ======================
  */
    /*!
      Sets object parenthood
    */
    VDKObject* Parent(VDKObject* p = NULL) {
        if(p) parent = p; return parent;
    }
    // signal and events default dispatchers for class level
    /*!
      \internal
    */
    static void VDKSignalPipe(GtkWidget* w, void* obj);
    /*!
      \internal
    */
    virtual int VDKObjectSignalResponse(GtkWidget* , int , void*, bool) 
      {
        return FALSE;
      }
    /*!
      \internal
    */
    virtual int VDKObjectEventResponse(GtkWidget* , GdkEvent*, void*, bool) 
      {
        return FALSE;
      }

    virtual int ObjectSignalDetach(int , int ) 
      {
        return -1;
      }
    virtual bool ObjectSignalAttach(int ) 
      {
        return false;
      }
    virtual int ObjectEventDetach(VDKEvent ) 
      {
        return -1;
      }
    virtual bool ObjectEventAttach(int ) 
      {
        return false;
      }
 protected:
     virtual int VDKObjectSignalResponseTableSize() 
       {
         return 0;
       }
     virtual int VDKObjectEventResponseTableSize() 
       {
         return 0;
       }
  /*
   */
  // signal and events default dispatchers for parent level
public:
    /*!
      \internal
    */
    virtual int VDKSignalResponse(GtkWidget* , int , void*, void *, bool) 
      {
        return 0;
      }
    /*!
      \internal
    */
    virtual int VDKEventResponse(GtkWidget* , GdkEvent* , void*, void*, bool )
      {
        return 0;
      }
    virtual int SignalDetach(VDKObject* , int ) 
      {
        return -1;
      }
    virtual bool SignalAttach(int ) 
      {
        return false;
      }
    virtual int EventDetach(VDKObject* ,VDKEvent ) 
      {
        return -1;
      }
    virtual bool EventAttach(int ) 
      {
        return false;
      }
protected:
    /*!
      \internal
    */
    virtual int VDKSignalResponseTableSize() 
      {
        return 0;
      }
    /*!
      \internal
    */
    virtual int VDKEventResponseTableSize() 
      {
        return 0;
      }
  /*
==================== signal management ala Gtk+ ======================
  */
public:
    /*!
      Placeholder for subclasses, at this level does nothing.
      Connects an object-signal to a <this> method
      \param obj connected object
      \param signal signal to be connected
      \param method class method that answers to signal
      \param gtk (default is true) if you set this arg to false no 
      real connection is made with gtk+ signal system and signal 
      is handled internally by vdk. This allow to define and use your 
      own signals without register them to gtk+
      \param after (default is false) if set to true connect signal in
      the "after" slot, meaninigfull only if previous <gtk> arg is set
      to true.
    */
    int SignalConnect(VDKObject* obj, 
		      char* signal,
		      bool (VDKObject::*method)(VDKObject*), 
		      bool gtk = true,
		      bool after = false) 
      {
        return -1;
      }
    /*!
      Placeholder for subclasses, at this level does nothing.
      Connects <this>-signal to a <this> method
      \param signal signal to be connected
      \param method class method that answers to signal
      \param gtk (default is true) if you set this arg to false no 
      real connection is made with gtk+ signal system and signal 
      is handled internally by vdk. This allow to define and use your 
      own signals without register them to gtk+
      \param after (default is false) if set to true connect signal in
      the "after" slot, meaninigfull only if previous <gtk> arg is set
      to true.
    */
    int SignalConnect(char* signal ,
		      bool (VDKObject::*method)(VDKObject*), 
		      bool gtk = true,
		      bool after = false) 
      {
        return -1;
      }
   // general signal unit response (at this level simply answer false)
    virtual int VDKSignalUnitResponse(GtkWidget* , char* , void*) 
      {
        return 0;
      }
    /*! disconnect this from connection
      \param   connection must be achieved with a previous
      SignalConnect() call
      */
    bool SignalDisconnect(int connection) 
      {
        return false;
      }
  // find signal at class level
    /*!
      \internal
    */
    virtual bool FindSignalAtClassLevel(VDKObject* , char* ) 
      //    virtual bool FindSignalAtClassLevel(VDKObject* , VDKString& ) 
      {
        return false;
      }
  // find signal at parent level
    /*!
      \internal
    */
  //   virtual bool FindSignalAtParentLevel(VDKObject* , VDKString& ) 
    virtual bool FindSignalAtParentLevel(VDKObject* , char* ) 
      {
        return false;
      }
protected:
    // unique Gtk+ callback that redirects to
    // above VDKSignalUnitResponse()
    /*!
      \internal
    */
    static void VDKSignalUnitPipe(GtkWidget* , void* );
  /*
==================== event management ala Gtk+ ======================
  */
public:
    /*!
      \internal
    */
  //  virtual bool FindEventAtClassLevel(VDKObject* , VDKString& ) 
  virtual bool FindEventAtClassLevel(VDKObject* , char* ) 
  {
    return false;
  }
    /*!
      \internal
    */
  //  virtual bool FindEventAtParentLevel(VDKObject* , VDKString& ) 
  virtual bool FindEventAtParentLevel(VDKObject* , char* ) 
  {
    return false;
  }
    /*!
      \internal
    */
      virtual int  VDKEventUnitResponse(GtkWidget* , char* , 
					GdkEvent* , void*) {
          return 0;
      }
    /*!
      Placeholder for subclasses, at this level does nothing.
      connects an object-event to a <this> method 
      \param   obj connected object
      \param event event to be connected
      \param method class method that answers to signal
      \param after (default is false) if set to true connect signal in
      the "after" slot.
    */
      int EventConnect(VDKObject* obj, 
		       char* event, 
		       bool (VDKObject::*method) (VDKObject* , GdkEvent*), 
		       bool after = false) 
	{
          return -1;
      
	}
      /*!
	Placeholder for subclasses, at this level does nothing.
	connects an <this>-event to a <this> method
	\param event event to be connected
	\param method class method that answers to signal
	\param after (default is false) if set to true connect signal in
	the "after" slot.
      */
      int EventConnect(char* , bool (VDKObject::*) (VDKObject* , GdkEvent*), 
		       bool after = false) 
	{
          return -1;
	}
      /*! disconnect this from connection
	\param   connection must be achieved with a previous
	EventConnect() call
      */
      bool EventDisconnect(int connection) 
	{
          return false;
	}
      virtual int  VDKSignalResponseListSize() {
          return 0;
      }
protected:
    // unique Gtk+ callback that redirects to
    // above VDKEventUnitResponse()
    /*!
      \internal
    */
    static int VDKEventUnitPipe(GtkWidget* , GdkEvent*, void* );

#ifdef USE_SIGCPLUSPLUS
 public:
   /** The signal for raw GdkEvents* */
    VDKRawEventSignal     OnRawEvent;
   /** The signal responsible for button events */
    VDKButtonSignal       OnButtonEvent;
   /** The signal responsible for keystroke events */ 
    VDKKeySignal          OnKeyEvent;
   /** The signal responsible for changes in key focus */
    VDKKeyFocusSignal     OnKeyFocusEvent;
   /** The signal responsible for changes in pointer focus */
    VDKPointerFocusSignal OnPointerFocusEvent;
   /** The signal responsible for pointer (mouse) events */
    VDKPointerSignal      OnPointerEvent;
   /** The signal responsible for map events */
     VDKMapSignal         OnMapEvent;
   /** The signal responsible for geometry events */
     VDKGeometrySignal    OnGeometryEvent;
   /** The signal responsible for paint events */
     VDKPaintSignal       OnPaintEvent;
#endif // USE_SIGCPLUSPLUS
};
#endif








