
[//000000001]: # (json::write \- JSON)
[//000000002]: # (Generated from file 'json\_write\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2009\-2013 Andreas Kupries <andreas\_kupries@sourceforge\.net>)
[//000000004]: # (json::write\(n\) 1\.0\.3 tcllib "JSON")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

json::write \- JSON generation

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [COMMANDS](#section2)

  - [RELATED](#section3)

  - [Bugs, Ideas, Feedback](#section4)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5  
package require json::write ?1\.0\.3?  

[__::json::write__ __indented__](#1)  
[__::json::write__ __indented__ *flag*](#2)  
[__::json::write__ __aligned__](#3)  
[__::json::write__ __aligned__ *flag*](#4)  
[__::json::write__ __string__ *s*](#5)  
[__::json::write__ __array__ *arg*\.\.\.](#6)  
[__::json::write__ __object__ *key* *value*\.\.\.](#7)  

# <a name='description'></a>DESCRIPTION

The __json::write__ package provides a simple Tcl\-only library for
generation of text in the JSON [http://www\.json\.org/](http://www\.json\.org/)
data exchange format as specified in RFC 4627
[http://www\.ietf\.org/rfc/rfc4627\.txt](http://www\.ietf\.org/rfc/rfc4627\.txt)\.

# <a name='section2'></a>COMMANDS

  - <a name='1'></a>__::json::write__ __indented__

    This method returns the current state of the indentation setting\.

  - <a name='2'></a>__::json::write__ __indented__ *flag*

    This and the method __aligned__ configure the layout of the JSON
    generated by the package\.

    If this *flag* is set \(default\) the package will break the generated JSON
    code across lines and indent it according to its inner structure, with each
    key of an object on a separate line\.

    If this flag is not set, the whole JSON object will be written on a single
    line, with minimum spacing between all elements\.

  - <a name='3'></a>__::json::write__ __aligned__

    This method returns the current state of the alignment setting\.

  - <a name='4'></a>__::json::write__ __aligned__ *flag*

    This and the method __indented__ configure the layout of the JSON
    generated by the package\.

    If this *flag* is set \(default\) the package ensures that the values for
    the keys in an object are vertically aligned with each other, for a nice
    table effect\. To make this work this also implies that __indented__ is
    set as well\.

    If this flag is not set, the output is formatted as per the value of
    __indented__, without trying to align the values for object keys\.

  - <a name='5'></a>__::json::write__ __string__ *s*

    This method takes the string *s* and returns it properly quoted for JSON
    as its result\.

  - <a name='6'></a>__::json::write__ __array__ *arg*\.\.\.

    This method takes a series of JSON formatted arguments and returns them as a
    properly formatted JSON array as its result\.

  - <a name='7'></a>__::json::write__ __object__ *key* *value*\.\.\.

    This method takes a series of key/value arguments, the values already
    formatted for JSON, and returns them as a properly formatted JSON object as
    its result, with the keys formatted as JSON strings\.

# <a name='section3'></a>RELATED

To parse json, instead of writing it, see package __[json](json\.md)__\.

# <a name='section4'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *json* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[data exchange](\.\./\.\./\.\./\.\./index\.md\#data\_exchange), [exchange
format](\.\./\.\./\.\./\.\./index\.md\#exchange\_format),
[javascript](\.\./\.\./\.\./\.\./index\.md\#javascript),
[json](\.\./\.\./\.\./\.\./index\.md\#json)

# <a name='category'></a>CATEGORY

CGI programming

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2009\-2013 Andreas Kupries <andreas\_kupries@sourceforge\.net>
