/*
 * Copyright (C) 2010 Martin Willi
 * Copyright (C) 2010 revosec AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licenseor (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be usefulbut
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <crypto/crypto_tester.h>

/**
 * Test 1 of RFC5528
 */
crypter_test_vector_t camellia_ctr1 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 16, .len = 16,
	.key	= "\xae\x68\x52\xf8\x12\x10\x67\xcc\x4b\xf7\xa5\x76\x55\x77\xf3\x9e"
			  "\x00\x00\x00\x30",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "Single block msg",
	.cipher	= "\xd0\x9d\xc2\x9a\x82\x14\x61\x9a\x20\x87\x7c\x76\xdb\x1f\x0b\x3f"
};

/**
 * Test 2 of RFC5528
 */
crypter_test_vector_t camellia_ctr2 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 16, .len = 32,
	.key	= "\x7e\x24\x06\x78\x17\xfa\xe0\xd7\x43\xd6\xce\x1f\x32\x53\x91\x63"
			  "\x00\x6c\xb6\xdb",
	.iv		= "\xc0\x54\x3b\x59\xda\x48\xd9\x0b",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
	.cipher	= "\xdb\xf3\xc7\x8d\xc0\x83\x96\xd4\xda\x7c\x90\x77\x65\xbb\xcb\x44"
			  "\x2b\x8e\x8e\x0f\x31\xf0\xdc\xa7\x2c\x74\x17\xe3\x53\x60\xe0\x48"
};

/**
 * Test 3 of RFC5528
 */
crypter_test_vector_t camellia_ctr3 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 16, .len = 36,
	.key	= "\x76\x91\xbe\x03\x5e\x50\x20\xa8\xac\x6e\x61\x85\x29\xf9\xa0\xdc"
			  "\x00\xe0\x01\x7b",
	.iv		= "\x27\x77\x7f\x3f\x4a\x17\x86\xf0",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
			  "\x20\x21\x22\x23",
	.cipher	= "\xb1\x9d\x1f\xcd\xcb\x75\xeb\x88\x2f\x84\x9c\xe2\x4d\x85\xcf\x73"
			  "\x9c\xe6\x4b\x2b\x5c\x9d\x73\xf1\x4f\x2d\x5d\x9d\xce\x98\x89\xcd"
			  "\xdf\x50\x86\x96",
};

/**
 * Test 4 of RFC5528
 */
crypter_test_vector_t camellia_ctr4 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 24, .len = 16,
	.key	= "\x16\xaf\x5b\x14\x5f\xc9\xf5\x79\xc1\x75\xf9\x3e\x3b\xfb\x0e\xed"
			  "\x86\x3d\x06\xcc\xfd\xb7\x85\x15"
			  "\x00\x00\x00\x48",
	.iv		= "\x36\x73\x3c\x14\x7d\x6d\x93\xcb",
	.plain	= "Single block msg",
	.cipher	= "\x23\x79\x39\x9e\x8a\x8d\x2b\x2b\x16\x70\x2f\xc7\x8b\x9e\x96\x96",
};

/**
 * Test 5 of RFC5528
 */
crypter_test_vector_t camellia_ctr5 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 24, .len = 32,
	.key	= "\x7c\x5c\xb2\x40\x1b\x3d\xc3\x3c\x19\xe7\x34\x08\x19\xe0\xf6\x9c"
			  "\x67\x8c\x3d\xb8\xe6\xf6\xa9\x1a"
			  "\x00\x96\xb0\x3b",
	.iv		= "\x02\x0c\x6e\xad\xc2\xcb\x50\x0d",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
	.cipher	= "\x7d\xef\x34\xf7\xa5\xd0\xe4\x15\x67\x4b\x7f\xfc\xae\x67\xc7\x5d"
			  "\xd0\x18\xb8\x6f\xf2\x30\x51\xe0\x56\x39\x2a\x99\xf3\x5a\x4c\xed",
};

/**
 * Test 6 of RFC5528
 */
crypter_test_vector_t camellia_ctr6 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 24, .len = 36,
	.key	= "\x02\xbf\x39\x1e\xe8\xec\xb1\x59\xb9\x59\x61\x7b\x09\x65\x27\x9b"
			  "\xf5\x9b\x60\xa7\x86\xd3\xe0\xfe"
			  "\x00\x07\xbd\xfd",
	.iv		= "\x5c\xbd\x60\x27\x8d\xcc\x09\x12",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
			  "\x20\x21\x22\x23",
	.cipher	= "\x57\x10\xe5\x56\xe1\x48\x7a\x20\xb5\xac\x0e\x73\xf1\x9e\x4e\x78"
			  "\x76\xf3\x7f\xdc\x91\xb1\xef\x4d\x4d\xad\xe8\xe6\x66\xa6\x4d\x0e"
			  "\xd5\x57\xab\x57",
};

/**
 * Test 7 of RFC5528
 */
crypter_test_vector_t camellia_ctr7 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 32, .len = 16,
	.key	= "\x77\x6b\xef\xf2\x85\x1d\xb0\x6f\x4c\x8a\x05\x42\xc8\x69\x6f\x6c"
			  "\x6a\x81\xaf\x1e\xec\x96\xb4\xd3\x7f\xc1\xd6\x89\xe6\xc1\xc1\x04"
			  "\x00\x00\x00\x60",
	.iv		= "\xdb\x56\x72\xc9\x7a\xa8\xf0\xb2",
	.plain	= "Single block msg",
	.cipher	= "\x34\x01\xf9\xc8\x24\x7e\xff\xce\xbd\x69\x94\x71\x4c\x1b\xbb\x11",
};

/**
 * Test 8 of RFC5528
 */
crypter_test_vector_t camellia_ctr8 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 32, .len = 32,
	.key	= "\xf6\xd6\x6d\x6b\xd5\x2d\x59\xbb\x07\x96\x36\x58\x79\xef\xf8\x86"
			  "\xc6\x6d\xd5\x1a\x5b\x6a\x99\x74\x4b\x50\x59\x0c\x87\xa2\x38\x84"
			  "\x00\xfa\xac\x24",
	.iv		= "\xc1\x58\x5e\xf1\x5a\x43\xd8\x75",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
	.cipher	= "\xd6\xc3\x03\x92\x24\x6f\x78\x08\xa8\x3c\x2b\x22\xa8\x83\x9e\x45"
			  "\xe5\x1c\xd4\x8a\x1c\xdf\x40\x6e\xbc\x9c\xc2\xd3\xab\x83\x41\x08",
};

/**
 * Test 9 of RFC5528
 */
crypter_test_vector_t camellia_ctr9 = {
	.alg = ENCR_CAMELLIA_CTR, .key_size = 32, .len = 36,
	.key	= "\xff\x7a\x61\x7c\xe6\x91\x48\xe4\xf1\x72\x6e\x2f\x43\x58\x1d\xe2"
			  "\xaa\x62\xd9\xf8\x05\x53\x2e\xdf\xf1\xee\xd6\x87\xfb\x54\x15\x3d"
			  "\x00\x1c\xc5\xb7",
	.iv		= "\x51\xa5\x1d\x70\xa1\xc1\x11\x48",
	.plain	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
			  "\x20\x21\x22\x23",
	.cipher	= "\xa4\xda\x23\xfc\xe6\xa5\xff\xaa\x6d\x64\xae\x9a\x06\x52\xa4\x2c"
			  "\xd1\x61\xa3\x4b\x65\xf9\x67\x9f\x75\xc0\x1f\x10\x1f\x71\x27\x6f"
			  "\x15\xef\x0d\x8d",
};
