/*
From: Thomas Roessler <roessler@guug.de>
Subject: sac / xterm's logout entries

I run the following program from cron every few minutes
here to fix xterm's wtmp entries.  Maybe you want to
include it with your sac package?
*/

/*
 * Fix xterm's messed-up wtmp entries.
 *
 * Thomas Roessler <roessler@rhein.de>, 
 * Thu Aug 29 15:42:37 MET DST 1996
 *
 * Copy and redistribute freely.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <unistd.h>
#include <utmp.h>
#include <paths.h>

#include <stdio.h>

int main(int argc, const char *argv[]) 
{
	struct utmp u;
	int fd;
	int status = 0;

	if((fd = open(argc == 2 ? argv[1] : _PATH_WTMP,O_RDWR)) == -1) {
		perror("open");
		exit(1);
	}

	if(flock(fd, LOCK_EX) == -1) {
		perror("flock");
		status = 1;
		goto bye;
	}

	while(read(fd, &u, sizeof(struct utmp)) == sizeof(struct utmp)) {
		if(u.ut_type == DEAD_PROCESS && *(u.ut_user)) {
			*(u.ut_user) = '\0';
			if(lseek(fd, -sizeof(struct utmp), SEEK_CUR) == -1) {
				perror("lseek");
				status = 1;
				goto bye;
			}
			if(write(fd, &u, sizeof(struct utmp)) != sizeof(struct utmp)) {
				perror("write");
				status = 1;
				goto bye;
			}
		}
	}

bye:

	if(flock(fd, LOCK_UN) == -1) {
		perror("flock");
		exit(1);
	}

	if(close(fd) == -1) {
		perror("close");
		exit(1);
	}

	return(status);
}
