Minutes from 25th OpenVDB TSC meeting, August 22, 2019

Attendees: *Nick* A., *Dan* B., *Peter* C.

Absent: *Ken* M., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), John Mertic (LF)

Agenda:

1) Quorum
2) Secretary
3) CMake / CI updates?
4) SPDX changeover
5) Upcoming Point Partitioner refactoring
6) Modifying deprecation policy
7) Where to start with modifying Tree classes
8) Next Meeting


1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) CMake / CI updates

Windows builds are still an issue. We believe this is due to the manual system
path setup which omits windows and disables CMake's automatic path detection
when given a toolchain file. The README should be updated to clarify the build
instructions listed are a starting point for CMake builds, intended for users to
be able to iteratively run and react to any CMake warnings/errors presented.
Nick believes PR #504 will help resolve some of these issues but there are some
outstanding questions with the implementation. Nick to continue to investigate.

CLA/PRs

Some PRs are becoming stalled on the CLA. All TSC members to chase/ensure they
have signed the digital LF CLA.

Older PRs/github issues are becoming awkward due to new submissions superseding
or re-implementing them. In the next TSC we should decide on a system for
closing or declining unresponsive or old PRs/issues.

4) SPDX changeover

Peter to take the lead on this change due to DreamWorks owning the current
license. Dan to provide Peter with examples of the requested changes that need
to occur. Chat links:

Dan: https://github.com/imageworks/OpenColorIO/pull/799
John: https://github.com/AcademySoftwareFoundation/openvdb/blob/master/LICENSE

John to start a discussion with DreamWorks legal on the migration to SPDX.

5) Upcoming Point Partitioner refactoring

Dan working on a refactor to the internals of the current point partitioner to
better work with OpenVDB Points. Currently it requires a two pass system (for
VDB Points) which isn't ideal. There are also a number of C++11 improvements
which can be made. Nick asked if the changes also benefit arrays of positions
(non VDB Point data). Dan reported faster performance with linear arrays.

6) Modifying deprecation policy

Discussed adding deprecation warnings in the next releases of VDB. VDB 6.2.0
will be the last supported VFX17 release which should introduce all related
deprecation warnings based on the VFX18 requirements. VDB 7.0.0 planned to bump
all minimum versions to the VFX18 platform (notably C++14). Support for ABI 2,
3, 4 and 5 to be maintained until VDB 7.0.0, with the plan to remove them at
the end of the year.

7) Where to start with modifying Tree classes

Discussion around the free function vs base (untyped) member function
implementation of grid/tree methods (prune, clip, topologyUnion etc). prune and
clip are interesting cases as they live on the untyped base version of the grid
object. This delegates runtime branching of the grid type to the virtual
function table rather than forcing the user to perform boilerplate switching on
unknown grids. This is particularly useful for the clip method which is used in
file IO. It's unclear whether we should continue to remove these methods because
of this. Methods that live solely on the typed derived classes can more easily
be moved into standalone header/free function combinations. However a decision
should be made as to how we want to leverage the base class API before we
consider this, as an argument could also be made to make some of these methods
on the derived grid/tree also available as pure virtual methods on the base
class. Discussion to continue.

8) Next Meeting

August 29th 2019.  3pm-4pm EDT (GMT-4).
