/*
 * Copyright 2016 higherfrequencytrading.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.threads.ThreadDump;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class BinaryLongArrayReferenceTest {

    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        threadDump.assertNoNewThreads();
    }

    @Test
    public void getSetValues() {
        int length = 128 * 8 + 2 * 8;
        Bytes bytes = Bytes.allocateDirect(length);
        BinaryLongArrayReference.write(bytes, 128);

        @NotNull BinaryLongArrayReference array = new BinaryLongArrayReference();
        array.bytesStore(bytes, 0, length);

        assertEquals(128, array.getCapacity());
        for (int i = 0; i < 128; i++)
            array.setValueAt(i, i + 1);

        for (int i = 0; i < 128; i++)
            assertEquals(i + 1, array.getValueAt(i));
        bytes.release();
    }
}