/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/absolute_pose/modules/gpnp5/modules.hpp>


void
opengv::absolute_pose::modules::gpnp5::init(
    Eigen::Matrix<double,44,80> & groebnerMatrix,
    const Eigen::Matrix<double,12,1> & a,
    Eigen::Matrix<double,12,1> & n,
    Eigen::Matrix<double,12,1> & m,
    Eigen::Matrix<double,12,1> & k,
    Eigen::Matrix<double,12,1> & l,
    Eigen::Matrix<double,12,1> & p,
    Eigen::Vector3d & c0,
    Eigen::Vector3d & c1,
    Eigen::Vector3d & c2,
    Eigen::Vector3d & c3 )
{
  Eigen::Vector3d temp = c0-c1;
  double c01w = temp.norm()*temp.norm();
  temp = c0-c2;
  double c02w = temp.norm()*temp.norm();
  temp = c0-c3;
  double c03w = temp.norm()*temp.norm();
  temp = c1-c2;
  double c12w = temp.norm()*temp.norm();
  temp = c1-c3;
  double c13w = temp.norm()*temp.norm();
  temp = c2-c3;
  double c23w = temp.norm()*temp.norm();

  groebnerMatrix(0,59) = ((((((((-2*p(0,0)*p(3,0)+pow(p(1,0),2))+pow(p(4,0),2))+pow(p(2,0),2))+pow(p(5,0),2))+pow(p(0,0),2))+pow(p(3,0),2))-2*p(1,0)*p(4,0))-2*p(2,0)*p(5,0));
  groebnerMatrix(0,60) = (((((((((((2*l(1,0)*p(1,0)-2*l(1,0)*p(4,0))-2*p(1,0)*l(4,0))+2*l(4,0)*p(4,0))+2*l(2,0)*p(2,0))-2*l(2,0)*p(5,0))-2*p(2,0)*l(5,0))+2*l(5,0)*p(5,0))+2*l(0,0)*p(0,0))-2*l(0,0)*p(3,0))-2*p(0,0)*l(3,0))+2*l(3,0)*p(3,0));
  groebnerMatrix(0,61) = ((((((((-2*l(0,0)*l(3,0)+pow(l(1,0),2))+pow(l(4,0),2))+pow(l(2,0),2))+pow(l(5,0),2))+pow(l(0,0),2))+pow(l(3,0),2))-2*l(1,0)*l(4,0))-2*l(2,0)*l(5,0));
  groebnerMatrix(0,62) = (((((((((((2*k(1,0)*p(1,0)-2*k(1,0)*p(4,0))-2*p(1,0)*k(4,0))+2*k(4,0)*p(4,0))+2*k(2,0)*p(2,0))-2*k(2,0)*p(5,0))-2*p(2,0)*k(5,0))+2*k(5,0)*p(5,0))+2*k(0,0)*p(0,0))-2*k(0,0)*p(3,0))-2*p(0,0)*k(3,0))+2*k(3,0)*p(3,0));
  groebnerMatrix(0,63) = (((((((((((2*k(1,0)*l(1,0)-2*k(1,0)*l(4,0))-2*l(1,0)*k(4,0))+2*k(4,0)*l(4,0))+2*k(2,0)*l(2,0))-2*k(2,0)*l(5,0))-2*l(2,0)*k(5,0))+2*k(5,0)*l(5,0))+2*k(0,0)*l(0,0))-2*k(0,0)*l(3,0))-2*l(0,0)*k(3,0))+2*k(3,0)*l(3,0));
  groebnerMatrix(0,64) = ((((((((-2*k(0,0)*k(3,0)+pow(k(1,0),2))+pow(k(4,0),2))+pow(k(2,0),2))+pow(k(5,0),2))+pow(k(0,0),2))+pow(k(3,0),2))-2*k(1,0)*k(4,0))-2*k(2,0)*k(5,0));
  groebnerMatrix(0,65) = (((((((((((2*m(1,0)*p(1,0)-2*m(1,0)*p(4,0))-2*p(1,0)*m(4,0))+2*m(4,0)*p(4,0))+2*m(2,0)*p(2,0))-2*m(2,0)*p(5,0))-2*p(2,0)*m(5,0))+2*m(5,0)*p(5,0))+2*m(0,0)*p(0,0))-2*m(0,0)*p(3,0))-2*p(0,0)*m(3,0))+2*m(3,0)*p(3,0));
  groebnerMatrix(0,66) = (((((((((((2*m(1,0)*l(1,0)-2*m(1,0)*l(4,0))-2*l(1,0)*m(4,0))+2*m(4,0)*l(4,0))+2*m(2,0)*l(2,0))-2*m(2,0)*l(5,0))-2*l(2,0)*m(5,0))+2*m(5,0)*l(5,0))+2*m(0,0)*l(0,0))-2*m(0,0)*l(3,0))-2*l(0,0)*m(3,0))+2*m(3,0)*l(3,0));
  groebnerMatrix(0,67) = (((((((((((2*m(1,0)*k(1,0)-2*m(1,0)*k(4,0))-2*k(1,0)*m(4,0))+2*m(4,0)*k(4,0))+2*m(2,0)*k(2,0))-2*m(2,0)*k(5,0))-2*k(2,0)*m(5,0))+2*m(5,0)*k(5,0))+2*m(0,0)*k(0,0))-2*m(0,0)*k(3,0))-2*k(0,0)*m(3,0))+2*m(3,0)*k(3,0));
  groebnerMatrix(0,68) = ((((((((-2*m(0,0)*m(3,0)+pow(m(1,0),2))+pow(m(4,0),2))+pow(m(2,0),2))+pow(m(5,0),2))+pow(m(0,0),2))+pow(m(3,0),2))-2*m(1,0)*m(4,0))-2*m(2,0)*m(5,0));
  groebnerMatrix(0,69) = (((((((((((-2*p(1,0)*n(4,0)+2*n(4,0)*p(4,0))+2*n(2,0)*p(2,0))-2*n(2,0)*p(5,0))-2*p(2,0)*n(5,0))+2*n(5,0)*p(5,0))+2*n(0,0)*p(0,0))-2*n(0,0)*p(3,0))-2*p(0,0)*n(3,0))+2*n(3,0)*p(3,0))+2*n(1,0)*p(1,0))-2*n(1,0)*p(4,0));
  groebnerMatrix(0,70) = (((((((((((-2*l(1,0)*n(4,0)+2*n(4,0)*l(4,0))+2*n(2,0)*l(2,0))-2*n(2,0)*l(5,0))-2*l(2,0)*n(5,0))+2*n(5,0)*l(5,0))+2*n(0,0)*l(0,0))-2*n(0,0)*l(3,0))-2*l(0,0)*n(3,0))+2*n(3,0)*l(3,0))+2*n(1,0)*l(1,0))-2*n(1,0)*l(4,0));
  groebnerMatrix(0,71) = (((((((((((-2*k(1,0)*n(4,0)+2*n(4,0)*k(4,0))+2*n(2,0)*k(2,0))-2*n(2,0)*k(5,0))-2*k(2,0)*n(5,0))+2*n(5,0)*k(5,0))+2*n(0,0)*k(0,0))-2*n(0,0)*k(3,0))-2*k(0,0)*n(3,0))+2*n(3,0)*k(3,0))+2*n(1,0)*k(1,0))-2*n(1,0)*k(4,0));
  groebnerMatrix(0,72) = (((((((((((-2*m(1,0)*n(4,0)+2*n(4,0)*m(4,0))+2*n(2,0)*m(2,0))-2*n(2,0)*m(5,0))-2*m(2,0)*n(5,0))+2*n(5,0)*m(5,0))+2*n(0,0)*m(0,0))-2*n(0,0)*m(3,0))-2*m(0,0)*n(3,0))+2*n(3,0)*m(3,0))+2*n(1,0)*m(1,0))-2*n(1,0)*m(4,0));
  groebnerMatrix(0,73) = ((((((((-2*n(0,0)*n(3,0)+pow(n(1,0),2))+pow(n(4,0),2))+pow(n(2,0),2))+pow(n(5,0),2))+pow(n(0,0),2))+pow(n(3,0),2))-2*n(1,0)*n(4,0))-2*n(2,0)*n(5,0));
  groebnerMatrix(0,74) = (((((((((((2*a(0,0)*p(0,0)-2*a(0,0)*p(3,0))-2*p(0,0)*a(3,0))+2*a(3,0)*p(3,0))+2*a(1,0)*p(1,0))-2*a(1,0)*p(4,0))-2*p(1,0)*a(4,0))+2*a(4,0)*p(4,0))+2*a(2,0)*p(2,0))-2*a(2,0)*p(5,0))-2*p(2,0)*a(5,0))+2*a(5,0)*p(5,0));
  groebnerMatrix(0,75) = (((((((((((2*a(0,0)*l(0,0)-2*a(0,0)*l(3,0))-2*l(0,0)*a(3,0))+2*a(3,0)*l(3,0))+2*a(1,0)*l(1,0))-2*a(1,0)*l(4,0))-2*l(1,0)*a(4,0))+2*a(4,0)*l(4,0))+2*a(2,0)*l(2,0))-2*a(2,0)*l(5,0))-2*l(2,0)*a(5,0))+2*a(5,0)*l(5,0));
  groebnerMatrix(0,76) = (((((((((((2*a(0,0)*k(0,0)-2*a(0,0)*k(3,0))-2*k(0,0)*a(3,0))+2*a(3,0)*k(3,0))+2*a(1,0)*k(1,0))-2*a(1,0)*k(4,0))-2*k(1,0)*a(4,0))+2*a(4,0)*k(4,0))+2*a(2,0)*k(2,0))-2*a(2,0)*k(5,0))-2*k(2,0)*a(5,0))+2*a(5,0)*k(5,0));
  groebnerMatrix(0,77) = (((((((((((2*a(0,0)*m(0,0)-2*a(0,0)*m(3,0))-2*m(0,0)*a(3,0))+2*a(3,0)*m(3,0))+2*a(1,0)*m(1,0))-2*a(1,0)*m(4,0))-2*m(1,0)*a(4,0))+2*a(4,0)*m(4,0))+2*a(2,0)*m(2,0))-2*a(2,0)*m(5,0))-2*m(2,0)*a(5,0))+2*a(5,0)*m(5,0));
  groebnerMatrix(0,78) = (((((((((((2*a(0,0)*n(0,0)-2*a(0,0)*n(3,0))-2*n(0,0)*a(3,0))+2*a(3,0)*n(3,0))+2*a(1,0)*n(1,0))-2*a(1,0)*n(4,0))-2*n(1,0)*a(4,0))+2*a(4,0)*n(4,0))+2*a(2,0)*n(2,0))-2*a(2,0)*n(5,0))-2*n(2,0)*a(5,0))+2*a(5,0)*n(5,0));
  groebnerMatrix(0,79) = (((((((((-c01w+pow(a(4,0),2))+pow(a(2,0),2))-2*a(2,0)*a(5,0))+pow(a(5,0),2))+pow(a(0,0),2))-2*a(0,0)*a(3,0))+pow(a(3,0),2))+pow(a(1,0),2))-2*a(1,0)*a(4,0));
  groebnerMatrix(1,59) = ((((((((pow(p(1,0),2)+pow(p(2,0),2))+pow(p(6,0),2))+pow(p(7,0),2))+pow(p(8,0),2))+pow(p(0,0),2))-2*p(0,0)*p(6,0))-2*p(1,0)*p(7,0))-2*p(2,0)*p(8,0));
  groebnerMatrix(1,60) = (((((((((((2*l(1,0)*p(1,0)+2*l(2,0)*p(2,0))-2*l(0,0)*p(6,0))-2*p(0,0)*l(6,0))+2*l(6,0)*p(6,0))-2*l(1,0)*p(7,0))-2*p(1,0)*l(7,0))+2*l(7,0)*p(7,0))-2*l(2,0)*p(8,0))-2*p(2,0)*l(8,0))+2*l(8,0)*p(8,0))+2*l(0,0)*p(0,0));
  groebnerMatrix(1,61) = ((((((((pow(l(1,0),2)+pow(l(2,0),2))+pow(l(6,0),2))+pow(l(7,0),2))+pow(l(8,0),2))+pow(l(0,0),2))-2*l(0,0)*l(6,0))-2*l(1,0)*l(7,0))-2*l(2,0)*l(8,0));
  groebnerMatrix(1,62) = (((((((((((2*k(1,0)*p(1,0)+2*k(2,0)*p(2,0))-2*k(0,0)*p(6,0))-2*p(0,0)*k(6,0))+2*k(6,0)*p(6,0))-2*k(1,0)*p(7,0))-2*p(1,0)*k(7,0))+2*k(7,0)*p(7,0))-2*k(2,0)*p(8,0))-2*p(2,0)*k(8,0))+2*k(8,0)*p(8,0))+2*k(0,0)*p(0,0));
  groebnerMatrix(1,63) = (((((((((((2*k(1,0)*l(1,0)+2*k(2,0)*l(2,0))-2*k(0,0)*l(6,0))-2*l(0,0)*k(6,0))+2*k(6,0)*l(6,0))-2*k(1,0)*l(7,0))-2*l(1,0)*k(7,0))+2*k(7,0)*l(7,0))-2*k(2,0)*l(8,0))-2*l(2,0)*k(8,0))+2*k(8,0)*l(8,0))+2*k(0,0)*l(0,0));
  groebnerMatrix(1,64) = ((((((((pow(k(1,0),2)+pow(k(2,0),2))+pow(k(6,0),2))+pow(k(7,0),2))+pow(k(8,0),2))+pow(k(0,0),2))-2*k(0,0)*k(6,0))-2*k(1,0)*k(7,0))-2*k(2,0)*k(8,0));
  groebnerMatrix(1,65) = (((((((((((2*m(1,0)*p(1,0)+2*m(2,0)*p(2,0))-2*m(0,0)*p(6,0))-2*p(0,0)*m(6,0))+2*m(6,0)*p(6,0))-2*m(1,0)*p(7,0))-2*p(1,0)*m(7,0))+2*m(7,0)*p(7,0))-2*m(2,0)*p(8,0))-2*p(2,0)*m(8,0))+2*m(8,0)*p(8,0))+2*m(0,0)*p(0,0));
  groebnerMatrix(1,66) = (((((((((((2*m(1,0)*l(1,0)+2*m(2,0)*l(2,0))-2*m(0,0)*l(6,0))-2*l(0,0)*m(6,0))+2*m(6,0)*l(6,0))-2*m(1,0)*l(7,0))-2*l(1,0)*m(7,0))+2*m(7,0)*l(7,0))-2*m(2,0)*l(8,0))-2*l(2,0)*m(8,0))+2*m(8,0)*l(8,0))+2*m(0,0)*l(0,0));
  groebnerMatrix(1,67) = (((((((((((2*m(1,0)*k(1,0)+2*m(2,0)*k(2,0))-2*m(0,0)*k(6,0))-2*k(0,0)*m(6,0))+2*m(6,0)*k(6,0))-2*m(1,0)*k(7,0))-2*k(1,0)*m(7,0))+2*m(7,0)*k(7,0))-2*m(2,0)*k(8,0))-2*k(2,0)*m(8,0))+2*m(8,0)*k(8,0))+2*m(0,0)*k(0,0));
  groebnerMatrix(1,68) = ((((((((pow(m(1,0),2)+pow(m(2,0),2))+pow(m(6,0),2))+pow(m(7,0),2))+pow(m(8,0),2))+pow(m(0,0),2))-2*m(0,0)*m(6,0))-2*m(1,0)*m(7,0))-2*m(2,0)*m(8,0));
  groebnerMatrix(1,69) = (((((((((((2*n(2,0)*p(2,0)-2*n(0,0)*p(6,0))-2*p(0,0)*n(6,0))+2*n(6,0)*p(6,0))-2*n(1,0)*p(7,0))-2*p(1,0)*n(7,0))+2*n(7,0)*p(7,0))-2*n(2,0)*p(8,0))-2*p(2,0)*n(8,0))+2*n(8,0)*p(8,0))+2*n(0,0)*p(0,0))+2*n(1,0)*p(1,0));
  groebnerMatrix(1,70) = (((((((((((2*n(2,0)*l(2,0)-2*n(0,0)*l(6,0))-2*l(0,0)*n(6,0))+2*n(6,0)*l(6,0))-2*n(1,0)*l(7,0))-2*l(1,0)*n(7,0))+2*n(7,0)*l(7,0))-2*n(2,0)*l(8,0))-2*l(2,0)*n(8,0))+2*n(8,0)*l(8,0))+2*n(0,0)*l(0,0))+2*n(1,0)*l(1,0));
  groebnerMatrix(1,71) = (((((((((((2*n(2,0)*k(2,0)-2*n(0,0)*k(6,0))-2*k(0,0)*n(6,0))+2*n(6,0)*k(6,0))-2*n(1,0)*k(7,0))-2*k(1,0)*n(7,0))+2*n(7,0)*k(7,0))-2*n(2,0)*k(8,0))-2*k(2,0)*n(8,0))+2*n(8,0)*k(8,0))+2*n(0,0)*k(0,0))+2*n(1,0)*k(1,0));
  groebnerMatrix(1,72) = (((((((((((2*n(2,0)*m(2,0)-2*n(0,0)*m(6,0))-2*m(0,0)*n(6,0))+2*n(6,0)*m(6,0))-2*n(1,0)*m(7,0))-2*m(1,0)*n(7,0))+2*n(7,0)*m(7,0))-2*n(2,0)*m(8,0))-2*m(2,0)*n(8,0))+2*n(8,0)*m(8,0))+2*n(0,0)*m(0,0))+2*n(1,0)*m(1,0));
  groebnerMatrix(1,73) = ((((((((pow(n(1,0),2)+pow(n(2,0),2))+pow(n(6,0),2))+pow(n(7,0),2))+pow(n(8,0),2))+pow(n(0,0),2))-2*n(0,0)*n(6,0))-2*n(1,0)*n(7,0))-2*n(2,0)*n(8,0));
  groebnerMatrix(1,74) = (((((((((((-2*a(0,0)*p(6,0)+2*a(0,0)*p(0,0))+2*a(1,0)*p(1,0))+2*a(2,0)*p(2,0))-2*p(0,0)*a(6,0))+2*a(6,0)*p(6,0))-2*a(1,0)*p(7,0))-2*p(1,0)*a(7,0))+2*a(7,0)*p(7,0))-2*a(2,0)*p(8,0))-2*p(2,0)*a(8,0))+2*a(8,0)*p(8,0));
  groebnerMatrix(1,75) = (((((((((((2*a(0,0)*l(0,0)+2*a(1,0)*l(1,0))+2*a(2,0)*l(2,0))-2*l(0,0)*a(6,0))+2*a(6,0)*l(6,0))-2*a(1,0)*l(7,0))-2*l(1,0)*a(7,0))+2*a(7,0)*l(7,0))-2*a(2,0)*l(8,0))-2*l(2,0)*a(8,0))+2*a(8,0)*l(8,0))-2*a(0,0)*l(6,0));
  groebnerMatrix(1,76) = (((((((((((-2*a(0,0)*k(6,0)+2*a(0,0)*k(0,0))+2*a(1,0)*k(1,0))+2*a(2,0)*k(2,0))-2*k(0,0)*a(6,0))+2*a(6,0)*k(6,0))-2*a(1,0)*k(7,0))-2*k(1,0)*a(7,0))+2*a(7,0)*k(7,0))-2*a(2,0)*k(8,0))-2*k(2,0)*a(8,0))+2*a(8,0)*k(8,0));
  groebnerMatrix(1,77) = (((((((((((2*a(0,0)*m(0,0)+2*a(1,0)*m(1,0))+2*a(2,0)*m(2,0))-2*m(0,0)*a(6,0))+2*a(6,0)*m(6,0))-2*a(1,0)*m(7,0))-2*m(1,0)*a(7,0))+2*a(7,0)*m(7,0))-2*a(2,0)*m(8,0))-2*m(2,0)*a(8,0))+2*a(8,0)*m(8,0))-2*a(0,0)*m(6,0));
  groebnerMatrix(1,78) = (((((((((((2*a(0,0)*n(0,0)+2*a(1,0)*n(1,0))+2*a(2,0)*n(2,0))-2*n(0,0)*a(6,0))+2*a(6,0)*n(6,0))-2*a(1,0)*n(7,0))-2*n(1,0)*a(7,0))+2*a(7,0)*n(7,0))-2*a(2,0)*n(8,0))-2*n(2,0)*a(8,0))+2*a(8,0)*n(8,0))-2*a(0,0)*n(6,0));
  groebnerMatrix(1,79) = (((((((((-c02w+pow(a(2,0),2))-2*a(0,0)*a(6,0))+pow(a(6,0),2))-2*a(1,0)*a(7,0))+pow(a(7,0),2))-2*a(2,0)*a(8,0))+pow(a(8,0),2))+pow(a(0,0),2))+pow(a(1,0),2));
  groebnerMatrix(2,59) = ((((((((pow(p(1,0),2)+pow(p(2,0),2))+pow(p(9,0),2))+pow(p(10,0),2))+pow(p(11,0),2))+pow(p(0,0),2))-2*p(0,0)*p(9,0))-2*p(1,0)*p(10,0))-2*p(2,0)*p(11,0));
  groebnerMatrix(2,60) = (((((((((((2*l(1,0)*p(1,0)+2*l(2,0)*p(2,0))-2*l(0,0)*p(9,0))-2*p(0,0)*l(9,0))+2*l(9,0)*p(9,0))-2*l(1,0)*p(10,0))-2*p(1,0)*l(10,0))+2*l(10,0)*p(10,0))-2*l(2,0)*p(11,0))-2*p(2,0)*l(11,0))+2*l(11,0)*p(11,0))+2*l(0,0)*p(0,0));
  groebnerMatrix(2,61) = ((((((((pow(l(1,0),2)+pow(l(2,0),2))+pow(l(9,0),2))+pow(l(10,0),2))+pow(l(11,0),2))+pow(l(0,0),2))-2*l(0,0)*l(9,0))-2*l(1,0)*l(10,0))-2*l(2,0)*l(11,0));
  groebnerMatrix(2,62) = (((((((((((2*k(1,0)*p(1,0)+2*k(2,0)*p(2,0))-2*k(0,0)*p(9,0))-2*p(0,0)*k(9,0))+2*k(9,0)*p(9,0))-2*k(1,0)*p(10,0))-2*p(1,0)*k(10,0))+2*k(10,0)*p(10,0))-2*k(2,0)*p(11,0))-2*p(2,0)*k(11,0))+2*k(11,0)*p(11,0))+2*k(0,0)*p(0,0));
  groebnerMatrix(2,63) = (((((((((((2*k(1,0)*l(1,0)+2*k(2,0)*l(2,0))-2*k(0,0)*l(9,0))-2*l(0,0)*k(9,0))+2*k(9,0)*l(9,0))-2*k(1,0)*l(10,0))-2*l(1,0)*k(10,0))+2*k(10,0)*l(10,0))-2*k(2,0)*l(11,0))-2*l(2,0)*k(11,0))+2*k(11,0)*l(11,0))+2*k(0,0)*l(0,0));
  groebnerMatrix(2,64) = ((((((((-2*k(0,0)*k(9,0)+pow(k(1,0),2))+pow(k(2,0),2))+pow(k(9,0),2))+pow(k(10,0),2))+pow(k(11,0),2))+pow(k(0,0),2))-2*k(1,0)*k(10,0))-2*k(2,0)*k(11,0));
  groebnerMatrix(2,65) = (((((((((((-2*m(0,0)*p(9,0)+2*m(1,0)*p(1,0))+2*m(2,0)*p(2,0))-2*p(0,0)*m(9,0))+2*m(9,0)*p(9,0))-2*m(1,0)*p(10,0))-2*p(1,0)*m(10,0))+2*m(10,0)*p(10,0))-2*m(2,0)*p(11,0))-2*p(2,0)*m(11,0))+2*m(11,0)*p(11,0))+2*m(0,0)*p(0,0));
  groebnerMatrix(2,66) = (((((((((((-2*m(0,0)*l(9,0)+2*m(1,0)*l(1,0))+2*m(2,0)*l(2,0))-2*l(0,0)*m(9,0))+2*m(9,0)*l(9,0))-2*m(1,0)*l(10,0))-2*l(1,0)*m(10,0))+2*m(10,0)*l(10,0))-2*m(2,0)*l(11,0))-2*l(2,0)*m(11,0))+2*m(11,0)*l(11,0))+2*m(0,0)*l(0,0));
  groebnerMatrix(2,67) = (((((((((((-2*m(0,0)*k(9,0)+2*m(1,0)*k(1,0))+2*m(2,0)*k(2,0))-2*k(0,0)*m(9,0))+2*m(9,0)*k(9,0))-2*m(1,0)*k(10,0))-2*k(1,0)*m(10,0))+2*m(10,0)*k(10,0))-2*m(2,0)*k(11,0))-2*k(2,0)*m(11,0))+2*m(11,0)*k(11,0))+2*m(0,0)*k(0,0));
  groebnerMatrix(2,68) = ((((((((pow(m(1,0),2)+pow(m(2,0),2))+pow(m(9,0),2))+pow(m(10,0),2))+pow(m(11,0),2))+pow(m(0,0),2))-2*m(1,0)*m(10,0))-2*m(2,0)*m(11,0))-2*m(0,0)*m(9,0));
  groebnerMatrix(2,69) = (((((((((((-2*n(0,0)*p(9,0)+2*n(2,0)*p(2,0))-2*p(0,0)*n(9,0))+2*n(9,0)*p(9,0))-2*n(1,0)*p(10,0))-2*p(1,0)*n(10,0))+2*n(10,0)*p(10,0))-2*n(2,0)*p(11,0))-2*p(2,0)*n(11,0))+2*n(11,0)*p(11,0))+2*n(0,0)*p(0,0))+2*n(1,0)*p(1,0));
  groebnerMatrix(2,70) = (((((((((((-2*n(0,0)*l(9,0)+2*n(2,0)*l(2,0))-2*l(0,0)*n(9,0))+2*n(9,0)*l(9,0))-2*n(1,0)*l(10,0))-2*l(1,0)*n(10,0))+2*n(10,0)*l(10,0))-2*n(2,0)*l(11,0))-2*l(2,0)*n(11,0))+2*n(11,0)*l(11,0))+2*n(0,0)*l(0,0))+2*n(1,0)*l(1,0));
  groebnerMatrix(2,71) = (((((((((((-2*n(0,0)*k(9,0)+2*n(2,0)*k(2,0))-2*k(0,0)*n(9,0))+2*n(9,0)*k(9,0))-2*n(1,0)*k(10,0))-2*k(1,0)*n(10,0))+2*n(10,0)*k(10,0))-2*n(2,0)*k(11,0))-2*k(2,0)*n(11,0))+2*n(11,0)*k(11,0))+2*n(0,0)*k(0,0))+2*n(1,0)*k(1,0));
  groebnerMatrix(2,72) = (((((((((((-2*n(0,0)*m(9,0)-2*m(0,0)*n(9,0))+2*n(2,0)*m(2,0))+2*n(9,0)*m(9,0))-2*n(1,0)*m(10,0))-2*m(1,0)*n(10,0))+2*n(10,0)*m(10,0))-2*n(2,0)*m(11,0))-2*m(2,0)*n(11,0))+2*n(11,0)*m(11,0))+2*n(0,0)*m(0,0))+2*n(1,0)*m(1,0));
  groebnerMatrix(2,73) = ((((((((pow(n(1,0),2)+pow(n(2,0),2))+pow(n(9,0),2))+pow(n(10,0),2))+pow(n(11,0),2))+pow(n(0,0),2))-2*n(1,0)*n(10,0))-2*n(2,0)*n(11,0))-2*n(0,0)*n(9,0));
  groebnerMatrix(2,74) = (((((((((((-2*a(0,0)*p(9,0)+2*a(0,0)*p(0,0))+2*a(1,0)*p(1,0))+2*a(2,0)*p(2,0))-2*p(0,0)*a(9,0))+2*a(9,0)*p(9,0))-2*a(1,0)*p(10,0))-2*p(1,0)*a(10,0))+2*a(10,0)*p(10,0))-2*a(2,0)*p(11,0))-2*p(2,0)*a(11,0))+2*a(11,0)*p(11,0));
  groebnerMatrix(2,75) = (((((((((((-2*a(0,0)*l(9,0)+2*a(0,0)*l(0,0))+2*a(1,0)*l(1,0))+2*a(2,0)*l(2,0))-2*l(0,0)*a(9,0))+2*a(9,0)*l(9,0))-2*a(1,0)*l(10,0))-2*l(1,0)*a(10,0))+2*a(10,0)*l(10,0))-2*a(2,0)*l(11,0))-2*l(2,0)*a(11,0))+2*a(11,0)*l(11,0));
  groebnerMatrix(2,76) = (((((((((((2*a(0,0)*k(0,0)+2*a(1,0)*k(1,0))+2*a(2,0)*k(2,0))+2*a(9,0)*k(9,0))-2*a(1,0)*k(10,0))-2*k(1,0)*a(10,0))+2*a(10,0)*k(10,0))-2*a(2,0)*k(11,0))-2*k(2,0)*a(11,0))+2*a(11,0)*k(11,0))-2*k(0,0)*a(9,0))-2*a(0,0)*k(9,0));
  groebnerMatrix(2,77) = (((((((((((2*a(0,0)*m(0,0)+2*a(1,0)*m(1,0))+2*a(2,0)*m(2,0))+2*a(9,0)*m(9,0))-2*a(1,0)*m(10,0))-2*m(1,0)*a(10,0))+2*a(10,0)*m(10,0))-2*a(2,0)*m(11,0))-2*m(2,0)*a(11,0))+2*a(11,0)*m(11,0))-2*m(0,0)*a(9,0))-2*a(0,0)*m(9,0));
  groebnerMatrix(2,78) = (((((((((((-2*a(0,0)*n(9,0)+2*a(0,0)*n(0,0))+2*a(1,0)*n(1,0))+2*a(2,0)*n(2,0))+2*a(9,0)*n(9,0))-2*a(1,0)*n(10,0))-2*n(1,0)*a(10,0))+2*a(10,0)*n(10,0))-2*a(2,0)*n(11,0))-2*n(2,0)*a(11,0))+2*a(11,0)*n(11,0))-2*n(0,0)*a(9,0));
  groebnerMatrix(2,79) = (((((((((-c03w+pow(a(2,0),2))-2*a(0,0)*a(9,0))+pow(a(9,0),2))-2*a(1,0)*a(10,0))+pow(a(10,0),2))-2*a(2,0)*a(11,0))+pow(a(11,0),2))+pow(a(0,0),2))+pow(a(1,0),2));
  groebnerMatrix(3,59) = ((((((((pow(p(4,0),2)+pow(p(5,0),2))+pow(p(6,0),2))+pow(p(7,0),2))+pow(p(8,0),2))+pow(p(3,0),2))-2*p(3,0)*p(6,0))-2*p(4,0)*p(7,0))-2*p(5,0)*p(8,0));
  groebnerMatrix(3,60) = (((((((((((2*l(4,0)*p(4,0)+2*l(5,0)*p(5,0))+2*l(6,0)*p(6,0))+2*l(7,0)*p(7,0))+2*l(8,0)*p(8,0))-2*l(4,0)*p(7,0))-2*p(4,0)*l(7,0))-2*l(3,0)*p(6,0))-2*p(3,0)*l(6,0))-2*l(5,0)*p(8,0))-2*p(5,0)*l(8,0))+2*l(3,0)*p(3,0));
  groebnerMatrix(3,61) = ((((((((pow(l(4,0),2)+pow(l(5,0),2))+pow(l(6,0),2))+pow(l(7,0),2))+pow(l(8,0),2))+pow(l(3,0),2))-2*l(3,0)*l(6,0))-2*l(4,0)*l(7,0))-2*l(5,0)*l(8,0));
  groebnerMatrix(3,62) = (((((((((((2*k(4,0)*p(4,0)+2*k(5,0)*p(5,0))+2*k(6,0)*p(6,0))+2*k(7,0)*p(7,0))+2*k(8,0)*p(8,0))-2*k(5,0)*p(8,0))-2*k(4,0)*p(7,0))-2*p(4,0)*k(7,0))-2*k(3,0)*p(6,0))-2*p(3,0)*k(6,0))-2*p(5,0)*k(8,0))+2*k(3,0)*p(3,0));
  groebnerMatrix(3,63) = (((((((((((2*k(4,0)*l(4,0)+2*k(5,0)*l(5,0))+2*k(6,0)*l(6,0))+2*k(7,0)*l(7,0))+2*k(8,0)*l(8,0))-2*k(5,0)*l(8,0))-2*k(4,0)*l(7,0))-2*l(4,0)*k(7,0))-2*k(3,0)*l(6,0))-2*l(3,0)*k(6,0))-2*l(5,0)*k(8,0))+2*k(3,0)*l(3,0));
  groebnerMatrix(3,64) = ((((((((pow(k(4,0),2)+pow(k(5,0),2))+pow(k(6,0),2))+pow(k(7,0),2))+pow(k(8,0),2))+pow(k(3,0),2))-2*k(5,0)*k(8,0))-2*k(3,0)*k(6,0))-2*k(4,0)*k(7,0));
  groebnerMatrix(3,65) = (((((((((((2*m(4,0)*p(4,0)+2*m(5,0)*p(5,0))+2*m(6,0)*p(6,0))+2*m(7,0)*p(7,0))+2*m(8,0)*p(8,0))-2*m(4,0)*p(7,0))-2*p(4,0)*m(7,0))-2*m(5,0)*p(8,0))-2*m(3,0)*p(6,0))-2*p(3,0)*m(6,0))-2*p(5,0)*m(8,0))+2*m(3,0)*p(3,0));
  groebnerMatrix(3,66) = (((((((((((2*m(4,0)*l(4,0)+2*m(5,0)*l(5,0))+2*m(6,0)*l(6,0))+2*m(7,0)*l(7,0))+2*m(8,0)*l(8,0))-2*m(4,0)*l(7,0))-2*l(4,0)*m(7,0))-2*m(5,0)*l(8,0))-2*m(3,0)*l(6,0))-2*l(3,0)*m(6,0))-2*l(5,0)*m(8,0))+2*m(3,0)*l(3,0));
  groebnerMatrix(3,67) = (((((((((((2*m(4,0)*k(4,0)+2*m(5,0)*k(5,0))+2*m(6,0)*k(6,0))+2*m(7,0)*k(7,0))+2*m(8,0)*k(8,0))-2*k(5,0)*m(8,0))-2*m(4,0)*k(7,0))-2*k(4,0)*m(7,0))-2*m(5,0)*k(8,0))-2*m(3,0)*k(6,0))-2*k(3,0)*m(6,0))+2*m(3,0)*k(3,0));
  groebnerMatrix(3,68) = ((((((((pow(m(4,0),2)+pow(m(5,0),2))+pow(m(6,0),2))+pow(m(7,0),2))+pow(m(8,0),2))+pow(m(3,0),2))-2*m(3,0)*m(6,0))-2*m(4,0)*m(7,0))-2*m(5,0)*m(8,0));
  groebnerMatrix(3,69) = (((((((((((2*n(4,0)*p(4,0)+2*n(5,0)*p(5,0))+2*n(6,0)*p(6,0))+2*n(7,0)*p(7,0))+2*n(8,0)*p(8,0))-2*p(4,0)*n(7,0))-2*n(5,0)*p(8,0))-2*n(3,0)*p(6,0))-2*p(3,0)*n(6,0))-2*n(4,0)*p(7,0))-2*p(5,0)*n(8,0))+2*n(3,0)*p(3,0));
  groebnerMatrix(3,70) = (((((((((((2*n(4,0)*l(4,0)+2*n(5,0)*l(5,0))+2*n(6,0)*l(6,0))+2*n(7,0)*l(7,0))+2*n(8,0)*l(8,0))-2*l(4,0)*n(7,0))-2*n(5,0)*l(8,0))-2*n(3,0)*l(6,0))-2*l(3,0)*n(6,0))-2*n(4,0)*l(7,0))-2*l(5,0)*n(8,0))+2*n(3,0)*l(3,0));
  groebnerMatrix(3,71) = (((((((((((2*n(4,0)*k(4,0)+2*n(5,0)*k(5,0))+2*n(6,0)*k(6,0))+2*n(7,0)*k(7,0))+2*n(8,0)*k(8,0))-2*k(5,0)*n(8,0))-2*k(4,0)*n(7,0))-2*n(5,0)*k(8,0))-2*n(3,0)*k(6,0))-2*k(3,0)*n(6,0))-2*n(4,0)*k(7,0))+2*n(3,0)*k(3,0));
  groebnerMatrix(3,72) = (((((((((((2*n(4,0)*m(4,0)+2*n(5,0)*m(5,0))+2*n(6,0)*m(6,0))+2*n(7,0)*m(7,0))+2*n(8,0)*m(8,0))-2*m(4,0)*n(7,0))-2*n(5,0)*m(8,0))-2*m(5,0)*n(8,0))-2*n(3,0)*m(6,0))-2*m(3,0)*n(6,0))-2*n(4,0)*m(7,0))+2*n(3,0)*m(3,0));
  groebnerMatrix(3,73) = ((((((((pow(n(4,0),2)+pow(n(5,0),2))+pow(n(6,0),2))+pow(n(7,0),2))+pow(n(8,0),2))+pow(n(3,0),2))-2*n(3,0)*n(6,0))-2*n(4,0)*n(7,0))-2*n(5,0)*n(8,0));
  groebnerMatrix(3,74) = (((((((((((-2*a(3,0)*p(6,0)+2*a(3,0)*p(3,0))+2*a(4,0)*p(4,0))+2*a(5,0)*p(5,0))+2*a(6,0)*p(6,0))+2*a(7,0)*p(7,0))+2*a(8,0)*p(8,0))-2*p(3,0)*a(6,0))-2*a(4,0)*p(7,0))-2*p(4,0)*a(7,0))-2*a(5,0)*p(8,0))-2*p(5,0)*a(8,0));
  groebnerMatrix(3,75) = (((((((((((2*a(3,0)*l(3,0)+2*a(4,0)*l(4,0))+2*a(5,0)*l(5,0))+2*a(6,0)*l(6,0))+2*a(7,0)*l(7,0))+2*a(8,0)*l(8,0))-2*l(3,0)*a(6,0))-2*a(4,0)*l(7,0))-2*l(4,0)*a(7,0))-2*a(5,0)*l(8,0))-2*l(5,0)*a(8,0))-2*a(3,0)*l(6,0));
  groebnerMatrix(3,76) = (((((((((((2*a(3,0)*k(3,0)-2*k(5,0)*a(8,0))+2*a(4,0)*k(4,0))+2*a(5,0)*k(5,0))+2*a(6,0)*k(6,0))+2*a(7,0)*k(7,0))+2*a(8,0)*k(8,0))-2*k(3,0)*a(6,0))-2*a(4,0)*k(7,0))-2*k(4,0)*a(7,0))-2*a(5,0)*k(8,0))-2*a(3,0)*k(6,0));
  groebnerMatrix(3,77) = (((((((((((2*a(3,0)*m(3,0)+2*a(4,0)*m(4,0))+2*a(5,0)*m(5,0))+2*a(6,0)*m(6,0))+2*a(7,0)*m(7,0))+2*a(8,0)*m(8,0))-2*m(3,0)*a(6,0))-2*a(4,0)*m(7,0))-2*m(4,0)*a(7,0))-2*a(5,0)*m(8,0))-2*m(5,0)*a(8,0))-2*a(3,0)*m(6,0));
  groebnerMatrix(3,78) = (((((((((((2*a(3,0)*n(3,0)+2*a(4,0)*n(4,0))+2*a(5,0)*n(5,0))+2*a(6,0)*n(6,0))+2*a(7,0)*n(7,0))+2*a(8,0)*n(8,0))-2*n(3,0)*a(6,0))-2*a(4,0)*n(7,0))-2*n(4,0)*a(7,0))-2*a(5,0)*n(8,0))-2*n(5,0)*a(8,0))-2*a(3,0)*n(6,0));
  groebnerMatrix(3,79) = (((((((((-c12w+pow(a(4,0),2))+pow(a(5,0),2))+pow(a(6,0),2))+pow(a(7,0),2))+pow(a(8,0),2))-2*a(3,0)*a(6,0))-2*a(4,0)*a(7,0))+pow(a(3,0),2))-2*a(5,0)*a(8,0));
  groebnerMatrix(4,59) = ((((((((pow(p(4,0),2)+pow(p(5,0),2))+pow(p(9,0),2))+pow(p(10,0),2))+pow(p(11,0),2))+pow(p(3,0),2))-2*p(3,0)*p(9,0))-2*p(4,0)*p(10,0))-2*p(5,0)*p(11,0));
  groebnerMatrix(4,60) = (((((((((((2*l(4,0)*p(4,0)+2*l(5,0)*p(5,0))+2*l(9,0)*p(9,0))+2*l(10,0)*p(10,0))+2*l(11,0)*p(11,0))-2*l(3,0)*p(9,0))-2*p(3,0)*l(9,0))-2*l(4,0)*p(10,0))-2*p(4,0)*l(10,0))-2*l(5,0)*p(11,0))-2*p(5,0)*l(11,0))+2*l(3,0)*p(3,0));
  groebnerMatrix(4,61) = ((((((((pow(l(4,0),2)+pow(l(5,0),2))+pow(l(9,0),2))+pow(l(10,0),2))+pow(l(11,0),2))+pow(l(3,0),2))-2*l(3,0)*l(9,0))-2*l(4,0)*l(10,0))-2*l(5,0)*l(11,0));
  groebnerMatrix(4,62) = (((((((((((2*k(4,0)*p(4,0)+2*k(5,0)*p(5,0))+2*k(9,0)*p(9,0))+2*k(10,0)*p(10,0))+2*k(11,0)*p(11,0))-2*k(3,0)*p(9,0))-2*p(3,0)*k(9,0))-2*k(4,0)*p(10,0))-2*p(4,0)*k(10,0))-2*k(5,0)*p(11,0))-2*p(5,0)*k(11,0))+2*k(3,0)*p(3,0));
  groebnerMatrix(4,63) = (((((((((((2*k(4,0)*l(4,0)+2*k(5,0)*l(5,0))+2*k(9,0)*l(9,0))+2*k(10,0)*l(10,0))+2*k(11,0)*l(11,0))-2*k(3,0)*l(9,0))-2*l(3,0)*k(9,0))-2*k(4,0)*l(10,0))-2*l(4,0)*k(10,0))-2*k(5,0)*l(11,0))-2*l(5,0)*k(11,0))+2*k(3,0)*l(3,0));
  groebnerMatrix(4,64) = ((((((((pow(k(4,0),2)+pow(k(5,0),2))+pow(k(9,0),2))+pow(k(10,0),2))+pow(k(11,0),2))+pow(k(3,0),2))-2*k(3,0)*k(9,0))-2*k(4,0)*k(10,0))-2*k(5,0)*k(11,0));
  groebnerMatrix(4,65) = (((((((((((2*m(4,0)*p(4,0)+2*m(5,0)*p(5,0))+2*m(9,0)*p(9,0))+2*m(10,0)*p(10,0))+2*m(11,0)*p(11,0))-2*m(3,0)*p(9,0))-2*p(3,0)*m(9,0))-2*m(4,0)*p(10,0))-2*p(4,0)*m(10,0))-2*m(5,0)*p(11,0))-2*p(5,0)*m(11,0))+2*m(3,0)*p(3,0));
  groebnerMatrix(4,66) = (((((((((((2*m(4,0)*l(4,0)+2*m(5,0)*l(5,0))+2*m(9,0)*l(9,0))+2*m(10,0)*l(10,0))+2*m(11,0)*l(11,0))-2*m(3,0)*l(9,0))-2*l(3,0)*m(9,0))-2*m(4,0)*l(10,0))-2*l(4,0)*m(10,0))-2*m(5,0)*l(11,0))-2*l(5,0)*m(11,0))+2*m(3,0)*l(3,0));
  groebnerMatrix(4,67) = (((((((((((2*m(4,0)*k(4,0)+2*m(5,0)*k(5,0))+2*m(9,0)*k(9,0))+2*m(10,0)*k(10,0))+2*m(11,0)*k(11,0))-2*m(3,0)*k(9,0))-2*k(3,0)*m(9,0))-2*m(4,0)*k(10,0))-2*k(4,0)*m(10,0))-2*m(5,0)*k(11,0))-2*k(5,0)*m(11,0))+2*m(3,0)*k(3,0));
  groebnerMatrix(4,68) = ((((((((pow(m(4,0),2)+pow(m(5,0),2))+pow(m(9,0),2))+pow(m(10,0),2))+pow(m(11,0),2))+pow(m(3,0),2))-2*m(3,0)*m(9,0))-2*m(4,0)*m(10,0))-2*m(5,0)*m(11,0));
  groebnerMatrix(4,69) = (((((((((((2*n(4,0)*p(4,0)+2*n(5,0)*p(5,0))+2*n(9,0)*p(9,0))+2*n(10,0)*p(10,0))+2*n(11,0)*p(11,0))-2*n(3,0)*p(9,0))-2*p(3,0)*n(9,0))-2*n(4,0)*p(10,0))-2*p(4,0)*n(10,0))-2*n(5,0)*p(11,0))-2*p(5,0)*n(11,0))+2*n(3,0)*p(3,0));
  groebnerMatrix(4,70) = (((((((((((2*n(4,0)*l(4,0)+2*n(5,0)*l(5,0))+2*n(9,0)*l(9,0))+2*n(10,0)*l(10,0))+2*n(11,0)*l(11,0))-2*n(3,0)*l(9,0))-2*l(3,0)*n(9,0))-2*n(4,0)*l(10,0))-2*l(4,0)*n(10,0))-2*n(5,0)*l(11,0))-2*l(5,0)*n(11,0))+2*n(3,0)*l(3,0));
  groebnerMatrix(4,71) = (((((((((((2*n(4,0)*k(4,0)+2*n(5,0)*k(5,0))+2*n(9,0)*k(9,0))+2*n(10,0)*k(10,0))+2*n(11,0)*k(11,0))-2*n(3,0)*k(9,0))-2*k(3,0)*n(9,0))-2*n(4,0)*k(10,0))-2*k(4,0)*n(10,0))-2*n(5,0)*k(11,0))-2*k(5,0)*n(11,0))+2*n(3,0)*k(3,0));
  groebnerMatrix(4,72) = (((((((((((2*n(4,0)*m(4,0)+2*n(5,0)*m(5,0))+2*n(9,0)*m(9,0))+2*n(10,0)*m(10,0))+2*n(11,0)*m(11,0))-2*n(3,0)*m(9,0))-2*m(3,0)*n(9,0))-2*n(4,0)*m(10,0))-2*m(4,0)*n(10,0))-2*n(5,0)*m(11,0))-2*m(5,0)*n(11,0))+2*n(3,0)*m(3,0));
  groebnerMatrix(4,73) = ((((((((pow(n(4,0),2)+pow(n(5,0),2))+pow(n(9,0),2))+pow(n(10,0),2))+pow(n(11,0),2))+pow(n(3,0),2))-2*n(3,0)*n(9,0))-2*n(4,0)*n(10,0))-2*n(5,0)*n(11,0));
  groebnerMatrix(4,74) = (((((((((((2*a(3,0)*p(3,0)+2*a(4,0)*p(4,0))+2*a(5,0)*p(5,0))+2*a(9,0)*p(9,0))+2*a(10,0)*p(10,0))+2*a(11,0)*p(11,0))-2*a(3,0)*p(9,0))-2*p(3,0)*a(9,0))-2*a(4,0)*p(10,0))-2*p(4,0)*a(10,0))-2*a(5,0)*p(11,0))-2*p(5,0)*a(11,0));
  groebnerMatrix(4,75) = (((((((((((2*a(3,0)*l(3,0)+2*a(4,0)*l(4,0))+2*a(5,0)*l(5,0))+2*a(9,0)*l(9,0))+2*a(10,0)*l(10,0))+2*a(11,0)*l(11,0))-2*a(3,0)*l(9,0))-2*l(3,0)*a(9,0))-2*a(4,0)*l(10,0))-2*l(4,0)*a(10,0))-2*a(5,0)*l(11,0))-2*l(5,0)*a(11,0));
  groebnerMatrix(4,76) = (((((((((((2*a(3,0)*k(3,0)+2*a(4,0)*k(4,0))+2*a(5,0)*k(5,0))+2*a(9,0)*k(9,0))+2*a(10,0)*k(10,0))+2*a(11,0)*k(11,0))-2*a(3,0)*k(9,0))-2*k(3,0)*a(9,0))-2*a(4,0)*k(10,0))-2*k(4,0)*a(10,0))-2*a(5,0)*k(11,0))-2*k(5,0)*a(11,0));
  groebnerMatrix(4,77) = (((((((((((2*a(3,0)*m(3,0)+2*a(4,0)*m(4,0))+2*a(5,0)*m(5,0))+2*a(9,0)*m(9,0))+2*a(10,0)*m(10,0))+2*a(11,0)*m(11,0))-2*a(3,0)*m(9,0))-2*m(3,0)*a(9,0))-2*a(4,0)*m(10,0))-2*m(4,0)*a(10,0))-2*a(5,0)*m(11,0))-2*m(5,0)*a(11,0));
  groebnerMatrix(4,78) = (((((((((((2*a(3,0)*n(3,0)+2*a(4,0)*n(4,0))+2*a(5,0)*n(5,0))+2*a(9,0)*n(9,0))+2*a(10,0)*n(10,0))+2*a(11,0)*n(11,0))-2*a(3,0)*n(9,0))-2*n(3,0)*a(9,0))-2*a(4,0)*n(10,0))-2*n(4,0)*a(10,0))-2*a(5,0)*n(11,0))-2*n(5,0)*a(11,0));
  groebnerMatrix(4,79) = (((((((((-c13w+pow(a(4,0),2))+pow(a(5,0),2))+pow(a(9,0),2))+pow(a(10,0),2))+pow(a(11,0),2))+pow(a(3,0),2))-2*a(3,0)*a(9,0))-2*a(4,0)*a(10,0))-2*a(5,0)*a(11,0));
  groebnerMatrix(5,59) = ((((((((pow(p(6,0),2)+pow(p(7,0),2))+pow(p(8,0),2))+pow(p(9,0),2))+pow(p(10,0),2))+pow(p(11,0),2))-2*p(8,0)*p(11,0))-2*p(6,0)*p(9,0))-2*p(7,0)*p(10,0));
  groebnerMatrix(5,60) = (((((((((((2*l(6,0)*p(6,0)+2*l(7,0)*p(7,0))+2*l(8,0)*p(8,0))+2*l(9,0)*p(9,0))+2*l(10,0)*p(10,0))+2*l(11,0)*p(11,0))-2*l(6,0)*p(9,0))-2*p(6,0)*l(9,0))-2*l(7,0)*p(10,0))-2*p(7,0)*l(10,0))-2*l(8,0)*p(11,0))-2*p(8,0)*l(11,0));
  groebnerMatrix(5,61) = ((((((((pow(l(6,0),2)+pow(l(7,0),2))+pow(l(8,0),2))+pow(l(9,0),2))+pow(l(10,0),2))+pow(l(11,0),2))-2*l(8,0)*l(11,0))-2*l(6,0)*l(9,0))-2*l(7,0)*l(10,0));
  groebnerMatrix(5,62) = (((((((((((2*k(6,0)*p(6,0)+2*k(7,0)*p(7,0))+2*k(8,0)*p(8,0))+2*k(9,0)*p(9,0))+2*k(10,0)*p(10,0))+2*k(11,0)*p(11,0))-2*k(7,0)*p(10,0))-2*k(6,0)*p(9,0))-2*p(6,0)*k(9,0))-2*p(7,0)*k(10,0))-2*k(8,0)*p(11,0))-2*p(8,0)*k(11,0));
  groebnerMatrix(5,63) = (((((((((((2*k(6,0)*l(6,0)+2*k(7,0)*l(7,0))+2*k(8,0)*l(8,0))+2*k(9,0)*l(9,0))+2*k(10,0)*l(10,0))+2*k(11,0)*l(11,0))-2*k(7,0)*l(10,0))-2*l(7,0)*k(10,0))-2*k(6,0)*l(9,0))-2*l(6,0)*k(9,0))-2*k(8,0)*l(11,0))-2*l(8,0)*k(11,0));
  groebnerMatrix(5,64) = ((((((((pow(k(6,0),2)+pow(k(7,0),2))+pow(k(8,0),2))+pow(k(9,0),2))+pow(k(10,0),2))+pow(k(11,0),2))-2*k(8,0)*k(11,0))-2*k(6,0)*k(9,0))-2*k(7,0)*k(10,0));
  groebnerMatrix(5,65) = (((((((((((2*m(6,0)*p(6,0)+2*m(7,0)*p(7,0))+2*m(8,0)*p(8,0))+2*m(9,0)*p(9,0))+2*m(10,0)*p(10,0))+2*m(11,0)*p(11,0))-2*m(6,0)*p(9,0))-2*p(6,0)*m(9,0))-2*m(7,0)*p(10,0))-2*p(7,0)*m(10,0))-2*m(8,0)*p(11,0))-2*p(8,0)*m(11,0));
  groebnerMatrix(5,66) = (((((((((((2*m(6,0)*l(6,0)+2*m(7,0)*l(7,0))+2*m(8,0)*l(8,0))+2*m(9,0)*l(9,0))+2*m(10,0)*l(10,0))+2*m(11,0)*l(11,0))-2*l(7,0)*m(10,0))-2*m(6,0)*l(9,0))-2*l(6,0)*m(9,0))-2*m(7,0)*l(10,0))-2*m(8,0)*l(11,0))-2*l(8,0)*m(11,0));
  groebnerMatrix(5,67) = (((((((((((2*m(6,0)*k(6,0)+2*m(7,0)*k(7,0))+2*m(8,0)*k(8,0))+2*m(9,0)*k(9,0))+2*m(10,0)*k(10,0))+2*m(11,0)*k(11,0))-2*k(7,0)*m(10,0))-2*m(6,0)*k(9,0))-2*k(6,0)*m(9,0))-2*m(7,0)*k(10,0))-2*m(8,0)*k(11,0))-2*k(8,0)*m(11,0));
  groebnerMatrix(5,68) = ((((((((pow(m(6,0),2)+pow(m(7,0),2))+pow(m(8,0),2))+pow(m(9,0),2))+pow(m(10,0),2))+pow(m(11,0),2))-2*m(8,0)*m(11,0))-2*m(6,0)*m(9,0))-2*m(7,0)*m(10,0));
  groebnerMatrix(5,69) = (((((((((((2*n(6,0)*p(6,0)+2*n(7,0)*p(7,0))+2*n(8,0)*p(8,0))+2*n(9,0)*p(9,0))+2*n(10,0)*p(10,0))+2*n(11,0)*p(11,0))-2*n(6,0)*p(9,0))-2*p(6,0)*n(9,0))-2*n(7,0)*p(10,0))-2*p(7,0)*n(10,0))-2*n(8,0)*p(11,0))-2*p(8,0)*n(11,0));
  groebnerMatrix(5,70) = (((((((((((2*n(6,0)*l(6,0)+2*n(7,0)*l(7,0))+2*n(8,0)*l(8,0))+2*n(9,0)*l(9,0))+2*n(10,0)*l(10,0))+2*n(11,0)*l(11,0))-2*l(7,0)*n(10,0))-2*n(6,0)*l(9,0))-2*l(6,0)*n(9,0))-2*n(7,0)*l(10,0))-2*n(8,0)*l(11,0))-2*l(8,0)*n(11,0));
  groebnerMatrix(5,71) = (((((((((((2*n(6,0)*k(6,0)+2*n(7,0)*k(7,0))+2*n(8,0)*k(8,0))+2*n(9,0)*k(9,0))+2*n(10,0)*k(10,0))+2*n(11,0)*k(11,0))-2*k(7,0)*n(10,0))-2*n(6,0)*k(9,0))-2*k(6,0)*n(9,0))-2*n(7,0)*k(10,0))-2*n(8,0)*k(11,0))-2*k(8,0)*n(11,0));
  groebnerMatrix(5,72) = (((((((((((2*n(6,0)*m(6,0)+2*n(7,0)*m(7,0))+2*n(8,0)*m(8,0))+2*n(9,0)*m(9,0))+2*n(10,0)*m(10,0))+2*n(11,0)*m(11,0))-2*n(6,0)*m(9,0))-2*m(6,0)*n(9,0))-2*n(7,0)*m(10,0))-2*m(7,0)*n(10,0))-2*n(8,0)*m(11,0))-2*m(8,0)*n(11,0));
  groebnerMatrix(5,73) = ((((((((pow(n(6,0),2)+pow(n(7,0),2))+pow(n(8,0),2))+pow(n(9,0),2))+pow(n(10,0),2))+pow(n(11,0),2))-2*n(8,0)*n(11,0))-2*n(6,0)*n(9,0))-2*n(7,0)*n(10,0));
  groebnerMatrix(5,74) = (((((((((((2*a(6,0)*p(6,0)+2*a(7,0)*p(7,0))+2*a(8,0)*p(8,0))+2*a(9,0)*p(9,0))+2*a(10,0)*p(10,0))+2*a(11,0)*p(11,0))-2*a(8,0)*p(11,0))-2*p(8,0)*a(11,0))-2*a(6,0)*p(9,0))-2*p(6,0)*a(9,0))-2*a(7,0)*p(10,0))-2*p(7,0)*a(10,0));
  groebnerMatrix(5,75) = (((((((((((2*a(6,0)*l(6,0)+2*a(7,0)*l(7,0))+2*a(8,0)*l(8,0))+2*a(9,0)*l(9,0))+2*a(10,0)*l(10,0))+2*a(11,0)*l(11,0))-2*a(8,0)*l(11,0))-2*l(8,0)*a(11,0))-2*a(6,0)*l(9,0))-2*l(6,0)*a(9,0))-2*a(7,0)*l(10,0))-2*l(7,0)*a(10,0));
  groebnerMatrix(5,76) = (((((((((((2*a(6,0)*k(6,0)+2*a(7,0)*k(7,0))+2*a(8,0)*k(8,0))+2*a(9,0)*k(9,0))+2*a(10,0)*k(10,0))+2*a(11,0)*k(11,0))-2*a(8,0)*k(11,0))-2*k(8,0)*a(11,0))-2*a(6,0)*k(9,0))-2*k(6,0)*a(9,0))-2*a(7,0)*k(10,0))-2*k(7,0)*a(10,0));
  groebnerMatrix(5,77) = (((((((((((2*a(6,0)*m(6,0)+2*a(7,0)*m(7,0))+2*a(8,0)*m(8,0))+2*a(9,0)*m(9,0))+2*a(10,0)*m(10,0))+2*a(11,0)*m(11,0))-2*a(8,0)*m(11,0))-2*m(8,0)*a(11,0))-2*a(6,0)*m(9,0))-2*m(6,0)*a(9,0))-2*a(7,0)*m(10,0))-2*m(7,0)*a(10,0));
  groebnerMatrix(5,78) = (((((((((((2*a(6,0)*n(6,0)+2*a(7,0)*n(7,0))+2*a(8,0)*n(8,0))+2*a(9,0)*n(9,0))+2*a(10,0)*n(10,0))+2*a(11,0)*n(11,0))-2*a(8,0)*n(11,0))-2*n(8,0)*a(11,0))-2*a(6,0)*n(9,0))-2*n(6,0)*a(9,0))-2*a(7,0)*n(10,0))-2*n(7,0)*a(10,0));
  groebnerMatrix(5,79) = (((((((((-c23w+pow(a(6,0),2))+pow(a(7,0),2))+pow(a(8,0),2))+pow(a(9,0),2))+pow(a(10,0),2))+pow(a(11,0),2))-2*a(6,0)*a(9,0))-2*a(7,0)*a(10,0))-2*a(8,0)*a(11,0));
}
