<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 9, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] J Schulte - Industrial Light & Magic
  * [X] Matthias Scharfenberg - Industrial Light & Magic

# **OCIO TSC Meeting Notes**

* Response to ILM questions:
    - Doug: Wrote up answers for ILM, provided doc in last week's TSC notes. 
      Also created issue #1199 to facilitate discussion on topics.

* Overview of new PRs:
    - #1183 - Add operator << for FormatMetadata:
        - Doug: Making more convenient to access file format metadata from 
          python. Maps to `__repr__` in python.
    - #1184 - Description in Config files
        - Doug: Improved descriptions in config files. Cases where single or 
          multiline desc for color space, etc. Cleans up handling of those and 
          adds unit tests.
    - #1189 - Named color transforms
        - Doug: Issue #1101, discussed at August v2 wg meeting. Sharing slides 
          from wg meeting. How to integrate legacy transforms into OCIO. 
          Sometimes users just want to apply gamma or log-to-lin (with no 
          matrix). But want to specify them in OCIO config and access via OCIO 
          tools. Example: "Utility Curve/Shaper" color spaces in ACES config, 
          which are kind of broken (i.e. only a shaper if going to ACES2065-1).
            - Add named transforms section to config. Authors can define these 
              transforms in that area. ACES config has these transforms, 
              represented as color spaces, but problematic if you're not 
              starting from the right color space. These curve/shaper color 
              spaces could then become named transforms instead.
            - Apps could provide plug-in for accessing named transforms, or use 
              with ColorSpaceTransform or DisplayViewTransforms. They do not 
              show up in color space menus by default.
            - In ColorSpaceTransform and DisplayViewTransform, accepted like 
              color spaces as arguments to these transforms. Would bypass the 
              "other half" of the conversion. e.g. 
              ColorSpaceTransform("Utility - Curve - sRGB", "ACEScg") -> apply 
              the named transform and consider the result as ACEScg.
            - As mentioned in previous meeting, open to other proposals for 
              how to handle this, but nothing has been presented. Made very 
              clear that this is a hard requirement and want to do it within 
              OCIO rather than as separate tool. See issue and PR for more 
              info.
        - Mark B: Not excited about it. Not part of config authoring process 
          so can't see how chain of operations ties together. Highlighted by 
          ACES config, which ref color space is ACES2065-1, but people want to 
          work in ACEScg, so problematic with the extra matrix and color shift. 
          What users have hard requirement?
        - Doug: From users of thing like Maya and Flame, CG animation and 
          rendering, or finishing or compositing.
        - J: More dangerous in those applications. Easier for UX, but breaks 
          fundamental rules of moving to color managed process.
        - Doug: In big facility with color scientist, makes sense. A lot of 
          users don't have that. Proponent of the benefits of working proper 
          color managed way, but a lot of our users have not gotten to that 
          point yet. Looking in OCIO example configs repo, one is called 
          nuke-default, a Foundry config, made up of these sort of utility 
          transforms as well.
        - J/Mark B: Legacy config, made to allow continuation of Nuke workflows 
          with OCIO. Just proof of concepts to get Nuke color management 
          outside of Nuke.
        - Mark T: Just to replicate Nuke color management system.
        - Doug: Not recommending this approach, just saying it's a reality that 
          a lot of people want to work this way. Because of legacy. Users 5-10 
          years behind state of art.
        - Mark B: Talking about OCIO, not legacy workflows. Don't want to 
          enshrine these workflows, allow people to break the model.
        - Carol: If not using the standard ACES config, using nuke-default, not 
          making own configs. If you're trying to get facilities caught up in a 
          non-disruptive way, this would be an ok way to do that since it's 
          saying what it is explicitly. Not getting unintended results. I Like 
          that.
        - Mark B: Disagree. This is enabling people. Those that don't 
          understand color management are not are not going to be set right by 
          named transforms. Going to be enabled to work how they want and think 
          they have OCIO blessing. OCIO is an opinionated color management 
          library, not just a toolbox.
        - J: Valid question, is there an appetite for something like this as a 
          guiding path? Love to get input on that. Everyone has valid point of 
          view, but as a whole, what is the missions statement here? Are we 
          willing to compromise OCIO principles, or are there decisions and 
          workflows we want the industry to move into?
        - Doug: To clarify, think its clear users feel a need for this. It's in 
          the ACES config for a reason. Not that we're encouraging this, just 
          calling it what it is. Right now masquerading these as color spaces, 
          but they aren't. Reality that some want these and we should not call 
          them color spaces. If you're worried about encouraging this behavior, 
          I don't see that. See it as making it clearer to people how to do 
          color management. If you say we don't want you to use named 
          transforms, clear way to talk about the scenario. Don't want to frame 
          the question as: is this a good idea for color management? Most on 
          same page to not recommend it. If they are going to do it, and ACES 
          config has it, and should be called what they are.
        - Mark B: Color spaces are a simplification to allow talking about 
          OCIO. Just a block in chain that joins images together.
        - Carol: Should be explicit though, call this what it is, not a color 
          space.
        - MArk B: Increasing complexity with little benefit.
        - Matthias: Sort of agree with Carol. Agree having them in there as 
          first class citizen potentially perpetuating workflow and simplistic 
          interpretation of color management to avoid. Don't like to 
          compromise, but if have to have it, see benefit of it being explicit.
        - Mark B: Who needs it other than the config author? If you're the 
          author you know where you need to_ref and from_ref. Current toolkit 
          not complex and solves all these problems without extra level.
        - Carol: Another group pf people sit between authors and users. Those 
          that don't have someone to write config for them and need to 
          understand the config. This would aid those people and it's a big. 
          Not everyone can be a config author, requires skill not all have. 
          Need to support them.
        - J: The question is what is OCIO, who does it serve? A lot of that 
          user experience is driven by applications that use OCIO. What do we 
          want to enable those workflows to be like in OCIO. If there's a need 
          for these, that's a thing. But does OCIO have an opinion about this? 
          Or do we sacrifice some of that to give users accessible use of OCIO?
        - Matthias: Look at it from different point of view. Having transform 
          is one thing. Doug, any idea what would look like when presented to 
          end user, in say... Nuke. OCIOColorSpace node would not have this. 
          Doesn't fit there. Would it be a separate thing? Just an OCIO 
          transform or legacy transform?
        - Doug: Will vary based on application and task. For example, if 
          importing something into proper color managed env. If using Maya and 
          ACEScg as rendering space. May want to bring something in and call 
          it ACEScg, but you're not sure what the original texture is. Don't 
          have info so going to apply inverse gamma curve and call it ACEScg. 
          Same workflow as textures where you do know color space. May have 
          other scenarios where want to apply transform itself like 
          FileTransform.
        - Kevin: If I know how to read config, and just want to get transform, 
          this is a convenience. File transforms don't encapsulate all new 
          transforms, so harder to put this in file.
        - Mark: Config author could do that.
        - Kevin: Convenience for mocking up a config, but once done, not have 
          it. Could create separate Nuke node with obscure name for special 
          use, but not to be used by default. 
        - Matthias: Feels like amalgamation of old Nuke 1D input color space 
          for read node, and the new ability to use specific color space. Feels 
          like jamming those two workflows together. Could cause confusion down 
          the line, if you have color managed workflow.
        - J: From user perspective, having one thing that does full transform, 
          or one that does just the 1D path, does this make it harder for 
          people? User may not know what the differences are. Are we making it 
          harder?
        - Carol: Like the analogy of using this in place where would have used 
          FileTransform before. As simple as that.
        - Mark B: Who uses raw file transforms though? If this is just a 
          shortcut to a 1D LUT.
        - Kevin: If it was just 1D LUT, no point, but encapsulating other 
          transforms has more benefit. Have a lot of users who will try to 
          decipher how to get between two images. Would be handy for that. Once 
          you figure it out, put it into color space.
        - Carol: For many users, try in Nuke to figure out what happened, get 
          to place of confidence of where they are at, and work on image.
        - Doug: A lot of people on OCIO/ACES forums that don't understand how 
          OCIO config works, but in positron of having to use it to solve 
          problems. Think there are a lot of those people out there.
        - Matthias: Maybe needs clear distinction that this is not a color 
          space, with no to and from ref, just forward or reverse with name.
        - J: How do you solve this without offering up these workflows. At 
          least gives them something over nothing.
        - Mark B: Just documentation, teaching how to use it. Adding named 
          transforms not going to improve that.
        - Doug: Don't see how to solve this with documentation. Would need huge 
          number of color spaces, for this audience who aren't config authors. 
          If these are color spaces, would need every possible combination of 
          color space and non-linearity. Another workflow is unfortunately that 
          some apps allow a color transform where you specify independently a 
          matrix and a non-linearity. Can create a lot of trouble by mixing and 
          matching weird combinations. Sometimes people get things from these 
          other software. Nightmare to include every combination, but with 
          named transform, have way of undoing what had been done.
        - Carol: Seems like added complication, but could look at it as 
          building block of step in direction of where we want to be. More 
          educated users knowing what they are doing in color managed scenario. 
          Until we get to that point, could view this as interim. Helps to 
          teach and educate. Like in ACES gamut mapping wg, all agree it's not 
          ideal, but we have to do what helps.
        - Mark B: Having multiple named transforms to reconcile error from 
          another user. Are you anticipating a user assigning multiple named 
          transforms in Maya UI, or still picking single transforms from named 
          lists. If the later, still at mercy of config author, at which point 
          it's just a doc or training session to explain choices. 
        - Doug: Tried providing combinations in SynColor, many options, huge 
          list of matrix and log-to-lin combinations and nightmare to deal 
          with. Not desireable way of solving the problem.
        - J: Does TSC have a point of view on what color space interaction and 
          user experience should be.
        - Michael: Think that's an important topic for discussion. Created 
          issue #1174 for UX discussion where some of this could be determined.
        - Kevin: What I really need is a Nuke node, op builder, to put ops in 
          a row.
        - Michael: Suggested a GSoC project to create OCIO GUI last year for 
          exactly that reason. Would be awesome to have visual method for 
          authoring configs.
            - Let's bookmark this conversation for next week. Gives us time to 
              think this through more and can follow up to make an agreement.

* CUDA support:
    - Doug: Larry brought up topic about CUDA support, pressing issue for 
      OSL and a number of CG rednderers. 
    - Michael: We should follow up with Dennis about his OpenCL renderer. Could 
      perhaps influence other GPU compute implementations like Metal, Vulkan, 
      etc.
    - Mark B: Think this need is dying, since we now have OpenGL compute 
      shader.
    - Michael: CUDA requirement might be tied to OptiX. Could also explore 
      tools to emit to multiple APIs. Spir-V.
    - Mark: Spir-V builder needs large dependency graph, needs LLVM. Not stable 
      dependencies.
    - Patrick: Something to keep in mind. A lot of effort in current impl to 
      not have direct OpenGL dependency in core. Clear distinction between core 
      and shader language. Try to keep that. Advantage of OCIO.
    - Michael: Could be like OIIO which has plugins depending on optional 
      dependencies. More ideal to only depend on runtime though.
    - Mark B: Windows has HLSL, Mac has Metal. Don't want to support all that 
      stuff in the GPU impl. Emitting HLSL on Linux, etc. Could have call to 
      get native shader code.

* Misc:
    - Michael: Please have a look at my question in PR #1197 about workarounds 
      to support Python API docs on RTD. somewhat controversial choices so 
      would like input. Also to TSC, please have a look at the ASWF survey 
      questions. Could use some input on multiple choice answers.
    - Patrick: New API docs very helpful. Built branch locally and looks good.
    - Mei: Pavel, engineer from SPI starting using OCIO v2. Provided feedback 
      that overall very happy. Performance is faster, and has not been any 
      issues. Happy with it. Can get more feedback if there's specific
      questions for him.

* Items for next TSC meeting agenda:
    - Continued discussion on named color transforms.
    - Follow up on AD response to ILM feedback and questions.
