import { Arbitrary } from './definition/Arbitrary';
declare type TupleOf<T, N extends number> = N extends 0 ? [] : N extends 1 ? [T] : N extends 2 ? [T, T] : N extends 3 ? [T, T, T] : N extends 4 ? [T, T, T, T] : T[];
/**
 * Deduplicate the values generated by `arb`
 * in order to produce fully equal values
 *
 * @param arb Source arbitrary
 * @param numValues Number of values to produce
 */
declare function dedup<T, N extends number>(arb: Arbitrary<T>, numValues: N): Arbitrary<TupleOf<T, N>>;
export { dedup };
