# Jasmine Core 3.7 Release Notes

## Summary

This is a maintenance release of Jasmine with a number of new features and fixes.


## New features and bug fixes

* Allow custom object formatters to be added in beforeAll
    - Fixes [#1876](http://github.com/jasmine/jasmine/issues/1876)

* Allow specs to disable Jasmine's global error handling by overwriting `onerror`.
    - Merges [#1860](https://github.com/jasmine/jasmine/pull/1860) from @greghuc

* Fixed comparison between URL objects
    -  Fixes [#1866](http://github.com/jasmine/jasmine/issues/1866)

* Added support for stack traces created by `node --enable-source-maps`
  with tools like the Typescript compiler.
    - Merges [#1862](https://github.com/jasmine/jasmine/pull/1862) from @JannesMeyer

* Made properties added by createSpyObj() enumerable.
    - Merges [#1859](https://github.com/jasmine/jasmine/pull/1859) from DCtheTall
    - Fixes [#1837](http://github.com/jasmine/jasmine/issues/1837)

* Show the name of the spec/suite that caused a deprecation

* Warn if a spec or before/after function both takes a callback and returns a promise

* Don't overwrite MatchersUtil methods with ones that were added to 
  `Array.prototype`, esp. `contains`
    - Fixes [#1849](http://github.com/jasmine/jasmine/issues/1849)

* Allow generator functions to be passed to `.and.callFake`
    - Fixes [#1848](http://github.com/jasmine/jasmine/issues/1848)


## Documentation updates

* Fixed instructions for contributors to run Jasmine's ci script

* Updated supported Node versions in README

* Fixed script and CSS URLs in standalone example in README
    - Merges [#1839](https://github.com/jasmine/jasmine/pull/1839) from @snowman

* Fixed typo in asyncMatcher toBePending comment
    - Merges [#1847](https://github.com/jasmine/jasmine/pull/1847) from @SnailCoil

* Fixed link to custom object formatter tutorial

* Added jasmine.isSpy to the public interface
    - Fixes [#1880](http://github.com/jasmine/jasmine/issues/1880)



## Internal notes

* Fixed intermittent test failures

* Added additional assertions to tests for toBeTruthy and toBeFalsy
    -  Merges [#1875](https://github.com/jasmine/jasmine/pull/1875) from @yasinkocak

* Pointed Travis badge at travis-ci.com, not .org

* Fixed file globs so that Prettier runs on all files

* Check for forgotten console and debugger statements

* Fixed code in Jasmine that will trigger deprecations in 3.99
    
* Use jasmine-browser from npm rather than from the main branch
    - The current released version now works with IE, so we no longer need to
depend on main.


------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
