const canElideFrames = 'captureStackTrace' in Error;
const startStackFrames = new WeakMap();
class AssertionError extends Error {
    constructor(message = 'Unspecified AssertionError', props, ssf) {
        super(message);
        this.message = message;
        if (canElideFrames && ssf)
            startStackFrames.set(this, ssf);
        for (const key in props) {
            if (!(key in this)) {
                this[key] = props[key];
            }
        }
    }
    get name() {
        return 'AssertionError';
    }
    get ok() {
        return false;
    }
    get stack() {
        if (canElideFrames) {
            return Error.captureStackTrace(this, startStackFrames.get(this) || AssertionError);
        }
        else {
            return super.stack;
        }
    }
    toJSON(stack) {
        return Object.assign(Object.assign({}, this), { name: this.name, message: this.message, ok: false, stack: stack !== false ? this.stack : undefined });
    }
}

function assert(expr, msg) {
    if (!expr) {
        throw new AssertionError(msg || 'Assertion Failed');
    }
}
function not(expr, msg) {
    assert(!expr, msg);
}
function fail(msg) {
    assert(false, msg);
}

export { assert, fail, not };
