//------------------------------------------------------------------------------
// <copyright file="IStyleSheet.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace System.Web.UI {

    using System;
    using System.Collections;
    using System.Web.UI.WebControls;

    /// <devdoc>
    /// IStyleSheet represents the core functionality of a style sheet, i.e.
    /// a collection of named styles.
    /// </devdoc>
    public interface IStyleSheet {


        /// <devdoc>
        /// Creates a style rule for the specified selector.  Multiple rules are allowed of the
        /// same selector
        /// </devdoc>
        void CreateStyleRule(Style style, IUrlResolutionService urlResolver, string selector);


        /// <devdoc>
        /// Adds a new style rule to the style sheet and associates it with an
        /// autogenerated name. The style is rendered using the specified
        /// URL resolver.
        /// </devdoc>
        void RegisterStyle(Style style, IUrlResolutionService urlResolver);
    }
}
