//  main.cpp
//
//  Created by Martin Steinegger on 26.11.12.
//  Copyright (c) 2012 -. All rights reserved.
//

#include <iostream>
#include <fstream>
#include "ProfileStates.h"
#include "Parameters.h"
#include "StripedSmithWaterman.h"
#include "MsaFilter.h"
#include "PSSMCalculator.h"
#include "Sequence.h"
#include "SubstitutionMatrix.h"
#include "MultipleAlignment.h"

const char* binary_name = "test_profilestates";


int main (int, const char**) {
    Parameters& par = Parameters::getInstance();
    SubstitutionMatrix subMat(par.scoringMatrixFile.aminoacids, 2.0, 0.0);



    std::cout << "Subustitution matrix:";
    SubstitutionMatrix::print(subMat.subMatrix,subMat.num2aa,subMat.alphabetSize);
    //   BaseMatrix::print(subMat.subMatrix, subMat.alphabetSize);
    const char *seqs[1001];
    int counter = 0;

    seqs[counter++] = "QDELTAGPCATVHVITVQMAKSGELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
    seqs[counter++] = "-----------------EIAPLAELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
    seqs[counter++] = "---------------------AAELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
    seqs[counter++] = "------------------------LQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
    seqs[counter++] = "---------------------SQEIQVLSSEKAQRMAEFFSFLGDANRLRILSLLAEKEFCVSDLAARLDMSESAVSHQLRNLRAMRLVNYRKQGRRVFYRLHDNHVLHLYQAVAEHLDE--";
    seqs[counter++] = "-----------------------QVRQVQPEVAQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
    seqs[counter++] = "--------------------------------AQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
    seqs[counter++] = "-------------------------EVLSTEKSQRMAEFFSFLGDANRLRILSFLATKELCVSDIATLLEMSESAVSHQLRNLRAMRLVSYRKQGRHVFYRLHDNHILELYQAVAEHLDE--";
    seqs[counter++] = "------------------------------EKAQRMAQFFGLLADTNRLRIVDLLAQGEFCVRDIAVALEMSESAVSHQLRMLKALRLVRFRRQGRHIFYQLLDHHVLTLYKAAAEHLDE--";
    seqs[counter++] = "-----------------------QTQVLNSQKAQRMAEFFSLLGDANRLRLLSVLAAQELCVCDLAATLEMSESAVSHQLRALRALRLVSYRKQGRQVFYSLLDRHVLELYRAVAEHLDE--";
    seqs[counter++] = "--------------------------------AQQMAEFFAVLADPNRLRLISALASQELCVCDLAALMKMTESAVSHQLRLLKAMRLVSYRREGRNIYYSLADNHVISLYREVAVHLDE--";
    seqs[counter++] = "---------------------------------------FAALGDPTRFRIIAALQVQELCVGDLAAAIGLSQSAVSHQLRALRDLGLVRSRREGRLVYYALDDEHVVTLVAQALDHVREER";
    seqs[counter++] = "-------------------------------VTRQMAEFFKSLSDPTRLRIVQALLEEELCVCDISAIVDISISAISHQLRLLRSMHIVKFRKQGKMVYYSLEDEHISRMLEIALEHLNE--";
    seqs[counter++] = "------------------------------DITNRLAETFKVLGDPTRLKILLAVSLDELCVCDIASLLGTTKSAVSHQLRLLRSLRVVKYRKDGRIVYYSLDDSHVGNLLSEGLDHI----";
    seqs[counter++] = "-----------------------------------MAETFKILADPTRVKILHALAHKELCVCDIAVTLDMKVSAVSHQLRLLKSARLVKQRREGKNVYYQLDDHHVEQLFEKTLEHIKQ--";
    seqs[counter++] = "--------------------------------AGRLADLFKALADPTRVRIIAALLHTELCVDDLANLLDMSQSAISHQLRLLRNLHLVQFRRSGKHAFYRLVDDHVRDLFQRSREHL----";
    seqs[counter++] = "------------------------------ELLYELAELFKIFGDSSRIRILSLLQKERLCVSEISTLLNLSQSAISHQLRILRQARLVRYKKIGKEVFYELDDDHIEKIFEQGLEHIQE--";
    seqs[counter++] = "--------------------------------ATRLAAAFQALSDPTRVRLISALLEQELCVHDLAAVLGMSQSATSHQLRVLRALGLVRTRKEGRIVYYALDDEHIRELFQRGLEHI----";
    seqs[counter++] = "---------------------------------EEMASFFRMMGDPTRIRILSLLFDEELCVHTLAERLEMTHSAVSHQLALLKHARLVRSRREGRHVYYRLADEHVQKVYELAREHLEE--";
    seqs[counter++] = "-DEFKKGSDLNCHVMNIQDCKEVELKSVTEETIFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLGTSQSAISHQLRLLKVFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
    seqs[counter++] = "------------------------------ELIFNLADFFKTFGDSTRIKIICALMETELCVCDLANVINTSQSAVSHQLRVLRQSRLVKYRKDGKTVYYSLDDDHIKLLISQGLDHL----";
    seqs[counter++] = "-----------------------------------MAEVFKALNDPTRLKIINILIVSELCVNDIANLLEISQPAISHHLKELRQLKLIKYHKKGRSVFYSLDDEHIHPLFQQCLEHVNE--";
    seqs[counter++] = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDNHVECLVRMGMEHV----";
    seqs[counter++] = "---------------------------------EDLALLFKMFADPTRLKVLKALFEREMCVGDLAVLLKMTHSAVSHQLASLKKTRLVRSRKDGKVVYYSLDDDHIEEIFQKALDHVRE--";
    seqs[counter++] = "-------------------------------------------ADQTRLRILCLLRDREVCVHDIVEALDMSQSAISHQLRVLRDARLVSHRREGRHVYYRLADDHVREMLENALSH-----";
    seqs[counter++] = "-----------------------------------LSMLFKMFADPTRLRIFTILSHQTVCVDDLAEILGMTQSAVSHQLASLRKMNLVRSSKVGKNAYYQLADSHVMQIFSQALDHVKE--";
    seqs[counter++] = "-------PCAEVTALHLRL--SPATRAVDKGALQRAAAIFRALGDPARLHLLALLAAGEQCVSQLATETGDSLPAISQRLKLLRSERLVSQRRDGKHIYYQLADQHVVQLIEAGIDHAVESR";
    seqs[counter++] = "-----------------------------------LSEVYKSLGDGTRLKILLALKEKESCVCDLAAALSMSQSAISHQLRVLRNVRLVKYRREGKMVYYSLDDEHILKILQEGLNHI----";
    seqs[counter++] = "------------------------------EEVQKLSAIYKALGDPTRFKILFCLKQEEMCVCDISAILDMSQSAISHQLRVLRNLRIVKYRKEGKMVFYSLDDKHIFRILDEGINHIRE--";
    seqs[counter++] = "------------------------------ETMDAIAELFKGFADSTRVHILALLSRQELCVTDIAETVDVSQSAISHQLRILKQMHLIKFRREGKNILYSLADDHVKTILQMGLEHVLE--";
    seqs[counter++] = "-------------------------------------ELLKAVGDPTRMRILCALADRELCVCDLQAVLGLSQSAVSHQLRTLRNARLVTYRREGKMAYYTLADDHVRRLLDLSLEHV----";
    seqs[counter++] = "-------------------------EAKADQIASPLANFFKTLSDPTRLRIILAIGTTSLSVNEISTIINMSQSSVSHQLRILRDNHLVISQRFGQHIHYQLTDQHVLTILENSLDHISE--";
    seqs[counter++] = "-----------------------------------LAATFRLLGDRTRVRILEALAGDELCVCDLAAVVGHSQSAVSHQLRLLRAAKLVRVRRDGKNAFYSLDDDHVRHLFRQALDHVQE--";
    seqs[counter++] = "-----------------------------------MAQLFKILGDPTRVRILQALSISEMCVCDIAALLEMTQSAISHQLRLLKQGRLVKYRRDGKVVYYSLNDNHVRLIFDQALSHITE--";
    seqs[counter++] = "--------------------------ALTEKTAKELSELFKVVSDPTRIKILWAIGGGEVCVCCISELLGMSVSAVSHQLKTLRQAHLVKARREGRNIYYSLDDHHVKILLDVLLEHMEE--";
    seqs[counter++] = "---------------------------------ENLGEFFKVLTDASRLKILYALGAGELCVFDLSVTIGASVSSVSHHLAALKRVRLVKGRRDGRIIYYSLDDDHVKSIIRYAREHLEE--";
    seqs[counter++] = "---------------------------------QKLSNMFKLFSDETRLKIICSLLKEELCVCDLCELLGLNQSQVSHQLQLLRNSKLVKFRREGKQIFYSLDDEHVELIIQMALDHILE--";
    seqs[counter++] = "-----------------------------------LSETFGALADSNRAKILHSLLNQELCVCDIACVVGISESAISQHLRILRTLRLVKQRKQGRMMYYSLNDNHIRQLLEICLEH-----";
    seqs[counter++] = "-----------------------------------LAQLFAAFGDPTRLRILTALRSGDLCVCDLTAVLGMTASAVSHQLRLLRNLRLVRSRKVGRVVYYHLDDEHVLNL------------";
    seqs[counter++] = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
    seqs[counter++] = "-----------------------------------LADLFKMFADSTRLKILCILCESEMCVNDIANLISMSQSAVSHQLRILKQSKLIRGRREGKIVFYSLADSHINTIINNGLEHIQE--";
    seqs[counter++] = "--------------------QSQEREVLAAPLAWRVADIFKALGDPTRVKIIALLDAGEMCVGEMCLTLGMSQPAISSQLRLLRTLGIVSVRREGKHAYYRLADEHVRHLFHQGLAH-----";
    seqs[counter++] = "------------------------------EYIQELSAFFKVFGEENRTRILYALSIREMCVNDLVTLLGMSQSSVSHQLQILRAHGQVKFRKEGRNVFYSLDDKHVVDVFQEALQHI----";
    seqs[counter++] = "------------------------------KVIYELSEFFKILSDQTRLKILVLLFEKEQNVSELQRQIGVTQSNISHQLRILRQANLVRYRKIGRNVYYRLYDEHVEIIIKYAMEHLKE--";
    seqs[counter++] = "------------------------------EVMFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKVGKVVYYSLSDDHVKSIIELGLTHLSE--";
    seqs[counter++] = "-----------------------------------LAELFKIFGDATRIRILCALSEGEICVSDLAETLSMTQPAISHQLRILKNTRLVKARRDGKQIYYSLADAHVSSIIGTALEHVEE--";
    seqs[counter++] = "------------------------------ETLYDLADLFKVLGDSTRIKILCTLFEAEMCVCDIAAVLGMTQSAISHQLRVLKQARLVKYKRSGKVVYYSLDDEHVKHIFDQGLIHISENR";
    seqs[counter++] = "-----------------------------------LSDFYKVFGDPTRLKILFALESRELCVCDLAQILQMTKSAVSHQLKILRQTELVNFKKLGRSVFYRLSDAHIQGILDQGADHINE--";
    seqs[counter++] = "------------------------------ECVMDLADFFSIFSDSTRIRILWVLYGRELCVRDISDTLGISMSACSHQLKTLRNSGAVEARRDGKMIYYKLADEHVEILLRTGLEHIQE--";
    seqs[counter++] = "-----------------------------------LADMYKALGDPSRLRIVMALSQGEMCVCDLAAYLEISESAVSHQLRRLRSLALVKNRRDGKILYYSLDDDHVSSLVALGLEHVRE--";
    seqs[counter++] = "-------------------------------------DLFKTLGDPSRLRIIEVLSQEELSVDDLANQVGLTQSAASHQLRRLKLDRVVKYRKEGKFIYYSLADQHLLYLFNIARDHVQE--";
    seqs[counter++] = "-----------------------------PDQIESLSNFYKIMGDPTRLMLLMALEAGELCASDLANVTNMSRSAVSHQLKTLKQACLVRSRRDGKTIFYELDDEHIYSVLKVAFEHIQE--";
    seqs[counter++] = "-----------------------------------LSDFFKVLGDSTRARIISALDINEMCVCDLAVLLNMTKSAISHQLRSLKEANLVKFRKEGKVVFYSLTDDHVKDIFEKGLEHIRE--";
    seqs[counter++] = "-----------------------------------LSEFFKVFSDSTRVKILSALLISEMCVCDLAALLQVTQSAISHQLRLLKAFRLVKSRKEGKVVYYSLNDDHVKSILELGLLHLSEAK";
    seqs[counter++] = "-----------------------------PDIIDDLSELFKILGDQTRSKILFVLEQGEFCVSDISEAVGMTKYAVSHQLRTLKQAKLVKCRREGKEVIYSLDDDHVSTLFSCALAHVTE--";
    seqs[counter++] = "------------------------------------AELFKVFADSTRVKIINVLLENKLCVGDIAALVGGTQSAISHQLRILKSAKLVKYTKIGKTVYYELSDDHVKKLFSVGKEHINE--";
    seqs[counter++] = "------------------------------ETMSDLAAIFKLMGEPVRITILHALSIRDLCVCDLAELLGMSHSAVSHQLRLLRTARMVRFEKQGRKAIYSLNDRHVETIMQTALAHMQ---";
    seqs[counter++] = "---------------------------------QELANNFKVLGDPTRLRILQALMHGERCVRELADGIQMEQSAVSHQLRTLRDAGLVNFRRDGKVVYYSLADAHVFTLLSVGIEHVAE--";
    seqs[counter++] = "-----------------------------------LSELFKILGDYTRIKIIYSLSKKELCVCDISEVVQMSQSAISHQLRILKAARLVKFRREGKSVYYSLDDEHIDRLFNAGLEHVE---";
    seqs[counter++] = "------------------------------EIINELSEFFKVFSDTTRLRILEVLLNEETSVGVIANKINVSNSAVSHQLSYLRSTNLVKTRKEGQVIYYSIADNHIKVIIEYGLEHIKELK";
    seqs[counter++] = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADDHVAAVLSLTLKHLKE--";
    seqs[counter++] = "------------------------------DVVASLSELFKALGDPTRVKILSCLQISDMNVGDIADKLGMTTSAVSHQLRVLRAIKLVKGTKEGKEVRYSLDDDHVTLIMQCGLTHVNE--";
    seqs[counter++] = "-----------------------------------LAELFKVLGDYTRIKIIYALLKKELCVCDIAELLDMSQSSISHQLRTLKAARLVKFRKEGKVVYYSLDDEHIEHILNASLEHVE---";
    seqs[counter++] = "----------------------------------SIADFFAVFGDRTRIKILLALDQSPMCVCDLAVLLDMTKSVISHQLSSLKKINLVSSHKEGKHSYYALADDHIKKIIEMAVEHLEE--";
    seqs[counter++] = "------------------------VKSIDADTAQHLADLFKTLGDPTRIKILSLLTKTEMRVYDIADSLTMGQSAISHQLRVLRSARLVKFRRDGKEVLYSIDDDHVMKLLGQGLEHVQ---";
    seqs[counter++] = "---------------------------------KDLADTFKLLSDFTRVKILYVLSLSELCVQDISELTGVSQSAVSHQLRILRNSRLVSWKKTGKQVFYSLNSDAVRALIEKGMEHV----";
    seqs[counter++] = "-----------------------------------LAELFKVFGDTTRVKILFALFTAEMCVCDLTALLGLTQSAVSHQLRVLKQARLVKYRKDGKMVYYSLDDDHVKQIFDQGLAHI----";
    seqs[counter++] = "--------------------KSNE-QMLAPDDVDVTAEFFKALADPTRINIVNALQIHELCVTDLAEILGMTKSAVSHQLCYLRLNNLVMVKREGQRVYYALCDEHVEKVFEMAISHIKE--";
    seqs[counter++] = "------------------------------------ADIFRALGDPSRLRMLSLLIHDELCVTEIAEALGDNLSAVSQRLKLLKSERIVGARREGKHIFYRLSDHHV---------------";
    seqs[counter++] = "------------------------------DIVAKLSDFIKVLGDGTRIKIIWILEENEMCVNDLAVALNMSQSAVSHQLKTLKTANVVKSKREGKNIFYSLSDDHVKDIFLKTLEHIQE--";
    seqs[counter++] = "------------------------------ETMSDLSDFFKNFGDSTRIKIVSALISGELCVADIAEVLEMSVSAISHQLRILRQAKIVRARRNGKQMYYSIDDEHVAILYSLGLEHIRE--";
    seqs[counter++] = "------------------------------ETFNSLSDNFKVLSDPTRLKILYALMLKEICVCDLAAVLEMTDSAVSHQLRLLRNRNLVKFRKKGKMAYYSISDHKIV--------------";
    seqs[counter++] = "------------------------------------AELFKMFGDPTRLKLLAALLGQEVCVCDLSDLLGISQSAVSHQLRLLRASHLVKNRREGKSVFYSLDDEHVATILAQGMEHV----";
    seqs[counter++] = "-----------------------------------LSETFKIFGNPTRLKILSLLSVEDLCVCDICEILNMSQSAVSHQLRTLRSKNLVKYTKEGKQARYSLADKHVVQILKIGIEHVLE--";
    seqs[counter++] = "-------------------------------------DIFKILGDPSRMRIVAALRIKELCVGDISALMEISLSGVSHQLRLLKKSRIIKSRREGKLIYYSLDDDHIESLIDIALDHVRD--";
    seqs[counter++] = "---------------------------LSPQIVEEASRILKAISDPTRMKILYLLFQEECSVGHMVEVLGVSQSAISHQLTHLRHLRLVKYRREGNTYFYTYDDEHVVGILHQVIQHVE---";
    seqs[counter++] = "-----------------------------------LAELYKVFGDSTRIRILYALLESEMCVGDMAQLLGLTPTACSHQLRVLKNSKLVRFRREGKIMFYSLADDHVRSILALGMEHILE--";
    seqs[counter++] = "------------------------LRPVAEEAAK-LAPIFKALSDETRVKIIYALAQAELCVCDIAELTGCTLPAVSHHLRILRNIGLAKSRKEGKFIYYNIDDHHVSQIINAAFAHLRE--";
    seqs[counter++] = "----------------------------------ALSELFKILADPSRLRILHALQSPERCVCDLAALLDMSQSALSHQLAILRRARLVRPVKIGKIVYYQLDDHHVDALIALAMEHVSE--";
    seqs[counter++] = "----------------------------APEGTRRVAEVFGVLSDPTRARIVCALSIEELCVCDVAAVAGLSVSAASHQLKRLRDRGVVDYRKEGRLAFYRLVDDHVRSLMEEGVE------";
    seqs[counter++] = "-----------------------------------LAELFKVFGDPTRIRILWTLNEAEMCVCDIAVLLNMTQSAISHQLRVLKQANLVKNRKEGKAVYYSLVDDHVREIFDQGLIHINE--";
    seqs[counter++] = "----------------------------------AVAELFKALGDGSRMSILNALLCSELCVCDLTMILKMTQSAVSHQLRVLRGAKIVKSRKEGKNVYYSLDDPHIAMLIETGFEHVRE--";
    seqs[counter++] = "-----------------------------------LEELFKVMGSQTRLRIIALMEANELCVEHLADTVNISVSAISHQLKGLRQLRLVKTRKQAQSVYYSLDDEHIALLFNTARTHLSE--";
    seqs[counter++] = "------------------------------QVIEELAQFFKAVADASRLKLLLYLMKQEANVNELAEATGLTLSGVSQQLKLLKLMKLVKSSKQGKYVYYSLDDHHVKHIINDSLIHLSE--";
    seqs[counter++] = "-----------------------------------LADLFNIFGDTTRIKILHVLSKSEMCVCDISSLINMNRSSVSHQLKTLRQAKLVKYRKEGTIVYYSLSNDHVKQVFNQGLIHLIE--";
    seqs[counter++] = "------------------------------EVVQTLSTYFKALADDNRLKIIHALSREELCVRDVADIIGTTMQVASHHLRVLRDIGLVKNRKEGKHVFYSLKDRKTAEFVQNVIEDLED--";
    seqs[counter++] = "---------------------------------ERLAGVFRTFGDGTRLRILFALLRKEMCVNDLAQNLGMTVSAVSHQLRILRQGELVRTRREGKTVYYAIADHHVSLIIRSGAEHVLE--";
    seqs[counter++] = "-------------------------------------KLFKIYSDFTRLRIIDLLIEKEHCVQDIADSLDASQSAISHQLKLLRDLHVVKTRKQGKQVFYSLQDNHIKEIFLIGYSHATEC-";
    seqs[counter++] = "---------------------------------QKLSKLFKVLSDETRIKILYTISKHEVCVNDIANVLNLSQSAISHQLKTLKDANLIKSRREKQTIYYTLVDDHVHLIYNQALSHIKE--";
    seqs[counter++] = "------------------------------EAIQEVSKIFKMISDPTRLSILFLLQKEELSVGAIAQSLSMEQSAISHQLKTLRTSRLVKSKRAGKNMIYSLDDLHVFSILEQVLTHIEE--";
    seqs[counter++] = "---------------------------------------FSMFADGTRLKIMSALFVSEMCVGDLAILLNMSTSAISHQLASLKKTKLVRMRKEGKNVFYSMDDEHIEKIFQVTYLHVKE--";
    seqs[counter++] = "------------------------------------AALLGVISDPTRLKIMDALRLGELCVCDLAAVLSMSVSAISHQLRLLRTARLVRGRRAGKVIFYTIHDGHVEKLIDMALDHCRQC-";
    seqs[counter++] = "------------HTVTLEILVQGELRESIPEERQNVADIFSLLGDPARLRILIALSVRRLRVCDLVKVVGASESSVSHALRILRAHRVVDVIRRGREAHYALADSHVRALLELAIDHV----";
    seqs[counter++] = "-------------------------------------DFFDALGNPTRLKILALMEAGELCTCDLSAITKLSVSAISHQLRILKDRKIVTYRKDGKNVFYRLDDEHIREILRTALNHLSEVR";
    seqs[counter++] = "------------------------------------AEFFKVLGDPTRIKIVSLFENGELCVNDIVDVVDVSRTAVSHQLRILKDKRIISFRKEGQMKFYHLDDAHVEVIVLLTITHLQ---";
    seqs[counter++] = "---------------------------------EQLAELHKAMGDYTRIRILWYLMQKEYCVSDLAQKMEITESAISHQLRALRIARLVQSHKAGKNVIYSLQDEHIRWILEKTYDHISE--";
    seqs[counter++] = "---------------------------ISKELIGSAAAFFKVLGDETRMKILCTIADSEVCVNDIAEAVDMTKSAVSHQLKLLKDDDLVKSRREGKNIFYSLDDQHVMDILDIAFVHI----";
    seqs[counter++] = "-----------------------------------LCDIFKVLSDPTRMRIILTLVDSEMCVCDIAGAVECSQSNVSHQLRLMRQSGIVKFRKDGKSVYYSLDDDHVKTIIVQAVNHI----";
    seqs[counter++] = "------------------------------QAAVQFADWFKAFSDPTRVKIISALLKRELCVHDLTVLLEMGQSAVSHQLRYLRNLRIVKRRKVGKTVYYSLDDTHI---------------";
    seqs[counter++] = "------------------------------EILFDLADLFKVFGDSTRIRIMNVLFSGPTSVGEIAEVLDMSQSAISHQLKSLKDNNLVSSKRSGRSMYYELADDHVKTIFMTGLEHIKE--";
    seqs[counter++] = "-------------------------QQIEKNIIDSTSEFFKILADNTRLHIINLLLDREMFVNDIANALNMTNSSISHQLKKMKDNDVVKSRKDGKEVYYSLNDDHVKSIFLTTIDHI----";
    seqs[counter++] = "----------------------------AEEILYDVAELFKVFGDSTRIRIICALFESEMCVYDLAACLDMTQSAISHQLRILKQANLVKFRRDGKLMYYSLDDEHVKQIFDAGYKHIE---";
    seqs[counter++] = "----------------------------------SITQIFKAMADPTRVQILYLLSDKEYSVGEIARSLGFNQTTVSHQLRFLKNLRLVKSRREGTSIYYTQDDKHVLELLKQTIRHVE---";
    seqs[counter++] = "-------------------------------------QIFKALSDPNRVKIAYYLQHQELCVCDIADLLDVSVATASHHLRQLKALHIAKSRKEGKNVYYSLSDHHIQTLVAMTLEHQKEMR";
    seqs[counter++] = "------------------------------ETLYDVAELFKAFADTTRIKIIAILKEETLCVGAISEILNISQSAISHQLKALKNAKIVKSKREGKWIYYSLDDEHIKRIFDMGFEHI----";
    seqs[counter++] = "---------------TVEQETSTEHKNLPPEKVMPLADFFKVFGDSTRLKIIGILRHTSLSVCCIADCLGMEQSAISHQLKVLRNNHIVKVEKKGKQSFYSLDDLHVELLYQMGLEHIME--";
    seqs[counter++] = "---------------------------VTPEEATQLADLFRLLGDPTRAQLLALLEAGELCVCDLTETVEVSDTAVSHALRLLRTAGIVASRRAGRMIYYRLADVHVRMLLDLSREHL----";
    seqs[counter++] = "-----------------------------PAAAGKVAETLQALASPNRLRILTRLRQSPCSVTELSAAVGMEQPAVSHQLRLLRNLGLVAGDRSGRNIVYRLYDSHVASLLDEAVYHIE---";
    seqs[counter++] = "---------------------------IQAETLSAAAEIFKALGDVTRLRILDVLERREMKVQEIAAALGMTQSAISHQLGTLRTLRIVKARREGRSTFYSIDDGHVKQLFDLCVEHV----";
    seqs[counter++] = "---------------------------IAKEVS-GLSDLFKVIADETRTKIVFLLSETELCTCDLAEILRLSLPTISHHLKQLKSYRLVKSRREGKSVFYSLEDFHVVELIKLAKEHFQE--";
    seqs[counter++] = "-----------------------------------LAEVFRLMADPGRIRILALLEAGEVCVHDLASVSGLSESSVSQALRLMRAQRVVAGRRAGRHVFYRLDDSHVRMLLDLAITHV----";
    seqs[counter++] = "------------------------------EVLYDLAELFKVFGDSTRIRILYVLFETEMCVYDLSKILNVTQSAISHQLRVLKQNKLVKFRREGKNIFYSLADEH----------------";
    seqs[counter++] = "------------------------------KVLNHLSGIFKVLADPTRLRIIYTLSMGELCVTDISETLEMTQSSISHQLAILKSRDLIKVRKVGRKSYYSLDDDHVLSLFEGGYEH-----";
    seqs[counter++] = "-------------------------------------QLFKLLGDNTRLNIITLLTRKELCVEDLMKCTGMEQSAISHQLKKLRAHHIVKAEKVGKHVWYSLEDHHVLQLYNLADEH-----";
    seqs[counter++] = "--------------------------------------FFKVLADDTRIRILYALKEQEMCAGDIAVFLDMTKSAVSHQLAVMRKMHQVRARREGKNVFYSLDDQHIVDIMEEALIHM----";
    seqs[counter++] = "-----------------------------------MSEFFHMFDDPTRLKIIGALIISEMCVCDIAAVTGMSQSVISHHLKILRQERVIQFRRQGKMAYYSLCDDHIGGIFYQGRIHVQEER";
    seqs[counter++] = "---------------------------------------FKALSDPTRIRILNLLCADEHSVNDIAEILDLGQSTVSHQLRFLKNLRLVKFRREGTTLFYSKDDDHIMNLLKQAIEH-----";
    seqs[counter++] = "------------------------MQVLSPEQVGDVAEVFRLLGEPNRLRIVLACLETERTVGEIGEALGLSQSLTSHHLRLLRTARILRAIRHGRHVAYAIDDDHVRDVLRNMVAHLTE--";
    seqs[counter++] = "------------------------------------ADVFGLLGDPRRLKLLVALLEGELCVCDLAAVTGMSESATSHALRLLRAHRVVSVRRDGRMAYYRLDDAHV---------------";
    seqs[counter++] = "------------------------------ETVYNMATLFSTFSDSTRLKILLCLSRAKLCSCDISAAVNISKSATSHQMRILKMTKLVKAERKGKQIFYSLSDEHVSILLQAALEHVKE--";
    seqs[counter++] = "---------------------------------------FQALGDSTRLQILYALMHHTLCVRDLAILVGVSESAVSHQLRLLRDRRLVRQRRSGNIIYYSLDDEHLAVLFREA--------";
    seqs[counter++] = "------------------------------DVFEEMSGFYKLFSDRTRLKILWALRNGPLCVCDLCAVVGMSQPAVSQQLQKLRNGRIVKSRREGKVVYYSLDDEHIEAALDMAMEHVEE--";
    seqs[counter++] = "-----------------------------PEALNQAAEMFRAMGDPERLRLLTMLQGGERCVGEL---VGENDSTVSARLQSLHRARLLHRRREARHIFYRLADEHVAELLNNALEHASE--";
    seqs[counter++] = "------------------------------------------LATPSRLYILARLQEGPCSVGDLAEAVGMEASACSHQLRLLRNLGLVTGERQGRSIVYALYDHHVAELLDQALFHVE---";
    seqs[counter++] = "------------------------------------AQTFKALSDPTRIRILHLLSQGEHAVNGIAEKLNLLQSTVSHQLRFLKNLRLVKSRREGTSIYYSPEDEHVLDVLQQMIHHTQD--";
    seqs[counter++] = "-----------------------------------LAVIFGLLSDPGRVRILIALLEGEMCVCDLAATTGLSESGVSHALRLLRGPRVVQVRRSGRMAYYSLADSHVRMLLDLGLTHV----";
    seqs[counter++] = "--------------------------------AAKLAPLFKALSDETRVKIIYALAQQELCVCDIAELTGCTLPAVSHHLRLLRTMGLARCRKEGKFIYYTIDDHHVWQIINAAFEHMKE--";
    seqs[counter++] = "----------------------------AEHLVSAAAALFKVIGHPTRVRILLALAAEELCVCDLAQVLDATVSATSHQLRNMRAMGLVYFRTEGKLAYYRASDPVMVSLLQQGVEH-----";
    seqs[counter++] = "-----------------------------------LASLFKLFGDGTRVQILHALEQSEMCVCDLAVLLGVTKSAISHQLKALRLANLVKFRKEAQIVYYSLADDHVKEIIDKGFEHL----";
    seqs[counter++] = "---------------------------------KQVSQLYKVLSDPTRLRILLLLKEGEHNVTAISEQLGMEQSAVSHQLKLLRDSRVVKARREGKTIFYTLDDHHVIDILNQTFEHIE---";
    seqs[counter++] = "-----------------------------------MADLFKIFGDSTRIRILWALHESEMCVRGISKSLDLSMSAVSHQLKALKDADLVQSRRDGKNIYYSLCDEHVEILLNTALTHLKE--";
    seqs[counter++] = "----------------------------AEPVTEGLSTFFKALADDTRLKVIHALSQDELCVCDVANILGSTVQAASHHLRVLRNIGLAKYRKEGKRVFYSIRDRKTAGFIQKVIEDLKK--";
    seqs[counter++] = "------------------------------EMIEHLSEFFSMFSNPTRLRILLLLSKKEMCVGKIAEILRMDQSAVSAQLKVLRHLNLVKAKRHGRYMRYKLNNKHV---------------";
    seqs[counter++] = "------------------------------------ADIFKALADETRLKIFALTQENELCVCDVANIIGTSNATASHHLRHLRNLRIAKSRKEGKLVFYSLDDPHVITLVTMAMAHGQE--";
    seqs[counter++] = "-----------------------------------LAELFKVFGDSTRIRILFVLFEAEVCVCDLAEALHMTQPAISHQLKILKQAKLVRSRREGKSVFYSLADGHVRTIIAQGREHIEE--";
    seqs[counter++] = "-----------------------------------LADVFSVLGDPGRLRLLYALRDGEVSVGALSTLTGQSDSAVSHALQLLRAHRIVRVRREGRRAYYRLDDPHVQMLLEVARSH-----";
    seqs[counter++] = "---------------------------------QQIAQIMRLFGDPARLRLLVLLEVDEMCVGDLAQLAQMNESATSHALRLLRAHHVVAVRREGRMAYYRIIDTHVKASLQLTLDHV----";
    seqs[counter++] = "-----------------------------------MAETFRALADSTRVKIVGCLLEQELCTADLAAILNYSESAVSQHLRVLRQLRLVKQRREGKLVFYSLDDDHVRVLVLVCLNHI----";
    seqs[counter++] = "---------------------------------------FKALGDPTRARIIYALAVSKLSVGELATGLALTQSNVSHQLTVLKQLKLVVGTRNGRNVHYQLADKHIISIFQQVAAHAEE--";
    seqs[counter++] = "-----------------------------------LADVFGLLGEPNRVRLLIALLNGPMCVRDLAATIEMSESAVSHALRLLRAHRVVDVHRKGRVASYELADLHVLTLLKLGLEHV----";
    seqs[counter++] = "---------------------------------QKVSNLFKVIADPTRIDILYTLKDSRLSVSEIKDKLNMSQSAISHQLRVLKDVNLVKDERVGKNIFYSLSDNHVYDIFNQAIDHVRE--";
    seqs[counter++] = "----------------------------------SIAQIFKTLSDPTRLKILYVLSKKDLCVSDISELLSMSQSSISHQLALLRHQQLIKVNRVGRMAIYSLDDDHVLSIFNQGKTH-----";
    seqs[counter++] = "---------------------------------------FKVLGNQSRIRILLEIADEEKCVHEISEETDQSFSNASHHLKTLRDNRLVDYRKEGRHKYYRIKDDHVLKILQECIDH-----";
    seqs[counter++] = "-----------------------------------LSELFKILGDKTRINIIWTLDNREMCVCDIANVLNMTKSSISHQLAILKNAGIVKYYKSGKEVYYTLDDEHINKLYEIGLLHIEK--";
    seqs[counter++] = "---------------------------------EELANFYKIFSDPTKIKILWALDISEMCGCDLAAITGVTKSAISHQLSSLKELNLVKARKQGKIVYYSLSD------------------";
    seqs[counter++] = "----------------------------------SLANLYKIFGDATRIKIVYILFEHECCVCDIAATLGTTQSNVSHQLQILKSNDLVSYRREGKQIIYSLKDSHVKDIFEKGYEHITE--";
    seqs[counter++] = "--------------------------------AEALAESMRAFATGSRLRLLWALLDGELTVEELAERTELSQSAVSHQLRLLRQGRLVSVRRSGRHAHYRLHDPHVVDL------------";
    seqs[counter++] = "-----------------------------------LADLFKVFSDATRIKILFTLLETARCVADIAEATGASQSAVSHQLRILKQAHLVTFKRCGRSIEYSLADDHVYTMLLQGMNHICE--";
    seqs[counter++] = "-----------------------------------LADFFTAFSDTTRLKILFELLESEKTVTEICDNTDFSQSAASHQLSKLRILKLVKVRKQGKFAYYSLDDEHIEHIIETALEHFEE--";
    seqs[counter++] = "-----------------------------PGVDERVAALMGALASPTRLRLFALLESGELSAGELSKAVGMRPSATSHQLRVLRDLGLVRRRREGRRCYYSLADAHLGVLLREAL-------";
    seqs[counter++] = "-----------------------------------LSELFKLLSDPTRMKLVLALSCGEMCVCDLGAALGMTKSAISHQLKTMKQCSVVKSRREGKNVFYSLHDQHM---------------";
    seqs[counter++] = "------------------------------------ADFFKVFGDPTRLKILFLLEQGEKGVNAISEELGMQQSTISQQLKLLRACRLVRFRKDGRNVLYRLNDEHIHEILALGTEHYQE--";
    seqs[counter++] = "-----------------------------------LAGFFSVFSDPTRLKIISALSEKELCVHELSSLLDMKQPSISQHLKMLWQARVVKKRKVGLHVFYRLDDEHIEKIYTWGYEHVKE--";
    seqs[counter++] = "------------------------------EAAASVATTLQALATPSRLLILTELRHGPLPVTKLAEAVGMEQSAVSHQLRLLRNLGLVTGTRSGRSIVYSLYDNHVAQLLDEAVYH-----";
    seqs[counter++] = "---------------------------------------FKVIADQTRMRILLALSETSLSVNEIADILTMSQSSISHQLRVLKDNRLVKGTRLGKQIHYQLTDDHIVQIFKQIIEHIEE--";
    seqs[counter++] = "-EHLSADPLQT-HLIT-----SGLFEPMAPQEFQTSAELFGLLSDESRLRIFWILCHYEECVINLSSLVGMSSPAVSHHLRQLKTRRLIVSHRSGKEVYYKPAD------------------";
    seqs[counter++] = "------------------------------------AKIFKALADDTRIKIAYILAEEELCVCDIAAIIDASTATTSHHLRLLRKMGLTKYRKEGKQVYYSLDDDHVKDLIKIAFEHQQE--";
    seqs[counter++] = "--------------------------------ASRLADFFALFSDCSRLRVISALAISRMCVTDLADVCRMNQTTVSHQLRSLKSMGIVESERQGKIVFYRLADNKI---------------";
    seqs[counter++] = "---------------------------------------FKALGDPTRLGIVLELMETEKCVSEISSSLSISDSSTSHHLRSLRQLKLVKRRREGQKLFYSLDDHHVYLILTIGLEH-----";
    seqs[counter++] = "-----------------------------------------------RMRMISLLASGELCVGNLAIALHMSDSAVSHQRKTVRALRLVGYRKQNRHVF-----------------------";
    seqs[counter++] = "---------------------------------------FKALGDEARLRTLEMLVNREACVSEIAEASKEQISTVSHRLKLLRAEGLVNRRREGRHIYYSLADEHVMELIHNAFEH-----";
    seqs[counter++] = "-----------------------------------MALLYKTFGDATRLRIMYLLLQKEMAVCDIAACLNMTHSAISHQLSVLKNLNLVKYRKFGKTVIYSLADYHVSILIATAYEHITE--";
    seqs[counter++] = "-------------------------------------KLFKVLSDATRLRIYALTVEEELCVCDVSASVDCSIATASHHLRTLLKQGLVKYRKEGKVVYYSLDDHHISSLVHLAMEHVNE--";
    seqs[counter++] = "--------------------------------ATELGEMFRLLGDPNRLRIVASCLSQPMSVGDIADTLDLSPSLTSHHLRLLRSARLLKGTRHGKQVFYDLPDCHVRQMLTNMIEHVTE--";
    seqs[counter++] = "------------------------------QAAAQVASTLQALATPSRLMILTQLRNGPLPVTDLAEAIGMEQSAVSHQLRVLRNLGLVVGDRAGRSIVYSLYDTHVAQLLDEAIYH-----";
    seqs[counter++] = "---------------------------VSEEVVIKISNFYKALSDPSRLKIMSLLNEKGLCVSCIVEKVGMTQTAVSNQLKSLRDVNLVKSERKGKNIIYKLNDDHVRDILNLTMTHMEE--";
    seqs[counter++] = "-----------------------------------LSRMFGAFGDANRLKIMLAVADQDLCVCELGELLGMSAPAVSHHLRRLKDLSLVKTRRQGKLVYYSLDDQHIRDLLVIGQAHLQ---";
    seqs[counter++] = "------------------------------EETQRSVQIFKAFGDYTRYKILYLLYERELSVSEITSKIGVSQSAISHQLKLLRQTGLVSGRRDGQRILYSLADKHIIMIFKQVKEHISE--";
    seqs[counter++] = "---------------------------------------FKTMSDPTRMRIILAIAQGPITVNDLAAMLDLGQSTVSHQLRLLKQARLVAGERSGKQIYYHLVDDHVLEIYALTKAHIEE--";
    seqs[counter++] = "---------------------------VTPAESSRIADAFALLSDPGRVRVLALLEAGETCVCDLAEMVDMSPSALSHGLRLLRTAGVVTNRRDGRMVRYRLADSHVRLLLDVTREHL----";
    seqs[counter++] = "---------------------------------QRAAALFRALGDVERLKLLESLAQREVCVTELAETSRARMPTVSQRLRVLRAEGLVVQRREGKHIFYALADQHVVELVHNALQHASE--";
    seqs[counter++] = "------------------------------------AKIFALLGDAGRLQLVLRCMEKPQTVGELAEASGMSQSLTSHHLRQLRDQRILASERNGRHIFYQIDDEHISCVVRDVFAHV----";
    seqs[counter++] = "-----------------------------------LAETFRLLGDQSRLKILLQCMRGSVAVGDIAGSLDLSQSLVSHHLRLLRGARLVRGERQAKHIFYGIADQHVSQVLQDMAVHISE--";
    seqs[counter++] = "-----------------------------------LAEMFRLMGDPSRLKIIAACLGAPMCVSDIAAKYGMSQPLVSHHLRLLRAARVLRSERRGKQIFYEAADHHVKRVIGNMVEHVCE--";
    seqs[counter++] = "-------------------AKMNEPSILDPETLTSVSKIFKILQNEARLSIIYLLKDQELSVGEITNLINMEQSAVSHKLNALKKAHLVKTRRDGKTIFYSLDDDHVFNLLEQVITHSKE--";
    seqs[counter++] = "--------------------------------SEKLAEFYKTLGDKTRLRILSLLKVDERCVCELVEILGISQPTVSQHMRRLKSVHLVKERRQGRWVYYSL--------------------";
    seqs[counter++] = "------------------------------KTADDLAQLFSILGDGTRMRILFLLRNEETTVQSLADSLDMTHSAVSHHLRLIRPYQLVKSRKKGRNVFYSLYDDCVWHLLEEGLIHLRK--";
    seqs[counter++] = "--------------------------------AERLAEIMQALASPARLRILSMLSARPSTVTELSEQLQIGQTTVSNHLRLLRHLSLVTGSRAGRHIHYSLFDDHVTELLDEAIGHLE---";
    seqs[counter++] = "-----------------------------------LSEFFKFFGDTTRIRVIHLLLSGEMSVSAIAEKLNLEQSVVSHQLRILRTANLVKPTRDGRKIYYSLDDEHIGEIFNTGLAHI----";
    seqs[counter++] = "------------------------------ELLENVSDFFKALGNGTRLQIIWCLSRGELKSSELAAILQMSPSAISHQLTLLKNLKIVSVRREGKNQIYALADKHISQVLDSVVEHYEE--";
    seqs[counter++] = "---------------------TGELKHVLPEFAIETASLFGLLSDSTRLRILYLLYHREVCVRNIAEAIEMSPPAVSHHLRSLKQLGVITSRRIGKEVHYTIAD------------------";
    seqs[counter++] = "------------------------------EEVQGMAQMFKALSDPTRMKMAWLLDEGELCVCDMSILTKQSIATASHHLRLMKSLGIATSRKEGKNVFYSLADHHIRTLIRMTLEHMRE--";
    seqs[counter++] = "---------------------------------------FSALANPIRARIVNRLTDGEASVGELSEIVGVKQPLVSHHLKVLRSAHLVSARKDGQKAMYSLIDDHVASIFLDAFNHMKE--";
    seqs[counter++] = "--------------------------------------FHALRSEP-RLTIMYLLLEKDMCVCELERALGMTQSAISHNLRTLRQLDLVRVRKDGRFAVYSVADEHVRALLELSRSHVMGCQ";
    seqs[counter++] = "-----------------------------------LTEFFKMLGNPARIRILLLLMEQDANVSDLAEQLGMTQSAVSHQLNLLKLNKLVRGCRVGKMVFYALVDEHVQMVIEKGTEHIGRC-";
    seqs[counter++] = "--------------------------------------YFAALSEPNRLKILYILKNGEYCPCELSEILGCTKSALSHQLRILKDKNLIKNRKDGKFIYYSIKD------------------";
    seqs[counter++] = "-----------------------------------LSDFFGLLSESTRLKIILELIKGEKNVSQISKNLDMSQSAVLHQLRILRQGRIVKFKKAGKNVFYSIDDEHVEGIINKAIEHL----";
    seqs[counter++] = "----------------------------------SVAQLFKALADENRAKIFALCQDDELCVCDVANIIGSSVATASHHLRTLHKQGIVKYRKEGKLAFYSLDDDHIKQLFTLALAH-----";
    seqs[counter++] = "------------------------------EVLSGLADFFSIFSDATRMKIISALTITEMCVTDISEILGINQTTVSHQLKIMRQAGVVGFRREGKILFY----------------------";
    seqs[counter++] = "------------------------------EALYSEARIFKALADPNRLKIVKLLKEGELCACELTIALSSSQSTVSHHLSVLKSAGLVKERKEGKWSYFRLSEGAVIEILNQALKH-----";
    seqs[counter++] = "---------------------------------------FHLLRNKTRFKILLLLMEKERNVSELEEIIGGTQSAISHQLAELRNMKLVKDRQEKRMRYYSIYDSHVTSIIEAAVSHINEC-";
    seqs[counter++] = "---------------------------ISNEVLTEIVHIHKILANPSRVKILLLLSEGQQNVSQISDAIGLEQSAVSHQLKMLKAHQLVTQARNGKAINYQIGDSHILQLLKLSIAHAQE--";
    seqs[counter++] = "-------------------------------------DIFKILSEPTRLKILMALSLDSLCVCELASLLDVTQSAVSHQLRILRNAGMVDYERDGKMARYYLRDNMVV--------------";
    seqs[counter++] = "-----------------------EMELINKKEITELAELFKIFSSETRLKILYLLIDTEMCVHDIAKLINMNQSAVSHQLAVLREAHLVRYERKGRVLFYSL--------------------";
    seqs[counter++] = "-----------------------------------------VLANSTRVQILYLLEQSELNVSELTDILKIEQSNVSHQLQRLRDYQLISQKRKGKSIYYSLDDPHIITTLNQLMNHVQ---";
    seqs[counter++] = "-----------------------------------LEKIFKLLGNKQRLIILELLRERSYSVSEIINSLGMEQSAVSHQLKLLREAQLVETEKRGREVLYGLSDSHILILLDNALKHV----";
    seqs[counter++] = "---------------------------------------FKLLSNPSRLQMLKVLEQRELNVGELGDLLGLEQSVVSHQLALLRKHQLVSSERVGKANYYRLDDPHILDVVNEMLEH-----";
    seqs[counter++] = "------------------------------EILQKMSGLLKIAGDPTRLKMLYVLVRGPKCVCDLQEEIQASQSLVSHQLKILRDNGLVKCEKIGNRALYTLSDDHVVALLSIVHEHVME--";
    seqs[counter++] = "------------------------------ENAETAAEALKLLAEPTRLSILALLKDNEMAVGAIAEELGRPTPAISQHLAKLRAAKLVTFRKEGTTTYYSQKDEHVDMLVTNAL-------";
    seqs[counter++] = "-------------------------------VTEGMADLFKVLADDTRLKIVYALCRDELCVCDVATILGITNANASHHLRLLSHMGLAASRREGKMVFYRLQSPHVRHLLQEVLSRGEEDR";
    seqs[counter++] = "-----------------------------PEYITRMSAVFQALQSDTRLKILFLLRQKEMCVCELEQALEVTQSAVSHGLRTLRQLDLVRVRREGKFTVYYIADEHV---------------";
    seqs[counter++] = "-----------------------------------LADCHKALGDKTRLRILALLREEDLCVGELVEILKITQPAVSQHVRKLRNARLVKERRQGQWVYYSL--------------------";
    seqs[counter++] = "--------------------------------AEKIAELFKLISDGTRLRVLVLLCISEKCVSEIADAFGMSLPAVSHHLRVLKQAEIISSHRDGKEVYYSL--------------------";
    seqs[counter++] = "-----------------------------------LEKIFKILGNKQRLTILELLRSRSYSVSEIVDILNMEQSAVSHQLRVLREAQLVQAEKRGREVLYYLSDSHILILLDNALKHV----";
    seqs[counter++] = "------------------------------ELLDDLTDLFSVFSDKTRLRIVCALAMSRTCVTDLSGVLGINQTTVSHQLRLLRNLGVVRSERDGKIIYYSIKN------------------";
    seqs[counter++] = "---------------------------------EQVTDIFKALSDGNRLRIMHLLIQGESSVGHIAHALDLSQSNVSHQLRILKQAHLVKGNRDGQSMIYTIDDTHVTTLLKQAIHH-----";
    seqs[counter++] = "-----------------------------PKIFEMSTDLFSILSDVSRVRILWLLCHTEDCVANIADAVDMSSPAVSHHLKLLKSANILKYTKKGKEVYYTLAD------------------";
    seqs[counter++] = "------------------------------------AAMFKLLGDPTRARLLALLEAGELCVCDLAAATGTQEATVSQSLRMLRASGVVTGRRQGRLVFYRLADAHV---------------";
    seqs[counter++] = "---------------------------------ERLAGRFKGLADANRIKIAYLLTREELCVHDIARLVGISIANASHHLRLMRSLGVTKTRKKGTTVFYSLADRHVHTIVLLGMEHMEE--";
    seqs[counter++] = "------------------------------QVIVNLSSLYKVFADKTRLEILYALHENEMCVCDLAVLLNMTKSAISHQLKTLRLANLVKNRRVGKVVYYSLADEKVYEIFNQSFKQLTE--";
    seqs[counter++] = "---------------------------------QKVSQLYKVLSDPTRLKILLYLKQGELNVTALSEKLNMEQSAVSHQLKLLRENHVVKTDRVGKTIFYILDDHHVLDILNQTIQHI----";
    seqs[counter++] = "----------------------------------ALSDFFRIFGDQTRLRILYALAKTELCVCDLAKLLGASQSAVSHQLQVLRSHRLV---------------------------------";
    seqs[counter++] = "------------------------------DVAEKLAGAFKLLSVEARIRIVQVLKRRALCVTELTSQLGISQSATSQHLRVLKDARIVKFQKRGFHVYYHL--------------------";
    seqs[counter++] = "--------------------------------------------DPTRLKILLSLKEGELCSCDISEISKISISATSHQLRLLRDRKLVKYRKEGKFVYYELYDEKI---------------";
    seqs[counter++] = "---------------------------ISDHTATHLADTFSLLGDPSRIRVLGTLLDGPKRVLDIAQACGHTQSATSHSLRLLKAHHVVAGERHGREIHYALADDHVRALLTLALAHI----";
    seqs[counter++] = "---------------------------------QKILEILKILSDETRLKIVSLLAENELCVCELMEALRMSQSRISNHLRILRNTRIIEAKREGKWIFYSL--------------------";
    seqs[counter++] = "-----------------------------------LADFFDIFGDTSRIKILLALHDKSLPVSSIAELTGLSASAVSHHLSLLRGRRVVKVERKGKYRVYELDDDHVSSVLKMAISHIQEVK";
    seqs[counter++] = "---------------------------------EGIAVIFKALADDTRLKIVYALSQAELCVCDVAALINSTKSTASYHLRLLNHMGLAKFRKDGKLVYYRLADQHI---------------";
    seqs[counter++] = "--------------------------AIDAEAVQGVSALFKALGDETRLKVLALYKGEELCVCDVANIVGSTVATASHHLRLLRNIGIANYRKEGKLAFYSLRDAHI---------------";
    seqs[counter++] = "------------------------------------------LGDPTRLKIIYTLSETSMCVSDIAKTLDLSQSLVSHQLALLREAELVKVKRVSRNAIYSLDDAHVLTIFKQAHEH-----";
    seqs[counter++] = "-----------------------------PQLAAA-ANTFAMLASPARLHLVTLMSGGRFDVGTLAEKVGLSLPTTSQHLSKLRLAGIVSARRAGRHSYYTVEDPHVLSLVEQIFEHI----";
    seqs[counter++] = "---------------------------------------FKVLGDPTRTKIVLALDNREVCVCTLADTLGMTKSAVSHQLAILKANNIVKSRRDGKQVYYSFDDEHITDIIEIAQAHIKD--";
    seqs[counter++] = "------------------------------------ARLFKGLGDETRFRIYALYLEAELCVCDVAGILGTSVATASHHLRLMKNLGLTRSRKEGKMVYYSLDDDHVRLLVKLAIDHAAE--";
    seqs[counter++] = "---------------------------------------FQALGDPERLRLMIRLSEQEICVSELAELAQEQLTTVSARLKSLYAARLVKRRRQAKHVFYSIADDHVLQMIRGAVAHAAE--";
    seqs[counter++] = "-------------------------------------DIFKIIGDPTRLMILHAIEFHELCVCDLGHLVGVTKSAISHQMKLLKKYGLVKGRKVGKMVYYSVIDDNVKNLIHAGYNHV----";
    seqs[counter++] = "-------------------------------------ETFRLLGDPTRLKILLACLSEPKCVNDVASEVGITGSLTSHHLRLLRGARLVRAERQGRQIFYVAADSHVNAMLAEMVAHIRQ--";
    seqs[counter++] = "-----------------------------------LAEVFKVFGDSTRIKILYDLFEGEKNVTEICQDLEMNQSAISHQLKILRTARLVSGKRMGKSILYSLADEHVKTIIAMGIEHIEE--";
    seqs[counter++] = "---------------------------------------FSALADRSRLKILYALSETELCVCDVASLLGMKIATASHHLRKLRDLQILKYRNDGKLAYYSLKDQRVAEILHHTLNQLVE--";
    seqs[counter++] = "-----------------------------------LADLFKVFSDSTRMKIMYKLFDGEVSVGQIATSLDMSQSAISHQLKYLKESNLVKSKRNGKSMLYYLADDHVKIIIKTGLEHIEE--";
    seqs[counter++] = "-----------------------------------LVEFFKTLGDFTRLRIV-LELKTKRCVGELAEELEMSHSAVSHQLNILKANGIVKSQRQGKYIYYIVQDEYV----QNAIE------";
    seqs[counter++] = "----------------------------------AVAEVFKLISDGSRLRILWLLCHREVSVGDIAEMMDMSNPAVSHHLKLLKQSGLVDSRREGKEVFYRLAD------------------";
    seqs[counter++] = "--------------------------------------FFKQLGYSTRVRILCYLIQEPRKVSDIAVHLNMTLSSVSHQLRVLREAGLVSGQRQGKTITYQKKDDHVATIIQNTLDHL----";
    seqs[counter++] = "---------------------------VSPDVLELIAERFRVLADPARLQILNVLQGGEQTVTELMRTTGFRQAKVSKHLQLLYNLGFVDRRKEGLHVYYRL--------------------";
    seqs[counter++] = "---------------------------------------FKMLSDKTRLSIMLLIKEQEMNVSEISRALNMEQSAISHQLSALRSERLVKSRREKRSVFYSPNDQHVYDILTQVIDHLETC-";
    seqs[counter++] = "------------------MARAGDV----PSDYEPVSALFKALANPVRAAIVHLLSDRERTVGQLVEALGLPQPLVSQHLRVLRGALMVATRRQGQEIWYSVCDQHVAHILGDAMKHTQE--";
    seqs[counter++] = "---------------------------------KDIAEFFKLFSNDGRLKIISSLATDNLTVNEIVERTKLSQSLVSQQLKLLKNARILTNEKIGKTVTYSIYDRHILHLLKDVAEHLDE--";
    seqs[counter++] = "----------------------------------SVAQMLKAIADENRAKIYALCQDEELCVCDIANIIGITVANASHHLRTLHKQGIVRYRKEGKLAFYSLDDEHIRQIMMIVLEHKKE--";
    seqs[counter++] = "-----------------------------PDVGE-MVQIFKALADETRLRIYSLTLESEMCVCDVAAVIQSSSATASHHLRYLREHSLAKSERRGKMVYYALADKHVADLYEHAIEHTME--";
    seqs[counter++] = "---------------------------VSQEVVQQVAEYFSLLSEPMRLRLLHLLRDEEKCVQELVDATQTSQANVSKHLKVMWQAGILSRRSEGTSAYYRVEDEMIFELCNRVCDRL----";
    seqs[counter++] = "---------------------------------EKVSQLFKMLSDPTRLKILLYLKDGEQNVTAITQAVEMEQSAVSHQLRLLRENHVVKSHREGKAILYSLDDSHVLDILNQTLKHVEQ--";
    seqs[counter++] = "-------------------------------IAEHAAEVLKAIAHPVRLQIVELLQAEEMCVGDIVNALGAKQAITSQQLNMMKAKGVLSCRRDGARVYYRIENRNVIKLLDCIYDHCEK--";
    seqs[counter++] = "---------------------------------ERIAETLKALSDPTRLRIVSLLRHGELCVCDLTEALQTPQSKVSRHLAFLKNAGWVRARRSGKWVYYQILD------------------";
    seqs[counter++] = "-----------------------------------LSELFWVLSDATRIRILYALSEKEMCVCELARLLNNKQSSISHKLRILRNSKLVGFKRNGK--------------------------";
    seqs[counter++] = "--------------------------------------------NPTRLRILLLLSKKDMCVGKIAEILRMDQSAVSAQLKVLRHLNLVKAKRHGRYMRYKLNNKHV---------------";
    seqs[counter++] = "------------------------------EHSQIAAETFRMLADATRVRILWALFHDELSVNALAEHVGAVPTAVSQHLAKLRLAGLVSSRREGTFVYYSASDAHVKALVAQAL-------";
    seqs[counter++] = "----------------------GEIMVILPDRLQAQSELFKPLSDPTRLKILYLLRNGELCVCEIIFALKKPQSTISHHLNILKKAGFIKGRKEGVWIHYRLADAEIVGVIDNLTSILNE--";
    seqs[counter++] = "---------------------------------------FKALADETRVKIIALLQEPNLCVCDLAQITELTISGASHHLRLLKNMGLARSHKEGKHVRYCIHDEHVKIILEEALNH-----";
    seqs[counter++] = "------------------------------EQLQSLADTFKLMGDKTRLTILALLRERELCVCDLVDVTGMSQPSISQHLRKMKDAGLVSETRKGQWIYYSL--------------------";
    seqs[counter++] = "-------------------------------------------------------------------ALGTSESAVSHQLRRLRDQNLVLPRKEGRVVYYRLADAHVTDLLRNVLEHVGE--";
    seqs[counter++] = "-------------------------------------DLLGALANANRLKILSLIIDGELCVSAINAHVDLSEAALSHRLAKLRKLRLIESRRQGTTIYY----------------------";
    seqs[counter++] = "------------------------------EQAEELAGMFHLLGDVNRLRLICACLEEAVCVQDLADRFSLTPSLVSHHLRLLKAARLMRAERRGKQVFYTVNDEHV---------------";
    seqs[counter++] = "------------------------------------AKIFALLGDAGRLQLVLRCMEKPQTVSELAEATNMSQSLCSHHLRHLRDQRILASERRGRHILYRIDDDHISRVVRDTFAHVHE--";
    seqs[counter++] = "-------------------------------------EVFRMLADSTRIQLLWALIDRELSVNELAGEVGKLPASVSQHLAKLRMSRLVHTRREGTQIYYRLENEHIARLVTDALD------";
    seqs[counter++] = "---------------------------------KKIAEFYKALGDEVRLKILQMLSEQEMCVCEIIERLDMSQPAVSHHLKILRQVGLVKDSREGKWIYYSLHD------------------";
    seqs[counter++] = "-----------------------ELPALDDQHIASLAHLFHLLGDEGRIRLVLACMAGPVPVSELSAVTGMSQSLTSHHLRHLREARILRSERQGKQILYRLDDHHI---------------";
    seqs[counter++] = "-------------------------------------DIFKLLSHPMRLQIIYMLEQQTMNVGEIVERLGLEQSAVSHQLTLLRKGHLISTCQIGKIVCYSLNDKHILDIVNEALEHTQ---";
    seqs[counter++] = "------------------------------------------LSDPTRLRLLALLVREELSVAELQEILGMGQSRVSSQLALLRQVDLVTDRRDGKKAFYSIRSNRTLALLKSAIDSVSE--";
    seqs[counter++] = "------------------------IQPLSRKNAQSAEKLFKCLASASRLKILFVLLESEKSVGDITVDCDMSQPLVSQHLRHLRDNNLVYTKRHGKQVYYSIADEHIKHVVADCIQHVQ---";
    seqs[counter++] = "---------------------------IASELAPAVA-LFRSLGDPARLAILDRLARGEARVVDLTDELGLAQSTVSKHLACLRDCRLVDFRVEGRQSFYALARPELPALFRSA--------";
    seqs[counter++] = "------------------------------EEAAQLTSVLSLMADPTRARVLALDMVKELCVGDLALALESNEDAVGYALRLLRTAGLVTNRKQGRVVFYRL--------------------";
    seqs[counter++] = "------------------------------------ADLLKALSNPGRLRILCALVPGEMSVGDLETALGASQSYVSGQLLRLRNEGLVSCTRDGRSIRYQLAD------------------";
    seqs[counter++] = "------------------------------------------LSTPSRLLILARLREGPLPATELAAEVGMEQSACSHQLRLLRNLGLVVGERRGRSVVYALHDDHVAGLLDQAVYHVE---";
    seqs[counter++] = "------------------------------------AEYFKAISDPARVRIIYALANGELCVCELMLIMGMQQTVVSHHLKILKYANIVSDRKSGKWVNYSLADRRVL--------------";
    seqs[counter++] = "------------------------------------ANIFKLLGDYNRIRIINALKIKELCVCELSILLDMSQSSISHQLRILRHHNIVKNRKENKRVFYSLNNDKIFKLIEESI-------";
    seqs[counter++] = "-------------------------------------ELFTQLSSSTRIRLLCILAIEEMCVCELADMLKMSQPSISHHLRLLRQSGVVKYKKSGKRVIYYITD------------------";
    seqs[counter++] = "----------------------------------TLAELFKALGDPTRLNVLQLLTERQLCVGAIARRLGVTQPAVSQHLKVLKHLGLVKASRDGYHIHYSI-NQDMLASYKTHIDEWQ---";
    seqs[counter++] = "-----------------------------------MADILKVLGDPNRLHILSLISRQELCVCEITSILNISQSNASQHLARLRSVDLVKERRNAQWIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FQALSEPIRLQILDLLQEQELCVCEIREKIKISQSKLSFHLRILREAKLARSRQQGRWVYYSLNPEQLL-LLEQYLNQLRE--";
    seqs[counter++] = "-------------------------KALQREHLQSAADLAKSLSDENRLRILDCISRGKQSVGGIAKELSLSQPLVSHHLRELRRTLLVKIERNGAFVYYELSD------------------";
    seqs[counter++] = "-----------------------------------------ILGEPSRLKIVLALSEGDMCVYHIVKAVNSNQSAVSHQLRILRENKVIKSFRKGQNIVYSLDDEHIMQIINIVKTHVEE--";
    seqs[counter++] = "----------------------------------SLAKYGKAISDPKRIELMDLLVQAEKNVDVLSKETGMSIASTSHHLQILKEARLVSDRRKGRNIFYQIED------------------";
    seqs[counter++] = "------------------------------EHAEDLAQVMQALSSPGRLLILARLDDSPCSVSTLVEDCGMAQATISNHLRILRHLDLVTGQREGRQVIYSLYDAHVQEFFRQALGHI----";
    seqs[counter++] = "-----------------------DLSSLSRSQAEVASELFKSLSNPNRLQIVAALALGEHPVGDLETMLGIKQPTLSQQLAELRDAGFVESRREAKQVFYRLGDKRLLAL------------";
    seqs[counter++] = "-----------------------------------LADFYKLFSDSSRIKILFVLLSGAHCVKHIAEKAEMSQSAVSHQLAVLRRSNIIRQTRSGQNITYSLADDHVKLLLELAIAHIRE--";
    seqs[counter++] = "------------------------------------ANLFKALADETRLSIYALTIEEEMCVCDIAAVIGSSMATASHHLRYLRERSLAKSERKGKQIYYSLSDNHVRQLVKIAHEHTKE--";
    seqs[counter++] = "------------------------------QAATQTASLLKTLGNPDRLLLLCQLTQGEACVSDLEASLGIQQPTLSQQLTVLRNEELVATRREGKRIYYSIAD------------------";
    seqs[counter++] = "------------------------LQMNMTQAATQTASLLKTLGNPDRLLLLCQLTQGEACVSDLEASLGIVQPTLSQQLTVLRNEGLVATRREGKRIYYSIADEKLFTL------------";
    seqs[counter++] = "-----------------------EMQDIAAQLQELHARVCKAIADPKRLLIINELRDGELSVGDLCEALGFSQSNASQHLSVLRERGIVNARRSGNNVFYSLRSRKIV----QAVDLLRE--";
    seqs[counter++] = "------------------------------------AKFFHGLANPTRLKIVETLLAGEMSVSQIVDAVGVSQSQVSNQLACLKWCGYVTSRKEGKYILYRISDERVRAILQLA--------";
    seqs[counter++] = "------------------------------------AEGFRLLADPTRIKILWALLQGESSVACLAEMVGAAPTAVSQHLAKLRLAGLVKGRREGTYVHYSAADGHVRALLAEALFH-----";
    seqs[counter++] = "---------------------------------------FKALSDFNRVRIMEFLENGEASVGHISHSLNMTQSNVSHQLKLLKSTHLVKSKRQGQSMIYSIDDIHVSTLLKQAIHH-----";
    seqs[counter++] = "----------------------------APEVGVTLARALLALTDPSRVRLCRLIARQAMTTADLADRLTMTRPQVSRHLRALRELGLVRMERHGRHVLYEL--------------------";
    seqs[counter++] = "---------------------------------QMLDEFFKSLSEPVRLRVMYLLERGELCVCDIVSSLEVSQSVVSRHLAYLRNAGLVSSRRQGVWIYYQL--------------------";
    seqs[counter++] = "------------------------------DLAASVSEKLKVYAQPQRLMILSCLWRGERTVADIGQATGIVQPALSQQLAELRRADLVQTRKEAKQVWYRLAD------------------";
    seqs[counter++] = "---------------------------------KKLASFFDVLSDGTRLKILSALAITPMCVSDLSAVLEINQTTVSHQLARMRLAAMVDFRREGK--------------------------";
    seqs[counter++] = "-----------------------------------LAELYKLLGNVTRLKILLALAQGELCVCDVAHVLGLTVAATSHQLKLLRDQGWLAMRNDGKMVYYRL--------------------";
    seqs[counter++] = "-------------------------------------KILSLLKNPVRLQILYILSQQSLSVSEIVELLHLDQSLVSHHLSDLRKYQLVSTKRDGKSIFYELDDPHILDIVNETLEH-----";
    seqs[counter++] = "-----------------------------------LSETFRLLGDPSRLRILLHCEEGPKSVTDISETLELSQSLVSHHLRLLRGARLVTRVRHSKQMFYEISDQHVGDVLLDMLSHVRE--";
    seqs[counter++] = "-----------------------------------LAELFAALSDPTRLRLLNLMRDREVCVCDFVEILGQSQPKISRHLAYLRRAGIVCARREGKWMHYRIE-------------------";
    seqs[counter++] = "---------------------------------------FQQLGDPTRLKILWILCHCRECVSDIAAAVGMSDAAVSHHLQLLKRSGLIVGSRVGKEIHYTLSDERRAGLLHRMMDALFE--";
    seqs[counter++] = "-----------------------------------MADIFSVVADPTRRELLGTLLSAELSVGQLVERLGVSQPTVSKHLRVLRDIGLVTSREEGQHRYYRL--------------------";
    seqs[counter++] = "------------------------------EYFQTVALVFRQLSDANRVRLFWLLCHCEECVVNLAAMMGMSPPALSHHLRQLRESGLIVSRRDGKEVYY----------------------";
    seqs[counter++] = "------------------------------------AEVFNQLSDGTRLRILWLLCHSEECVNDIAAAVRMTAPAVSHHLKTLKQNGIIKSRRLGKEVLYTLED------------------";
    seqs[counter++] = "-------------------------------------QIYDALSDFTRFQILGALLLGEKSVTELQELLSVSQSATSHQLRLLRDRGLVTAKRDGRRVIYSLADDHVITLISVGLAH-----";
    seqs[counter++] = "--------------------------------------FLNLIADKRRIDIIYLIMKKRLCVQDIAEIINETVANTSYHLQQLKKGNIVKVEKEGKEVFYSLSDKHVYEILENVLEHI----";
    seqs[counter++] = "-----------------------------PQLLETAAGTLRMLAEPTRLNLLFQLTDGPKTVTELTAAVDVPRTVVSQHLAKLRLSGLVDTRKDGRHVIYSLHDGHLIRLIRETINH-----";
    seqs[counter++] = "--------------------------------AQAATALLKVLANENRLMILCTLMGGEMSVGELNTAVPLSQSALSQHLASLREAGLVSTRKEAQTVYYRLQ-------------------";
    seqs[counter++] = "------------------------------QAADAAVELLKALANPVRLKLLCFLVEQERSVGEIASRLGVRETLVSQHLSLLRRDKLVAYRRDGQTLWYRLAD------------------";
    seqs[counter++] = "-----------------------------PKTSELQAKLFRGFADPSRLAILETLRDGPLTVGEIVQATGLSQSNVSNHLGCLRDCGLVTATQQGRFVSYALSD------------------";
    seqs[counter++] = "------------------MAESQEMH---QEEAQNAASFLRSLGNPHRLQILCRLALGEQSVGQLHQFFDLSPSAFSQHLAVLRQQQLVSIRKESQTVYYSIKD------------------";
    seqs[counter++] = "------------------------------------------LSDAGRLRLLLWLAQREMCVSELVALEQDKVSSVSARLQMLHAVNLVTRRREAKHMFYALADVHVHRLLRNILDHAAE--";
    seqs[counter++] = "---------------------------------------FAVIAEPSRRRILDLLLQSESNVTDLAQALGLSQPLVSKHLRTLRQSGLVKVRKSQQHIY-----------------------";
    seqs[counter++] = "------------------------------------ARFFRVLGDPVRMGILELLLEGEKNVSEIVSRLGMSQSRVSNHLACLRWCGLVSVRRKGSFIYYSLADEQLRELLEIANDRVEK--";
    seqs[counter++] = "----------------------------------TLSDILHLMGEPNRLRLLVTCLEGAKSVSELAQQLQLSVPLTSHHLSLLRSARLLVANREGKHIYYSIYDAHVRCILDDMLKHFTE--";
    seqs[counter++] = "---------------------------------------FELLSDGNRLRLLLCLHHADICVGDLAAALDMTGTAVSHALRLLRNQGWVSATRDGRSMRYRLTD------------------";
    seqs[counter++] = "-------------------------------------DFFKALAHPTRIVLVEDLAEGEKCVCDLAQKIDADISTVSRHLRELRNAGIVANQKRGNQVFYSL--------------------";
    seqs[counter++] = "-----------------------------PEVDREIIEFLKALSNPIRLKILKLTRDNWLCVCLLSEVLGEDQTLISHHLRTLKTLDLVKERREGRMRFY----------------------";
    seqs[counter++] = "------------------------------ENADQAADFLSALANNKRLLILCKLLHNEMSVGALAKAIDLSQSALSQHLAKLRALDLVSTRRDAQTIYYMVSSPHI---------------";
    seqs[counter++] = "---------------------------------KNLSSYFKGLADENRLRILNLLFHGELCGCDIQYVLGASQSNVSRHLSYLKNAGLVNDRRKANRVYFSL--------------------";
    seqs[counter++] = "------------------------------------AELFKVLSSATRLRLLRTLAEEVSTVSRLAERSGLAQPLVSQHLRTLRSAGLVSVERVGREAHYSVADTHVTHIVEDAVHH-----";
    seqs[counter++] = "-----------------------------------LAETFGILSDSTRLSIVLACMETEVSAGDIATKLKVSPSLVSHHLRLLRAVRIVRSERRGKQVFYTMTDACVRDILTTMINHLPE--";
    seqs[counter++] = "------------------------------------AKFFRGLADPSRLALLLALRPGEKTVSTLSEETGLSQSNVSNHLACLKDCGLVVNRQEWRHVYYRIADSKVLTL------------";
    seqs[counter++] = "---------------------------------------FKCLSDPTRLQILHLLMEGEHCVGDIALKIGTTQANISKHLSLLKNAGLVVSNKQGMKVIYSLQ-------------------";
    seqs[counter++] = "----------------VPLPTSTLMQDIAAQLQELHARVCKAIADPKRLLIINELRDGELSVGDLCEALGFSQSNASQHLSVLRERGIVNARRSGNNVFYSLRSRKIV----QAVDLLRE--";
    seqs[counter++] = "---------------------------------KSLNEQFSVIANPNRLEMLEFLAQCEYSVDDLAKVMGLSVANTSHHLQQLRLAGLVASRKEAQRVFYRLKGDGVVEL------------";
    seqs[counter++] = "------------------------------------AEMLKALADPHRLGILLRLSKRELSVGELAEIEQEKVTTMSARLKVLLTAHLVKRRRKGQSVLYSLADTHVLNLVDNAIEH-----";
    seqs[counter++] = "-----------------------------PDVVQ----LFKVLADETRLEILRLLALTDLRVGEIVAHLGLPQNAVSYHLKQLRRLRLLRDHRSARDIYYSVDLDHLQALYAAA--------";
    seqs[counter++] = "-------------------------------------ETLKTLANQKRLEIVQLLGQGELTVSEMIEMLGISQSNLSQHLAVLRRYQIVATRKEGLYVYYRLTDGHI---------------";
    seqs[counter++] = "---------------------------------------FKILGDENRLRILNLLRKGELCVCEIELVLETTQSNVSRHLGKLRNEKIISFEKKAQWIYYRI--------------------";
    seqs[counter++] = "------------------------------------ADLFKALSSPARLRILSALIAGPSDVGSLADATELSQPLVSQHLRTLRLAGIVQVERIGRNAVYSLHDEHIAHIVGDAVSHVSE--";
    seqs[counter++] = "------------------------------------ARLFKVLGSESRLALLRILQAKPATVGVLVEKSGLTQPLVSQHLRVLRQTGLVTRDRQGKEVTYQIADHHVAHLIDDAIIH-----";
    seqs[counter++] = "-----------------------------------LANLFKVFSDSTRIRILFSLFDYEKNVNTISKELNLSQSAISHQLRYLKDSNLVKSQRDGQAMIYALSDRHVKFIIKLGLEHLYE--";
    seqs[counter++] = "-----------------------KVEAVKEELAASISQLFKVLADERRFKILYALTKQELCVCDVALIIGATVATTSHHLRTLSKQSILTHEKIGKMVYYQLSNPMIQQLVLDAMNQEKE--";
    seqs[counter++] = "---------------------------------KAVVRIFDVLGNRTRLRILLALASEELCVCDIAHALNLSISAASHQLRALHDRDWLRMRNDGKMVYY----------------------";
    seqs[counter++] = "---------------------------------ENVGEFAKALGHEKRLLIIELLSSHERCVEDLATAMGIGVKSVSAHLKVMRTQGILTTRKEGLRVYYRLRNDNILKLFQ----------";
    seqs[counter++] = "---------------------------------KELSNFFNAFGNPTRLKILLALKEEELCTCDLSNITGLSVSAISHQLRVLKGRKNVNYRGDGK--------------------------";
    seqs[counter++] = "---------------------------------------FHALGEPLRLKVIEILHREELCVCDLCERLHLRPSKLSFHLRALRQANLVLSRQQGRWVYYRL--------------------";
    seqs[counter++] = "-------------------------------------EVLRLLADRTRLAILAMLDGTEMPVNAIAEALGRPAPAVSQHLARLRAGRLVTSRRDGTTVFYGQPDEHVAALVANVLQHTEPHR";
    seqs[counter++] = "-------------------------------------EVFKAVADPCRLRIVKLLKEGELCVCEIMTALDKPQSTTSHHLSILREAGLVRERKDGKWSYYRLAD------------------";
    seqs[counter++] = "---------------------------------------FRALSDPIRLNVINLLQEKEMCVGDICLALKIAQPKLSFHLRVLRESGLLQTRQEGRWIYYRL--------------------";
    seqs[counter++] = "---------------------------------------FKALADANRRKILFLLKESDLTAGEIASEFDISKPSISHHLNILKNAGLVEARREGQQIYYSL--------------------";
    seqs[counter++] = "------------------------------------------LGEVNRLSLLALLHAGDLCVSDLAVAVGMSDSAVSHALRLLRAHGMVTAHREGRLVRYRL--------------------";
    seqs[counter++] = "---------------------------------------FKILSDETRLRIIILLAQEELCVCQISGVLNVSQPKVSKSLSRLRDLNLVIDERKEKFVFYKLKTENFVSTIRNIMDNLNESR";
    seqs[counter++] = "----------------------------------TLESLFSALADRTRLEIVLFIMRGKASVQEIARGINKSQSLVSHHLACLRNCGIVKTERKGKYVYYSLLDNEVVSIIKLAVEH-----";
    seqs[counter++] = "---------------------------------------FQALADPSRRAIFESLTRGEAAVKDLTTRFDISQPAVSQHLAALKDAGLVSGRREGRHVYYRVE-------------------";
    seqs[counter++] = "------------------------------------AALFHALSDAGRLRTLAILAEQSSSVSHLAEVTGERIGTVSARLKVLLQANLVTRRREGQSAIYSIADQHVLELIHNALEHVNE--";
    seqs[counter++] = "-------------------------------------DFFGIVADETRLRIIGLLNQKELCVCEMCEILGLSQPKVSRHLSKLRDAGIVIDSRQGQWVFYYL--------------------";
    seqs[counter++] = "---------------------------------------FKALGDNNRLRILSMLNVRELCVCEINAVLKVSMSTISSHLKILRNAGLVTSRKDGRWIIYRLE-------------------";
    seqs[counter++] = "------------------------------------AELFKALATPSRLKILLTLSHGPASVSNIVIATELSQPLVSQHLKVLRGIHLVSVQRDGREAIYSLMDDHVAHIILDAMAHVNE--";
    seqs[counter++] = "------------------------MMSVSEETSDEAARQLKAVADPVRLRILYALSKEPLCVCELSVLLNMSMPAVSHHLRILLSAGLLKVRKEGKFACYHLRDSH----------------";
    seqs[counter++] = "-----------------------------PQAAHEASDLLKALAHHTRLLILCILAKQERTVGEIENILGIQQAMVSQQLARLRLEGLVNTRRQGRLVYYSIGNVSVLAFLESLFD------";
    seqs[counter++] = "------------------------------------------LAEPTRLHLLWQLSNGPKTVTELTDASGAARTVVSQHLAKLRLSGLVDTRKDGRHVIYSLHDGHLVRLIRETINH-----";
    seqs[counter++] = "----------------------------------TISQIFKILSDETRVKIVALLTENELCVCDLANIVEATVAATSHHLRFLKKQGIANYRKDGKLVYYSL--------------------";
    seqs[counter++] = "------------------------------------------LGDPTRLRVTALLSGEELCVCDLAWVVGLAQNLVSHHLRLLKGAGLVTGRRHGRLVMYAL--------------------";
    seqs[counter++] = "------------------------------------AAIFKALGEVNRTRIVKALSLEELCVCDIATIIDATIATTSHHLRSLHGQGIIKSRKEGKMVYYSLDDDHIRQIVSMAFLHQEE--";
    seqs[counter++] = "------------------------------EDAEIAAGFLSAMANPKRLLILDSLVKEEMAVGALAHKVGLSQSALSQHLSKLRAQNLVSTRRDAQTIYY----------------------";
    seqs[counter++] = "------------------------------------------LSDPHRQSILKMLAHQEMGACEIIHSIGLSQPAVSHHLKILRQARLITSQKQGKMVFYSL--------------------";
    seqs[counter++] = "------------------------------------AEYFKALSHPTRIKIIELLSKKEMCVCQMMAALNLDQSHVSRHLMVLRANEMVKTRREGTIIFYSLTDENII--------------";
    seqs[counter++] = "-------------------------------------EMFRAFSDRTRLRILNLLLRGEMCVGDLVSILEMSQPRVSQHLSCLRNSGLVVGRREGQWNHYSL--------------------";
    seqs[counter++] = "---------------------------------------FKLLSNPTRLNILMLLEHEQLSVNEIVTQLEITQPQVSHQLAILKEQQLVSAKKIGKKSLYQLSDPHILSV------------";
    seqs[counter++] = "-------------------------------------DIFEALSDPHRRKILDMLKHGELCSSDIASQLDITPASVTHHLNKLRSANLIIKTRKGRNIYY----------------------";
    seqs[counter++] = "------------------------LERLEPQISEA-ARLMEMLSHPARLRILCTMLGGEKSVQELAINASLSQPAMSHHLRKLRDSELVNTRRDKQTIYYSLKGEHVAAVLE-VLEHL----";
    seqs[counter++] = "---------------------------------QARAERLRALGEPTRLRIYALHAGAELCVCDLAWIIGSSQGLVSHHLRQLRAAGLVTSRRDGKLVMYRL--------------------";
    seqs[counter++] = "------------------------------------ARIFKVLGDRNRTAIYALCENDTLCVCDIATIIDASVATTSHHLRTLYKEGVVTYEKKGKLAMYALDDNHIRQLMMTTLEHAEE--";
    seqs[counter++] = "---------------------------------------FELLSDANRLRLLLCLHHAPICVTDLSVALGMSGTAVSHALRLLRSQGWVSATRDGRSMRYQLAD------------------";
    seqs[counter++] = "------------------------------------------MADPLRLQVLNLLSKQELCVCDLCDRLQVKQPKLSFHLRQLREAGLIQARPQGRWTYYSL--------------------";
    seqs[counter++] = "-----------------------------PDFVETSAALLQAMANPARINILIILAEREVSVGPLSELVGLSQSALSQHLAKLRQAGLVSTRREAHTVYY----------------------";
    seqs[counter++] = "------------------------------------ADLFKVLSNPVRIQILDALRLGEQSVGYIAEWLEIEASAVSQQLAVLRSRNLVTSRKQGNYVFYSVRD------------------";
    seqs[counter++] = "---------------------------------------FQALSDPLRLQILQLLRHQELCVCELRDHLDIAQSKLSFHLKTLKEANLVRSRQEGRWIYYSL--------------------";
    seqs[counter++] = "---------------------------------QTTADIFKQLSDPTRIRIFWILCHCEECVINIASMMEMSSPAVAHHLRLLRSSGLIESRRDGKETYYRAVD------------------";
    seqs[counter++] = "-------------------------------------------ADEKRLKLVNLLLKQDYCVGALAKELEISKSAVSQHLKVLRESELVIGEKRGYWVHYSVQEDKLIEL------------";
    seqs[counter++] = "---------------------------------ERLTEIFKLLSDETRLRVVMLLAREETCVCEIVGVLGIPQPKVSKALSKLRDLGLVNDERKEKYVYY----------------------";
    seqs[counter++] = "------------------------------------AELFKALGHPLRLRILELLRTGEKTVGELQRLLMVEASSVSQQLAVMRAHHLVESRKQGTNVFYSVKD------------------";
    seqs[counter++] = "------------------------------------AEFFRTLGHPARIRALELLSEREWSVSELVPEIGLEASHLSQQLGVLRRAGLVTTRKQGTTVFYAVASPEIVTL------------";
    seqs[counter++] = "------------------------MQTPATTIPHLIAAGFYALCDPLIISVLELLRQQELCVCDLCKALGVNQSKLSFHLKTLKETALVHSRQEGRWIY-----------------------";
    seqs[counter++] = "---------------------------------EELSQSFRVLGDPTRLRILRLVAEAPLNVTELVSLVGVAQSSVSHHLGKLKGLGLLREERHAGYSYYSL--------------------";
    seqs[counter++] = "--------------------------------------------DEARLRLLVRLSEGERCVTDLAAGSDERMSTVSQRLKVLKGEGLVTGRREGKHVYYTLADRHV---------------";
    seqs[counter++] = "---------------------------MAVELVQSL----KALADDKRMQIIHLLLEGDLCVGALAQSLGISEPAVSQHLKVLREAGLVWGEKRG---------------------------";
    seqs[counter++] = "-----------------------------------------------------MLFLKEYSVNEIAENLHLRQSTVSHQLRFLKNLRLVKYRREGTTLYYSHDDAHVMNMLKETINH-----";
    seqs[counter++] = "----------------------GAMAAAQPPIYRLKADFFRLLGHPARVRILELLRDGERAVGELQAALGLDSSGTSQHLTAMRRQGLLESRRAGTSVLYRVKDPRIFQLLEVA--------";
    seqs[counter++] = "------------------------------------AELLALLADRTRLALLHALTGGEADVSTLTQVCGAARPAVSQHLARLRLAGLVNTRKEGRRVIYSLRDGHLRRVVDEAL-------";
    seqs[counter++] = "-------------------------------------ETFRLIGDPSRLKILYILSHTEENVRNISAAFDMSPPAVSHHLRLLKSMKIIKSERRGKEVYYTL--------------------";
    seqs[counter++] = "-------------------------------------KIYKVLSNMNRIKILYFLENHEADVSRIVDHVQLSQPIVSHQLAILYHYQLVTRHKRGKHVYYCLDDPHILEMVDAMLGHV----";
    seqs[counter++] = "---------------------------------KGVSQILKAIADENRAKIYALCQDEELCVCDIANILGVTIANASHHLRTLYKQGVVNFRKEGKLALYSLGDEHIRQIMMIALAHKKE--";
    seqs[counter++] = "------------------------------------ARVFKVLSVESRVRLIELLKQRSLCVNALARSLAITPAAVSQHLRVLRDAEVVIADKQGYHVHYRI--------------------";
    seqs[counter++] = "------------------------------KVAGQAAKLLAAIANARRLVILDIISQQETSVGSLAEQVGLSQSALSQHLAKLRSAKLVNTRRDAQTIYY----------------------";
    seqs[counter++] = "-----------------------------------------VLANANRLLLMCQLSQGEKCVGELEELLDLHQPTLSQQLGVLRSEGLVSTRRDGKKIYYSVADARVLAL------------";
    seqs[counter++] = "------------------------------EKSEQAARCLRAMAHPARLMILQLLSGSEMSVSELEKALDISQSNLSQHLNLMKDKQLLSSRRSGNQVYYSLKDPRLLGL------------";
    seqs[counter++] = "------------------------------------ANVFSLLSDPTRLRIILTLKEGEQPVGMIAEKLGRKPTIISQHLAKMRWGKLVRTRQEGTRIFYSLSDEHVSALVDQAI-------";
    seqs[counter++] = "-------------------------------------DIFKALGDENRLRIINLLSKGKLCVCDIEAILMMTQSNVSRHLNKLKNVGIISSEKKSQWVYY----------------------";
    seqs[counter++] = "-----------------------ELYQVEREELLSKAELLKVLGHPERLAIVLLTMDGERCVKELVEALGISQPKVSQHVGLMKELGILTFRKEGTKVLYRVNDRKVV--------------";
    seqs[counter++] = "-------------------------------------DIFRALGDPTRLRIVHLLRAMELAVGEIAQVVGQSQPRVSRHVRILAEAGLVERRKEGNWVFLRL--------------------";
    seqs[counter++] = "---------------------------------------FHILQSDTRLRILFLLSQKQMCVCELEAGLDVTQSAISHSLSIMKNAGIVGVKREGRFAIYFIHDEEIRKMMQICRKYAEESR";
    seqs[counter++] = "---------------------------------------FGILSDKTRLRILLLLQNRELCVCEIFGALRMSQPRVSRQLAILKQSRIIKDRRSGKWIYYRIEE------------------";
    seqs[counter++] = "--------CPMIYALSRNIVISIFLMNISSAALQEIADFFEVLAVPTRLGILLAIGEREVCVCHLEAVLKLRQAAISQHLQVFKKNGWVISRRQGRFVYYKLSNPSVLPL------------";
    seqs[counter++] = "-----------------------------------MADIFDVVADPTRRDLLRVLPTGEISVSELVQTLGISQPTVSKHLRVLRDSGLVSVREEGQHRYYRLE-------------------";
    seqs[counter++] = "--------------------------------ALSATELFRLLGDETRLRAVVLLRRGELCVCELTETLGVSQPKMSRHLATLRDSGLVETRRSGQWIHYQL--------------------";
    seqs[counter++] = "----------------------------APDAPEQAAKFLKSLGHPDRLKVLCSLVGGEQSVASIEAQVGASQSAVSQHLSRLRSEGLLQARRDGRQVYYSIAD------------------";
    seqs[counter++] = "-----------------------------------------VLGNPDRLLLLCQLSQGEYAVGELETLLGITQPTLSQQLAVLREEQLVSTRREGKQVFYRIDSEAALALMQ----------";
    seqs[counter++] = "---------------------------------------------------------------DLAQVLQMTPSAISHQLRVLKQMKLVTNRREGKTVFYSLADSHIKTIMNQGMEHIRK--";
    seqs[counter++] = "-------------------------------------EVLRVLADPTRLQLAGLLLDEEKSVSDLASQLDRPATGVSQHLAKMRMARLVSTRRRGTSVLYRVENDHVRQLVVDTIGHVE---";
    seqs[counter++] = "------------------------------EVADRLAGIFKQVGDPTRLKIFWLLCQQEECVTNIAYLLDMSSPAISHHLKSLKLADLIESERKGKEMFY----------------------";
    seqs[counter++] = "-------------------------------------DIFKQLSDPTRVRIFWLLSHREECVINIAALLDMSSPAVSHHLRSLTQSGLIESRRCGKEVYYKAGD------------------";
    seqs[counter++] = "-----------------------------------------VFAHPHRLMILSRLLRGECTVGEIDAATGIGQPALSQQLAQLRRAETVRTRREARQIHYSLADAHV---------------";
    seqs[counter++] = "-------------------------QLIGPELSRFKAEFFKALAHPLRIRIVDELRNGEVGVTHLCARLEVEQSSLSQQLAVLRARYIVNARKDGLSVLYSIRDPEIFSL------------";
    seqs[counter++] = "---------------------------------------FHALSDPIRLNILDILNNQEMCVGNICDLLSIKQSKVSFHLKILKESGFVETRQQGRCIYYRL--------------------";
    seqs[counter++] = "------------------------------EVFESTARYFSVLGEPTRLKILHVICHKEKCVNDIIRATGLLQANVSRHLGLMYQAGLLSKRRDGTQIFYRV--------------------";
    seqs[counter++] = "-----------------------------------LADVFRLLGEPNRLRILCAIGSDCKSVSELMSETGIGQSNTSFHLRFLRNAALVNAEPRGRNMYYRVRDKELLKL------------";
    seqs[counter++] = "--------------------------AAAKEELEEIASLLKLLGDKTRLTIFALLKVRELCVCELTELLHVSQPAISQHLRKLKLANLVRERKVGQWVHYSLRQRHIVLLEKSA--------";
    seqs[counter++] = "-------------------------------------ELFRILASQIKLEILSLLLENDLCVCQICAIVGTSQPNISQHLNTLRHLGVVDIRKDGTFIYYSL--------------------";
    seqs[counter++] = "-----------------------EFERICPFMLETFETVAKAVADPSRVRILKLLEGGELCVCQITTVLDLAPATISKHLAALKTAGLVQQRRDGKWVYYRLAERDFNAYARSFLD------";
    seqs[counter++] = "--------------------------------------FLRAISDPNRLKILCVLQGGSKCVCEIVPLVGISDKLASHHLKQLKNVGLLIEKREGKFIRYNL-DKKVIKEYKNV--------";
    seqs[counter++] = "-----------------------------------LSDILHLMGEVNRLKLLIECLKGPKSVSDLAEQLQLSVPLTSHHLSLLRSARLLMANREGKHIYYSIYDAHVRCILEDMLKHFTE--";
    seqs[counter++] = "---------------------------------------FDLLSDPHRLELLSLHRAPGICVSDLAAALGRSENAVSQALRVLRQQGWVSSTRVGRAVSYRLDD------------------";
    seqs[counter++] = "--------------------------------AEEVSELLRILAHPERLMVLCQLTKGEVGVGQLQQSSALSQSAFSQHLTVLRKHGLIEARKESQQVFYSLADTRVAQLIQ----------";
    seqs[counter++] = "--------------IEVEMATDEIMKKNAVEVA----ELLRVMAHPERLMVLCQLTHHEMGVGQLQQGSTLSQSAFSQHLTVLRKHGIIQARKESQQVFYRLADSRITAL------------";
    seqs[counter++] = "-----------------------------------------VLANPDRLKILCVLVDGEMNVQEIEESTDIHQPTLSQQLTVLRKADMVSTRREGKQIFYRLSDPKVLSLMQKLYEALNYC-";
    seqs[counter++] = "------------------------------------AEFFKTLGHPVRIRVLELLGQREHAVSEMLPEVGVEAANLSQQLAVLRRAGLVANRKEGSAVYYSL--------------------";
    seqs[counter++] = "------------------------------------ADLLLVMANAHRLRMLKTLAEREVAVNNLADIIGISQSALSQHLAKLRSRDLVKTRRDAQTIYY----------------------";
    seqs[counter++] = "------------------------------EVFESVARYFSVLGEPTRLRILHALCQEEKCVNEIIKVTALAQANVSRHLGLMYQAGMLSRRREGTQIFYKVAD------------------";
    seqs[counter++] = "------------------------------ETFEKISDLFKQLGDPTRMRIFWILCHHEECVIHISARMDMSSPAVAHHLRLLKTSGLVTSRRQGKETYYRASD------------------";
    seqs[counter++] = "------------------------------------------LSNEKRIRILYLLENHSFNVSELSEQLELPQPSVSHQLALLRQYQLVQAHRDGKQIFYTLDDPHIIEVLNDMLAHVQQ--";
    seqs[counter++] = "--------------------------------------FAKAISDPIRLRILYALREGELCVCELADALELRQSTLSTHLQIIRQAGLVQTRREGRWVYYALE-------------------";
    seqs[counter++] = "-------------------------------------EAFKAIADPTRRKILTLLRTGDLTAGEIASHFDMQKPSVSHHLKILKQADLVQDRREGQYIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FKALGQHLRLRIIALLAEQELCVCELEEILGITQPAISQHLRVLKEADLVWEEKVSQWVFYHLKKEKLAAVLQSWLAYLQ---";
    seqs[counter++] = "-----------------------------PKITGKWEDFFKVLSDETRLRILMLLNQRELCVCEICQILDLPQPKVSRHLAKMRDLDIVRGKKEDQWVFYYL--------------------";
    seqs[counter++] = "------------------------------ELFEEVANYFSLLCEPTRLKILYAVCNGERSVGDIVNEVESTQANVSRQINMLYRAKILARRKEGTQVYYRVDDEKTVDL------------";
    seqs[counter++] = "-------------------------------------EVFSMLADATRIRIILALRDQELSVNHLADIVDKSAPAVSQHLAKLRLARIVSTRQEGTKVFYRLTNEHARQLVADAI-------";
    seqs[counter++] = "-------------------------------------ELLRALASPTRIAIVQSLGSESRCVHELVGELELSQPLVSQHLRVLKDAGVVRGERNGREIMYSLVDHHIVHIVDDALVHATE--";
    seqs[counter++] = "------------------------------ELLENAAATLRMLAEPTRLHLLWQLSQGPKSVTELTEAAAVPRTVVSQHLAKLRLSGMVDGRKNGRQVIYSLHDGHLVRLIRETINH-----";
    seqs[counter++] = "-------------------------------------EILKALSDENRLRILNLLRWGKLCVGEIQSILGITQSNASRHLNKLKGVGIIKFEKDAQWVHYKL--------------------";
    seqs[counter++] = "------------------------------------------LSDPARLQMLWALSTEDLSLSDLAQLVGVSSTVASQLLSRLRTAGVLQTRKSGRHVIYSMHD------------------";
    seqs[counter++] = "--------------------------------AEKTARMFKVLSVGSRVRMVELLKERSLCVNALARTLGITAAAVSQHLRVLRDAGLVCPEKHGYYVHYRI--------------------";
    seqs[counter++] = "---------------------------------ERLAEIFKALGHPTRVKIVEYLADGEKCVKDIWQEIGVPQPTVSQHINILKNAGIISFRKDG---------------------------";
    seqs[counter++] = "------------------------MENLTPEAMEQVAAYFRALSEPTRLAILNLLREGERNVGELAQLCSCSPANVSRHLSLLSQHGLVRREGRGTAVYYRIADDSVYAL------------";
    seqs[counter++] = "------------------------------EKASDISKAFRHLGDPKRLQIFWLLCHRKECVINIAAIMGMSSPAISHHLKILKTAGLISSKREGKEMFYKAND------------------";
    seqs[counter++] = "---------------------------------ENLSPLFHALADPNRLRIIELLRQEDLTVGSIAERLDISQPQTSKQLRVLYDAGLVS--------------------------------";
    seqs[counter++] = "-------------------------------------ELLRALSAPIRLAIVSQLAEGERCVHELVNQLGAAQPLVSQHLRVLRGAGVVRGSRRGREIAYTLVDEHVAHIVADAVSHASE--";
    seqs[counter++] = "-------------------------------------ELLKIMAHPERMMVLCQLIEGEVAVAQLQQASLLSQSALSQHLALLRRQRLISARKRSQQVFYSLADQRVQQLI-ASLQHIASC-";
    seqs[counter++] = "-----------------------------PEVFDRIAERLRILAHPHRLRMVEMLLAGKYSVGELAESCSIPSHMASEHLRLMQHCGLLGSEKEGRYTYYRI--------------------";
    seqs[counter++] = "------------------------------------------LSDQNRLRVLSLLDGNELTVKEMLEILQLSQSTLSSQLSQLKDSGLVQSRRDGQYVFYKLPRQYETQMVSNPID------";
    seqs[counter++] = "------------------------------------AELLRQLANTNRLLILCHIAAEERSVGQLEADLGIKQPALSQQLAELRQYGLVKTRRQSRSIYYSIAD------------------";
    seqs[counter++] = "------------------------------------------LSDETRMRILNLLEKGEMCVCEMEEILDISQSNASRHLTKLTNAEIINYNKVSKYVYYKI--------------------";
    seqs[counter++] = "--------------------------------------------------LLYQLKDGERCVGELV-VDGNKLSTVSARLQTLLNANLVKRRRDARHLYYRLADQHVVQLIDNALAHVDE--";
    seqs[counter++] = "--------------------------------AEEVAELLRVMAHPERLMVLCQLTQSEMGVGQLQQGSTLSQSAFSQHLTVLRKHGIIQARKESQQVFYRLADSRI---------------";
    seqs[counter++] = "---------------------------------REMAELLGVLSHPCRVQIVEELRDSERNVNALQELLGISHSGVSQHLALLRTRKLLKERRSGRHVYYRL--------------------";
    seqs[counter++] = "---------------------------------------FALLADPLRLRIVEALSREQLCTCHLVDITGARQTTISNHLRLLREAGVVASEPEGRYTWYRL--------------------";
    seqs[counter++] = "-------------------------------------EILKALADETRIRILNLLYRETLCVCDLEEILKLSQSNASRHITKLKQAKLIAGEKQAQWIYYQV--------------------";
    seqs[counter++] = "---------------------------------RNLVKFFAALADPTRLRLLNMMAGGEVCVCHFQGVLQTNQPKISRHLAYLKKAGLVEARRDGKWMHYRL--------------------";
    seqs[counter++] = "---------------------------------------FKALGDEKRLRILSLLRQGERCACVLLEHLNLSQPTLSHHMKILCEARLVTGRKEGKWVYYSL--------------------";
    seqs[counter++] = "-------------------------------------KLFKALAHPTRIQILNLLQEGELCVCEIYEALELSQSNISQHLKVLRDQNLVESQKVGVEVHYKIKN------------------";
    seqs[counter++] = "------------------------------------AEILSLLADRTRLALLRRLSLGEADVTTLTRACGVARPAVSQHLARLRLAGLVTTRKEGRRVVYALRHGHLRRLIDEALN------";
    seqs[counter++] = "-------------------------------------EIFKALSDKNRLLILDMISCGELCACDIMDVLNLTQPTISHHMKVLQKCELVDARKEGKWVFY----------------------";
    seqs[counter++] = "-------------------------------------EVFRMLADATRVQVLWSLADREMSVNELAEQVGKPAPSVSQHLAKLRMARLVRTRRDGTTIFYRLENEHVRQLVIDAVE------";
    seqs[counter++] = "---------------------------------------FKLLGNETRLNILLLLEKQPQTVSELVSALHLKQSNVSHQLAQLKHHQLIASTRRGKNLLYSLRDPHVITMIETTYEH-----";
    seqs[counter++] = "---------------------------------------FKALADENRIRILNLLKNGKLCVCDIEAVLGIKQSNTSRHLNKLKMAGIIVSEKKSQWVYYRLND------------------";
    seqs[counter++] = "-------------------------------VYQLISEIFKTLAHPLRIQILMMLSEKERCVCELLNEIGVEQSNLSQHLRILKKQGIIDSRKDGQKMFYRI--------------------";
    seqs[counter++] = "-----------------------ELPEMSSEQLARLASLFRLLGDEGRLKLVMACIDAPQPVCCLSEISGMSQPLTSHHLRGLREARILKSSRRGKQVLYELDDHHI---------------";
    seqs[counter++] = "------------------------------DMAQEQVTILKALADPNRLAIIQHLTEGEACVCELLQLFSVTQPTLSHHMRILSDADLVKGRREGKWIHY----------------------";
    seqs[counter++] = "-------------------------------------DIFKALADENRIKIIKMLACCDMCVCDICGNLNLSQPAVSHHLKILSDSGLLNTTRKGKWIYYSL--------------------";
    seqs[counter++] = "-------------------------------------DLFKALSDPTRRKILELLKEKDMSAGEIAEYFDISKPSISHHLNILKNAKLVLWEKDGQNIIY----------------------";
    seqs[counter++] = "-------------------------------------KIFKILGSETRLNILLLLEKKDMTVTDLFNELEVSQPAISKQLAILKEYKIISYDKKGVENIYKLNDLHILNVINSTMGH-----";
    seqs[counter++] = "---------------------------MAEQVFAQVASYFGLLADPTRLRILSCLCGEERPVHDVVERIGLTQANISRHLNILYRAGVVDRRREGSSVLYKVVD------------------";
    seqs[counter++] = "------------------------------------AECLKALASPVRLKILFTLKDKPMCVTDLEQELGISQSSLSQHLRTLRYKGIVAKTRKGNKVYY----------------------";
    seqs[counter++] = "------------------------------------ATLFKALAEPIRLRILALLKDGELCVCDLTETLALPQSTVSRHLAVLRTAGWIRGRKGGSWTYYSL--------------------";
    seqs[counter++] = "------------------------------------ADLFKALADPMRLRILALLRTREACVCELAGLLPITQPAVSQHLRKLRQAGLIHERRHKYWTYY----------------------";
    seqs[counter++] = "------------------------------------ADFFKALAHPLRIRILEVLSEGERNVNELQTALGSEGSAVSQQLAVLRAKNLVNSFKEGTTVVYSLRD------------------";
    seqs[counter++] = "-----------------------------PDRAGRIAEVLKAVAHPLRLRIVASLCREELNVSALAERLGASQAIVSQQLRILRSLGLVA--------------------------------";
    seqs[counter++] = "-----------------------------------------------------VLKRRALCVTELTSQLGISQSATSQHLRVLKDARIVKFQKRGLHVYYHL--------------------";
    seqs[counter++] = "-----------------------------------LTNFLKIISDKNRLIILYLLSRNILCVCDIQKLIPLTQGALSIQLKNLMSAGLLESFKQGKWVFYKL--------------------";
    seqs[counter++] = "-----------------------DMQMMMKDNANKASSLLKAISHESRLLILCLLLRREMTVGELAEYSSLSQSAFSQHLSVLRNNGLVKCRKEAQNVYYSIND------------------";
    seqs[counter++] = "--------------------------------------FFEAFSNKNRFEILMQLRNKELCAGELQQKLKIEQTNLSHDLKCLLNCRFISVRKDGR--------------------------";
    seqs[counter++] = "-----------------------------------------ILANEDRLLLLCQLSQGEKAVGELEDALGIHQPTLSQQLGVLRSDGLVNTRREGKRIFYSIADDKVLAL------------";
    seqs[counter++] = "-------------------------------------------ADANRLRILACLKKGEVCVCDFTDFLNISQPAVSQHLRKLKEAGIITERKVGTWKHYRIQE------------------";
    seqs[counter++] = "-----------------------------------LSNIFKALNDPIRVKILFALLEYEICVGEMVNLLQIPQSHVSHQLRILRKYGIVEFTKDKKMSFYYIKNEYIKTL------------";
    seqs[counter++] = "---------------------------------------FDMLSAPNRLHLVWLLATGEFDVSTLAELSGSNVPAASQHLAKLRAAGIVTARRDGRRQLYRVEDPHIVTVIEQMFSHI----";
    seqs[counter++] = "--------------------KAKEAQLLSMEILEQAAECLRTLAHPHRLRIVQILLDHEESVGELARACELPSHMVSEHLRLLKDRGFLESRRDGRKVFY----------------------";
    seqs[counter++] = "-------------------------------------EIFKALGDENRIRILNLLIRQELCVCEIETVLDMTQSNASRHLNKLKTSGIITSEKKSQWVYYRV--------------------";
    seqs[counter++] = "------------------------------EVEQYIDRFLDTVCDTRRRAIVELLAISEMRSGDIARAIGLSAATTSEHLRQLAQTGLLTSRRQGNTVYYSLCNHKLVQAFRDLLEAL----";
    seqs[counter++] = "------------------------------EMMEATARVLKLLGDPTRLTILAILQKRECCVCELMEVFSSSQPAISQHLRKLKDAGLLQEERRGQWVYYSL--------------------";
    seqs[counter++] = "------------------------------------AELLAVLGNERRLVILGHLTEGEISVGELAVLVGLSKSALSQHLSKLRKHQLVSTRRHRQTVYY----------------------";
    seqs[counter++] = "-------------------------------------ELIRVLGDPLRLKIVTLLARETLCTSHLVEETGARQTNLSNHLRVLREAGVVETEPCGRFTYYKLRPDVIAAL------------";
    seqs[counter++] = "------------------------VSAFTEQFARKASDLLKAMSHETRLVILCLLSEKERSVGDIESILSMPQAAVSQQLARLRFDRLVKTRREGRTVYYSLASEEVTSL------------";
    seqs[counter++] = "------------------------------------ADLFKIMGDRSRLSMVAMMNRRECCVCDFTECFGMSQPAVSQHLKKLRAMGLIKERKEG---------------------------";
    seqs[counter++] = "--------------------------------SQEAAKVMQLLSHPDRLLILCLLSEKEYSVGEIEKQLDIHQPMLSQHLNRLRQQSLVATRREGKYIYYQLCD------------------";
    seqs[counter++] = "--------------------------------ASAAAELLKLVANPNRLRILYLLTEGERSVSEIEQRLGIRQPTLSQQLGELRNAGTVTTRRAHKVVFYSL--------------------";
    seqs[counter++] = "--------------------------------------FFKALADDSRLKIVGILANQECSVEELAVLLQLKEPTVSHHLAKLKELNLVTMRPEGNSRLYQL--------------------";
    seqs[counter++] = "------------------------------------ASILKALGHPIRLKILYLLSEKEHCVCELLSQINTSQPNLSQHLSILRNLKLIKDERNGNMVIYKLQDNKIV--------------";
    seqs[counter++] = "-------------------------------------------------------------VGELTEEVGVSQSLVSQHLRLLRAGRLLKQTRSGRNVFYALPDCHVRTMLTNMMDHVLE--";
    seqs[counter++] = "------------------------------------------LASSNRLELLEALAQGERSVDALAQATGMSVANTSHHLQILRDSGLAESRKEGLQVIYRLSDDQIPVL------------";
    seqs[counter++] = "---------------------------------QKLIKFFHALSDETRLKIIKLLEKSELCVCEIVAALDMVQPKVSFHLGVLKEAGLVKIKRKGKWILYSLDD------------------";
    seqs[counter++] = "--------------------------------AEVASELMKILSNENRLMILCQLVDGEKSVGELVELLDLNQPTVSQQLSRMKNQGLVSYRKNAQTVYYSL--------------------";
    seqs[counter++] = "-----------------------------------------LLGDKTRLTILSYLKDQELCVCELVDLLDISQPAISQHLKKLRVAEIIRERKQGTWVYYSL--------------------";
    seqs[counter++] = "------------------------------------------LADSTRLKILNLLSRQEMAVCELIEALDLSQPAVSHHLKLLKQACLITDSREGKWVLY----------------------";
    seqs[counter++] = "----------------------------------------------------------------MATEVGMEQSACSHQLRLLRNLGLVVGTRKGRSVVYSLYDNHVAELLDQAIYHIPVC-";
    seqs[counter++] = "--------------------------------------FLKVLGNPLRLQILKILSHVDMCVCAISEILGQQQTLVSHHLSKLKSARIVEERQNGKYRIYSIKDKRVKSL------------";
    seqs[counter++] = "--------------------------------AERLADRLRPLAQPQRLMILSLLLAGEHTVGEIETRTGIGQPALSQQLAELRRSGLVTTRRAARQVHYRIAD------------------";
    seqs[counter++] = "-------------------------------------DFLKLLADETRLKIIMMLSQRDMCVCEIMDELAMSQPAVSHHLRILKKSGIVRDDKDGRWVFYSL--------------------";
    seqs[counter++] = "--------------------KTRELELSIPGVSDTLAKFFRAIADPNRLLLLEFLVSCEHTGNECVAHVRLAQSRVSSHLQCLVNCGFVRVRREGHFAYYRVVDERVIDL------------";
    seqs[counter++] = "------------------------------------------LADKNRLKIIQYLSTGQRNVSEVADRLNVEENLASHHLRVLASLGFLKNDKKGREVYYRINETRFVALLKDLL-------";
    seqs[counter++] = "---------------------SHELAAAAPGI-EAMAAVLALAGNEVRLKMLFLLLDQQLCVCDLADVLQMNVSAISQHLRKLKDGGVIQARKVGQTVFYSL--------------------";
    seqs[counter++] = "------------------------------------------LADPTRMRMLWLISGEEYDVASLAAAVDIARPAVSQHLAKLKLAGLVTQRRDGRRILYRARGGHVLAEVMNAADH-----";
    seqs[counter++] = "--------------------------------AREVSRLLSVLANENRLLIVCLMMRSEMKVGELVDALHLSQSALSQHLTKLREEGLVEFRRESQTLHYKIADERVTKL------------";
    seqs[counter++] = "-----------------------------------LTNIFKVLSDENRLRMIVLLYQEELCVCELSGILNVPQPRISQNLSRLRDLNLVDDERKEKFVFYSL--------------------";
    seqs[counter++] = "------------------------------------AEILRILSHPERLLVLCQLMEGELGAGQLQNSSTLSQSAFSQHLTVLRKHNLVKVRKESQQVFYSLADERIAALIHN---------";
    seqs[counter++] = "------------------------------------------MGNPQRLRILLLLAEHERSVIELEALVGLSQSAVSQHLARLRQIKLVRFRRDGQMTFYAL--------------------";
    seqs[counter++] = "-----------------------------PIYAQ-LARVGKALASPIRLRLLDLLDGAELTVEELSEQAGVPLKNTSAQLQQLRAANLVATRKEGTRVHYRLAD------------------";
    seqs[counter++] = "---------------------------MATDALDQVSHLFKLMGHPKRLQLLYLLIQQSMTVSQISERLKWEQSAVSHQLQVLRKYQIVERVKNGRQVVYRLVD------------------";
    seqs[counter++] = "------------------------------------------LADSTRVQVLWALVDRELSVNDLAEHVGKPAPSVSQHLAKLRMARLVRTRKEGTQVIYRLENDHVRQLVTDAVN------";
    seqs[counter++] = "------------------------------------AEFFKTLGHPVRIRVLELLSEREHAVSEMLNEVGVEAAHLSQQLAVLRRAGLVTARREGSAVHYTLAD------------------";
    seqs[counter++] = "------------------------------------------LADENRLRILRALVGTEKPVSKLVEELGISQPLVSHHLKELRRALLVSVERRGPFVYCRLAD------------------";
    seqs[counter++] = "--------------------------------AEHVAEMLKLMAHPHRLMILCLLVESEHNVGELVEALDINQTALSNHLSKLRSAGLIDYTRYHRVLQYRL--------------------";
    seqs[counter++] = "---------------------------IVPVVFQGAADLFAALSCPTRLRIVCALSQADHTVRDLARASQCSQANVSGHLRLLRRANIVRCERSGNYVLYHL--------------------";
    seqs[counter++] = "------------------------------EVFEEVANYFSLLCEPTRLKILYAVCNGERSVGDIVAQVESTQANVSRQLAMLYRAKILARRKEGTLVFYRVDD------------------";
    seqs[counter++] = "---------------------------------RQLADVGGALSNPHRLKMISLLAQGDKPIDELAKLTNQSLAAASANVKVLRNCHLIATEKRGRSVYCSLKDPRVAELW-----------";
    seqs[counter++] = "-------------------------------------ELLRALSAPIRLAIVSELAEGERCVHELVDKLGAPQPLVSQHLRVLRSAGVVRGSRRGREIAYTLVDEHVAHIVTDAVSH-----";
    seqs[counter++] = "-------------------------------------------AHPLRLKILCVLGEGEACVQDIVEAVGTSQSNISQHLAILRDKGVLQTRKDANRVYYRVGDQRTLQL------------";
    seqs[counter++] = "-----------------------------------------VAAEPTRRRLLQLLAPGERTVTQLASQFTVTRSAISQHLGMLAEAGLVTARKQGRERYYRL--------------------";
    seqs[counter++] = "-----------------------------------------VAAEPTRRRLLQLLAPGERTVTQLASQFTVTRSAISQHLGMLAEAGLVTARKQGRERYYRL--------------------";
    seqs[counter++] = "-------------------------------------EMLKILSDTNRLRILNLLYIQELCVCELEYLLTISQSNLSKHLRLMGEIGFLDSRRQNKFIYYKI--------------------";
    seqs[counter++] = "------------------------------------AESFRLLADPTRIKVLWALLQGESSVACLAELAGAAPTXXSXHXXKLRLAGLVTGRREGTFVYYSAVNNHVRGLLAQALFH-----";
    seqs[counter++] = "--------------------------------AEATATLFA-LANQNRLLLLCQLCNGEMSVSALEEALGIHQPTLSQQLGVLRSEGLIASRREGKRIYYSVANPKVLVLINTLVD------";
    seqs[counter++] = "------------------------------EILDAAGELLRALAAPVRIAIVLQLRESQRCVHELVDALHVPQPLVSQHLKILKAAGVVTGERSGREVLYRLADHHLAHIVLDAVAH-----";
    seqs[counter++] = "---------------------------------QDLLKVFYALSDSVRLGIVSLLECEELCVCQITQAFGLSQPNASFHLRVLREANLVLWEKRGKWTYYKINHH-----------------";
    seqs[counter++] = "---------------------------------------FKALGEPSRLKIIKLLSQQSMCVCELSEVLDMSQPRVSQHLRTLKEVDLVYEERQGFWTYYKL--------------------";
    seqs[counter++] = "---------------------------------------FKALSDQTRLRMVTLLSRREYCNCEFVSIFGISQPAISRHIARLKEARLIHERRPGQWIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FKALADSNRLRILDYLKKGKSCACDLSDNLGIPQTALSYHMRILCQAKLVKSEQVGKWKHYQLND------------------";
    seqs[counter++] = "-----------------------ELEAKAEDAAQ----FLKMIASPPRLLLLCHMAERECSVGELAERTGMRMPTVSQQLSLLRAQGLVNTRRDGTTIYYRL--------------------";
    seqs[counter++] = "-------------------------------------KIFSALSDKNRLRIYLLLTQAELCVCELVNILDMEQSRISHSLRILKEAKLINNHRVGK--------------------------";
    seqs[counter++] = "-----------------------------PESLRSIASLLKALSDPLRLQVLEQLSTGERCVCDLTSSLALSQSRLSFHLKVMKEAGLLSDRQSGRWVYYRIRPESLNAL------------";
    seqs[counter++] = "------------------------------------AKLFRGFADPSRLAILEVLRSAPATVGEIAASTGQGLSNVSNHLRCLRDCGLVVRQRDGQRVRYSLSDQRVAAL------------";
    seqs[counter++] = "--------------------------AMAGNVEQA-EQLLKVLANKNRLMILCSLQDSEMSVSQLNEAVPLAQSALSQHLAALRKANIVATRRESQTIYYRVIDENAVVL------------";
    seqs[counter++] = "-------------------------------------------ADTLRVQVLSLLHKNSFSVGELVEILGVRQSALSHHLKVLAQAELVATRREGNSIFY----------------------";
    seqs[counter++] = "----------------------------AAQVFERAAELFGLLSSPLRLRIVGELCRGELNVGQLQERIGATQSNMSQHLSVLYRAGVVARRRDGAQVHYRI--------------------";
    seqs[counter++] = "----------------------------------ALLRWLKALSDDTRLRLLHLLSRYELSVGEVVQVLGMSQPRVSRHLKILADAGMVQVRRDGLWAFYSATSH-----------------";
    seqs[counter++] = "-----------------------DMQDIAAQLQELHARVCKAIADPKRLLIINELRDRELSVGELCEATGLSQSNASQHLTILRERGIVTTRRVKNNVFYSLRSQKIV----QAVDLLRE--";
    seqs[counter++] = "---------------------------------------FRALSDRTRLRILNLLRGGELCVCDLVDVLDVPQPTASRHLAYLRNAGLVLARKEGLWHYYRL--------------------";
    seqs[counter++] = "------------------------------------AAYFQALAEPTRLQILNFLRQQERNVGELAQLCGYSSANISRHLALLTQHGLVSRQARGNSAYYRIAD------------------";
    seqs[counter++] = "-------------------------------------DMFKAMADPTRRRILQLLSEKNLSAGEIAEEFTMSKPAISKHLDILKTSELITCEKQGQYVIYAINTSAVEQMYCRFLD------";
    seqs[counter++] = "--------------------------------AHEASDLLKALAHQTRLLILCILANEERTVGEIENILGIQQAMVSQQLARLRLEGLVHTRRQGRLVYYSIGNVSVLAFLESLFD------";
    seqs[counter++] = "--------------------------------------------DPLRLNVLRALANDSFGVLELAQIFGIGQSGMSHHLKVLAQADLVATRREGNAIFYRRALPHLNAVKDGALDH-----";
    seqs[counter++] = "------------------------------EMTPDIVSFLKTISEENRLKILCFLRDWEKCVCEIVEFLKIPQNLVSHHLRKLKDARILSARKDGMNVRYSINEDEI---------------";
    seqs[counter++] = "----------------------------AEPVFDRLAQVLDLAGNANRLKIIYLLEESNLCVCDLSDILGMSIPAVSQHLRKLKDAQLIQARKVGQTVFYSL--------------------";
    seqs[counter++] = "--------------------------------ASAAARLMKLMANEQRLILMCRLGEGECSVGDLAAHVGLAQSAASQHLAKLRAEGVVATRRDGQTIYYRLED------------------";
    seqs[counter++] = "------------------------------ENATEVAGILKQLSNPYRLMILCCLSENELTVGDLNQRIDLSQSALSQHLAKLRESNIVTTRRESQTIFYRI--------------------";
    seqs[counter++] = "-----------------------------------------VLSNPDRLKILCVLIDGELNVQQIEKTAQVYQPTLSQQLTILRKSKMVSTRREGKQIFYQFSDMRILQIMQTLYD------";
    seqs[counter++] = "---------------------------------------FHSLSDATRLAIVLRLARGEARVADLVGELGLAQSTVSAHVACLRDCQLVAGRPEGRQIFYRLARRELIDLLASALE------";
    seqs[counter++] = "-----------------------------------MAKFYRALGDPTRLDLLEFCAEDERTGNECVERAGLSQGRVSAHLACLVSCGLVSVRRQGRFAYYRVTDPRVAEL------------";
    seqs[counter++] = "---------------------------IETEISPELTNFIKVLSNPIRAGIIKMLKKRWMCVCLIAKALNQDQTLISHHLRTLKNMNLLHERREGK--------------------------";
    seqs[counter++] = "------------------------------------AQVFKALGNPVRMALVQELLAGERCVCDLAQALGGNMPAVSKHLATLREAGIVSCRREGTTIHYSL--------------------";
    seqs[counter++] = "------------------------------------AKLMEMLSQPVRLRILCILLDGEQSVLKLADMAGLSQPAMSHHLRKLRDADLVNTRRDAQTIYYSLKGQEVSAV------------";
    seqs[counter++] = "------------------------------------------LGSSNRLMLVCQLLDGERAVGELAEALGLAQSVVSQHLSLLRRDGLVTGRRDGQSIYYAISDDRVHAL------------";
    seqs[counter++] = "----------------------------------------AVLANINRLLLMCQLSQGEKCVGELEELLDLHQPTLSQQLGVLRGAGLVNTRRDGKKIHYSVADARVLTL------------";
    seqs[counter++] = "---------------------------------QTLLGFFQALADANRLRIVGVLAQGPQTVEQISALLGLGMSTTSHHLRKLAKAGLVEARADGHYSVYSLRTQTLEELAKNLL-------";
    seqs[counter++] = "-------------------------------------DLFKCIGNPTRYKILKVLCERPLCVNKLNEAVGYSQPNISQHLKLMRMSGIVTCSKNGMNICYQIADDDIIKLLELAEDILKNRR";

    char ** seqsCpy = new char*[counter];
    for (int k = 0; k < counter; ++k) {
        seqsCpy[k] = MultipleAlignment::initX(122);
        for (int pos = 0; pos < 122; ++pos) {
//            seqs[k][pos] = (seqs[k][pos] == '-') ? MultipleAlignment::GAP : subMat.aa2num[(int) seqs[k][pos]];
            seqsCpy[k][pos] = (seqs[k][pos] == '-') ? MultipleAlignment::GAP : static_cast<int>(subMat.aa2num[(int) seqs[k][pos]]);
        }
    }

    MultipleAlignment::MSAResult res(122, 122, counter, seqsCpy);
    MultipleAlignment::print(res, &subMat);

    MsaFilter msaFilter(10000, counter, &subMat, par.gapOpen.aminoacids, par.gapExtend.aminoacids);
    std::vector<Matcher::result_t> empty;
    size_t filteredSetSize = msaFilter.filter(res, empty, 0, 0,-20.0, 90, 100);

/*    std::cout << "Filtered:" << filterResult.setSize << std::endl;
//    for(size_t k = 0; k < res.setSize; k++){
//        std::cout << "k=" << k << "\t" << (int)filterResult.keep[k] << std::endl;
//    }

    std::cout <<"Filterted MSA" << std::endl;
    for(size_t k = 0; k < filterResult.setSize; k++){
        printf("k=%.3zu ", k);
        for(size_t pos = 0; pos < res.centerLength; pos++){
            char aa = filterResult.filteredMsaSequence[k][pos];
            printf("%c", (aa < MultipleAlignment::NAA) ? subMat.num2aa[(int)aa] : '-' );
        }
        printf("\n");
    }
*/
    //seqSet.push_back(s5);
    PSSMCalculator pssm(&subMat, par.maxSeqLen, filteredSetSize, 1.0, 1.5);
    PSSMCalculator::Profile profile = pssm.computePSSMFromMSA(filteredSetSize, res.centerLength,  (const char **) res.msaSequence, false);
    //std::string libraryString((const char *)Library1_lib, Library1_lib_len);
    ProfileStates ps(32, subMat.pBack);

    char mmOrder[] = {'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y','\0'};
    for (size_t i=0 ; i<20;i++)
        std::cout<< mmOrder[ProfileStates::hh2mmseqsAAorder(i)] <<std::endl;

//    std::ifstream libFile;
//    libFile.open ("/home/clovis/Software/mmseqs-dev/data/LibraryPure.lib");

//    std::string libData((std::istreambuf_iterator<char>(libFile)),
//                        std::istreambuf_iterator<char>());

//    ps.read(libData);

//    std::string sequence({0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,'\0'});

    size_t L = res.centerLength;
    std::string disc;
    ps.discretize(profile.prob, L, disc);
    for (size_t i = 0 ; i< L ; i++)
        std::cout<<i<<","<<(int)disc[i]<<std::endl;
    //pssm.printProfile(res.centerLength);
    pssm.printPSSM(res.centerLength);
    for (int k = 0; k < counter; ++k) {
        free(seqsCpy[k]);
    }
    delete [] seqsCpy;
    return 0;
}

//PQITLWQRPLVTIKIGGQLKEALLDTGADDTVLEEMSLPGRWKPKMIGGIGGFIKVRQYDQILIEICGHKAIGTVLVGPTPVNIIGRNLLTQIGCTLNF
//                     ALLDTGADDTVISEEDWPTDWPVMEAANPQIHGIGGGIPVRKSRDMIELGVINRDGSLERPLLLFPLVAMTPVNILGRDCLQGLGLRLTNL
