/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <iostream>
#include <sstream>
#include <fstream>
#include <cstdio>

#include "MvKeyManager.h"
#include "MvKeyProfile.h"

/*key_.push_back(MvKey("count","Count",true));
	key_.push_back(MvKey("mars.date","Date",true));
	key_.push_back(MvKey("mars.time","Time",true));
	key_.push_back(MvKey("mars.step","Step",true));
	key_.push_back(MvKey("mars.param","Param",true));
	key_.push_back(MvKey("dataRepresentationType","Rep",true));
	key_.push_back(MvKey("mars.levelist","Level",true));
	key_.push_back(MvKey("mars.levtype","Levtype",true));
	key_.push_back(MvKey("mars.class","Class",false));
	key_.push_back(MvKey("mars.type","Type",false));
	key_.push_back(MvKey("mars.stream","Stream",false));
	key_.push_back(MvKey("editionNumber","Edition",false));*/


MvKeyManager::~MvKeyManager()
{
    clear();
}

void MvKeyManager::clear()
{
    for (vector<MvKeyProfile*>::iterator it = begin(); it != end(); it++) {
        delete (*it);
    }

    vector<MvKeyProfile*>::clear();
}

MvKeyProfile* MvKeyManager::addProfile(string name)
{
    MvKeyProfile* profile = new MvKeyProfile(name);
    push_back(profile);
    return profile;
}

void MvKeyManager::deleteProfile(int index)
{
    vector<MvKeyProfile*>::iterator it = begin() + index;
    delete (*it);
    erase(it);
}

void MvKeyManager::loadProfiles()
{
    ifstream in(fprof_.c_str(), ifstream::in);

    if (!in) {
        MvKeyProfile* prof = new MvKeyProfile("Metview default");
        push_back(prof);

        prof->addKey(new MvKey("count", "Index"));
        prof->addKey(new MvKey("mars.date", "Date"));
        prof->addKey(new MvKey("mars.time", "Time"));
        prof->addKey(new MvKey("mars.step", "Step"));
        prof->addKey(new MvKey("mars.param", "Param"));
        prof->addKey(new MvKey("dataRepresentationType", "Rep"));
        prof->addKey(new MvKey("mars.levelist", "Level"));
        prof->addKey(new MvKey("mars.levtype", "Levtype"));

        saveProfiles();
    }
    else {
        //Create a deafult profile
        char c[256];
        string name, sname;

        MvKeyProfile* prof = 0;
        while (in.getline(c, 256)) {
            //cout << c << endl;

            string s = c;

            if (s.find("#PROFILE") != string::npos) {
                in.getline(c, 256);

                if (!prof) {
                    prof = new MvKeyProfile(c);
                    push_back(prof);
                }
                else
                    break;
            }
            else {
                name = c;
                in.getline(c, 256);
                sname = c;

                if (prof)
                    prof->addKey(new MvKey(name, sname));
                else
                    break;
            }
        }
    }
}

void MvKeyManager::saveProfiles()
{
    ofstream out(fprof_.c_str(), ofstream::out);

    for (vector<MvKeyProfile*>::iterator it = begin(); it != end(); it++) {
        MvKeyProfile* prof = *it;

        out << "#PROFILE" << endl;
        out << prof->name() << endl;
        //out  << prof->size() << endl;
        for (vector<MvKey*>::iterator it1 = prof->begin(); it1 != prof->end(); it1++) {
            MvKey* key = *it1;
            out << key->name() << endl;
            out << key->shortName() << endl;
        }
    }

    out.close();
}
