# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class MergeTimeFilter(MultiBlockDataSetAlgorithm):
    r"""
    MergeTimeFilter - Create a multiblock containing one block per
    input, with unified timestep list.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    MergeTimeFilter takes multiple temporal datasets as input and
    synchronize them.
    
    The output data is a multiblock dataset containing one block per
    input dataset. The output timesteps is the union (or the
    intersection) of each input timestep lists. Duplicates time values
    are removed, dependending on a tolerance, either absolute or
    relative.
    
    When source time is exactly 0., absolute tolerance is used even in
    relative mode.
    
    Note that the actual merge of timesteps is done duing the
    request_information pass. In the 'Relative' mode, inputs are processed
    in order and compararison is done with previously processed inputs.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMergeTimeFilter, obj, update, **traits)
    
    use_intersection = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get if the merge use intersection instead of union. Default
        is false (union is used).
        """
    )

    def _use_intersection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseIntersection,
                        self.use_intersection_)

    use_relative_tolerance = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get if the tolerance is relative to previous input or
        absolute.
        
        Default is false (absolute tolerance).
        """
    )

    def _use_relative_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseRelativeTolerance,
                        self.use_relative_tolerance_)

    tolerance = traits.Trait(1e-05, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the tolerance for comparing time step values to see if
        they are close enough to be considered identical. Default is
        0.00001
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    _updateable_traits_ = \
    (('use_intersection', 'GetUseIntersection'),
    ('use_relative_tolerance', 'GetUseRelativeTolerance'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('tolerance',
    'GetTolerance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_intersection', 'use_relative_tolerance',
    'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MergeTimeFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MergeTimeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_intersection', 'use_relative_tolerance'], [],
            ['tolerance']),
            title='Edit MergeTimeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MergeTimeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

