# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.homogeneous_transform import HomogeneousTransform


class LinearTransform(HomogeneousTransform):
    r"""
    LinearTransform - abstract superclass for linear transformations
    
    Superclass: HomogeneousTransform
    
    LinearTransform provides a generic interface for linear (affine or
    12 degree-of-freedom) geometric transformations.
    
    @warning
    Portions of this class (i.e., when transforming arrays of points
    and/or associated attributes such as normals and vectors) has been
    threaded with SMPTools. Using TBB or other non-sequential type
    (set in the CMake variable VTK_SMP_IMPLEMENTATION_TYPE) may improve
    performance significantly.
    
    @sa
    Transform IdentityTransform
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLinearTransform, obj, update, **traits)
    
    def _get_linear_inverse(self):
        return wrap_vtk(self._vtk_obj.GetLinearInverse())
    linear_inverse = traits.Property(_get_linear_inverse, desc=\
        r"""
        Just like get_inverse, but it includes a typecast to
        LinearTransform.
        """
    )

    def internal_transform_normal(self, *args):
        """
        internal_transform_normal(self, in_:(float, float, float),
            out:[float, float, float]) -> None
        C++: virtual void internal_transform_normal(const double in[3],
            double out[3])"""
        ret = self._wrap_call(self._vtk_obj.InternalTransformNormal, *args)
        return ret

    def internal_transform_vector(self, *args):
        """
        internal_transform_vector(self, in_:(float, float, float),
            out:[float, float, float]) -> None
        C++: virtual void internal_transform_vector(const double in[3],
            double out[3])"""
        ret = self._wrap_call(self._vtk_obj.InternalTransformVector, *args)
        return ret

    def transform_double_normal(self, *args):
        """
        transform_double_normal(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: double *transform_double_normal(double x, double y, double z)
        transform_double_normal(self, normal:(float, float, float)) -> (
            float, float, float)
        C++: double *transform_double_normal(const double normal[3])
        Apply the transformation to a double-precision (x,y,z) normal.
        Use this if you are programming in python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformDoubleNormal, *args)
        return ret

    def transform_double_vector(self, *args):
        """
        transform_double_vector(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: double *transform_double_vector(double x, double y, double z)
        transform_double_vector(self, vec:(float, float, float)) -> (float,
            float, float)
        C++: double *transform_double_vector(const double vec[3])
        Apply the transformation to a double-precision (x,y,z) vector.
        Use this if you are programming in python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformDoubleVector, *args)
        return ret

    def transform_float_normal(self, *args):
        """
        transform_float_normal(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: float *transform_float_normal(float x, float y, float z)
        transform_float_normal(self, normal:(float, float, float)) -> (
            float, float, float)
        C++: float *transform_float_normal(const float normal[3])
        Apply the transformation to an (x,y,z) normal. Use this if you
        are programming in python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformFloatNormal, *args)
        return ret

    def transform_float_vector(self, *args):
        """
        transform_float_vector(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: float *transform_float_vector(float x, float y, float z)
        transform_float_vector(self, vec:(float, float, float)) -> (float,
            float, float)
        C++: float *transform_float_vector(const float vec[3])
        Apply the transformation to an (x,y,z) vector. Use this if you
        are programming in python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformFloatVector, *args)
        return ret

    def transform_normal(self, *args):
        """
        transform_normal(self, in_:(float, float, float), out:[float,
            float, float]) -> None
        C++: void transform_normal(const double in[3], double out[3])
        transform_normal(self, x:float, y:float, z:float) -> (float, float,
             float)
        C++: double *transform_normal(double x, double y, double z)
        transform_normal(self, normal:(float, float, float)) -> (float,
            float, float)
        C++: double *transform_normal(const double normal[3])
        Apply the transformation to a double-precision normal. You can
        use the same array to store both the input and output.
        """
        ret = self._wrap_call(self._vtk_obj.TransformNormal, *args)
        return ret

    def transform_normals(self, *args):
        """
        transform_normals(self, inNms:DataArray, outNms:DataArray)
            -> None
        C++: virtual void transform_normals(DataArray *inNms,
            DataArray *outNms)
        Apply the transformation to a series of normals, and append the
        results to outNms.
        """
        my_args = deref_array(args, [('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TransformNormals, *my_args)
        return ret

    def transform_vector(self, *args):
        """
        transform_vector(self, x:float, y:float, z:float) -> (float, float,
             float)
        C++: double *transform_vector(double x, double y, double z)
        transform_vector(self, normal:(float, float, float)) -> (float,
            float, float)
        C++: double *transform_vector(const double normal[3])
        transform_vector(self, in_:(float, float, float), out:[float,
            float, float]) -> None
        C++: void transform_vector(const double in[3], double out[3])
        Synonymous with transform_double_vector(x,y,z). Use this if you are
        programming in python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformVector, *args)
        return ret

    def transform_vectors(self, *args):
        """
        transform_vectors(self, inVrs:DataArray, outVrs:DataArray)
            -> None
        C++: virtual void transform_vectors(DataArray *inVrs,
            DataArray *outVrs)
        Apply the transformation to a series of vectors, and append the
        results to outVrs.
        """
        my_args = deref_array(args, [('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TransformVectors, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LinearTransform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LinearTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit LinearTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LinearTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

