/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2019 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * scale 4D
 * This formula contains aux.actualScaleA

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfScale4dIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfScale4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL useScale = 1.0f;
	useScale = aux->actualScaleA + fractal->transformCommon.scale;

	z *= useScale;

	if (!fractal->analyticDE.enabledFalse)
		aux->DE = mad(aux->DE, fabs(useScale), 1.0f);
	else
		aux->DE =
			mad(aux->DE * fabs(useScale), fractal->analyticDE.scale1, fractal->analyticDE.offset1);

	if (fractal->transformCommon.functionEnabledFFalse
			&& aux->i >= fractal->transformCommon.startIterationsY
			&& aux->i < fractal->transformCommon.stopIterationsY)
	{
		// update actualScaleA for next iteration
		REAL vary = fractal->transformCommon.scaleVary0
								* (fabs(aux->actualScaleA) - fractal->transformCommon.scaleC1);
		if (fractal->transformCommon.functionEnabledMFalse)
			aux->actualScaleA = -vary;
		else
			aux->actualScaleA = aux->actualScaleA - vary;
	}
	return z;
}