/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.refactoring.java.spi;

/**
 * Filters used by Java Find Usages plugins.
 * 
 * @author Ralph Benjamin Ruijs <ralphbenjamin@netbeans.org>
 * @since 1.39
 */
public enum JavaWhereUsedFilters {

    IMPORT("filter-import"),
    COMMENT("filter-comment"),
    TESTFILE("filter-testfile"),
    /**
     * @since 1.54
     */
    SOURCEFILE("filter-sourcefile"),
    /**
     * @since 1.55
     */
    BINARYFILE("filter-binaryfile"),
    /**
     * @since 1.55
     */
    DEPENDENCY("filter-dependencyfile"),
    /**
     * @since 1.55
     */
    PLATFORM("filter-platformfile");
    private final String key;

    private JavaWhereUsedFilters(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public static enum ReadWrite {

        READ("filter-read"),
        WRITE("filter-write"),
        READ_WRITE("filter-readwrite");
        private final String key;

        private ReadWrite(String key) {
            this.key = key;
        }

        public String getKey() {
            return key;
        }
    }
}