/***************************************************************************
 * falconkerror.h
 * This file is part of the KDE project
 * copyright (C)2007-2008 by Giancarlo Niccolai (jonnymind@falconpl.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef FALCONKERROR_H

#include <falcon/error.h>

#define KF_OBJECT_GONE_ERROR    10001
#define KF_OBJECT_GONE_ERROR_DESC   i18n( "QObject has been deleted in the meanwhile" )

namespace Kross {

    /** 
    * This class implements a special Error subclass meant for exceptions
    * generated by Kross framework.
    *
    * At Falcon script level, this error will be known as  "KrossError",
    * while it is named FalconKrossError in C++ to avoid name clashes.
    */
    class FalconKrossError: public ::Falcon::Error
    {
    public:
    FalconKrossError():
        Error( "KrossError" )
    {}
    
    FalconKrossError( const Falcon::ErrorParam &params  ):
        Error( "KrossError", params )
        {}
    };
    
    /** 
    * Declarator for the falcon class "KrossError".
    */
    void DeclareFalconKrossError( ::Falcon::Module *self );
}

#endif
