
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAudioDecoderControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAudioDecoderControl>
#include <QAudioBuffer>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAudioDecoderControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAudioDecoderControl::staticMetaObject);
}


// QAudioFormat QAudioDecoderControl::audioFormat()


static void _init_f_audioFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_audioFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAudioDecoderControl *)cls)->audioFormat ());
}


// bool QAudioDecoderControl::bufferAvailable()


static void _init_f_bufferAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_bufferAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoderControl *)cls)->bufferAvailable ());
}


// void QAudioDecoderControl::bufferAvailableChanged(bool available)


static void _init_f_bufferAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bufferAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->bufferAvailableChanged (arg1);
}


// void QAudioDecoderControl::bufferReady()


static void _init_f_bufferReady_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_bufferReady_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->bufferReady ();
}


// qint64 QAudioDecoderControl::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoderControl *)cls)->duration ());
}


// void QAudioDecoderControl::durationChanged(qint64 duration)


static void _init_f_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->durationChanged (arg1);
}


// void QAudioDecoderControl::error(int error, const QString &errorString)


static void _init_f_error_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_error_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->error (arg1, arg2);
}


// void QAudioDecoderControl::finished()


static void _init_f_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->finished ();
}


// void QAudioDecoderControl::formatChanged(const QAudioFormat &format)


static void _init_f_formatChanged_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_formatChanged_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->formatChanged (arg1);
}


// qint64 QAudioDecoderControl::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoderControl *)cls)->position ());
}


// void QAudioDecoderControl::positionChanged(qint64 position)


static void _init_f_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->positionChanged (arg1);
}


// QAudioBuffer QAudioDecoderControl::read()


static void _init_f_read_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioBuffer > ();
}

static void _call_f_read_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioBuffer > ((QAudioBuffer)((QAudioDecoderControl *)cls)->read ());
}


// void QAudioDecoderControl::setAudioFormat(const QAudioFormat &format)


static void _init_f_setAudioFormat_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioFormat_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->setAudioFormat (arg1);
}


// void QAudioDecoderControl::setSourceDevice(QIODevice *device)


static void _init_f_setSourceDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->setSourceDevice (arg1);
}


// void QAudioDecoderControl::setSourceFilename(const QString &fileName)


static void _init_f_setSourceFilename_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceFilename_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->setSourceFilename (arg1);
}


// void QAudioDecoderControl::sourceChanged()


static void _init_f_sourceChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sourceChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->sourceChanged ();
}


// QIODevice *QAudioDecoderControl::sourceDevice()


static void _init_f_sourceDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_sourceDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAudioDecoderControl *)cls)->sourceDevice ());
}


// QString QAudioDecoderControl::sourceFilename()


static void _init_f_sourceFilename_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sourceFilename_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDecoderControl *)cls)->sourceFilename ());
}


// void QAudioDecoderControl::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->start ();
}


// QAudioDecoder::State QAudioDecoderControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDecoder::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDecoder::State>::target_type > ((qt_gsi::Converter<QAudioDecoder::State>::target_type)qt_gsi::CppToQtAdaptor<QAudioDecoder::State>(((QAudioDecoderControl *)cls)->state ()));
}


// void QAudioDecoderControl::stateChanged(QAudioDecoder::State newState)


static void _init_f_stateChanged_2338 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAudioDecoder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2338 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudioDecoder::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudioDecoder::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QAudioDecoder::State>(arg1).cref());
}


// void QAudioDecoderControl::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl *)cls)->stop ();
}


// static QString QAudioDecoderControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioDecoderControl::tr (arg1, arg2, arg3));
}


// static QString QAudioDecoderControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioDecoderControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAudioDecoderControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":audioFormat", "@brief Method QAudioFormat QAudioDecoderControl::audioFormat()\n", true, &_init_f_audioFormat_c0, &_call_f_audioFormat_c0);
  methods += new qt_gsi::GenericMethod ("bufferAvailable", "@brief Method bool QAudioDecoderControl::bufferAvailable()\n", true, &_init_f_bufferAvailable_c0, &_call_f_bufferAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bufferAvailableChanged", "@brief Method void QAudioDecoderControl::bufferAvailableChanged(bool available)\n", false, &_init_f_bufferAvailableChanged_864, &_call_f_bufferAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("bufferReady", "@brief Method void QAudioDecoderControl::bufferReady()\n", false, &_init_f_bufferReady_0, &_call_f_bufferReady_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QAudioDecoderControl::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("durationChanged", "@brief Method void QAudioDecoderControl::durationChanged(qint64 duration)\n", false, &_init_f_durationChanged_986, &_call_f_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method void QAudioDecoderControl::error(int error, const QString &errorString)\n", false, &_init_f_error_2684, &_call_f_error_2684);
  methods += new qt_gsi::GenericMethod ("finished", "@brief Method void QAudioDecoderControl::finished()\n", false, &_init_f_finished_0, &_call_f_finished_0);
  methods += new qt_gsi::GenericMethod ("formatChanged", "@brief Method void QAudioDecoderControl::formatChanged(const QAudioFormat &format)\n", false, &_init_f_formatChanged_2509, &_call_f_formatChanged_2509);
  methods += new qt_gsi::GenericMethod ("position", "@brief Method qint64 QAudioDecoderControl::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("positionChanged", "@brief Method void QAudioDecoderControl::positionChanged(qint64 position)\n", false, &_init_f_positionChanged_986, &_call_f_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method QAudioBuffer QAudioDecoderControl::read()\n", false, &_init_f_read_0, &_call_f_read_0);
  methods += new qt_gsi::GenericMethod ("setAudioFormat|audioFormat=", "@brief Method void QAudioDecoderControl::setAudioFormat(const QAudioFormat &format)\n", false, &_init_f_setAudioFormat_2509, &_call_f_setAudioFormat_2509);
  methods += new qt_gsi::GenericMethod ("setSourceDevice|sourceDevice=", "@brief Method void QAudioDecoderControl::setSourceDevice(QIODevice *device)\n", false, &_init_f_setSourceDevice_1447, &_call_f_setSourceDevice_1447);
  methods += new qt_gsi::GenericMethod ("setSourceFilename|sourceFilename=", "@brief Method void QAudioDecoderControl::setSourceFilename(const QString &fileName)\n", false, &_init_f_setSourceFilename_2025, &_call_f_setSourceFilename_2025);
  methods += new qt_gsi::GenericMethod ("sourceChanged", "@brief Method void QAudioDecoderControl::sourceChanged()\n", false, &_init_f_sourceChanged_0, &_call_f_sourceChanged_0);
  methods += new qt_gsi::GenericMethod (":sourceDevice", "@brief Method QIODevice *QAudioDecoderControl::sourceDevice()\n", true, &_init_f_sourceDevice_c0, &_call_f_sourceDevice_c0);
  methods += new qt_gsi::GenericMethod (":sourceFilename", "@brief Method QString QAudioDecoderControl::sourceFilename()\n", true, &_init_f_sourceFilename_c0, &_call_f_sourceFilename_c0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAudioDecoderControl::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QAudioDecoder::State QAudioDecoderControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QAudioDecoderControl::stateChanged(QAudioDecoder::State newState)\n", false, &_init_f_stateChanged_2338, &_call_f_stateChanged_2338);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAudioDecoderControl::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAudioDecoderControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAudioDecoderControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QAudioDecoderControl> decl_QAudioDecoderControl (qtdecl_QMediaControl (), "QtMultimedia", "QAudioDecoderControl_Native",
  methods_QAudioDecoderControl (),
  "@hide\n@alias QAudioDecoderControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAudioDecoderControl> &qtdecl_QAudioDecoderControl () { return decl_QAudioDecoderControl; }

}


class QAudioDecoderControl_Adaptor : public QAudioDecoderControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAudioDecoderControl_Adaptor();

  //  [adaptor ctor] QAudioDecoderControl::QAudioDecoderControl()
  QAudioDecoderControl_Adaptor() : QAudioDecoderControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAudioDecoderControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAudioDecoderControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAudioDecoderControl::isSignalConnected(signal);
  }

  //  [expose] int QAudioDecoderControl::receivers(const char *signal)
  int fp_QAudioDecoderControl_receivers_c1731 (const char *signal) const {
    return QAudioDecoderControl::receivers(signal);
  }

  //  [expose] QObject *QAudioDecoderControl::sender()
  QObject * fp_QAudioDecoderControl_sender_c0 () const {
    return QAudioDecoderControl::sender();
  }

  //  [expose] int QAudioDecoderControl::senderSignalIndex()
  int fp_QAudioDecoderControl_senderSignalIndex_c0 () const {
    return QAudioDecoderControl::senderSignalIndex();
  }

  //  [adaptor impl] QAudioFormat QAudioDecoderControl::audioFormat()
  QAudioFormat cbs_audioFormat_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("audioFormat");
  }

  virtual QAudioFormat audioFormat() const
  {
    if (cb_audioFormat_c0_0.can_issue()) {
      return cb_audioFormat_c0_0.issue<QAudioDecoderControl_Adaptor, QAudioFormat>(&QAudioDecoderControl_Adaptor::cbs_audioFormat_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("audioFormat");
    }
  }

  //  [adaptor impl] bool QAudioDecoderControl::bufferAvailable()
  bool cbs_bufferAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bufferAvailable");
  }

  virtual bool bufferAvailable() const
  {
    if (cb_bufferAvailable_c0_0.can_issue()) {
      return cb_bufferAvailable_c0_0.issue<QAudioDecoderControl_Adaptor, bool>(&QAudioDecoderControl_Adaptor::cbs_bufferAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bufferAvailable");
    }
  }

  //  [adaptor impl] qint64 QAudioDecoderControl::duration()
  qint64 cbs_duration_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("duration");
  }

  virtual qint64 duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QAudioDecoderControl_Adaptor, qint64>(&QAudioDecoderControl_Adaptor::cbs_duration_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("duration");
    }
  }

  //  [adaptor impl] bool QAudioDecoderControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAudioDecoderControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAudioDecoderControl_Adaptor, bool, QEvent *>(&QAudioDecoderControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAudioDecoderControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QAudioDecoderControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAudioDecoderControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAudioDecoderControl_Adaptor, bool, QObject *, QEvent *>(&QAudioDecoderControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAudioDecoderControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] qint64 QAudioDecoderControl::position()
  qint64 cbs_position_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("position");
  }

  virtual qint64 position() const
  {
    if (cb_position_c0_0.can_issue()) {
      return cb_position_c0_0.issue<QAudioDecoderControl_Adaptor, qint64>(&QAudioDecoderControl_Adaptor::cbs_position_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("position");
    }
  }

  //  [adaptor impl] QAudioBuffer QAudioDecoderControl::read()
  QAudioBuffer cbs_read_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("read");
  }

  virtual QAudioBuffer read()
  {
    if (cb_read_0_0.can_issue()) {
      return cb_read_0_0.issue<QAudioDecoderControl_Adaptor, QAudioBuffer>(&QAudioDecoderControl_Adaptor::cbs_read_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("read");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::setAudioFormat(const QAudioFormat &format)
  void cbs_setAudioFormat_2509_0(const QAudioFormat &format)
  {
    __SUPPRESS_UNUSED_WARNING (format);
    throw qt_gsi::AbstractMethodCalledException("setAudioFormat");
  }

  virtual void setAudioFormat(const QAudioFormat &format)
  {
    if (cb_setAudioFormat_2509_0.can_issue()) {
      cb_setAudioFormat_2509_0.issue<QAudioDecoderControl_Adaptor, const QAudioFormat &>(&QAudioDecoderControl_Adaptor::cbs_setAudioFormat_2509_0, format);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setAudioFormat");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::setSourceDevice(QIODevice *device)
  void cbs_setSourceDevice_1447_0(QIODevice *device)
  {
    __SUPPRESS_UNUSED_WARNING (device);
    throw qt_gsi::AbstractMethodCalledException("setSourceDevice");
  }

  virtual void setSourceDevice(QIODevice *device)
  {
    if (cb_setSourceDevice_1447_0.can_issue()) {
      cb_setSourceDevice_1447_0.issue<QAudioDecoderControl_Adaptor, QIODevice *>(&QAudioDecoderControl_Adaptor::cbs_setSourceDevice_1447_0, device);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setSourceDevice");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::setSourceFilename(const QString &fileName)
  void cbs_setSourceFilename_2025_0(const QString &fileName)
  {
    __SUPPRESS_UNUSED_WARNING (fileName);
    throw qt_gsi::AbstractMethodCalledException("setSourceFilename");
  }

  virtual void setSourceFilename(const QString &fileName)
  {
    if (cb_setSourceFilename_2025_0.can_issue()) {
      cb_setSourceFilename_2025_0.issue<QAudioDecoderControl_Adaptor, const QString &>(&QAudioDecoderControl_Adaptor::cbs_setSourceFilename_2025_0, fileName);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setSourceFilename");
    }
  }

  //  [adaptor impl] QIODevice *QAudioDecoderControl::sourceDevice()
  QIODevice * cbs_sourceDevice_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("sourceDevice");
  }

  virtual QIODevice * sourceDevice() const
  {
    if (cb_sourceDevice_c0_0.can_issue()) {
      return cb_sourceDevice_c0_0.issue<QAudioDecoderControl_Adaptor, QIODevice *>(&QAudioDecoderControl_Adaptor::cbs_sourceDevice_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sourceDevice");
    }
  }

  //  [adaptor impl] QString QAudioDecoderControl::sourceFilename()
  QString cbs_sourceFilename_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("sourceFilename");
  }

  virtual QString sourceFilename() const
  {
    if (cb_sourceFilename_c0_0.can_issue()) {
      return cb_sourceFilename_c0_0.issue<QAudioDecoderControl_Adaptor, QString>(&QAudioDecoderControl_Adaptor::cbs_sourceFilename_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sourceFilename");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::start()
  void cbs_start_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual void start()
  {
    if (cb_start_0_0.can_issue()) {
      cb_start_0_0.issue<QAudioDecoderControl_Adaptor>(&QAudioDecoderControl_Adaptor::cbs_start_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QAudioDecoder::State QAudioDecoderControl::state()
  qt_gsi::Converter<QAudioDecoder::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QAudioDecoder::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAudioDecoder::State>(cb_state_c0_0.issue<QAudioDecoderControl_Adaptor, qt_gsi::Converter<QAudioDecoder::State>::target_type>(&QAudioDecoderControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QAudioDecoderControl_Adaptor>(&QAudioDecoderControl_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAudioDecoderControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAudioDecoderControl_Adaptor, QChildEvent *>(&QAudioDecoderControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAudioDecoderControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAudioDecoderControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAudioDecoderControl_Adaptor, QEvent *>(&QAudioDecoderControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAudioDecoderControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAudioDecoderControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAudioDecoderControl_Adaptor, const QMetaMethod &>(&QAudioDecoderControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAudioDecoderControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAudioDecoderControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAudioDecoderControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAudioDecoderControl_Adaptor, QTimerEvent *>(&QAudioDecoderControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAudioDecoderControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_audioFormat_c0_0;
  gsi::Callback cb_bufferAvailable_c0_0;
  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_position_c0_0;
  gsi::Callback cb_read_0_0;
  gsi::Callback cb_setAudioFormat_2509_0;
  gsi::Callback cb_setSourceDevice_1447_0;
  gsi::Callback cb_setSourceFilename_2025_0;
  gsi::Callback cb_sourceDevice_c0_0;
  gsi::Callback cb_sourceFilename_c0_0;
  gsi::Callback cb_start_0_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAudioDecoderControl_Adaptor::~QAudioDecoderControl_Adaptor() { }

//  Constructor QAudioDecoderControl::QAudioDecoderControl() (adaptor class)

static void _init_ctor_QAudioDecoderControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAudioDecoderControl_Adaptor> ();
}

static void _call_ctor_QAudioDecoderControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioDecoderControl_Adaptor *> (new QAudioDecoderControl_Adaptor ());
}


// QAudioFormat QAudioDecoderControl::audioFormat()

static void _init_cbs_audioFormat_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_cbs_audioFormat_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAudioDecoderControl_Adaptor *)cls)->cbs_audioFormat_c0_0 ());
}

static void _set_callback_cbs_audioFormat_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_audioFormat_c0_0 = cb;
}


// bool QAudioDecoderControl::bufferAvailable()

static void _init_cbs_bufferAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_bufferAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoderControl_Adaptor *)cls)->cbs_bufferAvailable_c0_0 ());
}

static void _set_callback_cbs_bufferAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_bufferAvailable_c0_0 = cb;
}


// void QAudioDecoderControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAudioDecoderControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QAudioDecoderControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QAudioDecoderControl::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoderControl_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QAudioDecoderControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoderControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAudioDecoderControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoderControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QAudioDecoderControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDecoderControl_Adaptor *)cls)->fp_QAudioDecoderControl_isSignalConnected_c2394 (arg1));
}


// qint64 QAudioDecoderControl::position()

static void _init_cbs_position_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_position_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoderControl_Adaptor *)cls)->cbs_position_c0_0 ());
}

static void _set_callback_cbs_position_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_position_c0_0 = cb;
}


// QAudioBuffer QAudioDecoderControl::read()

static void _init_cbs_read_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioBuffer > ();
}

static void _call_cbs_read_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioBuffer > ((QAudioBuffer)((QAudioDecoderControl_Adaptor *)cls)->cbs_read_0_0 ());
}

static void _set_callback_cbs_read_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_read_0_0 = cb;
}


// exposed int QAudioDecoderControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAudioDecoderControl_Adaptor *)cls)->fp_QAudioDecoderControl_receivers_c1731 (arg1));
}


// exposed QObject *QAudioDecoderControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAudioDecoderControl_Adaptor *)cls)->fp_QAudioDecoderControl_sender_c0 ());
}


// exposed int QAudioDecoderControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDecoderControl_Adaptor *)cls)->fp_QAudioDecoderControl_senderSignalIndex_c0 ());
}


// void QAudioDecoderControl::setAudioFormat(const QAudioFormat &format)

static void _init_cbs_setAudioFormat_2509_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAudioFormat_2509_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = args.read<const QAudioFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_setAudioFormat_2509_0 (arg1);
}

static void _set_callback_cbs_setAudioFormat_2509_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_setAudioFormat_2509_0 = cb;
}


// void QAudioDecoderControl::setSourceDevice(QIODevice *device)

static void _init_cbs_setSourceDevice_1447_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSourceDevice_1447_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_setSourceDevice_1447_0 (arg1);
}

static void _set_callback_cbs_setSourceDevice_1447_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_setSourceDevice_1447_0 = cb;
}


// void QAudioDecoderControl::setSourceFilename(const QString &fileName)

static void _init_cbs_setSourceFilename_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSourceFilename_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_setSourceFilename_2025_0 (arg1);
}

static void _set_callback_cbs_setSourceFilename_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_setSourceFilename_2025_0 = cb;
}


// QIODevice *QAudioDecoderControl::sourceDevice()

static void _init_cbs_sourceDevice_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_sourceDevice_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAudioDecoderControl_Adaptor *)cls)->cbs_sourceDevice_c0_0 ());
}

static void _set_callback_cbs_sourceDevice_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_sourceDevice_c0_0 = cb;
}


// QString QAudioDecoderControl::sourceFilename()

static void _init_cbs_sourceFilename_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_sourceFilename_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDecoderControl_Adaptor *)cls)->cbs_sourceFilename_c0_0 ());
}

static void _set_callback_cbs_sourceFilename_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_sourceFilename_c0_0 = cb;
}


// void QAudioDecoderControl::start()

static void _init_cbs_start_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_start_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_start_0_0 ();
}

static void _set_callback_cbs_start_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_start_0_0 = cb;
}


// QAudioDecoder::State QAudioDecoderControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDecoder::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDecoder::State>::target_type > ((qt_gsi::Converter<QAudioDecoder::State>::target_type)((QAudioDecoderControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// void QAudioDecoderControl::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QAudioDecoderControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoderControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoderControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAudioDecoderControl> &qtdecl_QAudioDecoderControl ();

static gsi::Methods methods_QAudioDecoderControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioDecoderControl::QAudioDecoderControl()\nThis method creates an object of class QAudioDecoderControl.", &_init_ctor_QAudioDecoderControl_Adaptor_0, &_call_ctor_QAudioDecoderControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("audioFormat", "@brief Virtual method QAudioFormat QAudioDecoderControl::audioFormat()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_audioFormat_c0_0, &_call_cbs_audioFormat_c0_0);
  methods += new qt_gsi::GenericMethod ("audioFormat", "@hide", true, &_init_cbs_audioFormat_c0_0, &_call_cbs_audioFormat_c0_0, &_set_callback_cbs_audioFormat_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferAvailable", "@brief Virtual method bool QAudioDecoderControl::bufferAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bufferAvailable_c0_0, &_call_cbs_bufferAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferAvailable", "@hide", true, &_init_cbs_bufferAvailable_c0_0, &_call_cbs_bufferAvailable_c0_0, &_set_callback_cbs_bufferAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAudioDecoderControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAudioDecoderControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAudioDecoderControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method qint64 QAudioDecoderControl::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAudioDecoderControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAudioDecoderControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAudioDecoderControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("position", "@brief Virtual method qint64 QAudioDecoderControl::position()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("position", "@hide", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0, &_set_callback_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Virtual method QAudioBuffer QAudioDecoderControl::read()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_read_0_0, &_call_cbs_read_0_0);
  methods += new qt_gsi::GenericMethod ("read", "@hide", false, &_init_cbs_read_0_0, &_call_cbs_read_0_0, &_set_callback_cbs_read_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAudioDecoderControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAudioDecoderControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAudioDecoderControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setAudioFormat", "@brief Virtual method void QAudioDecoderControl::setAudioFormat(const QAudioFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAudioFormat_2509_0, &_call_cbs_setAudioFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setAudioFormat", "@hide", false, &_init_cbs_setAudioFormat_2509_0, &_call_cbs_setAudioFormat_2509_0, &_set_callback_cbs_setAudioFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setSourceDevice", "@brief Virtual method void QAudioDecoderControl::setSourceDevice(QIODevice *device)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSourceDevice_1447_0, &_call_cbs_setSourceDevice_1447_0);
  methods += new qt_gsi::GenericMethod ("setSourceDevice", "@hide", false, &_init_cbs_setSourceDevice_1447_0, &_call_cbs_setSourceDevice_1447_0, &_set_callback_cbs_setSourceDevice_1447_0);
  methods += new qt_gsi::GenericMethod ("setSourceFilename", "@brief Virtual method void QAudioDecoderControl::setSourceFilename(const QString &fileName)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSourceFilename_2025_0, &_call_cbs_setSourceFilename_2025_0);
  methods += new qt_gsi::GenericMethod ("setSourceFilename", "@hide", false, &_init_cbs_setSourceFilename_2025_0, &_call_cbs_setSourceFilename_2025_0, &_set_callback_cbs_setSourceFilename_2025_0);
  methods += new qt_gsi::GenericMethod ("sourceDevice", "@brief Virtual method QIODevice *QAudioDecoderControl::sourceDevice()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sourceDevice_c0_0, &_call_cbs_sourceDevice_c0_0);
  methods += new qt_gsi::GenericMethod ("sourceDevice", "@hide", true, &_init_cbs_sourceDevice_c0_0, &_call_cbs_sourceDevice_c0_0, &_set_callback_cbs_sourceDevice_c0_0);
  methods += new qt_gsi::GenericMethod ("sourceFilename", "@brief Virtual method QString QAudioDecoderControl::sourceFilename()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sourceFilename_c0_0, &_call_cbs_sourceFilename_c0_0);
  methods += new qt_gsi::GenericMethod ("sourceFilename", "@hide", true, &_init_cbs_sourceFilename_c0_0, &_call_cbs_sourceFilename_c0_0, &_set_callback_cbs_sourceFilename_c0_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method void QAudioDecoderControl::start()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0, &_set_callback_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QAudioDecoder::State QAudioDecoderControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QAudioDecoderControl::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAudioDecoderControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAudioDecoderControl_Adaptor> decl_QAudioDecoderControl_Adaptor (qtdecl_QAudioDecoderControl (), "QtMultimedia", "QAudioDecoderControl",
  methods_QAudioDecoderControl_Adaptor (),
  "@qt\n@brief Binding of QAudioDecoderControl");

}

