/*
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * HTTPResponseInfo.java
 *
 * Created on November 6, 2003, 2:11 PM
 */

package testutil;

/**
 * Used as a holder for information about an http response. This
 * class is used by ClientServerTestUtil to return information
 * after making a manual request to an endpoint.
 */
public class HTTPResponseInfo {

    int responseCode;
    String responseMessage;
    String responseBody;
    
    public HTTPResponseInfo(int responseCode,
        String responseMessage, 
        String responseBody) {
            
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseBody = responseBody;
    }
    
    /**
     * Get the response code from the http request. It returns the
     * value of getResponseCode() called on the http connection object.
     *
     * @return The integer response code
     */
    public int getResponseCode() {
        return responseCode;
    }
    
    /**
     * Get the http response message, such as "OK". This comes from
     * getResponseMessage() called on the http connection object.
     */
    public String getResponseMessage() {
        return responseMessage;
    }
    
    /**
     * Get the actual response (the body) of the http call. This
     * String comes from the input stream or error stream of the
     * http connection object.
     *
     * @return The response from the call.
     */
    public String getResponseBody() {
        return responseBody;
    }
    
}
