#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-sauna@example.com"
SENDER="mailto:paul.boddie@example.com"
OUTSIDESENDER="mailto:paul.boddie@example.net"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_in_freebusy
same_domain_only
EOF
echo '10,12,14,16,18:0,15,30,45' > "$PREFS/$USER/permitted_times"
echo 'PT60S' > "$PREFS/$USER/freebusy_offers"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-outsider.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$OUTSIDESENDER" "freebusy" \
|  tee out0f.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-outsider.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out1f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Relax the scheduling function.

cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_in_freebusy
EOF

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-outsider.txt" 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
|  tee out2f.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

# Check the free/busy state of the resource again.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T154500Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

# Try a different scheduling function.

ACL="$PWD/acl.tmp"

cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_in_freebusy
access_control_list "$ACL"
EOF

# Try without an ACL.

cat > "$ACL" <<EOF
EOF

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out3f.tmp \
|  grep -q "^20141126T160000Z${TAB}20141126T164500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR \
| tee out4r.tmp \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out4.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out4f.tmp

   ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Try with an unreasonable ACL.

cat > "$ACL" <<EOF
decline
EOF

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out4s.tmp \
|  grep -q "^20141126T160000Z${TAB}20141126T164500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR \
| tee out5r.tmp \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out5.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5f.tmp

   ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Try with a reasonable ACL.

cat > "$ACL" <<EOF
accept
decline attendee simon.skunk@example.com
EOF

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out5s.tmp \
|  grep -q "^20141126T160000Z${TAB}20141126T164500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out6f.tmp

   ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the ACL, using the implicit preference setting to hold the list.

cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_in_freebusy
access_control_list
EOF

cat > "$PREFS/$USER/acl" <<EOF
accept
decline attendee simon.skunk@example.com
accept organiser mailto:paul.boddie@example.com
EOF

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-acl.txt" 2>> $ERROR \
| tee out7r.tmp \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out7.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
|  tee out7f.tmp \
|  grep -q "^20141126T160000Z${TAB}20141126T164500Z" \
&& echo "Success" \
|| echo "Failed"

rm "$ACL"
