package CParse::Op::Relation;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;
use CParse::Op::Relation::Greater;
use CParse::Op::Relation::GreaterEqual;
use CParse::Op::Relation::Less;
use CParse::Op::Relation::LessEqual;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $left = shift;
    my $right = shift;
    my $op = shift;

    return CParse::Op::Relation::Greater->new($left, $right) if $op eq '>';
    return CParse::Op::Relation::GreaterEqual->new($left, $right) if $op eq '>=';
    return CParse::Op::Relation::Less->new($left, $right) if $op eq '<';
    return CParse::Op::Relation::LessEqual->new($left, $right) if $op eq '<=';
    die;
  }

1;
