/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import java.util.Iterator;

import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.trafo.TrafoConstants;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;

public class TdEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));

		BaseTagFactory dbfactory = getTagFactory();

		boolean decomposeTables = script.isParameterOn(
				TrafoConstants.SECTION_DOCBOOK,
				TrafoConstants.PARAM_DECOMPOSE_TABLES,
				TrafoConstants.DEFAULT_DECOMPOSE_TABLES);

		if (decomposeTables || getHtmlElement().isMute()) {
			traverse(true);
			return finalizeValues();
		}

		org.dbdoclet.tag.html.Td td = (org.dbdoclet.tag.html.Td) getHtmlElement();
		org.dbdoclet.tag.docbook.Entry entry = dbfactory.createEntry();
		copyCommonAttributes(getHtmlElement(), entry);

		NodeListImpl children = td.getTrafoChildNodes();
		Iterator<NodeImpl> iterator = children.iterator();
		NodeImpl node;

		while (iterator.hasNext()) {

			node = iterator.next();

			if (node instanceof org.dbdoclet.tag.html.Table) {
				traverse(true);
				return finalizeValues();
			}
		}

		entry.setAlign(td.getAlign());
		entry.setChar(td.getChar());
		entry.setCharOff(td.getCharOff());
		entry.setVAlign(td.getVAlign());

		int colspan = td.getColspan();

		if (colspan > 1) {

			entry.setNameSt("c" + td.getIndex());
			entry.setNameEnd("c" + ((td.getIndex() + colspan) - 1));
		}

		int rowspan = td.getRowspan();

		if (rowspan > 0) {
			entry.setMorerows(rowspan);
		}

		org.dbdoclet.tag.docbook.Para para = dbfactory.createPara();
		para.setFormatType(ElementImpl.FORMAT_INLINE);

		entry.appendChild(para);
		para.setParentNode(entry);

		getParent().appendChild(entry);
		entry.setParentNode(getParent());

		setCurrent(para);
		traverse(true);

		return finalizeValues();
	}
}
