/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive;

public class Colspan {

    public static final Colspan CS_1 = new Colspan(1);
    public static final Colspan CS_2 = new Colspan(2);
    public static final Colspan CS_3 = new Colspan(3);
    public static final Colspan CS_4 = new Colspan(4);
    public static final Colspan CS_5 = new Colspan(5);
    public static final Colspan CS_6 = new Colspan(6);
    
    private int value = 1;

    public Colspan() {
        this(1);
    }
    
    public Colspan(int value) {
        
        if (value < 1) {
            value = 1;
        }
        
        this.value = value;
    }
    
    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }
    
}
