#!/bin/csh -f
#-----------------------------------------------------------------------------
# file:         diff.csh
#
# description:
#       Shell script to compare two output files, removing
#       differences caused by time/date stamps, host names
#       missing leading zeros, and other values that change 
#       over time
#
# usage:
#       diff.csh file_name.out_sample file_name.out...
#
# author:
#       Carl R Fosler / Intermetrics, Inc.
#
# history:
#        29-Aug-1997 CRF Initial version
#       11-Jul-2014 AT  Initial version for hdfeos5
#
#
#   Inputs:
#     $1 = file_name.out_sample
#     $2 = file_name.out.xxx
#
#
  if ( ! -r $1 ) then
	echo "ERROR - unable to read input file $1"
	exit -1
  endif
#
  if ( ! -r $2 ) then
	echo "ERROR - unable to read input file $2"
	exit -1
  endif
#
  set filen = "`basename $1 .out_sample`"
  echo $filen
#
  set sample_temp = "/tmp/$$.sample"
  set out_temp    = "/tmp/$$.out"
#
   if ( -r $filen"77.out" || -r $filen"90.out" ) then
#
# fortran
#
     \rm -f $sample_temp $out_temp
     sed -e "/ -\./s/-\./-0\./g" \
         -e "/ \./s/ \./ 0./g" \
         -e "/File Attribute/d" \
         -e "/Reference ID/d" \
         -e "/BEGIN_PGE: /d" \
         -e "/FILE: /d" \
         -e "/pgstest/s,/usr/pgstest/HDFEOS5/message,$PGSMSG,g" \
         -e "/PGSTK/s,/ecs/sdps/pgs/HDFEOS5/message,$PGSMSG,g" \
         -e "/pgstest/s,/fire2/pgstest/TOOLKIT/message,$PGSMSG,g" \
         -e "/open file/s,No such file or directory,No such file," \
                 $1 > $sample_temp
     sed -e "/ -\./s/-\./-0\./g" \
         -e "/ \./s/ \./ 0./g" \
         -e "/File Attribute/d" \
         -e "/Reference ID/d" \
         -e "/BEGIN_PGE: /d" \
         -e "/FILE: /d" \
         -e "/PGS_E_UNIX/s,No such file or,No such file," \
         -e "/PGS_E_UNIX/s,No such file o,No such file," \
                 $2 > $out_temp
     diff -bw $out_temp $sample_temp
     \rm -f $sample_temp $out_temp
#
# C or shell
#
  else

     \rm -f $sample_temp $out_temp
     sed -e "/Machine Name/d" \
         -e "/Start Date/d" \
         -e "/End Date/d" \
         -e "/\*\*\*\*\*-----/d" \
         -e "/\*\*\*---/d" \
         -e "/File Attribute/d" \
         -e "/Reference ID/d" \
         -e "/BEGIN_PGE: /d" \
         -e "/FILE: /d" \
         -e "/File Reference :/d" \
         -e "/Attribute :/d" \
         -e "/\-0.000/s/\-0.000/ 0.000/g" \
         -e "/PGSTK/s,/ecs/sdps/pgs/PGSTK/message,$PGSMSG,g" \
         -e "/pgstest/s,/fire2/pgstest/TOOLKIT/message,$PGSMSG,g" \
         -e "/bin/s,/fire2/pgstest/TOOLKIT/bin/sun5,$PGSBIN,g" \
         -e "/TOOLKIT/s,/fire2/pgstest/TOOLKIT/test/test_drivers,$HDFEOS5_TST_SRC,g" \
         -e "/runtime/s,/fire2/pgstest/TOOLKIT/runtime,$PGSRUN,g" \
			$1 > $sample_temp
     sed -e "/Machine Name/d" \
         -e "/Start Date/d" \
         -e "/End Date/d" \
         -e "/\*\*\*\*\*-----/d" \
         -e "/\*\*\*---/d" \
         -e "/File Attribute/d" \
         -e "/Reference ID/d" \
         -e "/BEGIN_PGE: /d" \
         -e "/FILE: /d" \
         -e "/File Reference :/d" \
         -e "/Attribute :/d" \
         -e "/\-0.000/s/\-0.000/ 0.000/g" \
                   	$2 > $out_temp

#  The negative zero test is not right, but since we convert both
#  the sample output as well as the output, this will convert all
#  strings with -0.000 to  0.000, so that even very small numbers
#  will get convert to postive numbers, but for our comparision, this
#  is good enought for now.  CRF

     diff -bw $out_temp $sample_temp
     \rm -f $sample_temp $out_temp

  endif

  echo "$filen done"
