/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.filetree.RemoteDragTree;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;

public class RemoteFileTreePanel
extends JPanel {
    final Cursor cbusy = new Cursor(3);
    final Cursor cdone = new Cursor(0);
    private JComboBox rootSelect;

    public RemoteFileTreePanel(JembossParams mysettings) throws JembossSoapException {
        this(mysettings, true);
    }

    public RemoteFileTreePanel(final JembossParams mysettings, boolean laddCombo) throws JembossSoapException {
        this.setLayout(new BorderLayout());
        final Hashtable<String, String> rootsdone = new Hashtable<String, String>();
        final FileRoots efr = new FileRoots(mysettings);
        final JPanel filep = new JPanel();
        final CardLayout fileLayout = new CardLayout();
        filep.setLayout(fileLayout);
        this.rootSelect = new JComboBox(efr.getRootVector());
        int cstart = efr.getDefaultRootIndex();
        if (cstart != -1) {
            this.rootSelect.setSelectedIndex(cstart);
        }
        Dimension d = this.rootSelect.getPreferredSize();
        this.rootSelect.setPreferredSize(new Dimension((int)d.getWidth(), (int)d.getHeight() - 5));
        if (laddCombo) {
            this.add((Component)this.rootSelect, "North");
        }
        this.rootSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String rootName = (String)cb.getSelectedItem();
                efr.setCurrentRoot(rootName);
                efr.setCurrentDir(".");
                if (rootsdone.containsKey(rootName)) {
                    fileLayout.show(filep, rootName);
                } else {
                    RemoteFileTreePanel.this.setCursor(RemoteFileTreePanel.this.cbusy);
                    RemoteDragTree eft2 = new RemoteDragTree(mysettings, efr);
                    RemoteFileTreePanel.this.setCursor(RemoteFileTreePanel.this.cdone);
                    JScrollPane ss = new JScrollPane(eft2);
                    filep.add((Component)ss, efr.getCurrentRoot());
                    rootsdone.put(efr.getCurrentRoot(), "yes");
                    fileLayout.show(filep, efr.getCurrentRoot());
                }
            }
        });
        this.setCursor(this.cbusy);
        RemoteDragTree eft = new RemoteDragTree(mysettings, efr);
        this.setCursor(this.cdone);
        JScrollPane s = new JScrollPane(eft);
        filep.add((Component)s, efr.getCurrentRoot());
        rootsdone.put(efr.getCurrentRoot(), "yes");
        this.setPreferredSize(new Dimension(180, 500));
        this.add((Component)filep, "Center");
    }

    public JComboBox getRootSelect() {
        return this.rootSelect;
    }
}

