/* Copyright (C) 2004, 2005, 2009 and 2010 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SOCKET_NOTIFY_H
#define SOCKET_NOTIFY_H

#include "prog_defs.h"

#include <string>
#include <utility>

#include <gtk/gtk.h>

#include <c++-gtk-utils/window.h>
#include <c++-gtk-utils/emitter.h>


namespace SocketNotifyDialogCB {
  extern "C"  void socket_notify_dialog_button_clicked(GtkWidget*, void*);
}

class SocketNotifyDialog: public WinBase {
  const int standard_size;
  std::pair<std::string, std::string> fax_name;

  GtkWidget* number_button_p;
  GtkWidget* send_button_p;
  GtkWidget* queue_button_p;

  GtkWidget* number_entry_p;

  void set_number_cb(const std::string&);
  void send_signals(void);
protected:
  virtual void on_delete_event(void);
public:
  friend void SocketNotifyDialogCB::socket_notify_dialog_button_clicked(GtkWidget*, void*);

  EmitterArg<const std::pair<std::string, std::string>&> fax_name_sig;
  EmitterArg<const std::string&> fax_number_sig;
  Emitter sendfax_sig;
  Emitter queue_sig;

  SocketNotifyDialog(const int standard_size, const std::pair<std::string, unsigned int>&);
};

#endif
