// SPDX-FileCopyrightText: Copyright (C) DUNE Project contributors, see file LICENSE.md in module root
// SPDX-License-Identifier: LicenseRef-GPL-2.0-only-with-DUNE-exception
// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:

/**
 * \author: Marian Piatkowski, Steffen Müthing
 * \file
 * \brief Test data for complexmatrixtest.
 */

void assemblecomplexmatrix(Dune::FieldMatrix<std::complex<double>,10,10>& complexmatrix) {
  complexmatrix[0][0] = {-9.673988567513409e-01,-5.142264587405261e-01};
  complexmatrix[0][1] = {5.348995842667770e-02,5.398276725503746e-01};
  complexmatrix[0][2] = {-5.234400916488097e-01,9.412682633573508e-01};
  complexmatrix[0][3] = {3.757227805330059e-01,-6.680516673568877e-01};
  complexmatrix[0][4] = {-3.501868668711683e-02,-5.683500820623478e-01};
  complexmatrix[0][5] = {-7.936576231353253e-01,-7.478493218067332e-01};
  complexmatrix[0][6] = {-8.509403988024874e-01,9.002080633771643e-01};
  complexmatrix[0][7] = {1.466372567911807e-01,5.111616707924576e-01};
  complexmatrix[0][8] = {-2.818092625969133e-01,1.049700449709641e-01};
  complexmatrix[0][9] = {9.588682586135659e-01,4.876224144769936e-01};

  complexmatrix[1][0] = {-7.255368464279626e-01,6.083535084539808e-01};
  complexmatrix[1][1] = {-1.995427558196442e-01,7.830589040103644e-01};
  complexmatrix[1][2] = {8.044161469696165e-01,7.018395735425127e-01};
  complexmatrix[1][3] = {-1.197909447922330e-01,7.601504725218520e-01};
  complexmatrix[1][4] = {9.005047482906396e-01,8.402565074340704e-01};
  complexmatrix[1][5] = {-9.111866824846659e-03,5.209504568581238e-01};
  complexmatrix[1][6] = {-8.949414751934547e-01,4.312675960507550e-02};
  complexmatrix[1][7] = {-8.961223624162946e-01,-6.843857428451934e-01};
  complexmatrix[1][8] = {1.588599882828352e-01,-9.484830829074997e-02};
  complexmatrix[1][9] = {8.067326805585682e-01,9.671914763595870e-01};

  complexmatrix[2][0] = {-6.866418214918308e-01,-1.981112115076330e-01};
  complexmatrix[2][1] = {-4.333705079897170e-01,-2.950833054702185e-01};
  complexmatrix[2][2] = {-4.666685012479632e-01,7.952068144433233e-02};
  complexmatrix[2][3] = {6.584021866593519e-01,-3.393257406257678e-01};
  complexmatrix[2][4] = {-7.046799704919942e-01,7.621243390078305e-01};
  complexmatrix[2][5] = {9.695033300525990e-01,8.700079731037877e-01};
  complexmatrix[2][6] = {-6.475786872429674e-01,-5.198752551897780e-01};
  complexmatrix[2][7] = {9.999871421605289e-01,-5.913427786861281e-01};
  complexmatrix[2][8] = {3.747748692402499e-01,-8.007198729555680e-01};
  complexmatrix[2][9] = {3.337606691446904e-01,-5.482961891909555e-03};

  complexmatrix[3][0] = {-7.404191064370885e-01,-7.823823959484615e-01};
  complexmatrix[3][1] = {6.154490400177655e-01,8.380529479300849e-01};
  complexmatrix[3][2] = {-2.495860472552414e-01,5.204974727334908e-01};
  complexmatrix[3][3] = {-5.420636579124554e-01,7.867448291679586e-01};
  complexmatrix[3][4] = {2.821611926342180e-01,-1.360931634605365e-01};
  complexmatrix[3][5] = {3.688900337409646e-01,-2.336233375750590e-01};
  complexmatrix[3][6] = {5.955961037406681e-01,4.653088233737781e-01};
  complexmatrix[3][7] = {7.799112888890838e-01,-7.490630483948919e-01};
  complexmatrix[3][8] = {6.161597606801239e-02,5.145876647506784e-01};
  complexmatrix[3][9] = {-6.720639931373595e-01,6.600236676912865e-01};

  complexmatrix[4][0] = {9.978490360071179e-01,-5.634861893781862e-01};
  complexmatrix[4][1] = {-8.604894475361748e-01,8.986541507293722e-01};
  complexmatrix[4][2] = {2.507072828014878e-02,3.354475215708126e-01};
  complexmatrix[4][3] = {-2.992796428963913e-01,3.733398166360984e-01};
  complexmatrix[4][4] = {2.391929678801414e-01,-4.378811751668720e-01};
  complexmatrix[4][5] = {4.995417648458582e-01,-2.626729166427035e-01};
  complexmatrix[4][6] = {3.131273059701210e-01,9.348102770442190e-01};
  complexmatrix[4][7] = {9.955979986095791e-01,-8.918848446998209e-01};
  complexmatrix[4][8] = {-3.914097004530065e-01,9.844569228517157e-01};
  complexmatrix[4][9] = {7.778975003296031e-01,-8.460106383292054e-01};

  complexmatrix[5][0] = {2.586478880879683e-02,6.782244693852144e-01};
  complexmatrix[5][1] = {5.199070044420218e-02,-8.278883042875157e-01};
  complexmatrix[5][2] = {6.321286832132045e-02,-9.214393132931736e-01};
  complexmatrix[5][3] = {9.129365058210384e-01,1.772802663861217e-01};
  complexmatrix[5][4] = {5.720041960347464e-01,-3.850842525181752e-01};
  complexmatrix[5][5] = {-4.116792759912458e-01,-5.354769227725812e-01};
  complexmatrix[5][6] = {2.789166910941325e-01,5.194696837661181e-01};
  complexmatrix[5][7] = {7.410797298611513e-01,-8.553424011242308e-01};
  complexmatrix[5][8] = {1.539422251069649e-01,7.552275563381741e-01};
  complexmatrix[5][9] = {2.994139722080036e-01,-5.039117631986326e-01};

  complexmatrix[6][0] = {2.252796651913225e-01,-4.079367646053139e-01};
  complexmatrix[6][1] = {-6.155723080111539e-01,3.264538540162396e-01};
  complexmatrix[6][2] = {-1.247248068101354e-01,8.636701125016764e-01};
  complexmatrix[6][3] = {3.146080790621266e-01,7.173526518593323e-01};
  complexmatrix[6][4] = {-1.059328415924371e-01,-5.477867496888091e-01};
  complexmatrix[6][5] = {1.689770012949485e-01,-5.111745286319287e-01};
  complexmatrix[6][6] = {-8.130390456938367e-01,-7.301951766620367e-01};
  complexmatrix[6][7] = {-9.916767822539791e-01,8.461382546676968e-01};
  complexmatrix[6][8] = {4.956185927128507e-01,2.578198626906703e-01};
  complexmatrix[6][9] = {2.589594066417586e-01,-5.417260404404840e-01};

  complexmatrix[7][0] = {2.751045354060384e-01,4.857438013356852e-02};
  complexmatrix[7][1] = {7.804652050977876e-01,-3.022141295029848e-01};
  complexmatrix[7][2] = {8.616195907171906e-01,4.419046861314702e-01};
  complexmatrix[7][3] = {-1.208801610026882e-01,8.479395778141634e-01};
  complexmatrix[7][4] = {-6.249337809276458e-01,-4.475306558644077e-01};
  complexmatrix[7][5] = {-6.952204162698334e-01,4.642970317342769e-01};
  complexmatrix[7][6] = {4.042013969291935e-02,-8.435357165725602e-01};
  complexmatrix[7][7] = {1.877843584808447e-01,-6.392554685656240e-01};
  complexmatrix[7][8] = {-9.291581865070193e-01,4.956057339420570e-01};
  complexmatrix[7][9] = {4.012399294419400e-01,-3.662657250493140e-01};

  complexmatrix[8][0] = {-1.283402601854600e-02,9.455500477671390e-01};
  complexmatrix[8][1] = {-8.716573584227159e-01,-9.599539022706234e-01};
  complexmatrix[8][2] = {-4.314131938998649e-01,4.770686298036335e-01};
  complexmatrix[8][3] = {-2.031266666963355e-01,6.295337926733930e-01};
  complexmatrix[8][4] = {1.128875106167455e-01,-1.669974388401012e-01};
  complexmatrix[8][5] = {-7.490501905554208e-01,5.869407763643846e-01};
  complexmatrix[8][6] = {-8.601872044895716e-01,-5.906898274974384e-01};
  complexmatrix[8][7] = {-6.737370014534039e-01,-2.166195387098098e-01};
  complexmatrix[8][8] = {6.664770840045424e-01,8.507531023820645e-01};
  complexmatrix[8][9] = {-3.424459133960520e-01,-5.371440954213702e-01};

  complexmatrix[9][0] = {-4.149664311739459e-01,5.427153955878297e-01};
  complexmatrix[9][1] = {-8.459652545144625e-02,-8.738083233469205e-01};
  complexmatrix[9][2] = {2.799576331302327e-01,-2.919026405047171e-01};
  complexmatrix[9][3] = {3.684370505476542e-01,8.219440615838134e-01};
  complexmatrix[9][4] = {-6.607858276277714e-01,8.136078677203542e-01};
  complexmatrix[9][5] = {-6.717961326575820e-01,4.901427782560432e-01};
  complexmatrix[9][6] = {-7.715905321629679e-02,6.393545603562867e-01};
  complexmatrix[9][7] = {8.260533548081541e-01,6.393903054480397e-01};
  complexmatrix[9][8] = {7.465426855471649e-01,6.620750816827989e-01};
  complexmatrix[9][9] = {-8.516780602986357e-01,2.661443870822640e-01};
}

void assemblecomplexsol(Dune::FieldVector<std::complex<double>,10>& complexsol) {
  complexsol[0] = {6.803754343094190e-01,-2.112341463618139e-01};
  complexsol[1] = {5.661984475172117e-01,5.968800669521466e-01};
  complexsol[2] = {8.232947158735686e-01,-6.048972614132321e-01};
  complexsol[3] = {-3.295544885702220e-01,5.364591896238080e-01};
  complexsol[4] = {-4.444505783936245e-01,1.079399115908610e-01};
  complexsol[5] = {-4.520589627567950e-02,2.577418495238488e-01};
  complexsol[6] = {-2.704310544163133e-01,2.680182039123102e-02};
  complexsol[7] = {9.044594503494257e-01,8.323901360074013e-01};
  complexsol[8] = {2.714234559198019e-01,4.345938588653662e-01};
  complexsol[9] = {-7.167948892883933e-01,2.139377525141173e-01};
}

void assemblehermitianmatrix(Dune::FieldMatrix<std::complex<double>,10,10>& hermitianmatrix) {
  hermitianmatrix[0][0] = {7.197903669889858e+00,0.000000000000000e+00};
  hermitianmatrix[0][1] = {-3.796134060556492e+00,3.378779614117114e-01};
  hermitianmatrix[0][2] = {-7.792613368410124e-01,-2.029495926144751e+00};
  hermitianmatrix[0][3] = {2.424358093154745e-01,-5.210063258489648e-01};
  hermitianmatrix[0][4] = {1.215783110733711e+00,-2.010080764899121e+00};
  hermitianmatrix[0][5] = {2.007393091095153e+00,1.261146874742959e+00};
  hermitianmatrix[0][6] = {8.400538096522401e-01,3.556657457954513e-01};
  hermitianmatrix[0][7] = {-5.366239926352748e-01,1.065157738997571e+00};
  hermitianmatrix[0][8] = {-3.100062250221378e-01,-1.853912328045908e-01};
  hermitianmatrix[0][9] = {-1.369506171548954e-01,-2.191920974481131e+00};

  hermitianmatrix[1][0] = {-3.796134060556492e+00,-3.378779614117114e-01};
  hermitianmatrix[1][1] = {8.177347822939913e+00,0.000000000000000e+00};
  hermitianmatrix[1][2] = {3.423679740643685e+00,-8.327540053361566e-01};
  hermitianmatrix[1][3] = {-5.738847217530769e-01,1.285746142919267e+00};
  hermitianmatrix[1][4] = {-1.000317599806714e+00,-1.686041686108639e+00};
  hermitianmatrix[1][5] = {-2.161820121002458e+00,-2.291203709707303e+00};
  hermitianmatrix[1][6] = {3.311679204788015e+00,-1.703242106082667e-01};
  hermitianmatrix[1][7] = {1.566275624302893e-03,2.355130514323052e-01};
  hermitianmatrix[1][8] = {-2.052276321346663e+00,7.263179682041794e-01};
  hermitianmatrix[1][9] = {6.517140901693339e-01,-5.382604520819103e-01};

  hermitianmatrix[2][0] = {-7.792613368410124e-01,2.029495926144751e+00};
  hermitianmatrix[2][1] = {3.423679740643685e+00,8.327540053361566e-01};
  hermitianmatrix[2][2] = {6.099598957224000e+00,0.000000000000000e+00};
  hermitianmatrix[2][3] = {9.363518872122267e-01,2.431336243539179e+00};
  hermitianmatrix[2][4] = {-4.512089463662358e-01,4.768094168245564e-01};
  hermitianmatrix[2][5] = {-7.197164862085857e-01,1.030153878182087e+00};
  hermitianmatrix[2][6] = {-1.681901621557627e-01,1.939031624543862e+00};
  hermitianmatrix[2][7] = {-3.685384612851221e-01,8.749011852426078e-01};
  hermitianmatrix[2][8] = {-3.309499218189973e-01,6.471561610525622e-01};
  hermitianmatrix[2][9] = {1.117932973970579e+00,-1.250965917379453e+00};

  hermitianmatrix[3][0] = {2.424358093154745e-01,5.210063258489648e-01};
  hermitianmatrix[3][1] = {-5.738847217530769e-01,-1.285746142919267e+00};
  hermitianmatrix[3][2] = {9.363518872122267e-01,-2.431336243539179e+00};
  hermitianmatrix[3][3] = {6.331005113267439e+00,0.000000000000000e+00};
  hermitianmatrix[3][4] = {-2.993398678694307e-01,-2.546975173854160e-02};
  hermitianmatrix[3][5] = {6.807164931619119e-01,6.842214609887675e-01};
  hermitianmatrix[3][6] = {-1.585628344826376e+00,5.718554836282774e-01};
  hermitianmatrix[3][7] = {-3.977057407423769e-01,6.989648283164356e-01};
  hermitianmatrix[3][8] = {3.474749763656946e+00,-9.804983433454130e-01};
  hermitianmatrix[3][9] = {3.837829404449155e-01,2.955801965170571e-01};

  hermitianmatrix[4][0] = {1.215783110733711e+00,2.010080764899121e+00};
  hermitianmatrix[4][1] = {-1.000317599806714e+00,1.686041686108639e+00};
  hermitianmatrix[4][2] = {-4.512089463662358e-01,-4.768094168245564e-01};
  hermitianmatrix[4][3] = {-2.993398678694307e-01,2.546975173854160e-02};
  hermitianmatrix[4][4] = {5.782508877722716e+00,0.000000000000000e+00};
  hermitianmatrix[4][5] = {2.352248681811305e+00,-1.915408924791806e+00};
  hermitianmatrix[4][6] = {-5.050140077330580e-02,1.720340837323670e+00};
  hermitianmatrix[4][7] = {-1.384292690960728e+00,-1.610641396488195e+00};
  hermitianmatrix[4][8] = {-1.497233786162651e+00,-7.140793387576246e-01};
  hermitianmatrix[4][9] = {2.644285604378166e+00,1.537531467522439e+00};

  hermitianmatrix[5][0] = {2.007393091095153e+00,-1.261146874742959e+00};
  hermitianmatrix[5][1] = {-2.161820121002458e+00,2.291203709707303e+00};
  hermitianmatrix[5][2] = {-7.197164862085857e-01,-1.030153878182087e+00};
  hermitianmatrix[5][3] = {6.807164931619119e-01,-6.842214609887675e-01};
  hermitianmatrix[5][4] = {2.352248681811305e+00,1.915408924791806e+00};
  hermitianmatrix[5][5] = {6.708789570096198e+00,0.000000000000000e+00};
  hermitianmatrix[5][6] = {-9.395295739035217e-01,5.542147306633838e-01};
  hermitianmatrix[5][7] = {6.376861664858158e-02,-1.078862327434092e+00};
  hermitianmatrix[5][8] = {-6.072363218363827e-01,-2.568973945662960e+00};
  hermitianmatrix[5][9] = {5.604196275925352e-01,7.924409894223814e-01};

  hermitianmatrix[6][0] = {8.400538096522401e-01,-3.556657457954513e-01};
  hermitianmatrix[6][1] = {3.311679204788015e+00,1.703242106082667e-01};
  hermitianmatrix[6][2] = {-1.681901621557627e-01,-1.939031624543862e+00};
  hermitianmatrix[6][3] = {-1.585628344826376e+00,-5.718554836282774e-01};
  hermitianmatrix[6][4] = {-5.050140077330580e-02,-1.720340837323670e+00};
  hermitianmatrix[6][5] = {-9.395295739035217e-01,-5.542147306633838e-01};
  hermitianmatrix[6][6] = {8.328660025951734e+00,0.000000000000000e+00};
  hermitianmatrix[6][7] = {1.911840958553550e+00,-3.724184659980277e+00};
  hermitianmatrix[6][8] = {1.137677844325891e-01,5.604277205039606e-01};
  hermitianmatrix[6][9] = {-7.313018555728619e-01,-8.468371873228848e-01};

  hermitianmatrix[7][0] = {-5.366239926352748e-01,-1.065157738997571e+00};
  hermitianmatrix[7][1] = {1.566275624302893e-03,-2.355130514323052e-01};
  hermitianmatrix[7][2] = {-3.685384612851221e-01,-8.749011852426078e-01};
  hermitianmatrix[7][3] = {-3.977057407423769e-01,-6.989648283164356e-01};
  hermitianmatrix[7][4] = {-1.384292690960728e+00,1.610641396488195e+00};
  hermitianmatrix[7][5] = {6.376861664858158e-02,1.078862327434092e+00};
  hermitianmatrix[7][6] = {1.911840958553550e+00,3.724184659980277e+00};
  hermitianmatrix[7][7] = {1.087602223303330e+01,0.000000000000000e+00};
  hermitianmatrix[7][8] = {-1.711803279506748e+00,8.772768099603478e-03};
  hermitianmatrix[7][9] = {-8.661271304690032e-02,7.620932443208487e-01};

  hermitianmatrix[8][0] = {-3.100062250221378e-01,1.853912328045908e-01};
  hermitianmatrix[8][1] = {-2.052276321346663e+00,-7.263179682041794e-01};
  hermitianmatrix[8][2] = {-3.309499218189973e-01,-6.471561610525622e-01};
  hermitianmatrix[8][3] = {3.474749763656946e+00,9.804983433454130e-01};
  hermitianmatrix[8][4] = {-1.497233786162651e+00,7.140793387576246e-01};
  hermitianmatrix[8][5] = {-6.072363218363827e-01,2.568973945662960e+00};
  hermitianmatrix[8][6] = {1.137677844325891e-01,-5.604277205039606e-01};
  hermitianmatrix[8][7] = {-1.711803279506748e+00,-8.772768099603478e-03};
  hermitianmatrix[8][8] = {6.476008026107579e+00,0.000000000000000e+00};
  hermitianmatrix[8][9] = {-2.937196022651017e+00,4.075385476181479e-01};

  hermitianmatrix[9][0] = {-1.369506171548954e-01,2.191920974481131e+00};
  hermitianmatrix[9][1] = {6.517140901693339e-01,5.382604520819103e-01};
  hermitianmatrix[9][2] = {1.117932973970579e+00,1.250965917379453e+00};
  hermitianmatrix[9][3] = {3.837829404449155e-01,-2.955801965170571e-01};
  hermitianmatrix[9][4] = {2.644285604378166e+00,-1.537531467522439e+00};
  hermitianmatrix[9][5] = {5.604196275925352e-01,-7.924409894223814e-01};
  hermitianmatrix[9][6] = {-7.313018555728619e-01,8.468371873228848e-01};
  hermitianmatrix[9][7] = {-8.661271304690032e-02,-7.620932443208487e-01};
  hermitianmatrix[9][8] = {-2.937196022651017e+00,-4.075385476181479e-01};
  hermitianmatrix[9][9] = {7.264295214773998e+00,0.000000000000000e+00};
}
