info = {
    "name": "sw",
    "date_order": "DMY",
    "january": [
        "januari",
        "jan"
    ],
    "february": [
        "februari",
        "feb"
    ],
    "march": [
        "machi",
        "mac"
    ],
    "april": [
        "aprili",
        "apr"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "juni",
        "jun"
    ],
    "july": [
        "julai",
        "jul"
    ],
    "august": [
        "agosti",
        "ago"
    ],
    "september": [
        "septemba",
        "sep"
    ],
    "october": [
        "oktoba",
        "okt"
    ],
    "november": [
        "novemba",
        "nov"
    ],
    "december": [
        "desemba",
        "des"
    ],
    "monday": [
        "jumatatu"
    ],
    "tuesday": [
        "jumanne"
    ],
    "wednesday": [
        "jumatano"
    ],
    "thursday": [
        "alhamisi"
    ],
    "friday": [
        "ijumaa"
    ],
    "saturday": [
        "jumamosi"
    ],
    "sunday": [
        "jumapili"
    ],
    "am": [
        "am",
        "asubuhi"
    ],
    "pm": [
        "pm",
        "mchana"
    ],
    "year": [
        "mwaka"
    ],
    "month": [
        "mwezi"
    ],
    "week": [
        "wiki"
    ],
    "day": [
        "siku"
    ],
    "hour": [
        "saa"
    ],
    "minute": [
        "dakika",
        "dak"
    ],
    "second": [
        "sekunde",
        "sek"
    ],
    "relative-type": {
        "1 year ago": [
            "mwaka uliopita"
        ],
        "0 year ago": [
            "mwaka huu"
        ],
        "in 1 year": [
            "mwaka ujao"
        ],
        "1 month ago": [
            "mwezi uliopita"
        ],
        "0 month ago": [
            "mwezi huu"
        ],
        "in 1 month": [
            "mwezi ujao"
        ],
        "1 week ago": [
            "wiki iliyopita"
        ],
        "0 week ago": [
            "wiki hii"
        ],
        "in 1 week": [
            "wiki ijayo"
        ],
        "1 day ago": [
            "jana"
        ],
        "0 day ago": [
            "leo"
        ],
        "in 1 day": [
            "kesho"
        ],
        "0 hour ago": [
            "saa hii"
        ],
        "0 minute ago": [
            "dakika hii"
        ],
        "0 second ago": [
            "sasa hivi"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "baada ya mwaka (\\d+)",
            "baada ya miaka (\\d+)"
        ],
        "\\1 year ago": [
            "mwaka (\\d+) uliopita",
            "miaka (\\d+) iliyopita"
        ],
        "in \\1 month": [
            "baada ya mwezi (\\d+)",
            "baada ya miezi (\\d+)"
        ],
        "\\1 month ago": [
            "mwezi (\\d+) uliopita",
            "miezi (\\d+) iliyopita"
        ],
        "in \\1 week": [
            "baada ya wiki (\\d+)"
        ],
        "\\1 week ago": [
            "wiki (\\d+) iliyopita",
            "wiki (\\d+) zilizopita"
        ],
        "in \\1 day": [
            "baada ya siku (\\d+)"
        ],
        "\\1 day ago": [
            "siku (\\d+) iliyopita",
            "siku (\\d+) zilizopita"
        ],
        "in \\1 hour": [
            "baada ya saa (\\d+)"
        ],
        "\\1 hour ago": [
            "saa (\\d+) iliyopita",
            "saa (\\d+) zilizopita"
        ],
        "in \\1 minute": [
            "baada ya dakika (\\d+)"
        ],
        "\\1 minute ago": [
            "dakika (\\d+) iliyopita",
            "dakika (\\d+) zilizopita"
        ],
        "in \\1 second": [
            "baada ya sekunde (\\d+)"
        ],
        "\\1 second ago": [
            "sekunde (\\d+) iliyopita",
            "sekunde (\\d+) zilizopita"
        ]
    },
    "locale_specific": {
        "sw-UG": {
            "name": "sw-UG"
        },
        "sw-CD": {
            "name": "sw-CD",
            "week": [
                "juma"
            ]
        },
        "sw-KE": {
            "name": "sw-KE"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
