/*
 * FILE : ifeffit_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 883)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#include <tcl.h>
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/**************************************************************************
 * $Header: /home/newville/Codes/cvsroot/ifeffit/wrappers/tcl/ifeffit_wrap.c,v 1.1.1.1 2001/02/15 01:29:38 newville Exp $
 *
 * swigtcl8.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 **********************************************************************/

#if defined(_WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export 
#	else
#	    define SWIGEXPORT(a) a 
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a 
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SWIG_GLOBAL
#include <tcl.h>
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

#ifdef SWIG_NOINCLUDE
extern void SWIG_SetPointerObj(Tcl_Obj *, void *, char *);
extern void SWIG_RegisterMapping(char *, char *, void *(*)(void *));
extern char *SWIG_GetPointerObj(Tcl_Interp *, Tcl_Obj *, void **, char *);
extern int  SWIG_MakePtr(char *, const void *, char *);
extern void SWIG_RegisterType();
#else

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void) 
SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void)
SWIG_SetPointerObj(Tcl_Obj *objPtr, void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  char _temp[20], *_c;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    _c = &_temp[0];
    while (_r >= _result)
      *(_c++) = *(_r--);
    *_c = 0;
    Tcl_SetStringObj(objPtr,_temp,-1);
  } else {
    Tcl_SetStringObj(objPtr,"NULL",-1);
  }
  if (_ptr)
    Tcl_AppendToObj(objPtr,type,-1);
}

/* This is for backwards compatibility */

SWIGSTATICRUNTIME(int) 
SWIG_MakePtr(char *_c, const void *_ptr, char *type)
{
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;
  int      l = 0;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
      l++;
    }
    *_r = '_';
    l++;
    while (_r >= _result)
      *(_c++) = *(_r--);
    _r = type;
    while (*_r)
      *(_c++) = *(_r++);
    *(_c) = 0;
  } else {
      strcpy (_c, "NULL");
  }
  return l;
}

/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(char *)
SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *_t) {
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  char *_c;
  _p = 0;

  /* Extract the pointer value as a string */
  _c = Tcl_GetStringFromObj(objPtr, &i);

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start > end) sp = 0;
	  /* Try to find a match for this */
	  while (start <= end) {
	    if (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	    }
	    sp++;
	    start++;
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void)
SWIG_RegisterType() {
  /* Does nothing at the moment */
}

#endif

#ifdef __cplusplus
}
#endif
#define SWIG_init    Ifeffit_Init
#define SWIG_name    "ifeffit"
#define SWIG_prefix  ""
#define SWIG_namespace ""

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int) Ifeffit_Init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#include "ifeffit.h"


static char *_SWIG_GetPtr(Tcl_Interp *interp, char *s, void **ptr, char *type) {
  Tcl_Obj *obj;
  char *c;
  obj = Tcl_NewStringObj(s, strlen(s));
  c = SWIG_GetPointerObj(interp, obj, ptr, type);
  if (c) {
    c = strstr(s,c);
  }
  Tcl_DecrRefCount(obj);
  return c;
}

#define SWIG_GetPtr(a,b,c) _SWIG_GetPtr(interp, a,b,c)



#include <ctype.h>

/*------------------------------------------------------------------
  ptrcast(value,type)

  Constructs a new pointer value.   Value may either be a string
  or an integer. Type is a string corresponding to either the
  C datatype or mangled datatype.

  ptrcast(0,"Vector *")
               or
  ptrcast(0,"Vector_p")   
  ------------------------------------------------------------------ */

static int ptrcast(Tcl_Interp *interp, char *_ptrvalue, char *type) {

  char *r,*s;
  void *ptr;
  char *typestr,*c;
  int   pv;
  int   error = 0;

  /* Produce a "mangled" version of the type string.  */

  typestr = (char *) malloc(strlen(type)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr;
  *(r++) = '_';
  c = type;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
        *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;

  /* Check to see what kind of object _PTRVALUE is */
  if (Tcl_GetInt(interp,_ptrvalue,&pv) == TCL_OK) {
    ptr = (void *) pv;
    /* Received a numerical value. Make a pointer out of it */
    r = (char *) malloc(strlen(typestr)+22);
    if (ptr) {
      SWIG_MakePtr(r, ptr, typestr);
    } else {
      sprintf(r,"_0%s",typestr);
    }
    Tcl_SetResult(interp,r,TCL_VOLATILE);
    free(r);
  } else {
    /* Have a string.  Try to get the real pointer value */
    s = _ptrvalue;
    r = (char *) malloc(strlen(type)+22);
    
    /* Now extract the pointer value */
    if (!SWIG_GetPtr(s,&ptr,0)) {
      if (ptr) {
	SWIG_MakePtr(r,ptr,typestr);
      } else {
	sprintf(r,"_0%s",typestr);
      }
      Tcl_SetResult(interp,r,TCL_VOLATILE);
    } else {
      error = 1;
    }
    free(r);
  }
  free(typestr);
  if (error) {
    Tcl_SetResult(interp,"Type error in ptrcast. Argument is not a valid pointer value.",TCL_VOLATILE);
   return TCL_ERROR;
  }
  return TCL_OK;
}

/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

static int ptrvalue(Tcl_Interp *interp, char *_ptrvalue, int index, char *type) {
  void     *ptr;
  char     *s;
  int      error = 0;

  if (type) {
    if (strlen(type) == 0) type = 0;
  }
  s = _ptrvalue;
  if (SWIG_GetPtr(s,&ptr,0)) {
    Tcl_SetResult(interp,"Type error in ptrvalue. Argument is not a valid pointer value.",
		  TCL_STATIC);
    return TCL_ERROR;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    Tcl_SetResult(interp,"Unable to dereference NULL pointer.",TCL_STATIC);
    return TCL_ERROR;
  }

  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    sprintf(interp->result,"%ld",(long) *(((int *) ptr) + index));
  } else if (strcmp(type,"double") == 0) {
    Tcl_PrintDouble(interp,(double) *(((double *) ptr)+index), interp->result);
  } else if (strcmp(type,"short") == 0) {
    sprintf(interp->result,"%ld",(long) *(((short *) ptr) + index));
  } else if (strcmp(type,"long") == 0) {
    sprintf(interp->result,"%ld",(long) *(((long *) ptr) + index));
  } else if (strcmp(type,"float") == 0) {
    Tcl_PrintDouble(interp,(double) *(((float *) ptr)+index), interp->result);
  } else if (strcmp(type,"char") == 0) {
    Tcl_SetResult(interp,((char *) ptr) + index, TCL_VOLATILE);
  } else if (strcmp(type,"char *") == 0) {
    char *c = *(((char **) ptr)+index);
    if (c) Tcl_SetResult(interp,(char *) c, TCL_VOLATILE);
    else Tcl_SetResult(interp,"NULL", TCL_VOLATILE);
  } else {
    Tcl_SetResult(interp,"Unable to dereference unsupported datatype.",TCL_STATIC);
    return TCL_ERROR;
  }
  return TCL_OK;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */

static int ptrcreate(Tcl_Interp *interp, char *type, char *_ptrvalue, int numelements) {
  void     *ptr;
  int       sz;
  char     *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = "_int_p";
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = "_short_p";
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = "_long_p";
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = "_double_p";
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = "_float_p";
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = "_char_p";
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = "_char_pp";
  } else if (strcmp(type,"void") == 0) {
    sz = numelements;
  } else {
    Tcl_SetResult(interp,"Unable to create unknown datatype.",TCL_STATIC);
    return TCL_ERROR;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    Tcl_SetResult(interp,"Out of memory in ptrcreate.",TCL_STATIC); 
    return TCL_ERROR;
  }

  /* Now try to set its default value */

  if (_ptrvalue) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      Tcl_GetInt(interp,_ptrvalue,&ivalue);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip;
      int i, ivalue;
      Tcl_GetInt(interp,_ptrvalue,&ivalue);      
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = (short) ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip;
      int i, ivalue;
      Tcl_GetInt(interp,_ptrvalue,&ivalue);      
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = (long) ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      Tcl_GetDouble(interp,_ptrvalue,&ivalue);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip;
      double ivalue;
      int i;
      Tcl_GetDouble(interp,_ptrvalue,&ivalue);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = (double) ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) _ptrvalue;
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) _ptrvalue;
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    } 
  } 
  /* Create the pointer value */
  
  SWIG_MakePtr(temp,ptr,cast);
  Tcl_SetResult(interp,temp,TCL_VOLATILE);
  return TCL_OK;
}

/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

static int ptrset(Tcl_Interp *interp, char *_PTRVALUE, char *_VALUE, int index, char *type) {
  void     *ptr;
  char     *s;

  s = _PTRVALUE;
  if (SWIG_GetPtr(s,&ptr,0)) {
    Tcl_SetResult(interp,"Type error in ptrset. Argument is not a valid pointer value.",
		  TCL_STATIC);
    return TCL_ERROR;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    Tcl_SetResult(interp,"Unable to set NULL pointer.",TCL_STATIC);
    return TCL_ERROR;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    int ivalue;
    Tcl_GetInt(interp,_VALUE, &ivalue);
    *(((int *) ptr)+index) = ivalue;
  } else if (strcmp(type,"double") == 0) {
    double ivalue;
    Tcl_GetDouble(interp,_VALUE, &ivalue);
    *(((double *) ptr)+index) = (double) ivalue;
  } else if (strcmp(type,"short") == 0) {
    int ivalue;
    Tcl_GetInt(interp,_VALUE, &ivalue);
    *(((short *) ptr)+index) = (short) ivalue;
  } else if (strcmp(type,"long") == 0) {
    int ivalue;
    Tcl_GetInt(interp,_VALUE, &ivalue);
    *(((long *) ptr)+index) = (long) ivalue;
  } else if (strcmp(type,"float") == 0) {
    double ivalue;
    Tcl_GetDouble(interp,_VALUE, &ivalue);
    *(((float *) ptr)+index) = (float) ivalue;
  } else if (strcmp(type,"char") == 0) {
    char *c = _VALUE;
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = _VALUE;
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    Tcl_SetResult(interp,"Unable to set unsupported datatype.",TCL_STATIC);
    return TCL_ERROR;
  }
  return TCL_OK;
}

/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

static int ptradd(Tcl_Interp *interp, char *_PTRVALUE, int offset) {

  char *r,*s;
  void *ptr,*junk;
  char *type;

  /* Check to see what kind of object _PTRVALUE is */
  
  s = _PTRVALUE;

  /* Try to handle a few common datatypes first */

  if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
    ptr = (void *) (((int *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
    ptr = (void *) (((double *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
    ptr = (void *) (((short *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
    ptr = (void *) (((long *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
    ptr = (void *) (((float *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
    ptr = (void *) (((char *) ptr) + offset);
  } else if (!SWIG_GetPtr(s,&ptr,0)) {
    ptr = (void *) (((char *) ptr) + offset);
  } else {
    Tcl_SetResult(interp,"Type error in ptradd. Argument is not a valid pointer value.",TCL_STATIC);
    return TCL_ERROR;
  }
  type = SWIG_GetPtr(s,&junk,"INVALID POINTER");
  r = (char *) malloc(strlen(type)+20);
  if (ptr) {
    SWIG_MakePtr(r,ptr,type);
  } else {
    sprintf(r,"_0%s",type);
  }
  Tcl_SetResult(interp,r,TCL_VOLATILE);
  free(r);
  return TCL_OK;
}


/*------------------------------------------------------------------
  ptrmap(type1,type2)

  Allows a mapping between type1 and type2. (Like a typedef)
  ------------------------------------------------------------------ */

static void ptrmap(char *type1, char *type2) {

  char *typestr1,*typestr2,*c,*r;

  /* Produce a "mangled" version of the type string.  */

  typestr1 = (char *) malloc(strlen(type1)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr1;
  *(r++) = '_';
  c = type1;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  
  typestr2 = (char *) malloc(strlen(type2)+2);

  /* Go through and munge the typestring */
  
  r = typestr2;
  *(r++) = '_';
  c = type2;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  SWIG_RegisterMapping(typestr1,typestr2,0);
  SWIG_RegisterMapping(typestr2,typestr1,0);
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */

int ptrfree(Tcl_Interp *interp, char *_PTRVALUE) {
  void *ptr, *junk;
  char *s;

  s = _PTRVALUE;
  if (SWIG_GetPtr(s,&ptr,0)) {
    Tcl_SetResult(interp,"Type error in ptrfree. Argument is not a valid pointer value.",TCL_STATIC);
    return TCL_ERROR;
  }

  /* Check to see if this pointer is a char ** */
  if (!SWIG_GetPtr(s,&junk,"_char_pp")) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  } 
  if (ptr)
    free((char *) ptr);

  return TCL_OK;
}
static int _wrap_ptrcast(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrcast ptr type ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )ptrcast(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptrvalue(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    int  _arg2 = (int ) 0;
    char * _arg3 = (char *) 0;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrvalue ptr ?index? ?type? ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if (objc >2) { 
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    }
    if (objc >3) { 
    if ((_arg3 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    }
    _result = (int )ptrvalue(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptrset(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    char * _arg2;
    int  _arg3 = (int ) 0;
    char * _arg4 = (char *) 0;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrset ptr value ?index? ?type? ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if (objc >3) { 
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    }
    if (objc >4) { 
    if ((_arg4 = Tcl_GetStringFromObj(objv[4], &templength)) == NULL) return TCL_ERROR;
    }
    _result = (int )ptrset(_arg0,_arg1,_arg2,_arg3,_arg4);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptrcreate(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    char * _arg2 = (char *) 0;
    int  _arg3 = (int ) 1;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrcreate type ?value? ?nitems? ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if (objc >2) { 
    if ((_arg2 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    }
    if (objc >3) { 
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    }
    _result = (int )ptrcreate(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptrfree(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrfree ptr ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    _result = (int )ptrfree(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptradd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Interp * _arg0;
    char * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
{
  _arg0 = interp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptradd ptr offset ",-1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )ptradd(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
{
  return _result;
}
    return TCL_OK;
}
static int _wrap_ptrmap(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ptrmap type1 type2 ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    ptrmap(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_iff_exec(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_exec { char * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    _result = (int )iff_exec(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_get_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_get_string { char * } { char * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )iff_get_string(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_put_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_put_string { char * } { char * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )iff_put_string(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_get_scalar(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    double * _arg1;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_get_scalar { char * } { double * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iff_get_scalar. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )iff_get_scalar(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_put_scalar(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    double * _arg1;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_put_scalar { char * } { double * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iff_put_scalar. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )iff_put_scalar(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_get_array(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    double * _arg1;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_get_array { char * } { double * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iff_get_array. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )iff_get_array(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_put_array(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    int * _arg1;
    double * _arg2;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_put_array { char * } { int * } { double * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_int_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iff_put_array. Expected _int_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[3],(void **) &_arg2,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 3 of iff_put_array. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )iff_put_array(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iff_get_echo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iff_get_echo { char * } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    _result = (int )iff_get_echo(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ifeffit_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ifeffit_ { char * } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )ifeffit_(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iffgetstr_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    char * _arg1;
    int  _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iffgetstr_ { char * } { char * } { int  } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    _result = (int )iffgetstr_(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iffgetsca_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    double * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iffgetsca_ { char * } { double * } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iffgetsca_. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )iffgetsca_(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iffgetarr_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    double * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iffgetarr_ { char * } { double * } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iffgetarr_. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )iffgetarr_(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iffputarr_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    int * _arg1;
    double * _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    int templength;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iffputarr_ { char * } { int * } { double * } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_int_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of iffputarr_. Expected _int_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[3],(void **) &_arg2,"_double_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 3 of iffputarr_. Expected _double_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    _result = (int )iffputarr_(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_iffgetecho_(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    char * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. iffgetecho_ { char * } { int  } ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )iffgetecho_(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "_signed_long","_long",0},
    { "_long","_unsigned_long",0},
    { "_long","_signed_long",0},
    { "_unsigned_long","_long",0},
    { "_signed_int","_int",0},
    { "_unsigned_short","_short",0},
    { "_signed_short","_short",0},
    { "_unsigned_int","_int",0},
    { "_short","_unsigned_short",0},
    { "_short","_signed_short",0},
    { "_int","_unsigned_int",0},
    { "_int","_signed_int",0},
{0,0,0}};

SWIGEXPORT(int) Ifeffit_Init(Tcl_Interp *interp) {
	 if (interp == 0) 
		 return TCL_ERROR;
	 SWIG_RegisterType();
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrcast", _wrap_ptrcast, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrvalue", _wrap_ptrvalue, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrset", _wrap_ptrset, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrcreate", _wrap_ptrcreate, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrfree", _wrap_ptrfree, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptradd", _wrap_ptradd, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ptrmap", _wrap_ptrmap, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_exec", _wrap_iff_exec, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_get_string", _wrap_iff_get_string, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_put_string", _wrap_iff_put_string, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_get_scalar", _wrap_iff_get_scalar, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_put_scalar", _wrap_iff_put_scalar, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_get_array", _wrap_iff_get_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_put_array", _wrap_iff_put_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iff_get_echo", _wrap_iff_get_echo, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ifeffit_", _wrap_ifeffit_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iffgetstr_", _wrap_iffgetstr_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iffgetsca_", _wrap_iffgetsca_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iffgetarr_", _wrap_iffgetarr_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iffputarr_", _wrap_iffputarr_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "iffgetecho_", _wrap_iffgetecho_, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
	 return TCL_OK;
}
