/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;

final class NFIError
extends AbstractTruffleException {
    NFIError(String message) {
        this(message, null);
    }

    NFIError(String message, Node location) {
        super(message, NFIError.resolveLocation(location));
    }

    private static Node resolveLocation(Node node) {
        if (node == null || node.isAdoptable()) {
            return node;
        }
        return EncapsulatingNodeReference.getCurrent().get();
    }

    static NFIError illegalNativeAccess(Node location) {
        String error;
        String targetModule;
        Module truffleModule = Truffle.class.getModule();
        if (truffleModule.isNamed()) {
            targetModule = truffleModule.getName();
            error = String.format("Illegal native access from module %s.", targetModule);
        } else {
            targetModule = "ALL-UNNAMED";
            error = "Illegal native access from an unnamed module.";
        }
        return new NFIError(String.format("%s To enable the native access required by the NFI Panama backend, please add '--enable-native-access=%s' to the JVM command line options.", error, targetModule), location);
    }
}

