/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import sqlj.runtime.profile.util.Auditor;

public class PrintWriterAuditor
implements Auditor {
    private String m_prefix;
    private Hashtable m_objectHashes = new Hashtable();
    private static final Counter m_objCount = new Counter();
    private PrintWriter m_ps;

    public PrintWriterAuditor(PrintWriter printWriter) {
        this(printWriter, "");
    }

    public PrintWriterAuditor(PrintWriter printWriter, String string) {
        this.m_ps = printWriter;
        this.m_prefix = string;
    }

    private void printValue(Object object) {
        String string = object + "";
        int n2 = this.getAddressIndex(string, object);
        if (n2 != -1) {
            String string2 = (String)this.m_objectHashes.get(string);
            if (string2 == null) {
                string2 = string.substring(0, n2 + 1) + m_objCount.getNewCount();
                this.m_objectHashes.put(string, string2);
            }
            string = string2;
        }
        this.m_ps.print(string);
    }

    private int getAddressIndex(String string, Object object) {
        int n2 = string.indexOf(64);
        if (n2 != -1 && string.equals(object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()))) {
            return n2;
        }
        return -1;
    }

    @Override
    public void registerCall(Object object, String string, Object[] objectArray) {
        this.m_ps.print(this.m_prefix);
        this.printValue(object);
        this.m_ps.print(" . " + string + " ( ");
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.printValue(objectArray[n2]);
            if (++n2 >= objectArray.length) break;
            this.m_ps.print(" , ");
        }
        this.m_ps.println(" )");
    }

    @Override
    public void registerReturn(Object object, String string, Object object2) {
        this.m_ps.print(this.m_prefix);
        this.printValue(object);
        this.m_ps.print(" . " + string + " returned ");
        if (object2 != VOID_RETURN) {
            this.printValue(object2);
        }
        this.m_ps.println();
    }

    @Override
    public void registerException(Object object, String string, Exception exception) {
        this.m_ps.print(this.m_prefix);
        this.printValue(object);
        this.m_ps.print(" . " + string + " threw exception ");
        this.printValue(exception);
        this.m_ps.println();
    }

    private static class Counter {
        private int m_numObjs = 0;

        private Counter() {
        }

        public synchronized int getNewCount() {
            return ++this.m_numObjs;
        }
    }
}

