/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.utility.MetaDataUtility;

public final class WeakColumnReference
implements ColumnReference {
    private static final long serialVersionUID = 2986663326992262188L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;

    public WeakColumnReference(Column foreignKeyColumn, Column primaryKeyColumn) {
        this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "No foreign key column provided");
        this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "No primary key column provided");
    }

    @Override
    public int compareTo(ColumnReference columnRef) {
        if (columnRef == null) {
            return -1;
        }
        int compare = 0;
        ColumnReference other = columnRef;
        if (compare == 0) {
            compare = this.getKeySequence() - other.getKeySequence();
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.getFullName().compareTo(columnRef.getForeignKeyColumn().getFullName());
        }
        if (compare == 0) {
            compare = this.primaryKeyColumn.getFullName().compareTo(columnRef.getPrimaryKeyColumn().getFullName());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)obj;
        return Objects.equals(this.primaryKeyColumn, other.getPrimaryKeyColumn()) && Objects.equals(this.foreignKeyColumn, other.getForeignKeyColumn());
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public int getKeySequence() {
        return 1;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public int hashCode() {
        return Objects.hash(this.foreignKeyColumn, this.primaryKeyColumn);
    }

    @Override
    public boolean isSelfReferencing() {
        return false;
    }

    public boolean isValid() {
        if (this.primaryKeyColumn.equals(this.foreignKeyColumn) || this.foreignKeyColumn.isPartOfForeignKey()) {
            return false;
        }
        boolean isPkColumnPartial = MetaDataUtility.isPartial(this.primaryKeyColumn);
        boolean isFkColumnPartial = MetaDataUtility.isPartial(this.foreignKeyColumn);
        if (isFkColumnPartial && isPkColumnPartial || !this.primaryKeyColumn.isColumnDataTypeKnown() || !this.foreignKeyColumn.isColumnDataTypeKnown()) {
            return false;
        }
        ColumnDataType fkColumnType = this.foreignKeyColumn.getColumnDataType();
        ColumnDataType pkColumnType = this.primaryKeyColumn.getColumnDataType();
        boolean isValid = fkColumnType.getStandardTypeName().equals(pkColumnType.getStandardTypeName());
        return isValid;
    }

    public String toString() {
        return String.valueOf(this.foreignKeyColumn) + " ~~> " + String.valueOf(this.primaryKeyColumn);
    }
}

