/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public abstract class TpSlotRichCompare {
    private TpSlotRichCompare() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotRichCmpNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_richcompare");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, RichCmpOp var6);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotRichCmpBuiltin<?> slot, Object a, Object b, RichCmpOp op, @Cached(value="slot") TpSlotRichCmpBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") RichCmpBuiltinNode slotNode) {
            return slotNode.execute(frame, a, b, op);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlotRichCmpPython slot, Object a, Object b, RichCmpOp op, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcher, @Cached InlinedBranchProfile notImplementedProfile) {
            TruffleWeakReference<Object> callableRef = switch (op) {
                default -> throw new IncompatibleClassChangeError();
                case RichCmpOp.Py_LT -> slot.lt;
                case RichCmpOp.Py_LE -> slot.le;
                case RichCmpOp.Py_EQ -> slot.eq;
                case RichCmpOp.Py_NE -> slot.ne;
                case RichCmpOp.Py_GT -> slot.gt;
                case RichCmpOp.Py_GE -> slot.ge;
            };
            Object callable = slot.safeGet(callableRef);
            Object type = slot.safeGet(slot.type);
            if (callable != null && type != null) {
                return dispatcher.executeIgnoreDescriptorBindErrors(frame, inliningTarget, callable, type, a, b);
            }
            notImplementedProfile.enter(inliningTarget);
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object a, Object b, RichCmpOp op, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNodeA, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNodeB, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached.Exclusive @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, SpecialMethodNames.T_TP_RICHCOMPARE, slot.callable, toNativeNodeA.execute(a), toNativeNodeB.execute(b), op.asNative());
            return checkResultNode.execute(state, SpecialMethodNames.T___HASH__, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @CompilerDirectives.TruffleBoundary
        static Object callGenericSimpleBuiltin(TpSlotRichCmpBuiltinSimple<?> slot, Object a, Object b, RichCmpOp op) {
            return slot.executeUncached(a, b, op);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericComplexBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotRichCmpBuiltinComplex<?> slot, Object a, Object b, RichCmpOp op, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, a);
            PArguments.setArgument(arguments, 1, b);
            PArguments.setArgument(arguments, 2, (Object)op);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    public static final class TpSlotRichCmpPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> lt;
        private final TruffleWeakReference<Object> le;
        private final TruffleWeakReference<Object> eq;
        private final TruffleWeakReference<Object> ne;
        private final TruffleWeakReference<Object> gt;
        private final TruffleWeakReference<Object> ge;
        private final TruffleWeakReference<Object> type;

        public TpSlotRichCmpPython(Object type, Object lt, Object le, Object eq, Object ne, Object gt, Object ge) {
            this.type = TpSlotRichCmpPython.asWeakRef(type);
            this.lt = TpSlotRichCmpPython.asWeakRef(lt);
            this.le = TpSlotRichCmpPython.asWeakRef(le);
            this.eq = TpSlotRichCmpPython.asWeakRef(eq);
            this.ne = TpSlotRichCmpPython.asWeakRef(ne);
            this.gt = TpSlotRichCmpPython.asWeakRef(gt);
            this.ge = TpSlotRichCmpPython.asWeakRef(ge);
        }

        public static TpSlotRichCmpPython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == RichCmpOp.VALUES.length);
            assert (callableNames == null || TpSlotRichCmpPython.checkCallableNames(callableNames));
            return new TpSlotRichCmpPython(type, callables[0], callables[1], callables[2], callables[3], callables[4], callables[5]);
        }

        private static boolean checkCallableNames(TruffleString[] callableNames) {
            for (int i = 0; i < RichCmpOp.VALUES.length; ++i) {
                assert (RichCmpOp.VALUES[i].getPythonName().equalsUncached((AbstractTruffleString)callableNames[i], PythonUtils.TS_ENCODING));
            }
            return true;
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            return new TpSlotRichCmpPython(this.type.get(), this.lt.get(), this.le.get(), this.eq.get(), this.ne.get(), this.gt.get(), this.ge.get());
        }
    }

    public static final class RichCmpWrapperNode
    extends PythonBinaryBuiltinNode {
        private final RichCmpOp op;
        @Node.Child
        RichCmpBuiltinNode slotNode;

        public RichCmpWrapperNode(RichCmpOp op, RichCmpBuiltinNode slotNode) {
            this.op = op;
            this.slotNode = slotNode;
        }

        @Override
        public Object execute(VirtualFrame frame, Object arg, Object arg2) {
            return this.slotNode.execute(frame, arg, arg2, this.op);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class RichCmpBuiltinNode
    extends PythonTernaryBuiltinNode {
        @Override
        public final Object execute(VirtualFrame frame, Object arg, Object arg2, Object arg3) {
            return this.execute(frame, arg, arg2, (RichCmpOp)((Object)arg3));
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, RichCmpOp var4);
    }

    public static abstract class TpSlotRichCmpBuiltinComplex<T extends RichCmpBuiltinNode>
    extends TpSlotRichCmpBuiltin<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotRichCmpBuiltinComplex(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        @Override
        public final void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotRichCmpBuiltinComplex.createSlotCallTarget(language, SIGNATURE, this.getNodeFactory(), "tp_richcompare");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }
    }

    public static abstract class TpSlotRichCmpBuiltinSimple<T extends RichCmpBuiltinNode>
    extends TpSlotRichCmpBuiltin<T> {
        protected TpSlotRichCmpBuiltinSimple(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        protected abstract Object executeUncached(Object var1, Object var2, RichCmpOp var3);

        @Override
        public final void initialize(PythonLanguage language) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TpSlotRichCmpBuiltin<T extends RichCmpBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        static final BuiltinSlotWrapperSignature SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "other", "op");

        protected TpSlotRichCmpBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, SIGNATURE, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC);
        }

        final RichCmpBuiltinNode createSlotNode() {
            return (RichCmpBuiltinNode)((Object)this.createNode());
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            RichCmpOp op = RichCmpOp.fromName(tsName);
            assert (op != null) : "Unexpected richcmp name: " + tsName.toJavaStringUncached();
            NodeFactoryUtils.WrapperNodeFactory<RichCmpWrapperNode, RichCmpBuiltinNode> factory = NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), RichCmpWrapperNode.class, n -> new RichCmpWrapperNode(op, (RichCmpBuiltinNode)((Object)n)));
            return this.createBuiltin(core, type, tsName, BuiltinSlotWrapperSignature.BINARY, wrapper, factory);
        }
    }
}

