/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.map;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.map.MapBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.map.MapBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.map.PMap;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMap})
public final class MapBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MapBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MapBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonBuiltinNode {
        @Specialization
        static PTuple doit(PMap self, Object ignored, @Bind PythonLanguage language) {
            Object[] iterators = self.getIterators();
            Object[] args = new Object[iterators.length + 1];
            args[0] = self.getFunction();
            System.arraycopy(iterators, 0, args, 1, iterators.length);
            return PFactory.createTuple(language, new Object[]{PythonBuiltinClassType.PMap, PFactory.createTuple(language, args)});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PMap iter(PMap self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"self.getIterators().length == 1"})
        Object doOne(VirtualFrame frame, PMap self, @Bind Node inliningTarget, @Cached.Shared @Cached CallNode callNode, @Cached.Shared @Cached PyIterNextNode nextNode) {
            Object item = nextNode.execute((Frame)frame, inliningTarget, self.getIterators()[0]);
            return callNode.execute((Frame)frame, self.getFunction(), item);
        }

        @Specialization(replaces={"doOne"})
        Object doNext(VirtualFrame frame, PMap self, @Bind Node inliningTarget, @Cached.Shared @Cached CallNode callNode, @Cached.Shared @Cached PyIterNextNode nextNode) {
            Object[] iterators = self.getIterators();
            Object[] arguments = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                arguments[i] = nextNode.execute((Frame)frame, inliningTarget, iterators[i]);
            }
            return callNode.execute((Frame)frame, self.getFunction(), arguments);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="map", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class MapNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PMap doit(VirtualFrame frame, Object cls, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Cached(inline=false) TypeNodes.HasObjectInitNode hasObjectInitNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (keywords.length > 0 && hasObjectInitNode.executeCached(cls)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "map()");
            }
            if (args.length < 2) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MAP_MUST_HAVE_AT_LEAST_TWO_ARGUMENTS);
            }
            PMap map = PFactory.createMap(language, cls, getInstanceShape.execute(cls));
            map.setFunction(args[0]);
            Object[] iterators = new Object[args.length - 1];
            loopProfile.profileCounted(inliningTarget, (long)iterators.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < iterators.length)) {
                iterators[i] = getIter.execute((Frame)frame, inliningTarget, args[i + 1]);
                ++i;
            }
            map.setIterators(iterators);
            return map;
        }
    }
}

