// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// Qt-Security score:significant reason:trivial-impl-only

#ifndef QISCIICODEC_P_H
#define QISCIICODEC_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/qtextcodec_p.h>

QT_REQUIRE_CONFIG(codecs);

QT_BEGIN_NAMESPACE

class QIsciiCodec : public QTextCodec
{
public:
    explicit QIsciiCodec(int i) : idx(i) {}
    ~QIsciiCodec();

    static QTextCodec *create(const char *name);

    QByteArray name() const override;
    int mibEnum() const override;

    QString convertToUnicode(const char *, int, ConverterState *) const override;
    QByteArray convertFromUnicode(const QChar *, int, ConverterState *) const override;

private:
    int idx;
};

QT_END_NAMESPACE

#endif // QISCIICODEC_P_H
