/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class StubAwareComputation<Psi extends PsiElement, CustomStub, Result> {
    @NotNull
    private final PsiToStubConversion<Psi, ?, CustomStub> myConversion;
    @Nullable
    private final @Nullable Function<CustomStub, @Nullable Result> myStubComputation;
    @Nullable
    private final @Nullable Function<Psi, @Nullable Result> myAstComputation;
    @Nullable
    private final @Nullable Function<Psi, @Nullable Result> myAstStubLikeComputation;
    @Nullable
    private final @Nullable Function<Psi, @Nullable CustomStub> myStubBuilder;

    @NotNull
    public static <Psi extends StubBasedPsiElement<PsiStub>, PsiStub extends StubElement<Psi>> PsiToStubConversion<Psi, PsiStub, PsiStub> on(@NotNull Psi element) {
        if (element == null) {
            StubAwareComputation.$$$reportNull$$$0(0);
        }
        return new PsiToStubConversion<StubBasedPsiElement, StubElement, StubElement>(element, StubBasedPsiElement::getStub, StubBasedPsiElement::getStub);
    }

    private StubAwareComputation(@NotNull PsiToStubConversion<Psi, ?, CustomStub> conversion, @Nullable @Nullable Function<@Nullable CustomStub, Result> stubComputation, @Nullable Function<@NotNull Psi, Result> astComputation, @Nullable Function<@NotNull Psi, Result> astStubLikeComputation, @Nullable @Nullable Function<@NotNull Psi, @Nullable CustomStub> stubBuilder) {
        if (conversion == null) {
            StubAwareComputation.$$$reportNull$$$0(1);
        }
        this.myConversion = conversion;
        this.myAstComputation = astComputation;
        this.myStubComputation = stubComputation;
        this.myAstStubLikeComputation = astStubLikeComputation;
        this.myStubBuilder = stubBuilder;
    }

    @NotNull
    public StubAwareComputation<Psi, CustomStub, Result> overStub(@NotNull Function<@Nullable CustomStub, Result> stubComputation) {
        if (stubComputation == null) {
            StubAwareComputation.$$$reportNull$$$0(2);
        }
        return new StubAwareComputation<Psi, CustomStub, Result>(this.myConversion, stubComputation, this.myAstComputation, this.myAstStubLikeComputation, this.myStubBuilder);
    }

    @NotNull
    public StubAwareComputation<Psi, CustomStub, Result> overAst(@NotNull @NotNull Function<@NotNull Psi, Result> astComputation) {
        if (astComputation == null) {
            StubAwareComputation.$$$reportNull$$$0(3);
        }
        return new StubAwareComputation<Psi, CustomStub, Result>(this.myConversion, this.myStubComputation, astComputation, this.myAstStubLikeComputation, this.myStubBuilder);
    }

    @NotNull
    public StubAwareComputation<Psi, CustomStub, Result> overAstStubLike(@NotNull @NotNull Function<@NotNull Psi, Result> astStubLikeComputation) {
        if (astStubLikeComputation == null) {
            StubAwareComputation.$$$reportNull$$$0(4);
        }
        return new StubAwareComputation<Psi, CustomStub, Result>(this.myConversion, this.myStubComputation, this.myAstComputation, astStubLikeComputation, this.myStubBuilder);
    }

    @NotNull
    public StubAwareComputation<Psi, CustomStub, Result> withStubBuilder(@NotNull @NotNull Function<@NotNull Psi, @Nullable CustomStub> stubBuilder) {
        if (stubBuilder == null) {
            StubAwareComputation.$$$reportNull$$$0(5);
        }
        return new StubAwareComputation<Psi, CustomStub, Result>(this.myConversion, this.myStubComputation, this.myAstComputation, this.myAstStubLikeComputation, stubBuilder);
    }

    public Result compute(@NotNull TypeEvalContext context) {
        if (context == null) {
            StubAwareComputation.$$$reportNull$$$0(6);
        }
        if (this.myStubComputation == null) {
            throw new IllegalStateException("Over-stub computation must be provided");
        }
        Function<Psi, Result> overNewStubComputation = this.myStubBuilder != null ? this.myStubBuilder.andThen(this.myStubComputation) : null;
        Function astComputation = (Function)ObjectUtils.chooseNotNull(this.myAstComputation, overNewStubComputation);
        if (astComputation == null) {
            throw new IllegalStateException("Either over-AST computation or a stub builder must be provided");
        }
        Function astStubLikeComputation = (Function)ObjectUtils.chooseNotNull(this.myAstStubLikeComputation, overNewStubComputation);
        if (astStubLikeComputation == null) {
            throw new IllegalStateException("Either over-AST-stub-like computation or a stub builder must be provided");
        }
        Object psi = this.myConversion.myElement;
        if (context.maySwitchToAST((PsiElement)psi)) {
            return (Result)astComputation.apply(psi);
        }
        if (this.myConversion.getPsiStub() != null) {
            return this.myStubComputation.apply(this.myConversion.getCustomStub());
        }
        return (Result)astStubLikeComputation.apply(psi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubComputation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astComputation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astStubLikeComputation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/StubAwareComputation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "on";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "overStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "overAst";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "overAstStubLike";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "withStubBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class PsiToStubConversion<Psi extends PsiElement, PsiStub extends StubElement<Psi>, CustomStub> {
        @NotNull
        private final Psi myElement;
        private final @NotNull Function<Psi, @Nullable PsiStub> myStubGetter;
        private final @NotNull Function<Psi, @Nullable CustomStub> myCustomStubGetter;

        private PsiToStubConversion(@NotNull Psi element, @NotNull Function<Psi, @Nullable PsiStub> psiStubGetter, @NotNull Function<Psi, @Nullable CustomStub> customStubGetter) {
            if (element == null) {
                PsiToStubConversion.$$$reportNull$$$0(0);
            }
            if (psiStubGetter == null) {
                PsiToStubConversion.$$$reportNull$$$0(1);
            }
            if (customStubGetter == null) {
                PsiToStubConversion.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myStubGetter = psiStubGetter;
            this.myCustomStubGetter = customStubGetter;
        }

        @Nullable
        private PsiStub getPsiStub() {
            return (PsiStub)((StubElement)this.myStubGetter.apply(this.myElement));
        }

        @Nullable
        private CustomStub getCustomStub() {
            return this.myCustomStubGetter.apply(this.myElement);
        }

        @NotNull
        public <S> PsiToStubConversion<Psi, PsiStub, S> withCustomStub(@NotNull @NotNull Function<@NotNull PsiStub, @Nullable S> stubGetter) {
            if (stubGetter == null) {
                PsiToStubConversion.$$$reportNull$$$0(3);
            }
            return new PsiToStubConversion<PsiElement, PsiStub, Object>((PsiElement)this.myElement, this.myStubGetter, psi -> {
                StubElement stub = (StubElement)this.myStubGetter.apply(psi);
                return stub != null ? stubGetter.apply(stub) : null;
            });
        }

        @NotNull
        public <Result> StubAwareComputation<Psi, CustomStub, Result> overStub(@NotNull Function<CustomStub, Result> stubComputation) {
            if (stubComputation == null) {
                PsiToStubConversion.$$$reportNull$$$0(4);
            }
            return new StubAwareComputation(this, stubComputation, null, null, null);
        }

        @NotNull
        public <Result> StubAwareComputation<Psi, CustomStub, Result> overAst(@NotNull Function<Psi, Result> astComputation) {
            if (astComputation == null) {
                PsiToStubConversion.$$$reportNull$$$0(5);
            }
            return new StubAwareComputation(this, null, astComputation, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiStubGetter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customStubGetter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubGetter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubComputation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "astComputation";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/StubAwareComputation$PsiToStubConversion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCustomStub";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "overStub";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "overAst";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

