/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeleton;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PySkeletonUtil {
    private static final Key<PySkeletonHeader> CACHED_SKELETON_HEADER = Key.create((String)"CACHED_SKELETON_HEADER");

    @Nullable
    private static PySkeletonHeader readSkeletonHeader(@NotNull VirtualFile file, @NotNull Sdk pythonSdk) {
        VirtualFile skeletonsDir;
        if (file == null) {
            PySkeletonUtil.$$$reportNull$$$0(0);
        }
        if (pythonSdk == null) {
            PySkeletonUtil.$$$reportNull$$$0(1);
        }
        if ((skeletonsDir = PythonSdkUtil.findSkeletonsDir((Sdk)pythonSdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)file, (boolean)false)) {
            PySkeletonHeader skeletonHeader = (PySkeletonHeader)file.getUserData(CACHED_SKELETON_HEADER);
            if (skeletonHeader == null) {
                skeletonHeader = PySkeletonHeader.readSkeletonHeader(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                file.putUserData(CACHED_SKELETON_HEADER, (Object)skeletonHeader);
            }
            return skeletonHeader;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk) {
        if (pythonSdk == null) {
            PySkeletonUtil.$$$reportNull$$$0(2);
        }
        VirtualFile libDir = PythonSdkUtil.isVirtualEnv((Sdk)pythonSdk) ? PySearchUtilBase.findVirtualEnvLibDir(pythonSdk) : PySearchUtilBase.findLibDir(pythonSdk);
        return libDir != null ? libDir.findChild("site-packages") : null;
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk) {
        if (vFile == null) {
            PySkeletonUtil.$$$reportNull$$$0(3);
        }
        if (pythonSdk != null) {
            VirtualFile libDir;
            @Nullable VirtualFile originFile = vFile;
            @NotNull String originPath = vFile.getPath();
            boolean checkOnRemoteFS = false;
            PySkeletonHeader header = PySkeletonUtil.readSkeletonHeader(originFile, pythonSdk);
            if (header != null) {
                if (ApplicationManager.getApplication().isUnitTestMode() && Objects.equals(vFile.getParent(), PythonSdkUtil.findSkeletonsDir((Sdk)pythonSdk))) {
                    return true;
                }
                String binaryPath = header.getBinaryFile();
                if (binaryPath.equals("(built-in)") || binaryPath.equals("(pre-generated)")) {
                    return true;
                }
                if (PythonSdkUtil.isRemote((Sdk)pythonSdk)) {
                    checkOnRemoteFS = true;
                    originFile = null;
                } else {
                    originFile = VfsUtil.findFileByIoFile((File)new File(binaryPath), (boolean)true);
                }
                originPath = binaryPath;
            }
            if (originFile != null) {
                originFile = (VirtualFile)ObjectUtils.notNull((Object)originFile.getCanonicalFile(), (Object)originFile);
                originPath = originFile.getPath();
            }
            if ((libDir = PySearchUtilBase.findLibDir(pythonSdk)) != null && PySkeletonUtil.isUnderLibDirButNotSitePackages(originFile, originPath, libDir, pythonSdk, checkOnRemoteFS)) {
                return true;
            }
            VirtualFile venvLibDir = PySearchUtilBase.findVirtualEnvLibDir(pythonSdk);
            if (venvLibDir != null && PySkeletonUtil.isUnderLibDirButNotSitePackages(originFile, originPath, venvLibDir, pythonSdk, checkOnRemoteFS)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isUnderLibDirButNotSitePackages(@Nullable VirtualFile file, @NotNull String path, @NotNull VirtualFile libDir, @NotNull Sdk sdk, boolean checkOnRemoteFS) {
        String originLibDirPath;
        VirtualFile originLibDir;
        if (path == null) {
            PySkeletonUtil.$$$reportNull$$$0(4);
        }
        if (libDir == null) {
            PySkeletonUtil.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            PySkeletonUtil.$$$reportNull$$$0(6);
        }
        if (checkOnRemoteFS) {
            originLibDir = libDir;
            originLibDirPath = PySkeletonUtil.mapToRemote(originLibDir.getPath(), sdk);
        } else {
            originLibDir = (VirtualFile)ObjectUtils.notNull((Object)libDir.getCanonicalFile(), (Object)libDir);
            originLibDirPath = originLibDir.getPath();
        }
        if (checkOnRemoteFS || file == null) {
            String normalizedLidDirPath = FileUtil.toSystemIndependentName((String)originLibDirPath);
            String sitePackagesPath = normalizedLidDirPath + "/site-packages";
            String normalizedPath = FileUtil.toSystemIndependentName((String)path);
            return FileUtil.startsWith((String)normalizedPath, (String)normalizedLidDirPath) && !FileUtil.startsWith((String)normalizedPath, (String)sitePackagesPath);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)originLibDir, (VirtualFile)file, (boolean)false)) {
            VirtualFile sitePackagesDir = originLibDir.findChild("site-packages");
            return sitePackagesDir == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackagesDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    @NotNull
    private static String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk) {
        if (localRoot == null) {
            PySkeletonUtil.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            PySkeletonUtil.$$$reportNull$$$0(8);
        }
        String string = PythonRuntimeService.getInstance().mapToRemote(localRoot, sdk);
        if (string == null) {
            PySkeletonUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PySkeletonUtil.$$$reportNull$$$0(10);
        }
        String string = PyBuiltinCache.getBuiltinsFileName(PySdkUtil.getLanguageLevelForSdk((Sdk)sdk));
        if (string == null) {
            PySkeletonUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeleton/PySkeletonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeleton/PySkeletonUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToRemote";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnderLibDirButNotSitePackages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11 -> new IllegalStateException(string);
        };
    }
}

