/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import org.opensearch.secure_sm.AccessController;

public class NonValidatingObjectMapper {
    private static final ObjectMapper nonValidatingObjectMapper = new ObjectMapper();

    public static void inject(InjectableValues.Std injectableValues) {
        nonValidatingObjectMapper.setInjectableValues((InjectableValues)injectableValues);
    }

    public static <T> T readValue(String string, JavaType jt) throws IOException {
        try {
            return (T)AccessController.doPrivilegedChecked(() -> nonValidatingObjectMapper.readValue(string, jt));
        }
        catch (Exception e) {
            throw (IOException)e;
        }
    }

    public static TypeFactory getTypeFactory() {
        return nonValidatingObjectMapper.getTypeFactory();
    }

    static {
        nonValidatingObjectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        nonValidatingObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        nonValidatingObjectMapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, false);
        nonValidatingObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        nonValidatingObjectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }
}

