/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.multipartupload.model.ObjectLockMode;
import com.google.common.base.MoreObjects;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class CreateMultipartUploadRequest {
    private final String bucket;
    private final String key;
    private final Storage.PredefinedAcl cannedAcl;
    private final String contentType;
    private final Map<String, String> metadata;
    private final StorageClass storageClass;
    private final OffsetDateTime customTime;
    private final String kmsKeyName;
    private final ObjectLockMode objectLockMode;
    private final OffsetDateTime objectLockRetainUntilDate;

    private CreateMultipartUploadRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
        this.contentType = builder.contentType;
        this.metadata = builder.metadata;
        this.storageClass = builder.storageClass;
        this.customTime = builder.customTime;
        this.kmsKeyName = builder.kmsKeyName;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
    }

    @BetaApi
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    public String key() {
        return this.key;
    }

    @BetaApi
    public Storage.PredefinedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    @BetaApi
    public String getContentType() {
        return this.contentType;
    }

    @BetaApi
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @BetaApi
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    @BetaApi
    public OffsetDateTime getCustomTime() {
        return this.customTime;
    }

    @BetaApi
    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    @BetaApi
    public ObjectLockMode getObjectLockMode() {
        return this.objectLockMode;
    }

    @BetaApi
    public OffsetDateTime getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMultipartUploadRequest)) {
            return false;
        }
        CreateMultipartUploadRequest that = (CreateMultipartUploadRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && this.cannedAcl == that.cannedAcl && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.metadata, that.metadata) && Objects.equals((Object)this.storageClass, (Object)that.storageClass) && Objects.equals(this.customTime, that.customTime) && Objects.equals(this.kmsKeyName, that.kmsKeyName) && this.objectLockMode == that.objectLockMode && Objects.equals(this.objectLockRetainUntilDate, that.objectLockRetainUntilDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.key, this.cannedAcl, this.contentType, this.metadata, this.storageClass, this.customTime, this.kmsKeyName, this.objectLockMode, this.objectLockRetainUntilDate});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("cannedAcl", (Object)this.cannedAcl).add("contentType", (Object)this.contentType).add("metadata", this.metadata).add("storageClass", (Object)this.storageClass).add("customTime", (Object)this.customTime).add("kmsKeyName", (Object)this.kmsKeyName).add("objectLockMode", (Object)this.objectLockMode).add("objectLockRetainUntilDate", (Object)this.objectLockRetainUntilDate).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static final class Builder {
        private String bucket;
        private String key;
        private Storage.PredefinedAcl cannedAcl;
        private String contentType;
        private Map<String, String> metadata;
        private StorageClass storageClass;
        private OffsetDateTime customTime;
        private String kmsKeyName;
        private ObjectLockMode objectLockMode;
        private OffsetDateTime objectLockRetainUntilDate;

        private Builder() {
        }

        @BetaApi
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder cannedAcl(Storage.PredefinedAcl cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @BetaApi
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @BetaApi
        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @BetaApi
        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @BetaApi
        public Builder customTime(OffsetDateTime customTime) {
            this.customTime = customTime;
            return this;
        }

        @BetaApi
        public Builder kmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        @BetaApi
        public Builder objectLockMode(ObjectLockMode objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        @BetaApi
        public Builder objectLockRetainUntilDate(OffsetDateTime objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        @BetaApi
        public CreateMultipartUploadRequest build() {
            return new CreateMultipartUploadRequest(this);
        }
    }
}

